/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.core.Constraints;
import androidx.ui.core.LayoutDirection;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.TextLayoutInput;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aT\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0014"}, d2={"canReuse", "", "Landroidx/ui/text/TextLayoutResult;", "text", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "maxLines", "", "softWrap", "overflow", "Landroidx/ui/text/style/TextOverflow;", "density", "Landroidx/ui/unit/Density;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "constraints", "Landroidx/ui/core/Constraints;", "ui-text_release"})
public final class TextLayoutHelperKt {
    public static final boolean canReuse(@NotNull TextLayoutResult $this$canReuse, @NotNull AnnotatedString text, @NotNull TextStyle style, int maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull Font.ResourceLoader resourceLoader, @NotNull Constraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canReuse, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        TextLayoutInput layoutInput = $this$canReuse.getLayoutInput();
        if (!(Intrinsics.areEqual((Object)layoutInput.getText(), (Object)text) && Intrinsics.areEqual((Object)layoutInput.getStyle(), (Object)style) && layoutInput.getMaxLines() == maxLines && layoutInput.getSoftWrap() == softWrap && Intrinsics.areEqual((Object)((Object)layoutInput.getOverflow()), (Object)((Object)overflow)) && Intrinsics.areEqual((Object)layoutInput.getDensity(), (Object)density) && Intrinsics.areEqual((Object)layoutInput.getLayoutDirection(), (Object)layoutDirection) && Intrinsics.areEqual((Object)layoutInput.getResourceLoader(), (Object)resourceLoader))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)constraints.getMinWidth(), (Object)layoutInput.getConstraints().getMinWidth())) {
            return false;
        }
        if (!softWrap && !Intrinsics.areEqual((Object)((Object)overflow), (Object)((Object)TextOverflow.Ellipsis))) {
            return true;
        }
        return Intrinsics.areEqual((Object)constraints.getMaxWidth(), (Object)layoutInput.getConstraints().getMaxWidth());
    }
}

