/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Path;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.TextLayoutInput;
import androidx.ui.text.TextRange;
import androidx.ui.text.style.TextDirection;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001a\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u001d\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001eJ\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&J\u000e\u0010)\u001a\u00020(2\u0006\u0010%\u001a\u00020&J\u0016\u0010*\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020\tJ\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020&J\u000e\u0010.\u001a\u00020&2\u0006\u0010%\u001a\u00020&J\u000e\u0010/\u001a\u00020&2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&J\u000e\u00107\u001a\u0002082\u0006\u0010%\u001a\u00020&J\t\u00109\u001a\u00020&H\u00d6\u0001J\t\u0010:\u001a\u00020;H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006<"}, d2={"Landroidx/ui/text/TextLayoutResult;", "", "layoutInput", "Landroidx/ui/text/TextLayoutInput;", "multiParagraph", "Landroidx/ui/text/MultiParagraph;", "size", "Landroidx/ui/unit/IntPxSize;", "didOverflowHeight", "", "getDidOverflowHeight", "()Z", "didOverflowWidth", "getDidOverflowWidth", "firstBaseline", "Landroidx/ui/unit/Px;", "getFirstBaseline", "()Landroidx/ui/unit/Px;", "hasVisualOverflow", "getHasVisualOverflow", "lastBaseline", "getLastBaseline", "getLayoutInput", "()Landroidx/ui/text/TextLayoutInput;", "getMultiParagraph$ui_text_release", "()Landroidx/ui/text/MultiParagraph;", "getSize", "()Landroidx/ui/unit/IntPxSize;", "component1", "component2", "component2$ui_text_release", "component3", "copy", "equals", "other", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "", "getBoundingBox", "Landroidx/ui/geometry/Rect;", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineForOffset", "getOffsetForPosition", "position", "Landroidx/ui/unit/PxPosition;", "getParagraphDirection", "getPathForRange", "Landroidx/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/ui/text/TextRange;", "hashCode", "toString", "", "ui-text_release"})
public final class TextLayoutResult {
    private final TextLayoutInput layoutInput;
    private final MultiParagraph multiParagraph;
    private final IntPxSize size;
    private final Px firstBaseline;
    private final Px lastBaseline;

    public TextLayoutResult(@NotNull TextLayoutInput layoutInput, @NotNull MultiParagraph multiParagraph, @NotNull IntPxSize size) {
        float $this$px$iv;
        Px px;
        Intrinsics.checkParameterIsNotNull((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        this.layoutInput = layoutInput;
        this.multiParagraph = multiParagraph;
        this.size = size;
        float f = this.getMultiParagraph$ui_text_release().getFirstBaseline();
        TextLayoutResult textLayoutResult = this;
        textLayoutResult.firstBaseline = px = new Px($this$px$iv);
        $this$px$iv = this.getMultiParagraph$ui_text_release().getLastBaseline();
        textLayoutResult = this;
        textLayoutResult.lastBaseline = px = new Px($this$px$iv);
    }

    @NotNull
    public final TextLayoutInput getLayoutInput() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph getMultiParagraph$ui_text_release() {
        return this.multiParagraph;
    }

    @NotNull
    public final IntPxSize getSize() {
        return this.size;
    }

    @NotNull
    public final Px getFirstBaseline() {
        return this.firstBaseline;
    }

    @NotNull
    public final Px getLastBaseline() {
        return this.lastBaseline;
    }

    public final boolean getDidOverflowHeight() {
        return this.getMultiParagraph$ui_text_release().getDidExceedMaxLines();
    }

    public final boolean getDidOverflowWidth() {
        IntPxSize this_$iv = this.getSize();
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackInt1 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        return (float)new IntPx($this$ipx$iv$iv).getValue() < this.getMultiParagraph$ui_text_release().getWidth();
    }

    public final boolean getHasVisualOverflow() {
        return this.getDidOverflowWidth() || this.getDidOverflowHeight();
    }

    @NotNull
    public final Px getLineBottom(int lineIndex) {
        float $this$px$iv = this.getMultiParagraph$ui_text_release().getLineBottom(lineIndex);
        return new Px($this$px$iv);
    }

    public final int getLineForOffset(int offset) {
        return this.getMultiParagraph$ui_text_release().getLineForOffset(offset);
    }

    @NotNull
    public final Px getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float $this$px$iv = this.getMultiParagraph$ui_text_release().getHorizontalPosition(offset, usePrimaryDirection);
        return new Px($this$px$iv);
    }

    @NotNull
    public final TextDirection getParagraphDirection(int offset) {
        return this.getMultiParagraph$ui_text_release().getParagraphDirection(offset);
    }

    @NotNull
    public final TextDirection getBidiRunDirection(int offset) {
        return this.getMultiParagraph$ui_text_release().getBidiRunDirection(offset);
    }

    public final int getOffsetForPosition(@NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.getMultiParagraph$ui_text_release().getOffsetForPosition(position);
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        return this.getMultiParagraph$ui_text_release().getBoundingBox(offset);
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        return this.getMultiParagraph$ui_text_release().getWordBoundary(offset);
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        return this.getMultiParagraph$ui_text_release().getCursorRect(offset);
    }

    @NotNull
    public final Path getPathForRange(int start, int end) {
        return this.getMultiParagraph$ui_text_release().getPathForRange(start, end);
    }

    @NotNull
    public final TextLayoutInput component1() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph component2$ui_text_release() {
        return this.multiParagraph;
    }

    @NotNull
    public final IntPxSize component3() {
        return this.size;
    }

    @NotNull
    public final TextLayoutResult copy(@NotNull TextLayoutInput layoutInput, @NotNull MultiParagraph multiParagraph, @NotNull IntPxSize size) {
        Intrinsics.checkParameterIsNotNull((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        return new TextLayoutResult(layoutInput, multiParagraph, size);
    }

    public static /* synthetic */ TextLayoutResult copy$default(@NotNull TextLayoutResult this_, @Nullable TextLayoutInput layoutInput, @Nullable MultiParagraph multiParagraph, @Nullable IntPxSize size, int $mask0, @Nullable Object $handler) {
        TextLayoutInput textLayoutInput = ($mask0 & 1) != 0 ? this_.layoutInput : layoutInput;
        MultiParagraph multiParagraph2 = ($mask0 & 2) != 0 ? this_.multiParagraph : multiParagraph;
        IntPxSize intPxSize = ($mask0 & 4) != 0 ? this_.size : size;
        return this_.copy(textLayoutInput, multiParagraph2, intPxSize);
    }

    @NotNull
    public String toString() {
        return "TextLayoutResult(layoutInput=" + this.layoutInput + ", multiParagraph=" + this.multiParagraph + ", size=" + this.size + ")";
    }

    public int hashCode() {
        return (this.layoutInput.hashCode() * 31 + this.multiParagraph.hashCode()) * 31 + this.size.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextLayoutResult)) {
            return false;
        }
        Object object = other;
        TextLayoutResult textLayoutResult = (TextLayoutResult)object;
        if (!Intrinsics.areEqual((Object)this.layoutInput, (Object)textLayoutResult.layoutInput)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.multiParagraph, (Object)textLayoutResult.multiParagraph)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.size, (Object)textLayoutResult.size);
    }
}

