/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u001d"}, d2={"Landroidx/ui/text/TextRange;", "", "start", "", "end", "collapsed", "", "getCollapsed", "()Z", "getEnd", "()I", "length", "getLength", "max", "getMax", "min", "getMin", "getStart", "component1", "component2", "contains", "other", "offset", "copy", "equals", "hashCode", "intersects", "toString", "", "ui-text_release"})
public final class TextRange {
    private final int start;
    private final int end;

    public TextRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getMin() {
        return this.getStart() > this.getEnd() ? this.getEnd() : this.getStart();
    }

    public final int getMax() {
        return this.getStart() > this.getEnd() ? this.getStart() : this.getEnd();
    }

    public final boolean getCollapsed() {
        return this.getStart() == this.getEnd();
    }

    public final int getLength() {
        return this.getMax() - this.getMin();
    }

    public final boolean intersects(@NotNull TextRange other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.getMin() < other.getMax() && other.getMin() < this.getMax();
    }

    public final boolean contains(@NotNull TextRange other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.getMin() <= other.getMin() && other.getMax() <= this.getMax();
    }

    public final boolean contains(int offset) {
        return RangesKt.until((int)this.getMin(), (int)this.getMax()).contains(offset);
    }

    public final int component1() {
        return this.start;
    }

    public final int component2() {
        return this.end;
    }

    @NotNull
    public final TextRange copy(int start, int end) {
        return new TextRange(start, end);
    }

    public static /* synthetic */ TextRange copy$default(@NotNull TextRange this_, int start, int end, int $mask0, @Nullable Object $handler) {
        int n = ($mask0 & 1) != 0 ? this_.start : start;
        int n2 = ($mask0 & 2) != 0 ? this_.end : end;
        return this_.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "TextRange(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.start) * 31 + Integer.hashCode(this.end);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextRange)) {
            return false;
        }
        Object object = other;
        TextRange textRange = (TextRange)object;
        if (this.start != textRange.start) {
            return false;
        }
        return this.end == textRange.end;
    }
}

