/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.VisibleForTesting;
import androidx.ui.core.LayoutDirection;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Shadow;
import androidx.ui.text.LocaleList;
import androidx.ui.text.ParagraphStyleKt;
import androidx.ui.text.SpanStyleKt;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextAlign;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextIndent;
import androidx.ui.unit.TextUnit;
import androidx.ui.unit.TextUnitKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DefaultBackgroundColor", "Landroidx/ui/graphics/Color;", "DefaultColor", "DefaultFontSize", "Landroidx/ui/unit/TextUnit;", "DefaultLetterSpacing", "DefaultLineHeight", "lerp", "Landroidx/ui/text/TextStyle;", "start", "stop", "fraction", "", "resolveDefaults", "style", "direction", "Landroidx/ui/core/LayoutDirection;", "resolveTextDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "layoutDirection", "textDirectionAlgorithm", "ui-text_release"})
public final class TextStyleKt {
    private static final TextUnit DefaultFontSize = TextUnitKt.getSp((int)14);
    private static final TextUnit DefaultLetterSpacing = TextUnitKt.getSp((int)0);
    private static final Color DefaultBackgroundColor = Color.Companion.getTransparent();
    private static final TextUnit DefaultLineHeight = TextUnit.Companion.getInherit();
    private static final Color DefaultColor = Color.Companion.getBlack();

    @NotNull
    public static final TextStyle lerp(@NotNull TextStyle start, @NotNull TextStyle stop, float fraction) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        return new TextStyle(SpanStyleKt.lerp(start.toSpanStyle(), stop.toSpanStyle(), fraction), ParagraphStyleKt.lerp(start.toParagraphStyle(), stop.toParagraphStyle(), fraction));
    }

    @NotNull
    public static final TextStyle resolveDefaults(@NotNull TextStyle style, @NotNull LayoutDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        Object object = style.getColor();
        Color color = object == null ? DefaultColor : object;
        object = style.getFontWeight();
        Object object2 = object == null ? FontWeight.Companion.getNormal() : object;
        object = style.getFontStyle();
        FontStyle fontStyle = object == null ? FontStyle.Normal : object;
        object = style.getFontSynthesis();
        FontSynthesis fontSynthesis = object == null ? FontSynthesis.All : object;
        object = style.getFontFamily();
        Object object3 = object == null ? (FontFamily)FontFamily.Companion.getDefault() : object;
        object = style.getFontFeatureSettings();
        String string = object == null ? "" : object;
        object = style.getBaselineShift();
        Object object4 = object == null ? BaselineShift.Companion.getNone() : object;
        object = style.getTextGeometricTransform();
        Object object5 = object == null ? TextGeometricTransform.Companion.getNone$ui_text_release() : object;
        object = style.getLocaleList();
        Object object6 = object == null ? LocaleList.Companion.getCurrent() : object;
        object = style.getBackground();
        Color color2 = object == null ? DefaultBackgroundColor : object;
        object = style.getTextDecoration();
        Object object7 = object == null ? TextDecoration.Companion.getNone() : object;
        object = style.getShadow();
        Object object8 = object == null ? Shadow.Companion.getNone() : object;
        object = style.getTextAlign();
        TextAlign textAlign = object == null ? TextAlign.Start : object;
        object = style.getTextIndent();
        return new TextStyle(color, Intrinsics.areEqual((Object)style.getFontSize(), (Object)TextUnit.Companion.getInherit()) ? DefaultFontSize : style.getFontSize(), (FontWeight)object2, fontStyle, fontSynthesis, (FontFamily)object3, string, style.getLetterSpacing().isInherit() ? DefaultLetterSpacing : style.getLetterSpacing(), (BaselineShift)object4, (TextGeometricTransform)object5, (LocaleList)object6, color2, (TextDecoration)object7, (Shadow)object8, textAlign, TextStyleKt.resolveTextDirectionAlgorithm(direction, style.getTextDirectionAlgorithm()), style.getLineHeight().isInherit() ? DefaultLineHeight : style.getLineHeight(), object == null ? TextIndent.Companion.getNone() : object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @NotNull
    public static final TextDirectionAlgorithm resolveTextDirectionAlgorithm(@NotNull LayoutDirection layoutDirection, @Nullable TextDirectionAlgorithm textDirectionAlgorithm) {
        TextDirectionAlgorithm textDirectionAlgorithm2;
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        TextDirectionAlgorithm textDirectionAlgorithm3 = textDirectionAlgorithm;
        if (textDirectionAlgorithm3 == null) {
            LayoutDirection layoutDirection2 = layoutDirection;
            if (Intrinsics.areEqual((Object)layoutDirection2, (Object)LayoutDirection.Ltr)) {
                textDirectionAlgorithm2 = TextDirectionAlgorithm.ContentOrLtr;
                return textDirectionAlgorithm2;
            } else {
                if (!Intrinsics.areEqual((Object)layoutDirection2, (Object)LayoutDirection.Rtl)) throw new NoWhenBranchMatchedException();
                textDirectionAlgorithm2 = TextDirectionAlgorithm.ContentOrRtl;
            }
            return textDirectionAlgorithm2;
        } else {
            textDirectionAlgorithm2 = textDirectionAlgorithm3;
        }
        return textDirectionAlgorithm2;
    }
}

