/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.RequiresApi;
import androidx.text.style.BaselineShiftSpan;
import androidx.text.style.FontFeatureSpan;
import androidx.text.style.LetterSpacingSpanEm;
import androidx.text.style.LetterSpacingSpanPx;
import androidx.text.style.LineHeightSpan;
import androidx.text.style.PlaceholderSpan;
import androidx.text.style.ShadowSpan;
import androidx.text.style.SkewXSpan;
import androidx.text.style.TypefaceSpan;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.Locale;
import androidx.ui.text.LocaleList;
import androidx.ui.text.Placeholder;
import androidx.ui.text.PlaceholderVerticalAlign;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.platform.AndroidLocale;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextIndent;
import androidx.ui.unit.Density;
import androidx.ui.unit.TextUnit;
import androidx.ui.unit.TextUnitKt;
import androidx.ui.unit.TextUnitType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001ab\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00140\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0000\u001a$\u0010\"\u001a\u00020\u0015*\u00020#2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\f\u0010$\u001a\u00020%*\u00020\u0015H\u0002\u001a\f\u0010&\u001a\u00020'*\u00020(H\u0003\u001a\f\u0010)\u001a\u00020**\u00020+H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006,"}, d2={"spanUnit", "", "Landroidx/ui/unit/TextUnit;", "getSpanUnit", "(Landroidx/ui/unit/TextUnit;)I", "spanVerticalAlign", "Landroidx/ui/text/PlaceholderVerticalAlign;", "getSpanVerticalAlign", "(Landroidx/ui/text/PlaceholderVerticalAlign;)I", "createStyledText", "", "text", "", "contextFontSize", "", "lineHeight", "textIndent", "Landroidx/ui/text/style/TextIndent;", "spanStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/SpanStyle;", "placeholders", "Landroidx/ui/text/Placeholder;", "density", "Landroidx/ui/unit/Density;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "createTypeface", "Landroid/graphics/Typeface;", "style", "resolveTextDirectionHeuristics", "textDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "applySpanStyle", "Landroid/text/TextPaint;", "hasFontAttributes", "", "toAndroidLocaleList", "Landroid/os/LocaleList;", "Landroidx/ui/text/LocaleList;", "toJavaLocale", "Ljava/util/Locale;", "Landroidx/ui/text/Locale;", "ui-text_release"})
public final class AndroidParagraphHelperKt {
    @NotNull
    public static final SpanStyle applySpanStyle(@NotNull TextPaint $this$applySpanStyle, @NotNull SpanStyle style, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        TextPaint textPaint;
        Object it;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$applySpanStyle, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Object object = style.getFontSize().getType();
        if (Intrinsics.areEqual((Object)object, (Object)TextUnitType.Sp)) {
            boolean bl2 = false;
            bl = false;
            Density $this$applySpanStyle_u24lambda_u2d0 = density;
            $this$applySpanStyle.setTextSize($this$applySpanStyle_u24lambda_u2d0.toPx(style.getFontSize()).getValue());
        } else if (Intrinsics.areEqual((Object)object, (Object)TextUnitType.Em)) {
            TextPaint textPaint2 = $this$applySpanStyle;
            textPaint2.setTextSize(textPaint2.getTextSize() * style.getFontSize().getValue());
        } else if (!Intrinsics.areEqual((Object)object, (Object)TextUnitType.Inherit)) {
            throw new NoWhenBranchMatchedException();
        }
        if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
            $this$applySpanStyle.setTypeface(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter));
        }
        if ((object = style.getLocaleList()) != null) {
            Object object2 = object;
            bl = false;
            boolean bl3 = false;
            it = object2;
            if (Build.VERSION.SDK_INT >= 24) {
                $this$applySpanStyle.setTextLocales(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it));
            } else {
                Locale locale = ((LocaleList)it).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it).get(0);
                $this$applySpanStyle.setTextLocale(AndroidParagraphHelperKt.toJavaLocale(locale));
            }
        }
        object = style.getColor();
        if (object != null) {
            Object object3 = object;
            bl = false;
            boolean bl4 = false;
            it = object3;
            $this$applySpanStyle.setColor(ColorKt.toArgb((Color)it));
        }
        object = style.getLetterSpacing().getType();
        if (Intrinsics.areEqual((Object)object, (Object)TextUnitType.Em)) {
            $this$applySpanStyle.setLetterSpacing(style.getLetterSpacing().getValue());
        } else if (!Intrinsics.areEqual((Object)object, (Object)TextUnitType.Sp) && !Intrinsics.areEqual((Object)object, (Object)TextUnitType.Inherit)) {
            throw new NoWhenBranchMatchedException();
        }
        object = style.getFontFeatureSettings();
        if (object != null) {
            Object object4 = object;
            bl = false;
            boolean bl5 = false;
            it = object4;
            $this$applySpanStyle.setFontFeatureSettings((String)it);
        }
        object = style.getTextGeometricTransform();
        if (object != null) {
            Object object5 = object;
            bl = false;
            boolean bl6 = false;
            it = object5;
            textPaint = $this$applySpanStyle;
            textPaint.setTextScaleX(textPaint.getTextScaleX() * ((TextGeometricTransform)it).getScaleX());
        }
        object = style.getTextGeometricTransform();
        if (object != null) {
            Object object6 = object;
            bl = false;
            boolean bl7 = false;
            it = object6;
            textPaint = $this$applySpanStyle;
            textPaint.setTextSkewX(textPaint.getTextSkewX() + ((TextGeometricTransform)it).getSkewX());
        }
        object = style.getShadow();
        if (object != null) {
            Object object7 = object;
            bl = false;
            boolean bl8 = false;
            it = object7;
            $this$applySpanStyle.setShadowLayer(it.getBlurRadius().getValue(), it.getOffset().getDx(), it.getOffset().getDy(), ColorKt.toArgb((Color)it.getColor()));
        }
        object = style.getTextDecoration();
        if (object != null) {
            Object object8 = object;
            bl = false;
            boolean bl9 = false;
            it = object8;
            if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                $this$applySpanStyle.setUnderlineText(true);
            }
            if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                $this$applySpanStyle.setStrikeThruText(true);
            }
        }
        object = Intrinsics.areEqual((Object)style.getLetterSpacing().getType(), (Object)TextUnitType.Sp) && !(style.getLetterSpacing().getValue() == 0.0f) ? style.getLetterSpacing() : TextUnit.Companion.getInherit();
        Color color = Intrinsics.areEqual((Object)style.getBackground(), (Object)Color.Companion.getTransparent()) ? (Color)null : style.getBackground();
        BaselineShift baselineShift = Intrinsics.areEqual((Object)style.getBaselineShift(), (Object)BaselineShift.Companion.getNone()) ? (BaselineShift)null : style.getBaselineShift();
        return new SpanStyle(null, null, null, null, null, null, null, (TextUnit)object, baselineShift, null, null, color, null, null, 13951, null);
    }

    @NotNull
    public static final CharSequence createStyledText(@NotNull String text, float contextFontSize, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent, @NotNull List<AnnotatedString.Item<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Item<Placeholder>> placeholders, @NotNull Density density, @NotNull TypefaceAdapter typefaceAdapter) {
        boolean bl;
        boolean bl2;
        Unit unit;
        Unit unit2;
        boolean bl3;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(placeholders, (String)"placeholders");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        if (spanStyles.isEmpty() && textIndent == null) {
            return text;
        }
        SpannableString spannableString = new SpannableString((CharSequence)text);
        boolean bl4 = false;
        List deferredSpans = new ArrayList();
        Object object = lineHeight.getType();
        if (Intrinsics.areEqual((Object)object, (Object)TextUnitType.Sp)) {
            boolean bl5 = false;
            bl3 = false;
            Density $this$createStyledText_u24lambda_u2d8 = density;
            float f = $this$createStyledText_u24lambda_u2d8.toPx(lineHeight).getValue();
            SpannableString spannableString2 = spannableString;
            boolean bl6 = false;
            float f2 = (float)Math.ceil(f);
            int n = (int)f2;
            spannableString2.setSpan((Object)new LineHeightSpan(n), 0, text.length(), 33);
            unit2 = Unit.INSTANCE;
        } else if (Intrinsics.areEqual((Object)object, (Object)TextUnitType.Em)) {
            float f = lineHeight.getValue() * contextFontSize;
            SpannableString spannableString3 = spannableString;
            bl3 = false;
            float f3 = (float)Math.ceil(f);
            int n = (int)f3;
            spannableString3.setSpan((Object)new LineHeightSpan(n), 0, text.length(), 33);
            unit2 = Unit.INSTANCE;
        } else if (Intrinsics.areEqual((Object)object, (Object)TextUnitType.Inherit)) {
            unit2 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        object = textIndent;
        if (object == null) {
            unit = null;
        } else {
            Object object2 = object;
            bl3 = false;
            boolean $this$createStyledText_u24lambda_u2d8 = false;
            Object indent = object2;
            if (!Intrinsics.areEqual((Object)((TextIndent)indent).getFirstLine(), (Object)TextUnitKt.getSp((int)0)) || !Intrinsics.areEqual((Object)((TextIndent)indent).getRestLine(), (Object)TextUnitKt.getSp((int)0))) {
                if (!((TextIndent)indent).getFirstLine().isInherit() && !((TextIndent)indent).getRestLine().isInherit()) {
                    float f;
                    float f2;
                    bl2 = false;
                    bl = false;
                    Density $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = density;
                    TextUnitType textUnitType = ((TextIndent)indent).getFirstLine().getType();
                    if (Intrinsics.areEqual((Object)textUnitType, (Object)TextUnitType.Sp)) {
                        f2 = $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9.toPx(((TextIndent)indent).getFirstLine()).getValue();
                    } else if (Intrinsics.areEqual((Object)textUnitType, (Object)TextUnitType.Em)) {
                        f2 = ((TextIndent)indent).getFirstLine().getValue() * contextFontSize;
                    } else if (Intrinsics.areEqual((Object)textUnitType, (Object)TextUnitType.Inherit)) {
                        f2 = 0.0f;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    float firstLine = f2;
                    TextUnitType textUnitType2 = ((TextIndent)indent).getRestLine().getType();
                    if (Intrinsics.areEqual((Object)textUnitType2, (Object)TextUnitType.Sp)) {
                        f = $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9.toPx(((TextIndent)indent).getRestLine()).getValue();
                    } else if (Intrinsics.areEqual((Object)textUnitType2, (Object)TextUnitType.Em)) {
                        f = ((TextIndent)indent).getRestLine().getValue() * contextFontSize;
                    } else if (Intrinsics.areEqual((Object)textUnitType2, (Object)TextUnitType.Inherit)) {
                        f = 0.0f;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    float restLine = f;
                    SpannableString spannableString4 = spannableString;
                    boolean bl7 = false;
                    float f5 = (float)Math.ceil(firstLine);
                    int n = (int)f5;
                    bl7 = false;
                    float f6 = (float)Math.ceil(restLine);
                    int n2 = (int)f6;
                    int n3 = n;
                    spannableString4.setSpan((Object)new LeadingMarginSpan.Standard(n3, n2), 0, text.length(), 33);
                }
            }
            unit = Unit.INSTANCE;
        }
        for (AnnotatedString.Item item : spanStyles) {
            Unit unit3;
            Unit unit4;
            Unit unit5;
            Object object2;
            Unit unit6;
            Unit unit7;
            Unit unit8;
            Unit unit9;
            Unit unit10;
            Unit unit11;
            Unit unit12;
            boolean restLine;
            Unit unit13;
            int start = item.getStart();
            int end = item.getEnd();
            SpanStyle style = (SpanStyle)item.getItem();
            if (start < 0 || start >= text.length() || end <= start || end > text.length()) continue;
            Object object4 = style.getBaselineShift();
            if (object4 == null) {
                unit13 = null;
            } else {
                BaselineShift baselineShift = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                restLine = false;
                BaselineShift it = baselineShift;
                spannableString.setSpan((Object)new BaselineShiftSpan(it.getMultiplier()), start, end, 33);
                unit13 = Unit.INSTANCE;
            }
            object4 = style.getColor();
            if (object4 == null) {
                unit12 = null;
            } else {
                BaselineShift baselineShift = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                restLine = false;
                BaselineShift it = baselineShift;
                spannableString.setSpan((Object)new ForegroundColorSpan(ColorKt.toArgb((Color)it)), start, end, 33);
                unit12 = Unit.INSTANCE;
            }
            object4 = style.getTextDecoration();
            if (object4 == null) {
                unit11 = null;
            } else {
                Unit unit14;
                Unit unit15;
                Object object5 = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                restLine = false;
                Object it = object5;
                if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                    spannableString.setSpan((Object)new UnderlineSpan(), start, end, 33);
                    unit15 = Unit.INSTANCE;
                } else {
                    unit15 = Unit.INSTANCE;
                }
                if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                    spannableString.setSpan((Object)new StrikethroughSpan(), start, end, 33);
                    unit14 = Unit.INSTANCE;
                } else {
                    unit14 = Unit.INSTANCE;
                }
                unit11 = Unit.INSTANCE;
            }
            object4 = style.getFontSize().getType();
            if (Intrinsics.areEqual((Object)object4, (Object)TextUnitType.Sp)) {
                bl = false;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                Density $this$createStyledText_u24lambda_u2d14 = density;
                spannableString.setSpan((Object)new AbsoluteSizeSpan(MathKt.roundToInt((float)$this$createStyledText_u24lambda_u2d14.toPx(style.getFontSize()).getValue()), true), start, end, 33);
                unit10 = Unit.INSTANCE;
            } else if (Intrinsics.areEqual((Object)object4, (Object)TextUnitType.Em)) {
                spannableString.setSpan((Object)new RelativeSizeSpan(style.getFontSize().getValue()), start, end, 33);
                unit10 = Unit.INSTANCE;
            } else if (Intrinsics.areEqual((Object)object4, (Object)TextUnitType.Inherit)) {
                unit10 = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object4 = style.getFontFeatureSettings();
            if (object4 == null) {
                unit9 = null;
            } else {
                Object object6 = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean $this$createStyledText_u24lambda_u2d14 = false;
                Object it = object6;
                spannableString.setSpan((Object)new FontFeatureSpan((String)it), start, end, 33);
                unit9 = Unit.INSTANCE;
            }
            if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
                spannableString.setSpan((Object)new TypefaceSpan(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter)), start, end, 33);
                unit8 = Unit.INSTANCE;
            } else {
                unit8 = Unit.INSTANCE;
            }
            object4 = style.getTextGeometricTransform();
            if (object4 == null) {
                unit7 = null;
            } else {
                Unit unit16;
                Object object7 = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean $this$createStyledText_u24lambda_u2d14 = false;
                Object it = object7;
                if (!(((TextGeometricTransform)it).getScaleX() == 1.0f)) {
                    spannableString.setSpan((Object)new ScaleXSpan(((TextGeometricTransform)it).getScaleX()), start, end, 33);
                    unit16 = Unit.INSTANCE;
                } else {
                    unit16 = Unit.INSTANCE;
                }
                unit7 = Unit.INSTANCE;
            }
            object4 = style.getTextGeometricTransform();
            if (object4 == null) {
                unit6 = null;
            } else {
                Unit unit17;
                Object object8 = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean $this$createStyledText_u24lambda_u2d14 = false;
                Object it = object8;
                if (!(((TextGeometricTransform)it).getSkewX() == 0.0f)) {
                    spannableString.setSpan((Object)new SkewXSpan(((TextGeometricTransform)it).getSkewX()), start, end, 33);
                    unit17 = Unit.INSTANCE;
                } else {
                    unit17 = Unit.INSTANCE;
                }
                unit6 = Unit.INSTANCE;
            }
            object4 = style.getLetterSpacing().getType();
            if (Intrinsics.areEqual((Object)object4, (Object)TextUnitType.Sp)) {
                boolean bl8 = false;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                Density $this$createStyledText_u24lambda_u2d18 = density;
                object2 = deferredSpans.add(new Triple((Object)new LetterSpacingSpanPx($this$createStyledText_u24lambda_u2d18.toPx(style.getLetterSpacing()).getValue()), (Object)start, (Object)end));
            } else if (Intrinsics.areEqual((Object)object4, (Object)TextUnitType.Em)) {
                object2 = deferredSpans.add(new Triple((Object)new LetterSpacingSpanEm(style.getLetterSpacing().getValue()), (Object)start, (Object)end));
            } else if (Intrinsics.areEqual((Object)object4, (Object)TextUnitType.Inherit)) {
                object2 = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object4 = style.getLocaleList();
            if (object4 == null) {
                unit5 = null;
            } else {
                LocaleSpan localeSpan;
                Object object9 = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl9 = false;
                Object it = object9;
                if (Build.VERSION.SDK_INT >= 24) {
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it));
                } else {
                    Locale locale = ((LocaleList)it).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it).get(0);
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toJavaLocale(locale));
                }
                spannableString.setSpan((Object)localeSpan, start, end, 33);
                unit5 = Unit.INSTANCE;
            }
            object4 = style.getBackground();
            if (object4 == null) {
                unit4 = null;
            } else {
                Object object10 = object4;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl10 = false;
                Object it = object10;
                spannableString.setSpan((Object)new BackgroundColorSpan(ColorKt.toArgb((Color)it)), start, end, 33);
                unit4 = Unit.INSTANCE;
            }
            object4 = style.getShadow();
            if (object4 == null) {
                unit3 = null;
                continue;
            }
            Object object11 = object4;
            boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
            boolean bl11 = false;
            Object it = object11;
            spannableString.setSpan((Object)new ShadowSpan(ColorKt.toArgb((Color)it.getColor()), it.getOffset().getDx(), it.getOffset().getDy(), it.getBlurRadius().getValue()), start, end, 33);
            unit3 = Unit.INSTANCE;
        }
        for (Triple triple : deferredSpans) {
            Object span = triple.component1();
            int start = ((Number)triple.component2()).intValue();
            int end = ((Number)triple.component3()).intValue();
            spannableString.setSpan(span, start, end, 33);
        }
        for (AnnotatedString.Item item : placeholders) {
            Placeholder placeholder = (Placeholder)item.component1();
            int start = item.component2();
            int end = item.component3();
            bl2 = false;
            bl = false;
            Placeholder $this$createStyledText_u24lambda_u2d22 = placeholder;
            spannableString.setSpan((Object)new PlaceholderSpan($this$createStyledText_u24lambda_u2d22.getWidth().getValue(), AndroidParagraphHelperKt.getSpanUnit($this$createStyledText_u24lambda_u2d22.getWidth()), $this$createStyledText_u24lambda_u2d22.getHeight().getValue(), AndroidParagraphHelperKt.getSpanUnit($this$createStyledText_u24lambda_u2d22.getHeight()), density.getFontScale() * density.getDensity(), AndroidParagraphHelperKt.getSpanVerticalAlign($this$createStyledText_u24lambda_u2d22.getPlaceholderVerticalAlign())), start, end, 33);
        }
        return (CharSequence)spannableString;
    }

    private static final boolean hasFontAttributes(SpanStyle $this$hasFontAttributes) {
        return $this$hasFontAttributes.getFontFamily() != null || $this$hasFontAttributes.getFontStyle() != null || $this$hasFontAttributes.getFontWeight() != null;
    }

    private static final Typeface createTypeface(SpanStyle style, TypefaceAdapter typefaceAdapter) {
        Object object = style.getFontWeight();
        FontWeight fontWeight = object == null ? FontWeight.Companion.getNormal() : object;
        object = style.getFontStyle();
        Object object2 = object == null ? FontStyle.Normal : object;
        object = style.getFontSynthesis();
        return typefaceAdapter.create(style.getFontFamily(), fontWeight, (FontStyle)((Object)object2), (FontSynthesis)((Object)(object == null ? FontSynthesis.All : object)));
    }

    public static final int resolveTextDirectionHeuristics(@NotNull TextDirectionAlgorithm textDirectionAlgorithm) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textDirectionAlgorithm), (String)"textDirectionAlgorithm");
        TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm;
        if (Intrinsics.areEqual((Object)((Object)textDirectionAlgorithm2), (Object)((Object)TextDirectionAlgorithm.ContentOrLtr))) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)((Object)textDirectionAlgorithm2), (Object)((Object)TextDirectionAlgorithm.ContentOrRtl))) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)((Object)textDirectionAlgorithm2), (Object)((Object)TextDirectionAlgorithm.ForceLtr))) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)((Object)textDirectionAlgorithm2), (Object)((Object)TextDirectionAlgorithm.ForceRtl))) {
            n = 1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private static final java.util.Locale toJavaLocale(Locale $this$toJavaLocale) {
        return ((AndroidLocale)$this$toJavaLocale.getPlatformLocale$ui_text_release()).getJavaLocale();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=24)
    private static final android.os.LocaleList toAndroidLocaleList(LocaleList $this$toAndroidLocaleList) {
        Collection<java.util.Locale> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toAndroidLocaleList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            collection = destination$iv$iv;
            java.util.Locale locale2 = AndroidParagraphHelperKt.toJavaLocale((Locale)it);
            collection.add(locale2);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        java.util.Locale[] localeArray = thisCollection$iv.toArray(new java.util.Locale[0]);
        if (localeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = localeArray;
        java.util.Locale[] localeArray2 = (java.util.Locale[])collection;
        java.util.Locale[] localeArray3 = new java.util.Locale[localeArray2.length];
        System.arraycopy(localeArray2, 0, localeArray3, 0, localeArray2.length);
        java.util.Locale[] localeArray4 = localeArray3;
        return new android.os.LocaleList(localeArray4);
    }

    public static final int getSpanUnit(@NotNull TextUnit $this$spanUnit) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$this$spanUnit, (String)"<this>");
        TextUnitType textUnitType = $this$spanUnit.getType();
        if (Intrinsics.areEqual((Object)textUnitType, (Object)TextUnitType.Sp)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)textUnitType, (Object)TextUnitType.Em)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)textUnitType, (Object)TextUnitType.Inherit)) {
            n = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public static final int getSpanVerticalAlign(@NotNull PlaceholderVerticalAlign $this$spanVerticalAlign) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$spanVerticalAlign), (String)"<this>");
        PlaceholderVerticalAlign placeholderVerticalAlign = $this$spanVerticalAlign;
        if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.AboveBaseline))) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.Top))) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.Bottom))) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.Center))) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.TextTop))) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.TextBottom))) {
            n = 5;
        } else if (Intrinsics.areEqual((Object)((Object)placeholderVerticalAlign), (Object)((Object)PlaceholderVerticalAlign.TextCenter))) {
            n = 6;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }
}

