/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.style;

import androidx.compose.Immutable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\n\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u0006\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Landroidx/ui/text/style/TextDecoration;", "", "mask", "", "getMask", "()I", "component1", "contains", "", "other", "copy", "equals", "hashCode", "toString", "", "Companion", "ui-text_release"})
@Immutable
public final class TextDecoration {
    private final int mask;
    private static final TextDecoration None;
    private static final TextDecoration Underline;
    private static final TextDecoration LineThrough;
    @NotNull
    public static final Companion Companion;

    public TextDecoration(int mask) {
        this.mask = mask;
    }

    public final int getMask() {
        return this.mask;
    }

    public final boolean contains(@NotNull TextDecoration other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return (this.getMask() | other.getMask()) == this.getMask();
    }

    @NotNull
    public String toString() {
        if (this.getMask() == 0) {
            return "TextDecoration.None";
        }
        boolean bl = false;
        List values = new ArrayList();
        if ((this.getMask() & Companion.getUnderline().getMask()) != 0) {
            values.add("Underline");
        }
        if ((this.getMask() & Companion.getLineThrough().getMask()) != 0) {
            values.add("LineThrough");
        }
        if (values.size() == 1) {
            return Intrinsics.stringPlus((String)"TextDecoration.", (Object)((String)values.get(0)));
        }
        return "TextDecoration.combine([" + CollectionsKt.joinToString$default((Iterable)values, (CharSequence)", ", (CharSequence)null, (CharSequence)null, (int)0, (CharSequence)null, (Function1)null, (int)62, null) + "])";
    }

    public final int component1() {
        return this.mask;
    }

    @NotNull
    public final TextDecoration copy(int mask) {
        return new TextDecoration(mask);
    }

    public static /* synthetic */ TextDecoration copy$default(@NotNull TextDecoration this_, int mask, int $mask0, @Nullable Object $handler) {
        int n = ($mask0 & 1) != 0 ? this_.mask : mask;
        return this_.copy(n);
    }

    public int hashCode() {
        return Integer.hashCode(this.mask);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextDecoration)) {
            return false;
        }
        Object object = other;
        TextDecoration textDecoration = (TextDecoration)object;
        return this.mask == textDecoration.mask;
    }

    static {
        Companion = new Companion(null);
        None = new TextDecoration(0);
        Underline = new TextDecoration(1);
        LineThrough = new TextDecoration(2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u0014\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005\u00a8\u0006\r"}, d2={"Landroidx/ui/text/style/TextDecoration$Companion;", "", "LineThrough", "Landroidx/ui/text/style/TextDecoration;", "getLineThrough", "()Landroidx/ui/text/style/TextDecoration;", "None", "getNone", "Underline", "getUnderline", "combine", "decorations", "", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextDecoration getNone() {
            return None;
        }

        @NotNull
        public final TextDecoration getUnderline() {
            return Underline;
        }

        @NotNull
        public final TextDecoration getLineThrough() {
            return LineThrough;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TextDecoration combine(@NotNull List<TextDecoration> decorations) {
            void $this$fold$iv;
            Intrinsics.checkParameterIsNotNull(decorations, (String)"decorations");
            Iterable iterable = decorations;
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void decoration;
                TextDecoration textDecoration = (TextDecoration)element$iv;
                int acc = accumulator$iv;
                accumulator$iv = acc | decoration.getMask();
            }
            int mask = accumulator$iv;
            return new TextDecoration(mask);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

