/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.text.AnnotatedStringKt;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.SpanStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001:\u0002&'BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u0012\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u000b0\u0005\u00a2\u0006\u0002\u0010\fBY\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u0012\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u000b0\u0005\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005H\u00c6\u0003J\u0019\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u000b0\u0005H\u00c6\u0003J\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0019J]\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u00052\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u000b0\u00052\u0014\b\u0002\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J*\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00052\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\t\u0010#\u001a\u00020!H\u00d6\u0001J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Landroidx/ui/text/AnnotatedString;", "", "text", "", "spanStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/SpanStyle;", "Landroidx/ui/text/SpanStyleItem;", "paragraphStyles", "Landroidx/ui/text/ParagraphStyle;", "Landroidx/ui/text/ParagraphStyleItem;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "annotations", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAnnotations$ui_text_release", "()Ljava/util/List;", "getParagraphStyles", "getSpanStyles", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component4$ui_text_release", "copy", "equals", "", "other", "getStringAnnotations", "scope", "start", "", "end", "hashCode", "plus", "toString", "Builder", "Item", "ui-text_release"})
public final class AnnotatedString {
    private final String text;
    private final List<Item<SpanStyle>> spanStyles;
    private final List<Item<ParagraphStyle>> paragraphStyles;
    private final List<Item<String>> annotations;

    public AnnotatedString(@NotNull String text, @NotNull List<Item<SpanStyle>> spanStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles, @NotNull List<Item<String>> annotations) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        this.text = text;
        this.spanStyles = spanStyles;
        this.paragraphStyles = paragraphStyles;
        this.annotations = annotations;
        int lastStyleEnd = -1;
        for (Item<ParagraphStyle> paragraphStyle : this.getParagraphStyles()) {
            boolean bl = paragraphStyle.getStart() >= lastStyleEnd;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                String string = "ParagraphStyle should not overlap";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = paragraphStyle.getEnd() <= this.getText().length();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                String string = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            lastStyleEnd = paragraphStyle.getEnd();
        }
    }

    public /* synthetic */ AnnotatedString(String text, List spanStyles, List paragraphStyles, List annotations, int $mask0, DefaultConstructorMarker $marker) {
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        if (($mask0 & 2) != 0) {
            boolean bl = false;
            list5 = CollectionsKt.emptyList();
        } else {
            list5 = list4 = spanStyles;
        }
        if (($mask0 & 4) != 0) {
            boolean bl = false;
            list3 = CollectionsKt.emptyList();
        } else {
            list3 = list2 = paragraphStyles;
        }
        if (($mask0 & 8) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = annotations;
        }
        List list6 = list;
        this(text, list4, list2, list6);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Item<SpanStyle>> getSpanStyles() {
        return this.spanStyles;
    }

    @NotNull
    public final List<Item<ParagraphStyle>> getParagraphStyles() {
        return this.paragraphStyles;
    }

    @NotNull
    public final List<Item<String>> getAnnotations$ui_text_release() {
        return this.annotations;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Item<SpanStyle>> spanStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        List<Item<ParagraphStyle>> list = paragraphStyles;
        List<Item<SpanStyle>> list2 = spanStyles;
        String string = text;
        AnnotatedString annotatedString = this;
        boolean bl = false;
        List list3 = CollectionsKt.emptyList();
        annotatedString(string, list2, list, list3);
    }

    public /* synthetic */ AnnotatedString(String text, List spanStyles, List paragraphStyles, int $mask0, DefaultConstructorMarker $marker) {
        List list;
        List list2;
        List list3;
        if (($mask0 & 2) != 0) {
            boolean bl = false;
            list3 = CollectionsKt.emptyList();
        } else {
            list3 = list2 = spanStyles;
        }
        if (($mask0 & 4) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = paragraphStyles;
        }
        List list4 = list;
        this(text, list2, list4);
    }

    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Builder builder = new Builder(this);
        boolean bl = false;
        boolean bl2 = false;
        Builder $this$plus_u24lambda_u2d2 = builder;
        $this$plus_u24lambda_u2d2.append(other);
        return $this$plus_u24lambda_u2d2.toAnnotatedString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Item<String>> getStringAnnotations(@NotNull String scope, int start, int end) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Iterable $this$filter$iv = this.getAnnotations$ui_text_release();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Item it = (Item)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)scope, (Object)it.getScope()) && AnnotatedStringKt.intersect(start, end, it.getStart(), it.getEnd()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final List<Item<SpanStyle>> component2() {
        return this.spanStyles;
    }

    @NotNull
    public final List<Item<ParagraphStyle>> component3() {
        return this.paragraphStyles;
    }

    @NotNull
    public final List<Item<String>> component4$ui_text_release() {
        return this.annotations;
    }

    @NotNull
    public final AnnotatedString copy(@NotNull String text, @NotNull List<Item<SpanStyle>> spanStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles, @NotNull List<Item<String>> annotations) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        return new AnnotatedString(text, spanStyles, paragraphStyles, annotations);
    }

    public static /* synthetic */ AnnotatedString copy$default(@NotNull AnnotatedString this_, @Nullable String text, @Nullable List spanStyles, @Nullable List paragraphStyles, @Nullable List annotations, int $mask0, @Nullable Object $handler) {
        String string = ($mask0 & 1) != 0 ? this_.text : text;
        List<Item<SpanStyle>> list = ($mask0 & 2) != 0 ? this_.spanStyles : spanStyles;
        List<Item<ParagraphStyle>> list2 = ($mask0 & 4) != 0 ? this_.paragraphStyles : paragraphStyles;
        List<Item<String>> list3 = ($mask0 & 8) != 0 ? this_.annotations : annotations;
        return this_.copy(string, list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "AnnotatedString(text=" + this.text + ", spanStyles=" + this.spanStyles + ", paragraphStyles=" + this.paragraphStyles + ", annotations=" + this.annotations + ")";
    }

    public int hashCode() {
        return ((this.text.hashCode() * 31 + this.spanStyles.hashCode()) * 31 + this.paragraphStyles.hashCode()) * 31 + this.annotations.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedString)) {
            return false;
        }
        Object object = other;
        AnnotatedString annotatedString = (AnnotatedString)object;
        if (!Intrinsics.areEqual((Object)this.text, (Object)annotatedString.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.spanStyles, annotatedString.spanStyles)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paragraphStyles, annotatedString.paragraphStyles)) {
            return false;
        }
        return Intrinsics.areEqual(this.annotations, annotatedString.annotations);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001e"}, d2={"Landroidx/ui/text/AnnotatedString$Item;", "T", "", "item", "start", "", "end", "(Ljava/lang/Object;II)V", "scope", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getScope", "()Ljava/lang/String;", "getStart", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/ui/text/AnnotatedString$Item;", "equals", "", "other", "hashCode", "toString", "ui-text_release"})
    public static final class Item<T> {
        private final T item;
        private final int start;
        private final int end;
        private final String scope;

        public Item(T item, int start, int end, @NotNull String scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.item = item;
            this.start = start;
            this.end = end;
            this.scope = scope;
            boolean bl = this.getStart() <= this.getEnd();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                String string = "Reversed range is not supported";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public final T getItem() {
            return this.item;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        public Item(T item, int start, int end) {
            this(item, start, end, "");
        }

        public final T component1() {
            return this.item;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final String component4() {
            return this.scope;
        }

        @NotNull
        public final Item<T> copy(T item, int start, int end, @NotNull String scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            return new Item<T>(item, start, end, scope);
        }

        public static /* synthetic */ Item copy$default(@NotNull Item this_, @Nullable Object item, int start, int end, @Nullable String scope, int $mask0, @Nullable Object $handler) {
            Object object = ($mask0 & 1) != 0 ? this_.item : item;
            int n = ($mask0 & 2) != 0 ? this_.start : start;
            int n2 = ($mask0 & 4) != 0 ? this_.end : end;
            String string = ($mask0 & 8) != 0 ? this_.scope : scope;
            return this_.copy(object, n, n2, string);
        }

        @NotNull
        public String toString() {
            return "Item(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", scope=" + this.scope + ")";
        }

        public int hashCode() {
            return (((this.item == null ? 0 : this.item.hashCode()) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end)) * 31 + this.scope.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Object object = other;
            Item item = (Item)object;
            if (!Intrinsics.areEqual(this.item, item.item)) {
                return false;
            }
            if (this.start != item.start) {
                return false;
            }
            if (this.end != item.end) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scope, (Object)item.scope);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\bJ\u0016\u0010$\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010&\u001a\u00020\u0005J\b\u0010'\u001a\u00020\u0003H\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/ui/text/AnnotatedString$Builder;", "", "text", "", "(Ljava/lang/String;)V", "Landroidx/ui/text/AnnotatedString;", "(Landroidx/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "annotations", "", "Landroidx/ui/text/AnnotatedString$Builder$MutableItem;", "length", "getLength", "()I", "paragraphStyles", "Landroidx/ui/text/ParagraphStyle;", "spanStyles", "Landroidx/ui/text/SpanStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addAnnotationString", "", "scope", "annotation", "start", "end", "addStyle", "style", "append", "char", "", "pop", "index", "pushStringAnnotation", "pushStyle", "toAnnotatedString", "toString", "MutableItem", "ui-text_release"})
    public static final class Builder {
        private final StringBuilder text;
        private final List<MutableItem<SpanStyle>> spanStyles;
        private final List<MutableItem<ParagraphStyle>> paragraphStyles;
        private final List<MutableItem<String>> annotations;
        private final List<MutableItem<? extends Object>> styleStack;

        public Builder(int capacity) {
            List list;
            this.text = new StringBuilder(capacity);
            Builder builder = this;
            boolean bl = false;
            builder.spanStyles = list = (List)new ArrayList();
            builder = this;
            bl = false;
            builder.paragraphStyles = list = (List)new ArrayList();
            builder = this;
            bl = false;
            builder.annotations = list = (List)new ArrayList();
            builder = this;
            bl = false;
            builder.styleStack = list = (List)new ArrayList();
        }

        public /* synthetic */ Builder(int capacity, int $mask0, DefaultConstructorMarker $marker) {
            int n = ($mask0 & 1) != 0 ? 16 : capacity;
            this(n);
        }

        public Builder(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public Builder(@NotNull AnnotatedString text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public final int getLength() {
            return this.text.length();
        }

        @NotNull
        public String toString() {
            return this.text.toString();
        }

        public final void append(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.text.append(text);
        }

        public final void append(char c) {
            this.text.append(c);
        }

        public final void append(@NotNull AnnotatedString text) {
            Item it;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int start = this.text.length();
            this.text.append(text.getText());
            Iterable $this$forEach$iv = text.getSpanStyles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Item)element$iv;
                this.addStyle((SpanStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
            }
            $this$forEach$iv = text.getParagraphStyles();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Item)element$iv;
                this.addStyle((ParagraphStyle)it.getItem(), start + it.getStart(), start + it.getEnd());
            }
            $this$forEach$iv = text.getAnnotations$ui_text_release();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Item)element$iv;
                this.addAnnotationString(it.getScope(), (String)it.getItem(), start + it.getStart(), start + it.getEnd());
            }
        }

        public final void addStyle(@NotNull SpanStyle style, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            this.spanStyles.add(new MutableItem(style, start, end, null, 8, null));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            this.paragraphStyles.add(new MutableItem(style, start, end, null, 8, null));
        }

        public final void addAnnotationString(@NotNull String scope, @NotNull String annotation, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            this.annotations.add(new MutableItem<String>(annotation, start, end, scope));
        }

        public final int pushStyle(@NotNull SpanStyle style) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            MutableItem mutableItem = new MutableItem(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableItem it = mutableItem;
            this.styleStack.add(it);
            this.spanStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            MutableItem mutableItem = new MutableItem(style, this.text.length(), 0, null, 12, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableItem it = mutableItem;
            this.styleStack.add(it);
            this.paragraphStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStringAnnotation(@NotNull String scope, @NotNull String annotation) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            MutableItem mutableItem = new MutableItem(annotation, this.text.length(), 0, scope, 4, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableItem it = mutableItem;
            this.styleStack.add(it);
            this.annotations.add(it);
            return this.styleStack.size() - 1;
        }

        public final void pop() {
            Collection collection = this.styleStack;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                String string = "Nothing to pop.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            MutableItem<? extends Object> item = this.styleStack.remove(this.styleStack.size() - 1);
            item.setEnd(this.text.length());
        }

        public final void pop(int index) {
            boolean bl = index < this.styleStack.size();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                String string = index + " should be less than " + this.styleStack.size();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            while (this.styleStack.size() - 1 >= index) {
                this.pop();
            }
        }

        @NotNull
        public final AnnotatedString toAnnotatedString() {
            Object object;
            Object object2;
            MutableItem it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = this.spanStyles;
            String string = this.text.toString();
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MutableItem mutableItem = (MutableItem)item$iv$iv;
                collection = destination$iv$iv;
                object2 = it.toItem(this.text.length());
                collection.add(object2);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = this.paragraphStyles;
            collection = CollectionsKt.toList((Iterable)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MutableItem)item$iv$iv;
                object2 = destination$iv$iv;
                object = it.toItem(this.text.length());
                object2.add(object);
            }
            object2 = (List)destination$iv$iv;
            $this$map$iv = this.annotations;
            object2 = CollectionsKt.toList((Iterable)((Iterable)object2));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MutableItem)item$iv$iv;
                object = destination$iv$iv;
                Item item = it.toItem(this.text.length());
                object.add(item);
            }
            object = (List)destination$iv$iv;
            List list = CollectionsKt.toList((Iterable)((Iterable)object));
            Object object3 = object2;
            Collection collection2 = collection;
            String string2 = string;
            return new AnnotatedString(string2, (List<Item<SpanStyle>>)collection2, (List<Item<ParagraphStyle>>)object3, list);
        }

        public Builder() {
            this(0, 1, null);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J<\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\u0005J\t\u0010!\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\""}, d2={"Landroidx/ui/text/AnnotatedString$Builder$MutableItem;", "T", "", "item", "start", "", "end", "scope", "", "(Ljava/lang/Object;IILjava/lang/String;)V", "getEnd", "()I", "setEnd", "(I)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getScope", "()Ljava/lang/String;", "getStart", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;IILjava/lang/String;)Landroidx/ui/text/AnnotatedString$Builder$MutableItem;", "equals", "", "other", "hashCode", "toItem", "Landroidx/ui/text/AnnotatedString$Item;", "defaultEnd", "toString", "ui-text_release"})
        private static final class MutableItem<T> {
            private final T item;
            private final int start;
            private int end;
            private final String scope;

            public MutableItem(T item, int start, int end, @NotNull String scope) {
                Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
                this.item = item;
                this.start = start;
                this.end = end;
                this.scope = scope;
            }

            public /* synthetic */ MutableItem(Object item, int start, int end, String scope, int $mask0, DefaultConstructorMarker $marker) {
                int n = ($mask0 & 4) != 0 ? Integer.MIN_VALUE : end;
                String string = ($mask0 & 8) != 0 ? "" : scope;
                this(item, start, n, string);
            }

            public final T getItem() {
                return this.item;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            @NotNull
            public final String getScope() {
                return this.scope;
            }

            @NotNull
            public final Item<T> toItem(int defaultEnd) {
                int end = this.getEnd() == Integer.MIN_VALUE ? defaultEnd : this.getEnd();
                boolean bl = end != Integer.MIN_VALUE;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    String string = "Item.end should be set first";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return new Item<T>(this.getItem(), this.getStart(), end, this.getScope());
            }

            public static /* synthetic */ Item toItem$default(@NotNull MutableItem this_, int defaultEnd, int $mask0, @Nullable Object $handler) {
                int n = ($mask0 & 1) != 0 ? Integer.MIN_VALUE : defaultEnd;
                return this_.toItem(n);
            }

            public final T component1() {
                return this.item;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final String component4() {
                return this.scope;
            }

            @NotNull
            public final MutableItem<T> copy(T item, int start, int end, @NotNull String scope) {
                Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
                return new MutableItem<T>(item, start, end, scope);
            }

            public static /* synthetic */ MutableItem copy$default(@NotNull MutableItem this_, @Nullable Object item, int start, int end, @Nullable String scope, int $mask0, @Nullable Object $handler) {
                Object object = ($mask0 & 1) != 0 ? this_.item : item;
                int n = ($mask0 & 2) != 0 ? this_.start : start;
                int n2 = ($mask0 & 4) != 0 ? this_.end : end;
                String string = ($mask0 & 8) != 0 ? this_.scope : scope;
                return this_.copy(object, n, n2, string);
            }

            @NotNull
            public String toString() {
                return "MutableItem(item=" + this.item + ", start=" + this.start + ", end=" + this.end + ", scope=" + this.scope + ")";
            }

            public int hashCode() {
                return (((this.item == null ? 0 : this.item.hashCode()) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end)) * 31 + this.scope.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutableItem)) {
                    return false;
                }
                Object object = other;
                MutableItem mutableItem = (MutableItem)object;
                if (!Intrinsics.areEqual(this.item, mutableItem.item)) {
                    return false;
                }
                if (this.start != mutableItem.start) {
                    return false;
                }
                if (this.end != mutableItem.end) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.scope, (Object)mutableItem.scope);
            }
        }
    }
}

