/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Path;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.AnnotatedStringKt;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.MultiParagraphKt;
import androidx.ui.text.Paragraph;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphInfo;
import androidx.ui.text.ParagraphIntrinsicInfo;
import androidx.ui.text.ParagraphKt;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirection;
import androidx.ui.unit.Density;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B)\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0013J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0007J\u000e\u00105\u001a\u0002062\u0006\u00104\u001a\u00020\u0007J\u000e\u00107\u001a\u0002062\u0006\u00104\u001a\u00020\u0007J\u0016\u00108\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u00072\u0006\u00109\u001a\u00020\tJ\u000e\u0010:\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010<\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007J\u000e\u0010=\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010>\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010?\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010@\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010A\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u0007J\u000e\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\u0002032\u0006\u00104\u001a\u00020\u0007J\u0016\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u0007J\u000e\u0010J\u001a\u00020K2\u0006\u00104\u001a\u00020\u0007J\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0010\u0010P\u001a\u00020M2\u0006\u00104\u001a\u00020\u0007H\u0002J\u0010\u0010Q\u001a\u00020M2\u0006\u00104\u001a\u00020\u0007H\u0002J\u0010\u0010R\u001a\u00020M2\u0006\u0010;\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0011\u0010#\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0011\u0010)\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001cR\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001c\u00a8\u0006S"}, d2={"Landroidx/ui/text/MultiParagraph;", "", "annotatedString", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/ui/text/ParagraphConstraints;", "density", "Landroidx/ui/unit/Density;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;IZLandroidx/ui/text/ParagraphConstraints;Landroidx/ui/unit/Density;Landroidx/ui/text/font/Font$ResourceLoader;)V", "intrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "(Landroidx/ui/text/MultiParagraphIntrinsics;IZLandroidx/ui/text/ParagraphConstraints;)V", "getAnnotatedString", "()Landroidx/ui/text/AnnotatedString;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "getIntrinsics", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "lastBaseline", "getLastBaseline", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "paragraphInfoList", "", "Landroidx/ui/text/ParagraphInfo;", "getParagraphInfoList$ui_text_release", "()Ljava/util/List;", "width", "getWidth", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "getBoundingBox", "Landroidx/ui/geometry/Rect;", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineForOffset", "getLineHeight", "getLineLeft", "getLineRight", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/ui/unit/PxPosition;", "getParagraphDirection", "getPathForRange", "Landroidx/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/ui/text/TextRange;", "paint", "", "canvas", "Landroidx/ui/graphics/Canvas;", "requireIndexInRange", "requireIndexInRangeInclusiveEnd", "requireLineIndexInRange", "ui-text_release"})
public final class MultiParagraph {
    private final MultiParagraphIntrinsics intrinsics;
    private final int maxLines;
    private final boolean didExceedMaxLines;
    private final float width;
    private final float height;
    private final int lineCount;
    private final List<ParagraphInfo> paragraphInfoList;

    public MultiParagraph(@NotNull MultiParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, @NotNull ParagraphConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)intrinsics, (String)"intrinsics");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        this.intrinsics = intrinsics;
        this.maxLines = maxLines;
        float currentHeight = 0.0f;
        int currentLineCount = 0;
        boolean didExceedMaxLines = false;
        boolean bl = false;
        List paragraphInfoList = new ArrayList();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)this.getIntrinsics().getInfoList$ui_text_release())) {
            Px px;
            float $this$px$iv;
            int endLineIndex;
            float paragraphBottom;
            int index = indexedValue.component1();
            ParagraphIntrinsicInfo paragraphInfo = (ParagraphIntrinsicInfo)indexedValue.component2();
            Paragraph paragraph = ParagraphKt.Paragraph(paragraphInfo.getIntrinsics(), this.getMaxLines() - currentLineCount, ellipsis, constraints);
            float paragraphTop = currentHeight;
            currentHeight = paragraphBottom = currentHeight + paragraph.getHeight();
            int startLineIndex = currentLineCount;
            currentLineCount = endLineIndex = startLineIndex + paragraph.getLineCount();
            float f = paragraphTop;
            int n = endLineIndex;
            int n2 = startLineIndex;
            int n3 = paragraphInfo.getEndIndex();
            int n4 = paragraphInfo.getStartIndex();
            Paragraph paragraph2 = paragraph;
            List list = paragraphInfoList;
            Px px2 = new Px($this$px$iv);
            $this$px$iv = paragraphBottom;
            Px px3 = px = new Px($this$px$iv);
            Px px4 = px2;
            int n5 = n;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            Paragraph paragraph3 = paragraph2;
            list.add(new ParagraphInfo(paragraph3, n8, n7, n6, n5, px4, px3));
            if (!paragraph.getDidExceedMaxLines() && (endLineIndex != this.getMaxLines() || index == CollectionsKt.getLastIndex(this.getIntrinsics().getInfoList$ui_text_release()))) continue;
            didExceedMaxLines = true;
            break;
        }
        this.height = currentHeight;
        this.lineCount = currentLineCount;
        this.didExceedMaxLines = didExceedMaxLines;
        this.paragraphInfoList = paragraphInfoList;
        this.width = constraints.getWidth();
    }

    public /* synthetic */ MultiParagraph(MultiParagraphIntrinsics intrinsics, int maxLines, boolean ellipsis, ParagraphConstraints constraints, int $mask0, DefaultConstructorMarker $marker) {
        int n = ($mask0 & 2) != 0 ? Integer.MAX_VALUE : maxLines;
        boolean bl = ($mask0 & 4) != 0 ? false : ellipsis;
        this(intrinsics, n, bl, constraints);
    }

    @NotNull
    public final MultiParagraphIntrinsics getIntrinsics() {
        return this.intrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public MultiParagraph(@NotNull AnnotatedString annotatedString, @NotNull TextStyle style, int maxLines, boolean ellipsis, @NotNull ParagraphConstraints constraints, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this(new MultiParagraphIntrinsics(annotatedString, style, density, resourceLoader), maxLines, ellipsis, constraints);
    }

    public /* synthetic */ MultiParagraph(AnnotatedString annotatedString, TextStyle style, int maxLines, boolean ellipsis, ParagraphConstraints constraints, Density density, Font.ResourceLoader resourceLoader, int $mask0, DefaultConstructorMarker $marker) {
        int n = ($mask0 & 4) != 0 ? Integer.MAX_VALUE : maxLines;
        boolean bl = ($mask0 & 8) != 0 ? false : ellipsis;
        this(annotatedString, style, n, bl, constraints, density, resourceLoader);
    }

    private final AnnotatedString getAnnotatedString() {
        return this.getIntrinsics().getAnnotatedString();
    }

    public final float getMinIntrinsicWidth() {
        return this.getIntrinsics().getMaxIntrinsicWidth();
    }

    public final float getMaxIntrinsicWidth() {
        return this.getIntrinsics().getMaxIntrinsicWidth();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getFirstBaseline() {
        return this.getParagraphInfoList$ui_text_release().isEmpty() ? 0.0f : this.getParagraphInfoList$ui_text_release().get(0).getParagraph().getFirstBaseline();
    }

    public final float getLastBaseline() {
        return this.getParagraphInfoList$ui_text_release().isEmpty() ? 0.0f : ((ParagraphInfo)CollectionsKt.last(this.getParagraphInfoList$ui_text_release())).getParagraph().getLastBaseline();
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    @NotNull
    public final List<ParagraphInfo> getParagraphInfoList$ui_text_release() {
        return this.paragraphInfoList;
    }

    public final void paint(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        Iterable $this$forEach$iv = this.getParagraphInfoList$ui_text_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParagraphInfo it = (ParagraphInfo)element$iv;
            it.getParagraph().paint(canvas);
            canvas.translate(0.0f, it.getParagraph().getHeight());
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path getPathForRange(int start, int end) {
        void $this$filterNotTo$iv$iv;
        Object item$iv;
        ParagraphInfo it;
        boolean bl = new IntRange(0, end).contains(start) && end <= this.getAnnotatedString().getText().length();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Start(" + start + ") or End(" + end + ") is out of range [0.." + this.getAnnotatedString().getText().length() + "), or start > end!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (start == end) {
            return AndroidPathKt.Path();
        }
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), start);
        Path path = AndroidPathKt.Path();
        Iterable $this$takeWhile$iv = CollectionsKt.drop((Iterable)this.getParagraphInfoList$ui_text_release(), (int)paragraphIndex);
        boolean $i$f$takeWhile = false;
        Iterable list$iv = new ArrayList();
        Iterator iterator = $this$takeWhile$iv.iterator();
        while (iterator.hasNext() && (it = (ParagraphInfo)(item$iv = iterator.next())).getStartIndex() < end) {
            ((ArrayList)list$iv).add(item$iv);
        }
        Iterable $this$filterNot$iv = (List)list$iv;
        boolean $i$f$filterNot = false;
        list$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ParagraphInfo it2 = (ParagraphInfo)element$iv$iv;
            if (it2.getStartIndex() == it2.getEndIndex()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParagraphInfo it3 = (ParagraphInfo)element$iv;
            boolean bl4 = false;
            boolean bl5 = false;
            ParagraphInfo $this$getPathForRange_u24lambda_u2d5_u24lambda_u2d4 = it3;
            Path.DefaultImpls.addPath$default((Path)path, (Path)$this$getPathForRange_u24lambda_u2d5_u24lambda_u2d4.toGlobal($this$getPathForRange_u24lambda_u2d5_u24lambda_u2d4.getParagraph().getPathForRange($this$getPathForRange_u24lambda_u2d5_u24lambda_u2d4.toLocalIndex(start), $this$getPathForRange_u24lambda_u2d5_u24lambda_u2d4.toLocalIndex(end))), (Offset)null, (int)2, null);
        }
        return path;
    }

    public final int getOffsetForPosition(@NotNull PxPosition position) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PxPosition this_$iv = position;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n3);
        Px px = new Px($this$px$iv$iv);
        if (px.getValue() <= 0.0f) {
            n2 = 0;
        } else {
            this_$iv = position;
            value$iv$iv = this_$iv.getValue();
            $i$f$unpackFloat2 = false;
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
            bl = false;
            $this$px$iv$iv = Float.intBitsToFloat(n3);
            Px px2 = new Px($this$px$iv$iv);
            if (px2.getValue() >= this.getHeight()) {
                n2 = CollectionsKt.getLastIndex(this.getParagraphInfoList$ui_text_release());
            } else {
                this_$iv = position;
                List<ParagraphInfo> list = this.getParagraphInfoList$ui_text_release();
                value$iv$iv = this_$iv.getValue();
                $i$f$unpackFloat2 = false;
                floatCompanionObject = FloatCompanionObject.INSTANCE;
                n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
                bl = false;
                $this$px$iv$iv = Float.intBitsToFloat(n3);
                Px px3 = new Px($this$px$iv$iv);
                n2 = MultiParagraphKt.findParagraphByY(list, px3);
            }
        }
        int paragraphIndex = n2;
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl2 = false;
        boolean bl3 = false;
        ParagraphInfo $this$getOffsetForPosition_u24lambda_u2d6 = paragraphInfo;
        if ($this$getOffsetForPosition_u24lambda_u2d6.getLength() == 0) {
            int n4 = 0;
            n3 = $this$getOffsetForPosition_u24lambda_u2d6.getStartIndex() - 1;
            bl = false;
            n = Math.max(n4, n3);
        } else {
            n = $this$getOffsetForPosition_u24lambda_u2d6.toGlobalIndex($this$getOffsetForPosition_u24lambda_u2d6.getParagraph().getOffsetForPosition($this$getOffsetForPosition_u24lambda_u2d6.toLocal(position)));
        }
        return n;
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getBoundingBox_u24lambda_u2d7 = paragraphInfo;
        return $this$getBoundingBox_u24lambda_u2d7.toGlobal($this$getBoundingBox_u24lambda_u2d7.getParagraph().getBoundingBox($this$getBoundingBox_u24lambda_u2d7.toLocalIndex(offset)));
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.getParagraphInfoList$ui_text_release()) : MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getHorizontalPosition_u24lambda_u2d8 = paragraphInfo;
        return $this$getHorizontalPosition_u24lambda_u2d8.getParagraph().getHorizontalPosition($this$getHorizontalPosition_u24lambda_u2d8.toLocalIndex(offset), usePrimaryDirection);
    }

    @NotNull
    public final TextDirection getParagraphDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.getParagraphInfoList$ui_text_release()) : MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getParagraphDirection_u24lambda_u2d9 = paragraphInfo;
        return $this$getParagraphDirection_u24lambda_u2d9.getParagraph().getParagraphDirection($this$getParagraphDirection_u24lambda_u2d9.toLocalIndex(offset));
    }

    @NotNull
    public final TextDirection getBidiRunDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.getParagraphInfoList$ui_text_release()) : MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getBidiRunDirection_u24lambda_u2d10 = paragraphInfo;
        return $this$getBidiRunDirection_u24lambda_u2d10.getParagraph().getBidiRunDirection($this$getBidiRunDirection_u24lambda_u2d10.toLocalIndex(offset));
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getWordBoundary_u24lambda_u2d11 = paragraphInfo;
        return $this$getWordBoundary_u24lambda_u2d11.toGlobal($this$getWordBoundary_u24lambda_u2d11.getParagraph().getWordBoundary($this$getWordBoundary_u24lambda_u2d11.toLocalIndex(offset)));
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.getParagraphInfoList$ui_text_release()) : MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getCursorRect_u24lambda_u2d12 = paragraphInfo;
        return $this$getCursorRect_u24lambda_u2d12.toGlobal($this$getCursorRect_u24lambda_u2d12.getParagraph().getCursorRect($this$getCursorRect_u24lambda_u2d12.toLocalIndex(offset)));
    }

    public final int getLineForOffset(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.getParagraphInfoList$ui_text_release()) : MultiParagraphKt.findParagraphByIndex(this.getParagraphInfoList$ui_text_release(), offset);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineForOffset_u24lambda_u2d13 = paragraphInfo;
        return $this$getLineForOffset_u24lambda_u2d13.toGlobalLineIndex($this$getLineForOffset_u24lambda_u2d13.getParagraph().getLineForOffset($this$getLineForOffset_u24lambda_u2d13.toLocalIndex(offset)));
    }

    public final float getLineLeft(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.getParagraphInfoList$ui_text_release(), lineIndex);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineLeft_u24lambda_u2d14 = paragraphInfo;
        return $this$getLineLeft_u24lambda_u2d14.getParagraph().getLineLeft($this$getLineLeft_u24lambda_u2d14.toLocalLineIndex(lineIndex));
    }

    public final float getLineRight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.getParagraphInfoList$ui_text_release(), lineIndex);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineRight_u24lambda_u2d15 = paragraphInfo;
        return $this$getLineRight_u24lambda_u2d15.getParagraph().getLineRight($this$getLineRight_u24lambda_u2d15.toLocalLineIndex(lineIndex));
    }

    public final float getLineTop(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.getParagraphInfoList$ui_text_release(), lineIndex);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineTop_u24lambda_u2d16 = paragraphInfo;
        return $this$getLineTop_u24lambda_u2d16.toGlobalYPosition($this$getLineTop_u24lambda_u2d16.getParagraph().getLineTop($this$getLineTop_u24lambda_u2d16.toLocalLineIndex(lineIndex)));
    }

    public final float getLineBottom(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.getParagraphInfoList$ui_text_release(), lineIndex);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineBottom_u24lambda_u2d17 = paragraphInfo;
        return $this$getLineBottom_u24lambda_u2d17.toGlobalYPosition($this$getLineBottom_u24lambda_u2d17.getParagraph().getLineBottom($this$getLineBottom_u24lambda_u2d17.toLocalLineIndex(lineIndex)));
    }

    public final float getLineHeight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.getParagraphInfoList$ui_text_release(), lineIndex);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineHeight_u24lambda_u2d18 = paragraphInfo;
        return $this$getLineHeight_u24lambda_u2d18.getParagraph().getLineHeight($this$getLineHeight_u24lambda_u2d18.toLocalLineIndex(lineIndex));
    }

    public final float getLineWidth(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.getParagraphInfoList$ui_text_release(), lineIndex);
        ParagraphInfo paragraphInfo = this.getParagraphInfoList$ui_text_release().get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$getLineWidth_u24lambda_u2d19 = paragraphInfo;
        return $this$getLineWidth_u24lambda_u2d19.getParagraph().getLineWidth($this$getLineWidth_u24lambda_u2d19.toLocalLineIndex(lineIndex));
    }

    private final void requireIndexInRange(int offset) {
        boolean bl = StringsKt.getIndices((CharSequence)this.getAnnotatedString().getText()).contains(offset);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "offset(" + offset + ") is out of bounds [0, " + AnnotatedStringKt.getLength(this.getAnnotatedString()) + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void requireIndexInRangeInclusiveEnd(int offset) {
        boolean bl = new IntRange(0, this.getAnnotatedString().getText().length()).contains(offset);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "offset(" + offset + ") is out of bounds [0, " + AnnotatedStringKt.getLength(this.getAnnotatedString()) + "]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void requireLineIndexInRange(int lineIndex) {
        boolean bl = RangesKt.until((int)0, (int)this.getLineCount()).contains(lineIndex);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "lineIndex(" + lineIndex + ") is out of bounds [0, " + lineIndex + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

