/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.geometry.Offset;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shadow;
import androidx.ui.graphics.ShadowKt;
import androidx.ui.text.LocaleList;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.font.FontWeightKt;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.BaselineShiftKt;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextGeometricTransformKt;
import androidx.ui.unit.Px;
import androidx.ui.unit.TextUnit;
import androidx.ui.unit.TextUnitKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a+\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u0002H\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010\n\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0000\u00a8\u0006\u000e"}, d2={"lerp", "Landroidx/ui/text/SpanStyle;", "start", "stop", "fraction", "", "lerpDiscrete", "T", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;F)Ljava/lang/Object;", "lerpTextUnitInheritable", "Landroidx/ui/unit/TextUnit;", "t", "ui-text_release"})
public final class SpanStyleKt {
    @NotNull
    public static final TextUnit lerpTextUnitInheritable(@NotNull TextUnit a, @NotNull TextUnit b, float t) {
        Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (a.isInherit() && b.isInherit()) {
            return a;
        }
        return TextUnitKt.lerp((TextUnit)a, (TextUnit)b, (float)t);
    }

    public static final <T> T lerpDiscrete(T a, T b, float fraction) {
        return (double)fraction < 0.5 ? a : b;
    }

    @NotNull
    public static final SpanStyle lerp(@NotNull SpanStyle start, @NotNull SpanStyle stop, float fraction) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        Object object = start.getColor();
        Color color = object == null ? Color.Companion.getBlack() : object;
        object = stop.getColor();
        Color color2 = ColorKt.lerp((Color)color, (Color)(object == null ? Color.Companion.getBlack() : object), (float)fraction);
        object = SpanStyleKt.lerpDiscrete(start.getFontFamily(), stop.getFontFamily(), fraction);
        TextUnit textUnit = SpanStyleKt.lerpTextUnitInheritable(start.getFontSize(), stop.getFontSize(), fraction);
        Object object2 = start.getFontWeight();
        FontWeight fontWeight = object2 == null ? FontWeight.Companion.getNormal() : object2;
        object2 = stop.getFontWeight();
        FontWeight fontWeight2 = FontWeightKt.lerp(fontWeight, object2 == null ? FontWeight.Companion.getNormal() : object2, fraction);
        object2 = SpanStyleKt.lerpDiscrete(start.getFontStyle(), stop.getFontStyle(), fraction);
        FontSynthesis fontSynthesis = SpanStyleKt.lerpDiscrete(start.getFontSynthesis(), stop.getFontSynthesis(), fraction);
        String string = SpanStyleKt.lerpDiscrete(start.getFontFeatureSettings(), stop.getFontFeatureSettings(), fraction);
        TextUnit textUnit2 = SpanStyleKt.lerpTextUnitInheritable(start.getLetterSpacing(), stop.getLetterSpacing(), fraction);
        Object object3 = start.getBaselineShift();
        Object object4 = object3 == null ? new BaselineShift(0.0f) : object3;
        object3 = stop.getBaselineShift();
        BaselineShift baselineShift = BaselineShiftKt.lerp((BaselineShift)object4, (BaselineShift)(object3 == null ? new BaselineShift(0.0f) : object3), fraction);
        Object object5 = start.getTextGeometricTransform();
        Object object6 = object5 == null ? TextGeometricTransform.Companion.getNone$ui_text_release() : object5;
        object5 = stop.getTextGeometricTransform();
        object3 = TextGeometricTransformKt.lerp((TextGeometricTransform)object6, (TextGeometricTransform)(object5 == null ? TextGeometricTransform.Companion.getNone$ui_text_release() : object5), fraction);
        object5 = SpanStyleKt.lerpDiscrete(start.getLocaleList(), stop.getLocaleList(), fraction);
        Object object7 = start.getBackground();
        Color color3 = object7 == null ? Color.Companion.getTransparent() : object7;
        object7 = stop.getBackground();
        Color color4 = ColorKt.lerp((Color)color3, (Color)(object7 == null ? Color.Companion.getTransparent() : object7), (float)fraction);
        object7 = SpanStyleKt.lerpDiscrete(start.getTextDecoration(), stop.getTextDecoration(), fraction);
        Shadow shadow = start.getShadow();
        Shadow shadow2 = shadow == null ? new Shadow((Color)null, (Offset)null, (Px)null, 7, null) : shadow;
        shadow = stop.getShadow();
        Shadow shadow3 = ShadowKt.lerp((Shadow)shadow2, (Shadow)(shadow == null ? new Shadow((Color)null, (Offset)null, (Px)null, 7, null) : shadow), (float)fraction);
        return new SpanStyle(color2, textUnit, fontWeight2, (FontStyle)((Object)object2), fontSynthesis, (FontFamily)object, string, textUnit2, baselineShift, (TextGeometricTransform)object3, (LocaleList)object5, color4, (TextDecoration)object7, shadow3);
    }
}

