/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import android.content.Context;
import androidx.ui.text.Typeface;
import androidx.ui.text.font.DefaultFontFamily;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontListFontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.font.GenericFontFamily;
import androidx.ui.text.font.LoadedFontFamily;
import androidx.ui.text.platform.AndroidDefaultTypeface;
import androidx.ui.text.platform.AndroidFontListTypeface;
import androidx.ui.text.platform.AndroidGenericFontFamilyTypeface;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0018\u00010\u0007\u00a8\u0006\u000b"}, d2={"typefaceFromFontFamily", "Landroidx/ui/text/Typeface;", "context", "Landroid/content/Context;", "fontFamily", "Landroidx/ui/text/font/FontFamily;", "necessaryStyles", "", "Lkotlin/Pair;", "Landroidx/ui/text/font/FontWeight;", "Landroidx/ui/text/font/FontStyle;", "ui-text_release"})
public final class TypefaceKt {
    @NotNull
    public static final Typeface typefaceFromFontFamily(@NotNull Context context, @NotNull FontFamily fontFamily, @Nullable List<? extends Pair<FontWeight, ? extends FontStyle>> necessaryStyles) {
        Typeface typeface;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fontFamily, (String)"fontFamily");
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            typeface = new AndroidFontListTypeface((FontListFontFamily)fontFamily, context, necessaryStyles, null, 8, null);
        } else if (fontFamily2 instanceof GenericFontFamily) {
            typeface = new AndroidGenericFontFamilyTypeface((GenericFontFamily)fontFamily);
        } else if (fontFamily2 instanceof DefaultFontFamily) {
            typeface = new AndroidDefaultTypeface();
        } else if (fontFamily2 instanceof LoadedFontFamily) {
            typeface = ((LoadedFontFamily)fontFamily).getTypeface();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return typeface;
    }

    public static /* synthetic */ Typeface typefaceFromFontFamily$default(@NotNull Context context, @NotNull FontFamily fontFamily, @Nullable List necessaryStyles, int $mask0, @Nullable Object $handler) {
        List list = ($mask0 & 4) != 0 ? (List)null : necessaryStyles;
        return TypefaceKt.typefaceFromFontFamily(context, fontFamily, list);
    }
}

