/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Paint;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.text.LayoutIntrinsics;
import androidx.text.TextLayout;
import androidx.text.selection.WordBoundary;
import androidx.text.style.PlaceholderSpan;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Path;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.Paragraph;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.Placeholder;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextStyle;
import androidx.ui.text.platform.AndroidParagraphIntrinsics;
import androidx.ui.text.platform.AndroidParagraphKt;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.TextAlign;
import androidx.ui.text.style.TextDirection;
import androidx.ui.unit.Density;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001Bg\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016B%\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\rH\u0016J\u0010\u0010S\u001a\u00020;2\u0006\u0010R\u001a\u00020\rH\u0016J\u0010\u0010T\u001a\u00020;2\u0006\u0010R\u001a\u00020\rH\u0016J\u0018\u0010U\u001a\u00020'2\u0006\u0010R\u001a\u00020\r2\u0006\u0010V\u001a\u00020\u000fH\u0016J\u0010\u0010W\u001a\u00020'2\u0006\u0010X\u001a\u00020\rH\u0016J\u0010\u0010Y\u001a\u00020\r2\u0006\u0010R\u001a\u00020\rH\u0016J\u0010\u0010Z\u001a\u00020'2\u0006\u0010X\u001a\u00020\rH\u0016J\u0010\u0010[\u001a\u00020'2\u0006\u0010X\u001a\u00020\rH\u0016J\u0010\u0010\\\u001a\u00020'2\u0006\u0010X\u001a\u00020\rH\u0016J\u0010\u0010]\u001a\u00020'2\u0006\u0010X\u001a\u00020\rH\u0016J\u0010\u0010^\u001a\u00020'2\u0006\u0010X\u001a\u00020\rH\u0016J\u0010\u0010_\u001a\u00020\r2\u0006\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020Q2\u0006\u0010R\u001a\u00020\rH\u0016J\u0018\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\r2\u0006\u0010f\u001a\u00020\rH\u0016J\u0010\u0010L\u001a\u00020g2\u0006\u0010R\u001a\u00020\rH\u0016J\u0015\u0010h\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\rH\u0000\u00a2\u0006\u0002\biJ\u0010\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020mH\u0016R\u001a\u0010\u001a\u001a\u00020\u001b8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010)R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00102R\u0014\u00106\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010)R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020?8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b@\u0010\u001d\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020D8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bE\u0010\u001d\u001a\u0004\bF\u0010GR\u0014\u0010H\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010)R\u001b\u0010J\u001a\u00020K8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bN\u0010O\u001a\u0004\bL\u0010M\u00a8\u0006n"}, d2={"Landroidx/ui/text/platform/AndroidParagraph;", "Landroidx/ui/text/Paragraph;", "text", "", "style", "Landroidx/ui/text/TextStyle;", "spanStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/SpanStyle;", "placeholders", "Landroidx/ui/text/Placeholder;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/ui/text/ParagraphConstraints;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "density", "Landroidx/ui/unit/Density;", "(Ljava/lang/String;Landroidx/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;IZLandroidx/ui/text/ParagraphConstraints;Landroidx/ui/text/platform/TypefaceAdapter;Landroidx/ui/unit/Density;)V", "paragraphIntrinsics", "Landroidx/ui/text/platform/AndroidParagraphIntrinsics;", "(Landroidx/ui/text/platform/AndroidParagraphIntrinsics;IZLandroidx/ui/text/ParagraphConstraints;)V", "charSequence", "", "charSequence$annotations$ui_text_release", "()V", "getCharSequence$ui_text_release", "()Ljava/lang/CharSequence;", "getConstraints", "()Landroidx/ui/text/ParagraphConstraints;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getEllipsis", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layout", "Landroidx/text/TextLayout;", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "getParagraphIntrinsics", "()Landroidx/ui/text/platform/AndroidParagraphIntrinsics;", "placeholderRects", "Landroidx/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "textLocale", "Ljava/util/Locale;", "textLocale$annotations$ui_text_release", "getTextLocale$ui_text_release", "()Ljava/util/Locale;", "textPaint", "Landroid/text/TextPaint;", "textPaint$annotations$ui_text_release", "getTextPaint$ui_text_release", "()Landroid/text/TextPaint;", "width", "getWidth", "wordBoundary", "Landroidx/text/selection/WordBoundary;", "getWordBoundary", "()Landroidx/text/selection/WordBoundary;", "wordBoundary$delegate", "Lkotlin/Lazy;", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineForOffset", "getLineHeight", "getLineLeft", "getLineRight", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/ui/unit/PxPosition;", "getParagraphDirection", "getPathForRange", "Landroidx/ui/graphics/Path;", "start", "end", "Landroidx/ui/text/TextRange;", "isEllipsisApplied", "isEllipsisApplied$ui_text_release", "paint", "", "canvas", "Landroidx/ui/graphics/Canvas;", "ui-text_release"})
public final class AndroidParagraph
implements Paragraph {
    @NotNull
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private final AndroidParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final boolean ellipsis;
    private final ParagraphConstraints constraints;
    private final TextLayout layout;
    private final float width;
    private final List<Rect> placeholderRects;
    private final Lazy wordBoundary$delegate;

    /*
     * WARNING - void declaration
     */
    public AndroidParagraph(@NotNull AndroidParagraphIntrinsics paragraphIntrinsics, int maxLines, boolean ellipsis, @NotNull ParagraphConstraints constraints) {
        List list;
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)paragraphIntrinsics, (String)"paragraphIntrinsics");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.constraints = constraints;
        boolean bl = this.getMaxLines() >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "maxLines should be greater than 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TextStyle style = this.getParagraphIntrinsics().getStyle();
        int alignment = AndroidParagraphKt.access$toLayoutAlign$0(style.getTextAlign());
        TextAlign textAlign = style.getTextAlign();
        int n = textAlign == null ? -1 : WhenMappings.$EnumSwitchMapping$0[textAlign.ordinal()];
        int justificationMode = n == 1 ? 1 : 0;
        TextUtils.TruncateAt ellipsize = this.getEllipsis() ? TextUtils.TruncateAt.END : (TextUtils.TruncateAt)null;
        this.width = this.getConstraints().getWidth();
        CharSequence charSequence = this.getParagraphIntrinsics().getCharSequence$ui_text_release();
        float f = this.getConstraints().getWidth();
        PlaceholderSpan[] placeholderSpanArray = this.getTextPaint$ui_text_release();
        TextUtils.TruncateAt truncateAt = ellipsize;
        int n2 = alignment;
        int n3 = this.getParagraphIntrinsics().getTextDirectionHeuristic$ui_text_release();
        int n4 = this.getMaxLines();
        int n5 = justificationMode;
        LayoutIntrinsics layoutIntrinsics = this.getParagraphIntrinsics().getLayoutIntrinsics$ui_text_release();
        this.layout = new TextLayout(charSequence, f, (TextPaint)placeholderSpanArray, n2, truncateAt, n3, 1.0f, 0.0f, false, n4, 0, 0, n5, (int[])null, (int[])null, layoutIntrinsics, 28032, null);
        CharSequence charSequence2 = this.getParagraphIntrinsics().getCharSequence$ui_text_release();
        AndroidParagraph androidParagraph = this;
        bl2 = false;
        bl3 = false;
        CharSequence $this$placeholderRects_u24lambda_u2d4 = charSequence2;
        if (!($this$placeholderRects_u24lambda_u2d4 instanceof Spanned)) {
            boolean bl4 = false;
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            PlaceholderSpan[] $this$map$iv = (PlaceholderSpan[])((Spanned)$this$placeholderRects_u24lambda_u2d4).getSpans(0, $this$placeholderRects_u24lambda_u2d4.length(), PlaceholderSpan.class);
            boolean $i$f$map = false;
            placeholderSpanArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var14_20 = $this$mapTo$iv$iv;
            n4 = ((void)var14_20).length;
            for (n5 = 0; n5 < n4; ++n5) {
                float f2;
                void span;
                void item$iv$iv;
                void var18_25 = item$iv$iv = var14_20[n5];
                Collection collection = destination$iv$iv;
                int start = ((Spanned)$this$placeholderRects_u24lambda_u2d4).getSpanStart((Object)span);
                int end = ((Spanned)$this$placeholderRects_u24lambda_u2d4).getSpanEnd((Object)span);
                int line = this.layout.getLineForOffset(start);
                float left = this.getHorizontalPosition(start, true);
                float right = this.getHorizontalPosition(end, true);
                TextLayout textLayout = this.layout;
                boolean bl5 = false;
                boolean bl6 = false;
                TextLayout $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = textLayout;
                int n6 = span.getVerticalAlign();
                switch (n6) {
                    case 0: {
                        f2 = $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineBaseline(line) - (float)span.getHeightPx();
                        break;
                    }
                    case 1: {
                        f2 = $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineTop(line);
                        break;
                    }
                    case 2: {
                        f2 = $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineBottom(line) - (float)span.getHeightPx();
                        break;
                    }
                    case 3: {
                        f2 = ($this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineTop(line) + $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineBottom(line) - (float)span.getHeightPx()) / (float)2;
                        break;
                    }
                    case 4: {
                        f2 = (float)span.getFontMetrics().ascent + $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineBaseline(line);
                        break;
                    }
                    case 5: {
                        f2 = (float)span.getFontMetrics().descent + $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineBaseline(line) - (float)span.getHeightPx();
                        break;
                    }
                    case 6: {
                        Paint.FontMetricsInt fontMetricsInt = span.getFontMetrics();
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Paint.FontMetricsInt $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = fontMetricsInt;
                        f2 = (float)(($this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.ascent + $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.descent - span.getHeightPx()) / 2) + $this$placeholderRects_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getLineBaseline(line);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unexpected verticalAlignment");
                    }
                }
                float top = f2;
                float bottom = top + (float)span.getHeightPx();
                Rect rect = new Rect(left, top, right, bottom);
                collection.add(rect);
            }
            list2 = (List)destination$iv$iv;
        }
        androidParagraph.placeholderRects = list = list2;
        this.wordBoundary$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WordBoundary>(this){
            private final /* synthetic */ AndroidParagraph $this$AndroidParagraph;
            {
                this.$this$AndroidParagraph = $receiver;
                super(0);
            }

            @NotNull
            public final WordBoundary invoke() {
                return new WordBoundary(this.$this$AndroidParagraph.getTextLocale$ui_text_release(), AndroidParagraph.access$prop$getLayout$1(this.$this$AndroidParagraph).getText());
            }
        }));
    }

    @NotNull
    public final AndroidParagraphIntrinsics getParagraphIntrinsics() {
        return this.paragraphIntrinsics;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getEllipsis() {
        return this.ellipsis;
    }

    @NotNull
    public final ParagraphConstraints getConstraints() {
        return this.constraints;
    }

    public AndroidParagraph(@NotNull String text, @NotNull TextStyle style, @NotNull List<AnnotatedString.Item<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Item<Placeholder>> placeholders, int maxLines, boolean ellipsis, @NotNull ParagraphConstraints constraints, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(placeholders, (String)"placeholders");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        String string = text;
        TextStyle textStyle = style;
        List<AnnotatedString.Item<Placeholder>> list = placeholders;
        List<AnnotatedString.Item<SpanStyle>> list2 = spanStyles;
        TypefaceAdapter typefaceAdapter2 = typefaceAdapter;
        Density density2 = density;
        this(new AndroidParagraphIntrinsics(string, textStyle, list2, list, typefaceAdapter2, density2), maxLines, ellipsis, constraints);
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.layout.getHeight();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.getParagraphIntrinsics().getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.getParagraphIntrinsics().getMinIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        return this.layout.getLineBaseline(0);
    }

    @Override
    public float getLastBaseline() {
        return this.getMaxLines() < this.getLineCount() ? this.layout.getLineBaseline(this.getMaxLines() - 1) : this.layout.getLineBaseline(this.getLineCount() - 1);
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.layout.getDidExceedMaxLines();
    }

    @NotNull
    public final Locale getTextLocale$ui_text_release() {
        return this.getParagraphIntrinsics().getTextPaint$ui_text_release().getTextLocale();
    }

    @VisibleForTesting
    public static /* synthetic */ void textLocale$annotations$ui_text_release() {
    }

    @Override
    public int getLineCount() {
        return this.layout.getLineCount();
    }

    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_release() {
        return this.getParagraphIntrinsics().getCharSequence$ui_text_release();
    }

    @VisibleForTesting
    public static /* synthetic */ void charSequence$annotations$ui_text_release() {
    }

    @NotNull
    public final TextPaint getTextPaint$ui_text_release() {
        return this.getParagraphIntrinsics().getTextPaint$ui_text_release();
    }

    @VisibleForTesting
    public static /* synthetic */ void textPaint$annotations$ui_text_release() {
    }

    @Override
    public int getOffsetForPosition(@NotNull PxPosition position) {
        PxPosition this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PxPosition pxPosition = position;
        TextLayout textLayout = this.layout;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat2 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv & 0xFFFFFFFFL);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        Px px = new Px($this$px$iv$iv);
        int line = textLayout.getLineForVertical((int)px.getValue());
        this_$iv = position;
        int n2 = line;
        textLayout = this.layout;
        value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv >> 32);
        bl = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        Px px2 = new Px($this$px$iv$iv);
        return textLayout.getOffsetForHorizontal(n2, px2.getValue());
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        float left = this.layout.getPrimaryHorizontal(offset);
        float right = this.layout.getPrimaryHorizontal(offset + 1);
        int line = this.layout.getLineForOffset(offset);
        float top = this.layout.getLineTop(line);
        float bottom = this.layout.getLineBottom(line);
        float f = top;
        float f2 = bottom;
        float f3 = left;
        float f4 = right;
        return new Rect(f3, f, f4, f2);
    }

    @Override
    @NotNull
    public Path getPathForRange(int start, int end) {
        if (!new IntRange(0, end).contains(start) || end > this.getCharSequence$ui_text_release().length()) {
            throw new AssertionError((Object)("Start(" + start + ") or End(" + end + ") is out of Range(0.." + this.getCharSequence$ui_text_release().length() + "), or start > end!"));
        }
        android.graphics.Path path = new android.graphics.Path();
        this.layout.getSelectionPath(start, end, path);
        return AndroidPathKt.asComposePath((android.graphics.Path)path);
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        if (!new IntRange(0, this.getCharSequence$ui_text_release().length()).contains(offset)) {
            throw new AssertionError((Object)("offset(" + offset + ") is out of bounds (0," + this.getCharSequence$ui_text_release().length()));
        }
        float cursorWidth = 4.0f;
        float horizontal = this.layout.getPrimaryHorizontal(offset);
        int line = this.layout.getLineForOffset(offset);
        return new Rect(horizontal - 0.5f * cursorWidth, this.layout.getLineTop(line), horizontal + 0.5f * cursorWidth, this.layout.getLineBottom(line));
    }

    private final WordBoundary getWordBoundary() {
        Lazy lazy = this.wordBoundary$delegate;
        KProperty<Object> kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (WordBoundary)lazy.getValue();
    }

    @Override
    @NotNull
    public TextRange getWordBoundary(int offset) {
        return new TextRange(this.getWordBoundary().getWordStart(offset), this.getWordBoundary().getWordEnd(offset));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        return this.layout.getLineLeft(lineIndex);
    }

    @Override
    public float getLineRight(int lineIndex) {
        return this.layout.getLineRight(lineIndex);
    }

    @Override
    public float getLineTop(int lineIndex) {
        return this.layout.getLineTop(lineIndex);
    }

    @Override
    public float getLineBottom(int lineIndex) {
        return this.layout.getLineBottom(lineIndex);
    }

    @Override
    public float getLineHeight(int lineIndex) {
        return this.layout.getLineHeight(lineIndex);
    }

    @Override
    public float getLineWidth(int lineIndex) {
        return this.layout.getLineWidth(lineIndex);
    }

    @Override
    public int getLineForOffset(int offset) {
        return this.layout.getLineForOffset(offset);
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        return usePrimaryDirection ? this.layout.getPrimaryHorizontal(offset) : this.layout.getSecondaryHorizontal(offset);
    }

    @Override
    @NotNull
    public TextDirection getParagraphDirection(int offset) {
        int lineIndex = this.layout.getLineForOffset(offset);
        int direction = this.layout.getParagraphDirection(lineIndex);
        return direction == 1 ? TextDirection.Ltr : TextDirection.Rtl;
    }

    @Override
    @NotNull
    public TextDirection getBidiRunDirection(int offset) {
        return this.layout.isRtlCharAt(offset) ? TextDirection.Rtl : TextDirection.Ltr;
    }

    public final boolean isEllipsisApplied$ui_text_release(int lineIndex) {
        return this.layout.isEllipsisApplied(lineIndex);
    }

    @Override
    public void paint(@NotNull Canvas canvas) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            android.graphics.Canvas nativeCanvas = canvas.getNativeCanvas();
            if (this.getDidExceedMaxLines()) {
                nativeCanvas.save();
                nativeCanvas.clipRect(0.0f, 0.0f, this.getWidth(), this.getHeight());
            }
            this.layout.paint(nativeCanvas);
            if (!this.getDidExceedMaxLines()) break block1;
            nativeCanvas.restore();
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AndroidParagraph.class), "wordBoundary", "getWordBoundary()Landroidx/text/selection/WordBoundary;")))};
        $$delegatedProperties = kPropertyArray;
    }

    public static final /* synthetic */ TextLayout access$prop$getLayout$1(AndroidParagraph $this) {
        return $this.layout;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAlign.values().length];
            nArray[TextAlign.Justify.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

