/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.content.Context;
import android.graphics.Typeface;
import android.util.TypedValue;
import androidx.collection.LruCache;
import androidx.core.content.res.ResourcesCompat;
import androidx.ui.text.font.Font;
import androidx.ui.text.font.ResourceFont;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/ui/text/platform/AndroidTypefaceCache;", "", "()V", "cache", "Landroidx/collection/LruCache;", "", "Landroid/graphics/Typeface;", "createTypeface", "context", "Landroid/content/Context;", "resId", "", "getOrCreate", "font", "Landroidx/ui/text/font/Font;", "getOrCreateByResourceId", "ui-text_release"})
public final class AndroidTypefaceCache {
    private static final LruCache<String, Typeface> cache;
    @NotNull
    public static final AndroidTypefaceCache INSTANCE;

    private AndroidTypefaceCache() {
    }

    @NotNull
    public final Typeface getOrCreate(@NotNull Context context, @NotNull Font font) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        Font font2 = font;
        if (!(font2 instanceof ResourceFont)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown font type: ", (Object)font));
        }
        return this.getOrCreateByResourceId(context, ((ResourceFont)font).getResId());
    }

    private final Typeface getOrCreateByResourceId(Context context, int resId) {
        String string;
        TypedValue value = new TypedValue();
        context.getResources().getValue(resId, value, true);
        CharSequence charSequence = value.string;
        String string2 = string = charSequence == null ? (String)null : charSequence.toString();
        if (string == null) {
            return this.createTypeface(context, resId);
        }
        String key = string;
        if ((string = (Typeface)cache.get((Object)key)) != null) {
            charSequence = string;
            boolean bl = false;
            boolean bl2 = false;
            CharSequence it = charSequence;
            return it;
        }
        Typeface typeface = this.createTypeface(context, resId);
        Typeface cfr_ignored_0 = (Typeface)cache.put((Object)key, (Object)typeface);
        return typeface;
    }

    private final Typeface createTypeface(Context context, int resId) {
        Typeface typeface = ResourcesCompat.getFont((Context)context, (int)resId);
        if (typeface == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unable to load Font ", (Object)String.valueOf(resId)));
        }
        return typeface;
    }

    static {
        INSTANCE = new AndroidTypefaceCache();
        cache = new LruCache(16);
    }
}

