/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.core.Constraints;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutDirection;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Shadow;
import androidx.ui.input.EditOperation;
import androidx.ui.input.EditProcessor;
import androidx.ui.input.EditorValue;
import androidx.ui.input.FinishComposingTextEditOp;
import androidx.ui.input.ImeAction;
import androidx.ui.input.KeyboardType;
import androidx.ui.input.OffsetMap;
import androidx.ui.input.SetSelectionEditOp;
import androidx.ui.input.TextInputService;
import androidx.ui.input.TransformedText;
import androidx.ui.input.VisualTransformation;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.LocaleList;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.TextDelegate;
import androidx.ui.text.TextFieldDelegateKt;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextPainter;
import androidx.ui.text.TextRange;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import androidx.ui.unit.TextUnit;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Landroidx/ui/text/TextFieldDelegate;", "", "Companion", "ui-text_release"})
public final class TextFieldDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Triple<IntPx, IntPx, TextLayoutResult> layout(@NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText) {
        return Companion.layout(textDelegate, constraints, layoutDirection, prevResultText);
    }

    @JvmStatic
    @NotNull
    public static final Triple<IntPx, IntPx, TextLayoutResult> layout$default(@NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText, int $mask0, @Nullable Object $handler) {
        return androidx.ui.text.TextFieldDelegate$Companion.layout$default(Companion, textDelegate, constraints, layoutDirection, prevResultText, $mask0, $handler);
    }

    @JvmStatic
    public static final void draw(@NotNull Canvas canvas, @NotNull EditorValue value, @NotNull OffsetMap offsetMap, @NotNull TextLayoutResult textLayoutResult, boolean hasFocus, @NotNull Color selectionColor) {
        Companion.draw(canvas, value, offsetMap, textLayoutResult, hasFocus, selectionColor);
    }

    @JvmStatic
    public static final void notifyFocusedRect(@NotNull EditorValue value, @NotNull TextDelegate textDelegate, @NotNull TextLayoutResult textLayoutResult, @NotNull LayoutCoordinates layoutCoordinates, @NotNull TextInputService textInputService, int token, boolean hasFocus, @NotNull OffsetMap offsetMap) {
        Companion.notifyFocusedRect(value, textDelegate, textLayoutResult, layoutCoordinates, textInputService, token, hasFocus, offsetMap);
    }

    @JvmStatic
    public static final void onEditCommand$ui_text_release$ui_text_release(@NotNull List<? extends EditOperation> ops, @NotNull EditProcessor editProcessor, @NotNull Function1<? super EditorValue, Unit> onValueChange) {
        TextFieldDelegate.Companion.onEditCommand$ui_text_release(ops, editProcessor, (Function1<? super EditorValue, Unit>)onValueChange);
    }

    @JvmStatic
    public static final void onRelease(@NotNull PxPosition position, @NotNull TextLayoutResult textLayoutResult, @NotNull EditProcessor editProcessor, @NotNull OffsetMap offsetMap, @NotNull Function1<? super EditorValue, Unit> onValueChange, @Nullable TextInputService textInputService, int token, boolean hasFocus) {
        Companion.onRelease(position, textLayoutResult, editProcessor, offsetMap, onValueChange, textInputService, token, hasFocus);
    }

    @JvmStatic
    public static final int onFocus(@Nullable TextInputService textInputService, @NotNull EditorValue value, @NotNull EditProcessor editProcessor, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super EditorValue, Unit> onValueChange, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        return Companion.onFocus(textInputService, value, editProcessor, keyboardType, imeAction, onValueChange, onImeActionPerformed);
    }

    @JvmStatic
    public static final void onBlur(@Nullable TextInputService textInputService, int token, @NotNull EditProcessor editProcessor, boolean hasNextClient, @NotNull Function1<? super EditorValue, Unit> onValueChange) {
        Companion.onBlur(textInputService, token, editProcessor, hasNextClient, onValueChange);
    }

    @JvmStatic
    @NotNull
    public static final TransformedText applyVisualFilter(@NotNull EditorValue value, @Nullable VisualTransformation visualTransformation) {
        return Companion.applyVisualFilter(value, visualTransformation);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003J\u001a\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J>\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0013H\u0007JL\u0010\"\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\n\u0010'\u001a\u00060(j\u0002`)2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0007JB\u0010*\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010&2\n\u0010'\u001a\u00060(j\u0002`)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00152\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0/H\u0007J7\u00100\u001a\u00020\r2\f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010+\u001a\u00020,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0/H\u0001\u00a2\u0006\u0002\b4J^\u00105\u001a\u00060(j\u0002`)2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010+\u001a\u00020,2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0/2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\r0/H\u0007JZ\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0/2\b\u0010%\u001a\u0004\u0018\u00010&2\n\u0010'\u001a\u00060(j\u0002`)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006>"}, d2={"Landroidx/ui/text/TextFieldDelegate$Companion;", "", "applyCompositionDecoration", "Landroidx/ui/input/TransformedText;", "compositionRange", "Landroidx/ui/text/TextRange;", "transformed", "applyVisualFilter", "value", "Landroidx/ui/input/EditorValue;", "visualTransformation", "Landroidx/ui/input/VisualTransformation;", "draw", "", "canvas", "Landroidx/ui/graphics/Canvas;", "offsetMap", "Landroidx/ui/input/OffsetMap;", "textLayoutResult", "Landroidx/ui/text/TextLayoutResult;", "hasFocus", "", "selectionColor", "Landroidx/ui/graphics/Color;", "layout", "Lkotlin/Triple;", "Landroidx/ui/unit/IntPx;", "textDelegate", "Landroidx/ui/text/TextDelegate;", "constraints", "Landroidx/ui/core/Constraints;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "prevResultText", "notifyFocusedRect", "layoutCoordinates", "Landroidx/ui/core/LayoutCoordinates;", "textInputService", "Landroidx/ui/input/TextInputService;", "token", "", "Landroidx/ui/input/InputSessionToken;", "onBlur", "editProcessor", "Landroidx/ui/input/EditProcessor;", "hasNextClient", "onValueChange", "Lkotlin/Function1;", "onEditCommand", "ops", "", "Landroidx/ui/input/EditOperation;", "onEditCommand$ui_text_release", "onFocus", "keyboardType", "Landroidx/ui/input/KeyboardType;", "imeAction", "Landroidx/ui/input/ImeAction;", "onImeActionPerformed", "onRelease", "position", "Landroidx/ui/unit/PxPosition;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Triple<IntPx, IntPx, TextLayoutResult> layout(@NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText) {
            IntPx intPx;
            boolean isEmptyText;
            Intrinsics.checkParameterIsNotNull((Object)textDelegate, (String)"textDelegate");
            Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
            Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
            TextLayoutResult layoutResult = textDelegate.layout(constraints, layoutDirection, prevResultText);
            CharSequence charSequence = textDelegate.getText().getText();
            boolean bl = false;
            boolean bl2 = isEmptyText = charSequence.length() == 0;
            if (isEmptyText) {
                IntPx singleLineHeight = TextFieldDelegateKt.access$computeLineHeightForEmptyText$0(textDelegate.getStyle(), textDelegate.getDensity(), textDelegate.getResourceLoader());
                intPx = (IntPx)RangesKt.coerceIn((Comparable)((Comparable)singleLineHeight), (Comparable)((Comparable)constraints.getMinHeight()), (Comparable)((Comparable)constraints.getMaxHeight()));
            } else {
                IntPxSize this_$iv = layoutResult.getSize();
                long value$iv$iv = this_$iv.getValue();
                boolean $i$f$unpackInt2 = false;
                int $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                intPx = new IntPx($this$ipx$iv$iv);
            }
            IntPx height = intPx;
            IntPxSize this_$iv = layoutResult.getSize();
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackInt1 = false;
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            IntPx width = new IntPx($this$ipx$iv$iv);
            return new Triple((Object)width, (Object)height, (Object)layoutResult);
        }

        public static /* synthetic */ Triple layout$default(@NotNull Companion this_, @NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText, int $mask0, @Nullable Object $handler) {
            TextLayoutResult textLayoutResult = ($mask0 & 8) != 0 ? (TextLayoutResult)null : prevResultText;
            return this_.layout(textDelegate, constraints, layoutDirection, textLayoutResult);
        }

        @JvmStatic
        public final void draw(@NotNull Canvas canvas, @NotNull EditorValue value, @NotNull OffsetMap offsetMap, @NotNull TextLayoutResult textLayoutResult, boolean hasFocus, @NotNull Color selectionColor) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)offsetMap, (String)"offsetMap");
            Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkParameterIsNotNull((Object)selectionColor, (String)"selectionColor");
            if (value.getSelection().getCollapsed()) {
                if (hasFocus) {
                    Rect cursorRect = textLayoutResult.getCursorRect(offsetMap.originalToTransformed(value.getSelection().getMin()));
                    Paint paint = new Paint();
                    Rect rect = cursorRect;
                    Canvas canvas2 = canvas;
                    boolean bl = false;
                    boolean bl2 = false;
                    Paint $this$draw_u24lambda_u2d0 = paint;
                    $this$draw_u24lambda_u2d0.setColor(Color.Companion.getBlack());
                    Paint paint2 = paint;
                    canvas2.drawRect(rect, paint2);
                }
            } else {
                int end;
                int start = offsetMap.originalToTransformed(value.getSelection().getMin());
                if (start != (end = offsetMap.originalToTransformed(value.getSelection().getMax()))) {
                    Path selectionPath = textLayoutResult.getPathForRange(start, end);
                    Paint paint = new Paint();
                    Path path = selectionPath;
                    Canvas canvas3 = canvas;
                    boolean bl = false;
                    boolean bl3 = false;
                    Paint $this$draw_u24lambda_u2d1 = paint;
                    $this$draw_u24lambda_u2d1.setColor(selectionColor);
                    Paint paint3 = paint;
                    canvas3.drawPath(path, paint3);
                }
            }
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void notifyFocusedRect(@NotNull EditorValue value, @NotNull TextDelegate textDelegate, @NotNull TextLayoutResult textLayoutResult, @NotNull LayoutCoordinates layoutCoordinates, @NotNull TextInputService textInputService, int token, boolean hasFocus, @NotNull OffsetMap offsetMap) {
            PxPosition this_$iv;
            PxPosition globalLT;
            long l;
            void val1$iv$iv;
            void y$iv;
            PxPosition x$iv;
            void $this$px$iv32;
            void $this$px$iv22;
            Px px;
            Rect rect;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)textDelegate, (String)"textDelegate");
            Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkParameterIsNotNull((Object)layoutCoordinates, (String)"layoutCoordinates");
            Intrinsics.checkParameterIsNotNull((Object)textInputService, (String)"textInputService");
            Intrinsics.checkParameterIsNotNull((Object)offsetMap, (String)"offsetMap");
            if (!hasFocus) {
                return;
            }
            if (value.getSelection().getMax() < value.getText().length()) {
                rect = textLayoutResult.getBoundingBox(offsetMap.originalToTransformed(value.getSelection().getMax()));
            } else if (value.getSelection().getMax() != 0) {
                rect = textLayoutResult.getBoundingBox(offsetMap.originalToTransformed(value.getSelection().getMax()) - 1);
            } else {
                IntPx lineHeightForEmptyText = TextFieldDelegateKt.access$computeLineHeightForEmptyText$0(textDelegate.getStyle(), textDelegate.getDensity(), textDelegate.getResourceLoader());
                rect = new Rect(0.0f, 0.0f, 1.0f, (float)lineHeightForEmptyText.getValue());
            }
            Rect bbox = rect;
            float f = bbox.getLeft();
            LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
            Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
            float f2 = bbox.getTop();
            Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
            float f3 = x$iv.getValue();
            float val2$iv$iv = y$iv.getValue();
            boolean $i$f$packFloats = false;
            void var16_24 = val1$iv$iv;
            boolean bl = false;
            long v1$iv$iv = Float.floatToIntBits((float)var16_24);
            float f4 = val2$iv$iv;
            boolean bl2 = false;
            long v2$iv$iv = Float.floatToIntBits(f4);
            long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
            px = new PxPosition(l2);
            x$iv = globalLT = layoutCoordinates2.localToRoot((PxPosition)px);
            Rect.Companion companion = Rect.Companion;
            int n = token;
            layoutCoordinates2 = textInputService;
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackFloat1 = false;
            FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
            int n2 = (int)(value$iv$iv >> 32);
            bl = false;
            float $this$px$iv$iv = Float.intBitsToFloat(n2);
            Px px2 = new Px($this$px$iv$iv);
            this_$iv = globalLT;
            float f5 = px2.getValue();
            value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackFloat2 = false;
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n2 = (int)(value$iv$iv & 0xFFFFFFFFL);
            bl = false;
            $this$px$iv$iv = Float.intBitsToFloat(n2);
            Px px3 = new Px($this$px$iv$iv);
            layoutCoordinates2.notifyFocusedRect(n, companion.fromLTWH(f5, px3.getValue(), bbox.getWidth(), bbox.getHeight()));
        }

        @JvmStatic
        public final void onEditCommand$ui_text_release(@NotNull List<? extends EditOperation> ops, @NotNull EditProcessor editProcessor, @NotNull Function1<? super EditorValue, Unit> onValueChange) {
            Intrinsics.checkParameterIsNotNull(ops, (String)"ops");
            Intrinsics.checkParameterIsNotNull((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkParameterIsNotNull(onValueChange, (String)"onValueChange");
            onValueChange.invoke((Object)editProcessor.onEditCommands(ops));
        }

        @JvmStatic
        public final void onRelease(@NotNull PxPosition position, @NotNull TextLayoutResult textLayoutResult, @NotNull EditProcessor editProcessor, @NotNull OffsetMap offsetMap, @NotNull Function1<? super EditorValue, Unit> onValueChange, @Nullable TextInputService textInputService, int token, boolean hasFocus) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
                Intrinsics.checkParameterIsNotNull((Object)editProcessor, (String)"editProcessor");
                Intrinsics.checkParameterIsNotNull((Object)offsetMap, (String)"offsetMap");
                Intrinsics.checkParameterIsNotNull(onValueChange, (String)"onValueChange");
                TextInputService textInputService2 = textInputService;
                if (textInputService2 != null) {
                    textInputService2.showSoftwareKeyboard(token);
                }
                if (!hasFocus) break block1;
                int offset = offsetMap.transformedToOriginal(textLayoutResult.getOffsetForPosition(position));
                this.onEditCommand$ui_text_release(CollectionsKt.listOf((Object)new SetSelectionEditOp(offset, offset)), editProcessor, onValueChange);
            }
        }

        @JvmStatic
        public final int onFocus(@Nullable TextInputService textInputService, @NotNull EditorValue value, @NotNull EditProcessor editProcessor, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super EditorValue, Unit> onValueChange, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkParameterIsNotNull((Object)keyboardType, (String)"keyboardType");
            Intrinsics.checkParameterIsNotNull((Object)imeAction, (String)"imeAction");
            Intrinsics.checkParameterIsNotNull(onValueChange, (String)"onValueChange");
            Intrinsics.checkParameterIsNotNull(onImeActionPerformed, (String)"onImeActionPerformed");
            TextInputService textInputService2 = textInputService;
            Integer n = textInputService2 == null ? (Integer)null : Integer.valueOf(textInputService2.startInput(new EditorValue(value.getText(), value.getSelection(), value.getComposition()), keyboardType, imeAction, (Function1)new Function1<List<? extends EditOperation>, Unit>(editProcessor, onValueChange){
                private final /* synthetic */ EditProcessor $editProcessor;
                private final /* synthetic */ Function1<EditorValue, Unit> $onValueChange;
                {
                    this.$editProcessor = $editProcessor;
                    this.$onValueChange = $onValueChange;
                    super(1);
                }

                public final void invoke(@NotNull List<? extends EditOperation> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    TextFieldDelegate.Companion.onEditCommand$ui_text_release(it, this.$editProcessor, this.$onValueChange);
                }
            }, onImeActionPerformed));
            return n == null ? -1 : n;
        }

        @JvmStatic
        public final void onBlur(@Nullable TextInputService textInputService, int token, @NotNull EditProcessor editProcessor, boolean hasNextClient, @NotNull Function1<? super EditorValue, Unit> onValueChange) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)editProcessor, (String)"editProcessor");
                Intrinsics.checkParameterIsNotNull(onValueChange, (String)"onValueChange");
                this.onEditCommand$ui_text_release(CollectionsKt.listOf((Object)new FinishComposingTextEditOp()), editProcessor, onValueChange);
                TextInputService textInputService2 = textInputService;
                if (textInputService2 != null) {
                    textInputService2.stopInput(token);
                }
                if (hasNextClient || (textInputService2 = textInputService) == null) break block1;
                textInputService2.hideSoftwareKeyboard(token);
            }
        }

        @JvmStatic
        @NotNull
        public final TransformedText applyVisualFilter(@NotNull EditorValue value, @Nullable VisualTransformation visualTransformation) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            AnnotatedString annotatedString = new AnnotatedString(value.getText(), (List)null, (List)null, 6, null);
            VisualTransformation visualTransformation2 = visualTransformation;
            TransformedText transformedText = visualTransformation2 == null ? (TransformedText)null : visualTransformation2.filter(annotatedString);
            return transformedText == null ? new TransformedText(annotatedString, OffsetMap.Companion.getIdentityOffsetMap()) : transformedText;
        }

        @NotNull
        public final TransformedText applyCompositionDecoration(@NotNull TextRange compositionRange, @NotNull TransformedText transformed) {
            Intrinsics.checkParameterIsNotNull((Object)compositionRange, (String)"compositionRange");
            Intrinsics.checkParameterIsNotNull((Object)transformed, (String)"transformed");
            AnnotatedString.Builder builder = new AnnotatedString.Builder(transformed.getTransformedText());
            boolean bl = false;
            boolean bl2 = false;
            AnnotatedString.Builder $this$applyCompositionDecoration_u24lambda_u2d2 = builder;
            $this$applyCompositionDecoration_u24lambda_u2d2.addStyle(new SpanStyle((Color)null, (TextUnit)null, (FontWeight)null, (FontStyle)null, (FontSynthesis)null, (FontFamily)null, (String)null, (TextUnit)null, (BaselineShift)null, (TextGeometricTransform)null, (LocaleList)null, (Color)null, TextDecoration.Companion.getUnderline(), (Shadow)null, 12287, null), compositionRange.getStart(), compositionRange.getEnd());
            AnnotatedString.Builder builder2 = builder;
            OffsetMap offsetMap = transformed.getOffsetMap();
            AnnotatedString annotatedString = builder2.toAnnotatedString();
            return new TransformedText(annotatedString, offsetMap);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

