/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.selection;

import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.selection.Selectable;
import androidx.ui.core.selection.Selection;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextRange;
import androidx.ui.text.selection.TextSelectionDelegateKt;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B6\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J<\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/ui/text/selection/TextSelectionDelegate;", "Landroidx/ui/core/selection/Selectable;", "selectionRangeUpdate", "Lkotlin/Function1;", "Landroidx/ui/text/TextRange;", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/ui/core/LayoutCoordinates;", "layoutResultCallback", "Landroidx/ui/text/TextLayoutResult;", "getHandlePosition", "Landroidx/ui/unit/PxPosition;", "selection", "Landroidx/ui/core/selection/Selection;", "isStartHandle", "", "getLayoutCoordinates", "getSelection", "startPosition", "endPosition", "containerLayoutCoordinates", "longPress", "previousSelection", "getText", "Landroidx/ui/text/AnnotatedString;", "ui-text_release"})
public final class TextSelectionDelegate
implements Selectable {
    private final Function1<TextRange, Unit> selectionRangeUpdate;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;

    public TextSelectionDelegate(@NotNull Function1<? super TextRange, Unit> selectionRangeUpdate, @NotNull Function0<? extends LayoutCoordinates> coordinatesCallback, @NotNull Function0<TextLayoutResult> layoutResultCallback) {
        Intrinsics.checkParameterIsNotNull(selectionRangeUpdate, (String)"selectionRangeUpdate");
        Intrinsics.checkParameterIsNotNull(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkParameterIsNotNull(layoutResultCallback, (String)"layoutResultCallback");
        this.selectionRangeUpdate = selectionRangeUpdate;
        this.coordinatesCallback = coordinatesCallback;
        this.layoutResultCallback = layoutResultCallback;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Selection getSelection(@NotNull PxPosition startPosition, @NotNull PxPosition endPosition, @NotNull LayoutCoordinates containerLayoutCoordinates, boolean longPress, @Nullable Selection previousSelection, boolean isStartHandle) {
        long l;
        void val1$iv$iv$iv;
        void y$iv$iv;
        void x$iv$iv;
        PxPosition this_$iv;
        long l2;
        void val1$iv$iv$iv2;
        void y$iv$iv2;
        void x$iv$iv2;
        PxPosition this_$iv2;
        Intrinsics.checkParameterIsNotNull((Object)startPosition, (String)"startPosition");
        Intrinsics.checkParameterIsNotNull((Object)endPosition, (String)"endPosition");
        Intrinsics.checkParameterIsNotNull((Object)containerLayoutCoordinates, (String)"containerLayoutCoordinates");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return null;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        PxPosition relativePosition = containerLayoutCoordinates.childToLocal(layoutCoordinates2, PxPosition.Companion.getOrigin());
        PxPosition this_$iv$iv = this_$iv2 = startPosition;
        long value$iv$iv$iv = this_$iv$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv$iv52222 = Float.intBitsToFloat(n);
        this_$iv$iv = new Px($this$px$iv$iv$iv52222);
        PxPosition this_$iv$iv2 = relativePosition;
        long value$iv$iv$iv2 = this_$iv$iv2.getValue();
        boolean $i$f$unpackFloat12 = false;
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 >> 32);
        int $this$px$iv$iv$iv52222 = 0;
        float $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        Px other$iv$iv = new Px($this$px$iv$iv$iv);
        this_$iv$iv = new Px(this_$iv$iv.getValue() - other$iv$iv.getValue());
        this_$iv$iv2 = this_$iv2;
        value$iv$iv$iv2 = this_$iv$iv2.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        $this$px$iv$iv$iv52222 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        this_$iv$iv2 = new Px($this$px$iv$iv$iv);
        PxPosition this_$iv$iv3 = relativePosition;
        long value$iv$iv$iv3 = this_$iv$iv3.getValue();
        boolean $i$f$unpackFloat32 = false;
        FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv52222 = (int)(value$iv$iv$iv3 & 0xFFFFFFFFL);
        boolean bl = false;
        float $this$px$iv$iv$iv2 = Float.intBitsToFloat($this$px$iv$iv$iv52222);
        Px other$iv$iv22 = new Px($this$px$iv$iv$iv2);
        this_$iv$iv2 = new Px(this_$iv$iv2.getValue() - other$iv$iv22.getValue());
        float other$iv$iv22 = x$iv$iv2.getValue();
        float val2$iv$iv$iv = y$iv$iv2.getValue();
        int $i$f$packFloats22 = 0;
        void $this$px$iv$iv$iv52222 = val1$iv$iv$iv2;
        bl = false;
        long v1$iv$iv$iv = Float.floatToIntBits((float)$this$px$iv$iv$iv52222);
        float f = val2$iv$iv$iv;
        boolean bl2 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f);
        long l3 = l2 = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
        PxPosition startPx = new PxPosition(l3);
        PxPosition this_$iv$iv4 = this_$iv = endPosition;
        long value$iv$iv$iv4 = this_$iv$iv4.getValue();
        $i$f$unpackFloat12 = false;
        FloatCompanionObject $i$f$unpackFloat32 = FloatCompanionObject.INSTANCE;
        $i$f$packFloats22 = (int)(value$iv$iv$iv4 >> 32);
        int $this$px$iv$iv$iv52222 = 0;
        float $this$px$iv$iv$iv3 = Float.intBitsToFloat($i$f$packFloats22);
        this_$iv$iv4 = new Px($this$px$iv$iv$iv3);
        PxPosition this_$iv$iv5 = relativePosition;
        long value$iv$iv$iv5 = this_$iv$iv5.getValue();
        boolean $i$f$unpackFloat13 = false;
        FloatCompanionObject $i$f$packFloats22 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv52222 = (int)(value$iv$iv$iv5 >> 32);
        int n3 = 0;
        float $this$px$iv$iv$iv4 = Float.intBitsToFloat($this$px$iv$iv$iv52222);
        Px other$iv$iv3 = new Px($this$px$iv$iv$iv4);
        this_$iv$iv4 = new Px(this_$iv$iv4.getValue() - other$iv$iv3.getValue());
        this_$iv$iv5 = this_$iv;
        value$iv$iv$iv5 = this_$iv$iv5.getValue();
        boolean $i$f$unpackFloat22 = false;
        $i$f$packFloats22 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv52222 = (int)(value$iv$iv$iv5 & 0xFFFFFFFFL);
        n3 = 0;
        $this$px$iv$iv$iv4 = Float.intBitsToFloat($this$px$iv$iv$iv52222);
        this_$iv$iv5 = new Px($this$px$iv$iv$iv4);
        PxPosition this_$iv$iv6 = relativePosition;
        long value$iv$iv$iv6 = this_$iv$iv6.getValue();
        boolean $i$f$unpackFloat23 = false;
        FloatCompanionObject $this$px$iv$iv$iv52222 = FloatCompanionObject.INSTANCE;
        n3 = (int)(value$iv$iv$iv6 & 0xFFFFFFFFL);
        boolean bl3 = false;
        float $this$px$iv$iv$iv6 = Float.intBitsToFloat(n3);
        Px other$iv$iv322 = new Px($this$px$iv$iv$iv6);
        this_$iv$iv5 = new Px(this_$iv$iv5.getValue() - other$iv$iv322.getValue());
        float other$iv$iv322 = x$iv$iv.getValue();
        float val2$iv$iv$iv2 = y$iv$iv.getValue();
        boolean $i$f$packFloats = false;
        void var20_38 = val1$iv$iv$iv;
        bl3 = false;
        long v1$iv$iv$iv2 = Float.floatToIntBits((float)var20_38);
        float f2 = val2$iv$iv$iv2;
        boolean bl4 = false;
        long v2$iv$iv$iv2 = Float.floatToIntBits(f2);
        long l4 = l = v1$iv$iv$iv2 << 32 | v2$iv$iv$iv2 & 0xFFFFFFFFL;
        PxPosition endPx = new PxPosition(l4);
        Selection selection = TextSelectionDelegateKt.getTextSelectionInfo(textLayoutResult2, (Pair<PxPosition, PxPosition>)new Pair((Object)startPx, (Object)endPx), this, longPress, previousSelection, isStartHandle);
        if (selection != null) {
            this.selectionRangeUpdate.invoke((Object)selection.toTextRange());
            return selection;
        }
        this.selectionRangeUpdate.invoke(null);
        return null;
    }

    @NotNull
    public PxPosition getHandlePosition(@NotNull Selection selection, boolean isStartHandle) {
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        if (isStartHandle && !Intrinsics.areEqual((Object)selection.getStart().getSelectable(), (Object)this) || !isStartHandle && !Intrinsics.areEqual((Object)selection.getEnd().getSelectable(), (Object)this)) {
            return PxPosition.Companion.getOrigin();
        }
        if (this.getLayoutCoordinates() == null) {
            return PxPosition.Companion.getOrigin();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return PxPosition.Companion.getOrigin();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return TextSelectionDelegateKt.access$getSelectionHandleCoordinates$0(textLayoutResult2, isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset(), isStartHandle, selection.getHandlesCrossed());
    }

    @Nullable
    public LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @NotNull
    public AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", (List)null, (List)null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getLayoutInput().getText();
    }
}

