/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.selection;

import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.selection.Selectable;
import androidx.ui.core.selection.Selection;
import androidx.ui.geometry.Rect;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextRange;
import androidx.ui.text.selection.TextSelectionDelegateKt;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B6\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0016J<\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/ui/text/selection/TextSelectionDelegate;", "Landroidx/ui/core/selection/Selectable;", "selectionRangeUpdate", "Lkotlin/Function1;", "Landroidx/ui/text/TextRange;", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/ui/core/LayoutCoordinates;", "layoutResultCallback", "Landroidx/ui/text/TextLayoutResult;", "getBoundingBox", "Landroidx/ui/geometry/Rect;", "offset", "", "getHandlePosition", "Landroidx/ui/unit/PxPosition;", "selection", "Landroidx/ui/core/selection/Selection;", "isStartHandle", "", "getLayoutCoordinates", "getSelection", "startPosition", "endPosition", "containerLayoutCoordinates", "longPress", "previousSelection", "getText", "Landroidx/ui/text/AnnotatedString;", "ui-text_release"})
public final class TextSelectionDelegate
implements Selectable {
    private final Function1<TextRange, Unit> selectionRangeUpdate;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;

    public TextSelectionDelegate(@NotNull Function1<? super TextRange, Unit> selectionRangeUpdate, @NotNull Function0<? extends LayoutCoordinates> coordinatesCallback, @NotNull Function0<TextLayoutResult> layoutResultCallback) {
        Intrinsics.checkNotNullParameter(selectionRangeUpdate, (String)"selectionRangeUpdate");
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectionRangeUpdate = selectionRangeUpdate;
        this.coordinatesCallback = coordinatesCallback;
        this.layoutResultCallback = layoutResultCallback;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Selection getSelection(@NotNull PxPosition startPosition, @NotNull PxPosition endPosition, @NotNull LayoutCoordinates containerLayoutCoordinates, boolean longPress, @Nullable Selection previousSelection, boolean isStartHandle) {
        long l;
        void val1$iv$iv$iv;
        void x$iv$iv;
        void $this$iv$iv;
        long l2;
        void val1$iv$iv$iv2;
        void x$iv$iv2;
        void $this$iv$iv2;
        float $this$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        Intrinsics.checkNotNullParameter((Object)containerLayoutCoordinates, (String)"containerLayoutCoordinates");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return null;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        PxPosition relativePosition = containerLayoutCoordinates.childToLocal(layoutCoordinates2, PxPosition.Companion.getOrigin());
        PxPosition this_$iv = startPosition;
        boolean $i$f$minus = false;
        PxPosition this_$iv$iv22 = this_$iv;
        boolean $i$f$getX = false;
        long value$iv$iv$iv = this_$iv$iv22.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv$iv62222 = Float.intBitsToFloat(n);
        boolean $i$f$getPx = false;
        float this_$iv$iv22 = Px.constructor-impl((float)$this$px$iv$iv$iv62222);
        PxPosition this_$iv$iv = relativePosition;
        boolean $i$f$getX2 = false;
        long value$iv$iv$iv2 = this_$iv$iv.getValue();
        boolean $i$f$unpackFloat12 = false;
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 >> 32);
        int $this$px$iv$iv$iv62222 = 0;
        float $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        boolean $i$f$getPx2 = false;
        float other$iv$iv = Px.constructor-impl((float)$this$px$iv$iv$iv);
        boolean bl = false;
        $this$iv$iv3 = Px.constructor-impl((float)($this$iv$iv3 - other$iv$iv));
        this_$iv$iv3 = this_$iv;
        boolean $i$f$getY = false;
        value$iv$iv$iv2 = this_$iv$iv3.getValue();
        boolean $i$f$unpackFloat2 = false;
        floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv$iv2 & 0xFFFFFFFFL);
        $this$px$iv$iv$iv62222 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat(n2);
        $i$f$getPx2 = false;
        float this_$iv$iv3 = Px.constructor-impl((float)$this$px$iv$iv$iv);
        PxPosition this_$iv$iv4 = relativePosition;
        boolean $i$f$getY2 = false;
        long value$iv$iv$iv3 = this_$iv$iv4.getValue();
        boolean $i$f$unpackFloat32 = false;
        FloatCompanionObject floatCompanionObject3 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv62222 = (int)(value$iv$iv$iv3 & 0xFFFFFFFFL);
        boolean $this$px$iv$iv$iv3 = false;
        float $this$px$iv$iv$iv2 = Float.intBitsToFloat($this$px$iv$iv$iv62222);
        boolean $i$f$getPx3 = false;
        float other$iv$iv2 = Px.constructor-impl((float)$this$px$iv$iv$iv2);
        $i$f$minus-NgWp0Z9 = false;
        float y$iv$iv = Px.constructor-impl((float)($this$iv$iv2 - other$iv$iv2));
        boolean bl2 = false;
        void $i$f$minus-NgWp0Z9 = x$iv$iv2;
        float val2$iv$iv$iv = y$iv$iv;
        int $i$f$packFloats22 = 0;
        void $this$px$iv$iv$iv62222 = val1$iv$iv$iv2;
        $this$px$iv$iv$iv3 = false;
        long v1$iv$iv$iv = Float.floatToIntBits((float)$this$px$iv$iv$iv62222);
        float f = val2$iv$iv$iv;
        boolean bl3 = false;
        long v2$iv$iv$iv = Float.floatToIntBits(f);
        long l3 = l2 = v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL;
        PxPosition startPx = new PxPosition(l3);
        PxPosition this_$iv2 = endPosition;
        boolean $i$f$minus2 = false;
        this_$iv$iv42 = this_$iv2;
        boolean $i$f$getX3 = false;
        long value$iv$iv$iv4 = this_$iv$iv42.getValue();
        $i$f$unpackFloat12 = false;
        FloatCompanionObject $i$f$unpackFloat32 = FloatCompanionObject.INSTANCE;
        $i$f$packFloats22 = (int)(value$iv$iv$iv4 >> 32);
        int $this$px$iv$iv$iv62222 = 0;
        $this$px$iv$iv$iv = Float.intBitsToFloat($i$f$packFloats22);
        boolean $i$f$getPx4 = false;
        float this_$iv$iv42 = Px.constructor-impl((float)$this$px$iv$iv$iv);
        PxPosition this_$iv$iv5 = relativePosition;
        boolean $i$f$getX4 = false;
        long value$iv$iv$iv5 = this_$iv$iv5.getValue();
        boolean $i$f$unpackFloat13 = false;
        FloatCompanionObject $i$f$packFloats22 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv62222 = (int)(value$iv$iv$iv5 >> 32);
        int n3 = 0;
        float $this$px$iv$iv$iv4 = Float.intBitsToFloat($this$px$iv$iv$iv62222);
        boolean $i$f$getPx5 = false;
        float other$iv$iv3 = Px.constructor-impl((float)$this$px$iv$iv$iv4);
        $i$f$minus-NgWp0Z8 = false;
        float $this$iv$iv22 = Px.constructor-impl((float)($this$iv$iv22 - other$iv$iv3));
        this_$iv$iv52 = this_$iv2;
        boolean $i$f$getY3 = false;
        value$iv$iv$iv5 = this_$iv$iv52.getValue();
        boolean $i$f$unpackFloat22 = false;
        $i$f$packFloats22 = FloatCompanionObject.INSTANCE;
        $this$px$iv$iv$iv62222 = (int)(value$iv$iv$iv5 & 0xFFFFFFFFL);
        n3 = 0;
        $this$px$iv$iv$iv4 = Float.intBitsToFloat($this$px$iv$iv$iv62222);
        $i$f$getPx5 = false;
        float this_$iv$iv52 = Px.constructor-impl((float)$this$px$iv$iv$iv4);
        PxPosition this_$iv$iv6 = relativePosition;
        boolean $i$f$getY4 = false;
        long value$iv$iv$iv6 = this_$iv$iv6.getValue();
        boolean $i$f$unpackFloat23 = false;
        FloatCompanionObject $this$px$iv$iv$iv62222 = FloatCompanionObject.INSTANCE;
        n3 = (int)(value$iv$iv$iv6 & 0xFFFFFFFFL);
        boolean bl4 = false;
        float $this$px$iv$iv$iv5 = Float.intBitsToFloat(n3);
        boolean $i$f$getPx6 = false;
        float other$iv$iv4 = Px.constructor-impl((float)$this$px$iv$iv$iv5);
        $i$f$minus-NgWp0Z10 = false;
        float y$iv$iv2 = Px.constructor-impl((float)($this$iv$iv - other$iv$iv4));
        $i$f$PxPosition-qHcltEY = false;
        void $i$f$minus-NgWp0Z10 = x$iv$iv;
        float val2$iv$iv$iv2 = y$iv$iv2;
        boolean $i$f$packFloats = false;
        void var22_55 = val1$iv$iv$iv;
        bl4 = false;
        long v1$iv$iv$iv2 = Float.floatToIntBits((float)var22_55);
        float f2 = val2$iv$iv$iv2;
        boolean bl5 = false;
        long v2$iv$iv$iv2 = Float.floatToIntBits(f2);
        long l4 = l = v1$iv$iv$iv2 << 32 | v2$iv$iv$iv2 & 0xFFFFFFFFL;
        PxPosition endPx = new PxPosition(l4);
        Selection selection = TextSelectionDelegateKt.getTextSelectionInfo(textLayoutResult2, (Pair<PxPosition, PxPosition>)new Pair((Object)startPx, (Object)endPx), this, longPress, previousSelection, isStartHandle);
        if (selection != null) {
            this.selectionRangeUpdate.invoke((Object)selection.toTextRange());
            return selection;
        }
        this.selectionRangeUpdate.invoke(null);
        return null;
    }

    @NotNull
    public PxPosition getHandlePosition(@NotNull Selection selection, boolean isStartHandle) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && !Intrinsics.areEqual((Object)selection.getStart().getSelectable(), (Object)this) || !isStartHandle && !Intrinsics.areEqual((Object)selection.getEnd().getSelectable(), (Object)this)) {
            return PxPosition.Companion.getOrigin();
        }
        if (this.getLayoutCoordinates() == null) {
            return PxPosition.Companion.getOrigin();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return PxPosition.Companion.getOrigin();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return TextSelectionDelegateKt.access$getSelectionHandleCoordinates(textLayoutResult2, isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset(), isStartHandle, selection.getHandlesCrossed());
    }

    @Nullable
    public LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @NotNull
    public AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getLayoutInput().getText();
    }

    @NotNull
    public Rect getBoundingBox(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getBoundingBox(RangesKt.coerceIn((int)offset, (int)0, (int)(textLayoutResult2.getLayoutInput().getText().getText().length() - 1)));
    }
}

