/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.compose.Ambient;
import androidx.compose.CommitScope;
import androidx.compose.Composable;
import androidx.compose.Composer;
import androidx.compose.EffectsKt;
import androidx.compose.ScopeUpdateScope;
import androidx.compose.SlotTable;
import androidx.compose.internal.RestartableFunctionKt;
import androidx.ui.core.AmbientsKt;
import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.DrawModifierKt;
import androidx.ui.core.HorizontalAlignmentLine;
import androidx.ui.core.IntrinsicMeasurable;
import androidx.ui.core.IntrinsicMeasureScope;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutDirection;
import androidx.ui.core.LayoutKt;
import androidx.ui.core.Measurable;
import androidx.ui.core.MeasureScope;
import androidx.ui.core.Modifier;
import androidx.ui.core.OnPositionedModifierKt;
import androidx.ui.core.Placeable;
import androidx.ui.core.selection.Selectable;
import androidx.ui.core.selection.SelectionRegistrar;
import androidx.ui.core.selection.SelectionRegistrarKt;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.geometry.Size;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.drawscope.DrawScope;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.AnnotatedStringKt;
import androidx.ui.text.InlineTextContent;
import androidx.ui.text.Placeholder;
import androidx.ui.text.TextDelegate;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextState;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.selection.TextSelectionDelegate;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001ag\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\f0\u001eH\u0007\u00a2\u0006\u0002\u0010 \u001a>\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2'\u0010\"\u001a#\u0012\u001f\u0012\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001e\u00a2\u0006\u0002\b%0$j\u0002`&0#H\u0001\u00a2\u0006\u0002\u0010'\u001aa\u0010(\u001a?\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020*0$j\u0002`+0#\u0012%\u0012#\u0012\u001f\u0012\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001e\u00a2\u0006\u0002\b%0$j\u0002`&0#0)2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0000\u001ab\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0$0#H\u0000\"\u0019\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00f8\u0001\u0000\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b*:\b\u0000\u00104\"\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001e\u00a2\u0006\u0002\b%0$2\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001e\u00a2\u0006\u0002\b%0$*\u0018\b\u0000\u00105\"\b\u0012\u0004\u0012\u00020*0$2\b\u0012\u0004\u0012\u00020*0$\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"DefaultSelectionColor", "Landroidx/ui/graphics/Color;", "getDefaultSelectionColor", "()J", "J", "FirstBaseline", "Landroidx/ui/core/HorizontalAlignmentLine;", "getFirstBaseline", "()Landroidx/ui/core/HorizontalAlignmentLine;", "LastBaseline", "getLastBaseline", "CoreText", "", "text", "Landroidx/ui/text/AnnotatedString;", "modifier", "Landroidx/ui/core/Modifier;", "style", "Landroidx/ui/text/TextStyle;", "softWrap", "", "overflow", "Landroidx/ui/text/style/TextOverflow;", "maxLines", "", "inlineContent", "", "", "Landroidx/ui/text/InlineTextContent;", "onTextLayout", "Lkotlin/Function1;", "Landroidx/ui/text/TextLayoutResult;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/core/Modifier;Landroidx/ui/text/TextStyle;ZLandroidx/ui/text/style/TextOverflow;ILjava/util/Map;Lkotlin/jvm/functions/Function1;Landroidx/compose/Composer;III)V", "InlineChildren", "inlineContents", "", "Landroidx/ui/text/AnnotatedString$Range;", "Landroidx/compose/Composable;", "Landroidx/ui/text/InlineContentRange;", "(Landroidx/ui/text/AnnotatedString;Ljava/util/List;Landroidx/compose/Composer;II)V", "resolveInlineContent", "Lkotlin/Pair;", "Landroidx/ui/text/Placeholder;", "Landroidx/ui/text/PlaceholderRange;", "updateTextDelegate", "Landroidx/ui/text/TextDelegate;", "current", "density", "Landroidx/ui/unit/Density;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "placeholders", "InlineContentRange", "PlaceholderRange", "ui-text_release"})
public final class CoreTextKt {
    private static final long DefaultSelectionColor = ColorKt.Color((int)1714664933);
    private static final HorizontalAlignmentLine FirstBaseline = new HorizontalAlignmentLine((Function2)new Function2<Integer, Integer, Integer>(){

        @NotNull
        public final Integer invoke(int p0, int p1) {
            boolean bl = false;
            return Math.min(p0, p1);
        }

        @NotNull
        public final String getSignature() {
            return "min(II)I";
        }

        @NotNull
        public final String getName() {
            return "min";
        }

        @NotNull
        public final KDeclarationContainer getOwner() {
            return Reflection.getOrCreateKotlinPackage(MathKt.class, (String)"ui-text_release");
        }
    });
    private static final HorizontalAlignmentLine LastBaseline = new HorizontalAlignmentLine((Function2)new Function2<Integer, Integer, Integer>(){

        @NotNull
        public final Integer invoke(int p0, int p1) {
            boolean bl = false;
            return Math.max(p0, p1);
        }

        @NotNull
        public final String getSignature() {
            return "max(II)I";
        }

        @NotNull
        public final String getName() {
            return "max";
        }

        @NotNull
        public final KDeclarationContainer getOwner() {
            return Reflection.getOrCreateKotlinPackage(MathKt.class, (String)"ui-text_release");
        }
    });

    public static final long getDefaultSelectionColor() {
        return DefaultSelectionColor;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    public static final void CoreText(@NotNull AnnotatedString text, @Nullable Modifier modifier, @NotNull TextStyle style, boolean softWrap, @NotNull TextOverflow overflow, int maxLines, @NotNull Map<String, InlineTextContent> inlineContent, @NotNull Function1<? super TextLayoutResult, Unit> onTextLayout, @Nullable Composer<?> $composer, int $key, int $changed, int $default) {
        Object object;
        void $this$cache$iv$iv;
        void $key$iv;
        void this_$iv;
        void this_$iv2;
        void this_$iv3;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)overflow, (String)"overflow");
        Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
        Intrinsics.checkNotNullParameter(onTextLayout, (String)"onTextLayout");
        $composer.startRestartGroup($key);
        Modifier modifier2 = ($default & 2) != 0 ? (Modifier)Modifier.Companion : modifier;
        boolean bl = maxLines > 0;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "maxLines should be greater than 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Ambient ambient = (Ambient)SelectionRegistrarKt.getSelectionRegistrarAmbient();
        n = -1187471263;
        int $changed$iv = 0;
        boolean $i$f$getCurrent = false;
        Object object2 = $composer.consume((Ambient)this_$iv3);
        SelectionRegistrar selectionRegistrar = (SelectionRegistrar)object2;
        Ambient $key$iv2 = (Ambient)AmbientsKt.getDensityAmbient();
        $changed$iv = -1187471222;
        int $changed$iv2 = 0;
        boolean $i$f$getCurrent2 = false;
        Object object3 = $composer.consume((Ambient)this_$iv2);
        Density density = (Density)object3;
        Ambient $key$iv3 = (Ambient)AmbientsKt.getFontLoaderAmbient();
        $changed$iv2 = -1187471171;
        boolean $changed$iv3 = false;
        boolean $i$f$getCurrent3 = false;
        Object object4 = $composer.consume((Ambient)this_$iv);
        Font.ResourceLoader resourceLoader = (Font.ResourceLoader)object4;
        Pair<List<AnnotatedString.Range<Placeholder>>, List<AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>>>> pair = CoreTextKt.resolveInlineContent(text, inlineContent);
        List placeholders = (List)pair.component1();
        List inlineComposables = (List)pair.component2();
        int n2 = -1187471059;
        boolean $changed$iv4 = false;
        boolean $i$f$remember = false;
        $composer.startReplaceableGroup((int)$key$iv);
        Density density2 = $composer;
        boolean valid$iv$iv = true;
        boolean $i$f$cache = false;
        Object result$iv$iv = $this$cache$iv$iv.nextSlot();
        if (result$iv$iv == SlotTable.Companion.getEMPTY()) {
            TextState textState;
            boolean bl4 = false;
            object = text;
            TextStyle textStyle = style;
            Density density3 = density;
            boolean bl5 = softWrap;
            Font.ResourceLoader resourceLoader2 = resourceLoader;
            TextOverflow textOverflow = overflow;
            int n3 = maxLines;
            List list = placeholders;
            TextState value$iv$iv = textState = new TextState(new TextDelegate(object, textStyle, n3, bl5, textOverflow, density3, resourceLoader2, list));
            $this$cache$iv$iv.updateValue((Object)value$iv$iv);
            result$iv$iv = value$iv$iv;
        }
        Object object5 = result$iv$iv;
        $composer.endReplaceableGroup();
        TextState state = (TextState)object5;
        TextDelegate textDelegate = state.getTextDelegate();
        AnnotatedString annotatedString = text;
        TextStyle textStyle = style;
        density2 = density;
        boolean bl6 = softWrap;
        Font.ResourceLoader resourceLoader3 = resourceLoader;
        TextOverflow textOverflow = overflow;
        int n4 = maxLines;
        object = placeholders;
        state.setTextDelegate(CoreTextKt.updateTextDelegate(textDelegate, annotatedString, textStyle, density2, resourceLoader3, bl6, textOverflow, n4, (List<AnnotatedString.Range<Placeholder>>)object));
        textDelegate = (Function3)RestartableFunctionKt.restartableFunctionInstance((int)-1071318932, (boolean)true, (Object)new Function3<Composer<?>, Integer, Integer, Unit>(text, inlineComposables, $changed){
            private final /* synthetic */ AnnotatedString $text;
            private final /* synthetic */ List<AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>>> $inlineComposables;
            private final /* synthetic */ int $$changed;
            {
                this.$text = $text;
                this.$inlineComposables = $inlineComposables;
                this.$$changed = $$changed;
                super(3);
            }

            public final void invoke(@Nullable Composer<?> $composer, int $key, int $changed) {
                if (($changed & 3 ^ 2) != 0 || !$composer.getSkipping()) {
                    CoreTextKt.InlineChildren(this.$text, this.$inlineComposables, $composer, 649165365, 6 & this.$$changed);
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        });
        annotatedString = OnPositionedModifierKt.onPositioned((Modifier)DrawModifierKt.drawBehind((Modifier)modifier2, (Function1)((Function1)new Function1<DrawScope, Unit>(state){
            private final /* synthetic */ TextState $state;
            {
                this.$state = $state;
                super(1);
            }

            public final void invoke(@NotNull DrawScope drawScope) {
                Intrinsics.checkNotNullParameter((Object)drawScope, (String)"<this>");
                TextLayoutResult textLayoutResult = this.$state.getLayoutResult();
                if (textLayoutResult != null) {
                    TextLayoutResult textLayoutResult2 = textLayoutResult;
                    TextState textState = this.$state;
                    boolean bl = false;
                    boolean bl2 = false;
                    TextLayoutResult layoutResult = textLayoutResult2;
                    boolean bl3 = false;
                    DrawScope $this$drawCanvas$iv = drawScope;
                    boolean $i$f$drawCanvas = false;
                    Size size = $this$drawCanvas$iv.getSize();
                    Canvas canvas = $this$drawCanvas$iv.getCanvas();
                    boolean bl4 = false;
                    TextRange textRange = textState.getSelectionRange();
                    if (textRange != null) {
                        TextRange textRange2 = textRange;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        TextRange it = textRange2;
                        boolean bl7 = false;
                        TextDelegate.Companion.paintBackground(it.getMin(), it.getMax(), textState.getSelectionPaint(), canvas, layoutResult);
                    }
                    TextDelegate.Companion.paint(canvas, layoutResult);
                }
            }
        })), (Function1)((Function1)new Function1<LayoutCoordinates, Unit>(state, selectionRegistrar){
            private final /* synthetic */ TextState $state;
            private final /* synthetic */ SelectionRegistrar $selectionRegistrar;
            {
                this.$state = $state;
                this.$selectionRegistrar = $selectionRegistrar;
                super(1);
            }

            public final void invoke(@NotNull LayoutCoordinates it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$state.setLayoutCoordinates(it);
                if (this.$selectionRegistrar != null && this.$state.getSelectionRange() != null) {
                    LayoutCoordinates $this$globalPosition$iv = it;
                    boolean $i$f$getGlobalPosition = false;
                    Offset newGlobalPosition = $this$globalPosition$iv.localToGlobal(Offset.Companion.getZero());
                    if (!Intrinsics.areEqual((Object)newGlobalPosition, (Object)this.$state.getPreviousGlobalPosition())) {
                        this.$selectionRegistrar.onPositionChange();
                    }
                    this.$state.setPreviousGlobalPosition(newGlobalPosition);
                }
            }
        }));
        textStyle = (Function4)new Function4<IntrinsicMeasureScope, List<? extends IntrinsicMeasurable>, Integer, LayoutDirection, Integer>(state){
            private final /* synthetic */ TextState $state;
            {
                this.$state = $state;
                super(4);
            }

            public final int invoke(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull List<? extends IntrinsicMeasurable> $noName_0, int $noName_1, @NotNull LayoutDirection layoutDirection) {
                Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"<this>");
                Intrinsics.checkNotNullParameter($noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
                this.$state.getTextDelegate().layoutIntrinsics(layoutDirection);
                return this.$state.getTextDelegate().getMinIntrinsicWidth();
            }
        };
        density2 = (Function4)new Function4<IntrinsicMeasureScope, List<? extends IntrinsicMeasurable>, Integer, LayoutDirection, Integer>(state){
            private final /* synthetic */ TextState $state;
            {
                this.$state = $state;
                super(4);
            }

            public final int invoke(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull List<? extends IntrinsicMeasurable> $noName_0, int width, @NotNull LayoutDirection layoutDirection) {
                Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"<this>");
                Intrinsics.checkNotNullParameter($noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
                return TextDelegate.layout$default((TextDelegate)this.$state.getTextDelegate(), (Constraints)ConstraintsKt.Constraints((int)0, (int)width, (int)0, (int)Integer.MAX_VALUE), (LayoutDirection)layoutDirection, null, (int)4, null).getSize().getHeight();
            }
        };
        Function4 function4 = (Function4)new Function4<IntrinsicMeasureScope, List<? extends IntrinsicMeasurable>, Integer, LayoutDirection, Integer>(state){
            private final /* synthetic */ TextState $state;
            {
                this.$state = $state;
                super(4);
            }

            public final int invoke(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull List<? extends IntrinsicMeasurable> $noName_0, int $noName_1, @NotNull LayoutDirection layoutDirection) {
                Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"<this>");
                Intrinsics.checkNotNullParameter($noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
                this.$state.getTextDelegate().layoutIntrinsics(layoutDirection);
                return this.$state.getTextDelegate().getMaxIntrinsicWidth();
            }
        };
        resourceLoader3 = (Function4)new Function4<IntrinsicMeasureScope, List<? extends IntrinsicMeasurable>, Integer, LayoutDirection, Integer>(state){
            private final /* synthetic */ TextState $state;
            {
                this.$state = $state;
                super(4);
            }

            public final int invoke(@NotNull IntrinsicMeasureScope intrinsicMeasureScope, @NotNull List<? extends IntrinsicMeasurable> $noName_0, int width, @NotNull LayoutDirection layoutDirection) {
                Intrinsics.checkNotNullParameter((Object)intrinsicMeasureScope, (String)"<this>");
                Intrinsics.checkNotNullParameter($noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
                return TextDelegate.layout$default((TextDelegate)this.$state.getTextDelegate(), (Constraints)ConstraintsKt.Constraints((int)0, (int)width, (int)0, (int)Integer.MAX_VALUE), (LayoutDirection)layoutDirection, null, (int)4, null).getSize().getHeight();
            }
        };
        textOverflow = (Function4)new Function4<MeasureScope, List<? extends Measurable>, Constraints, LayoutDirection, MeasureScope.MeasureResult>(state, onTextLayout){
            private final /* synthetic */ TextState $state;
            private final /* synthetic */ Function1<TextLayoutResult, Unit> $onTextLayout;
            {
                this.$state = $state;
                this.$onTextLayout = $onTextLayout;
                super(4);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MeasureScope.MeasureResult invoke(@NotNull MeasureScope measureScope, @NotNull List<? extends Measurable> measurables, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection) {
                void $this$mapIndexedNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)measureScope, (String)"<this>");
                Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
                Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
                Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
                TextLayoutResult layoutResult = this.$state.getTextDelegate().layout(constraints, layoutDirection, this.$state.getLayoutResult());
                if (!Intrinsics.areEqual((Object)this.$state.getLayoutResult(), (Object)layoutResult)) {
                    this.$onTextLayout.invoke((Object)layoutResult);
                }
                this.$state.setLayoutResult(layoutResult);
                boolean bl = measurables.size() >= layoutResult.getPlaceholderRects().size();
                boolean bl2 = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl) {
                    boolean bl5 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Iterable $this$mapIndexedNotNull$iv = layoutResult.getPlaceholderRects();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Pair pair;
                    void rect;
                    void element$iv$iv;
                    int n = index$iv$iv$iv++;
                    boolean bl6 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    T t = item$iv$iv$iv;
                    int index$iv$iv = n2;
                    boolean bl7 = false;
                    Rect rect2 = (Rect)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl8 = false;
                    void var26_31 = rect;
                    if (var26_31 == null) {
                        pair = null;
                    } else {
                        long l;
                        void y$iv;
                        void x$iv;
                        void var27_32 = var26_31;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        void it = var27_32;
                        boolean bl11 = false;
                        float f = it.getWidth();
                        int n3 = 0;
                        Measurable measurable = measurables.get(index);
                        MeasureScope measureScope2 = measureScope;
                        boolean bl12 = false;
                        float f2 = (float)Math.floor(f);
                        f = it.getHeight();
                        int n4 = 0;
                        int n5 = (int)f2;
                        bl12 = false;
                        float f3 = (float)Math.floor(f);
                        f = it.getLeft();
                        float f4 = it.getTop();
                        measureScope2 = measureScope2.measure(measurable, ConstraintsKt.Constraints$default((int)n3, (int)n5, (int)n4, (int)((int)f3), (int)5, null));
                        boolean $i$f$Offset = false;
                        boolean $i$f$packFloats = false;
                        void var44_49 = x$iv;
                        boolean bl13 = false;
                        long v1$iv$iv = Float.floatToIntBits((float)var44_49);
                        void var48_52 = y$iv;
                        boolean bl14 = false;
                        long v2$iv$iv = Float.floatToIntBits((float)var48_52);
                        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
                        Measurable measurable2 = measurable = new Offset(l2);
                        MeasureScope measureScope3 = measureScope2;
                        pair = new Pair((Object)measureScope3, (Object)measurable2);
                    }
                    if (pair == null) continue;
                    Pair pair2 = pair;
                    boolean bl15 = false;
                    boolean bl16 = false;
                    Pair it$iv$iv = pair2;
                    boolean bl17 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List placeables = (List)destination$iv$iv;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CoreTextKt.getFirstBaseline(), (Object)MathKt.roundToInt((float)layoutResult.getFirstBaseline())), TuplesKt.to((Object)CoreTextKt.getLastBaseline(), (Object)MathKt.roundToInt((float)layoutResult.getLastBaseline()))};
                return measureScope.layout(layoutResult.getSize().getWidth(), layoutResult.getSize().getHeight(), MapsKt.mapOf((Pair[])pairArray), (Function1)new Function1<Placeable.PlacementScope, Unit>((List<? extends Pair<? extends Placeable, Offset>>)placeables){
                    private final /* synthetic */ List<Pair<Placeable, Offset>> $placeables;
                    {
                        this.$placeables = $placeables;
                        super(1);
                    }

                    public final void invoke(@NotNull Placeable.PlacementScope placementScope) {
                        Intrinsics.checkNotNullParameter((Object)placementScope, (String)"<this>");
                        List<Pair<Placeable, Offset>> $this$fastForEach$iv = this.$placeables;
                        boolean $i$f$fastForEach = false;
                        int n = 0;
                        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
                        if (n <= n2) {
                            do {
                                Pair<Placeable, Offset> item$iv;
                                int index$iv = n++;
                                Pair<Placeable, Offset> placeable = item$iv = $this$fastForEach$iv.get(index$iv);
                                boolean bl = false;
                                placementScope.place((Placeable)placeable.getFirst(), (Offset)placeable.getSecond());
                            } while (n <= n2);
                        }
                    }
                });
            }
        };
        LayoutKt.Layout((Function3)textDelegate, (Function4)textStyle, (Function4)density2, (Function4)function4, (Function4)resourceLoader3, (Modifier)annotatedString, (Function4)textOverflow, (Composer)$composer, (int)-1187470345, (int)0, (int)0);
        EffectsKt.onCommit((Object)selectionRegistrar, (Function1)((Function1)new Function1<CommitScope, Unit>(selectionRegistrar, state){
            private final /* synthetic */ SelectionRegistrar $selectionRegistrar;
            private final /* synthetic */ TextState $state;
            {
                this.$selectionRegistrar = $selectionRegistrar;
                this.$state = $state;
                super(1);
            }

            public final void invoke(@NotNull CommitScope commitScope) {
                Selectable selectable;
                Intrinsics.checkNotNullParameter((Object)commitScope, (String)"<this>");
                SelectionRegistrar selectionRegistrar = this.$selectionRegistrar;
                if (selectionRegistrar == null) {
                    selectable = null;
                } else {
                    SelectionRegistrar selectionRegistrar2 = selectionRegistrar;
                    SelectionRegistrar selectionRegistrar3 = this.$selectionRegistrar;
                    TextState textState = this.$state;
                    boolean bl = false;
                    boolean bl2 = false;
                    SelectionRegistrar it = selectionRegistrar2;
                    boolean bl3 = false;
                    selectable = selectionRegistrar3.subscribe((Selectable)new TextSelectionDelegate((Function1<? super TextRange, Unit>)((Function1)new Function1<TextRange, Unit>(textState){
                        private final /* synthetic */ TextState $state;
                        {
                            this.$state = $state;
                            super(1);
                        }

                        public final void invoke(@Nullable TextRange it) {
                            this.$state.setSelectionRange(it);
                        }
                    }), (Function0<? extends LayoutCoordinates>)((Function0)new Function0<LayoutCoordinates>(textState){
                        private final /* synthetic */ TextState $state;
                        {
                            this.$state = $state;
                            super(0);
                        }

                        @Nullable
                        public final LayoutCoordinates invoke() {
                            return this.$state.getLayoutCoordinates();
                        }
                    }), (Function0<TextLayoutResult>)((Function0)new Function0<TextLayoutResult>(textState){
                        private final /* synthetic */ TextState $state;
                        {
                            this.$state = $state;
                            super(0);
                        }

                        @Nullable
                        public final TextLayoutResult invoke() {
                            return this.$state.getLayoutResult();
                        }
                    })));
                }
                Selectable id2 = selectable;
                commitScope.onDispose((Function0)new Function0<Unit>(id2, this.$selectionRegistrar){
                    private final /* synthetic */ Selectable $id;
                    private final /* synthetic */ SelectionRegistrar $selectionRegistrar;
                    {
                        this.$id = $id;
                        this.$selectionRegistrar = $selectionRegistrar;
                        super(0);
                    }

                    public final void invoke() {
                        Selectable selectable = this.$id;
                        if (selectable != null) {
                            Selectable selectable2 = selectable;
                            SelectionRegistrar selectionRegistrar = this.$selectionRegistrar;
                            Selectable selectable3 = this.$id;
                            boolean bl = false;
                            boolean bl2 = false;
                            Selectable it = selectable2;
                            boolean bl3 = false;
                            selectionRegistrar.unsubscribe(selectable3);
                        }
                    }
                });
            }
        }), (Composer)$composer, (int)-1187465608, (int)0);
        textDelegate = $composer.endRestartGroup();
        if (textDelegate != null) {
            textDelegate.updateScope(new Function3<Composer<?>, Integer, Integer, Unit>(text, modifier2, style, softWrap, overflow, maxLines, inlineContent, onTextLayout, $changed, $default){
                private final /* synthetic */ AnnotatedString $text;
                private final /* synthetic */ Modifier $modifier;
                private final /* synthetic */ TextStyle $style;
                private final /* synthetic */ boolean $softWrap;
                private final /* synthetic */ TextOverflow $overflow;
                private final /* synthetic */ int $maxLines;
                private final /* synthetic */ Map<String, InlineTextContent> $inlineContent;
                private final /* synthetic */ Function1<TextLayoutResult, Unit> $onTextLayout;
                private final /* synthetic */ int $$changed;
                private final /* synthetic */ int $$default;
                {
                    this.$text = $text;
                    this.$modifier = $modifier;
                    this.$style = $style;
                    this.$softWrap = $softWrap;
                    this.$overflow = $overflow;
                    this.$maxLines = $maxLines;
                    this.$inlineContent = $inlineContent;
                    this.$onTextLayout = $onTextLayout;
                    this.$$changed = $$changed;
                    this.$$default = $$default;
                    super(3);
                }

                public final void invoke(@Nullable Composer<?> $composer, int $key, int $force) {
                    CoreTextKt.CoreText(this.$text, this.$modifier, this.$style, this.$softWrap, this.$overflow, this.$maxLines, this.$inlineContent, this.$onTextLayout, $composer, $key, this.$$changed | 1, this.$$default);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    public static final void InlineChildren(@NotNull AnnotatedString text, @NotNull List<AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>>> inlineContents, @Nullable Composer<?> $composer, int $key, int $changed) {
        ScopeUpdateScope scopeUpdateScope;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(inlineContents, (String)"inlineContents");
        $composer.startRestartGroup($key);
        List<AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>>> $this$fastForEach$iv = inlineContents;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                void $this$cache$iv$iv;
                void $key$iv;
                AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>> item$iv;
                int index$iv = n++;
                AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>> $dstr$content$start$end = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                Function4 content = (Function4)$dstr$content$start$end.component1();
                int start = $dstr$content$start$end.component2();
                int end = $dstr$content$start$end.component3();
                int n3 = 1080818355;
                boolean bl2 = false;
                Modifier modifier = null;
                Function3 function3 = (Function3)RestartableFunctionKt.restartableFunction($composer, (int)-756393428, (boolean)true, (Object)new Function3<Composer<?>, Integer, Integer, Unit>(content, text, start, end){
                    private final /* synthetic */ Function4<String, Composer<?>, Integer, Integer, Unit> $content;
                    private final /* synthetic */ AnnotatedString $text;
                    private final /* synthetic */ int $start;
                    private final /* synthetic */ int $end;
                    {
                        this.$content = $content;
                        this.$text = $text;
                        this.$start = $start;
                        this.$end = $end;
                        super(3);
                    }

                    public final void invoke(@Nullable Composer<?> $composer, int $key, int $changed) {
                        if (($changed & 3 ^ 2) != 0 || !$composer.getSkipping()) {
                            this.$content.invoke((Object)AnnotatedStringKt.subSequence((AnnotatedString)this.$text, (int)this.$start, (int)this.$end).getText(), $composer, (Object)1820719389, (Object)0);
                        } else {
                            $composer.skipToGroupEnd();
                        }
                    }
                });
                boolean $i$f$remember = false;
                $composer.startReplaceableGroup((int)$key$iv);
                Composer<?> composer = $composer;
                boolean valid$iv$iv = true;
                boolean $i$f$cache = false;
                Object result$iv$iv = $this$cache$iv$iv.nextSlot();
                if (result$iv$iv == SlotTable.Companion.getEMPTY()) {
                    boolean bl3 = false;
                    Function4<MeasureScope, List<? extends Measurable>, Constraints, LayoutDirection, MeasureScope.MeasureResult> value$iv$iv = new Function4<MeasureScope, List<? extends Measurable>, Constraints, LayoutDirection, MeasureScope.MeasureResult>(){

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final MeasureScope.MeasureResult invoke(@NotNull MeasureScope measureScope, @NotNull List<? extends Measurable> children, @NotNull Constraints constrains, @NotNull LayoutDirection $noName_2) {
                            void $this$mapTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)measureScope, (String)"<this>");
                            Intrinsics.checkNotNullParameter(children, (String)"children");
                            Intrinsics.checkNotNullParameter((Object)constrains, (String)"constrains");
                            Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
                            Iterable $this$map$iv = children;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                Measurable measurable = (Measurable)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                Placeable placeable = measureScope.measure((Measurable)it, constrains);
                                collection.add(placeable);
                            }
                            List placeables = (List)destination$iv$iv;
                            return MeasureScope.layout$default((MeasureScope)measureScope, (int)constrains.getMaxWidth(), (int)constrains.getMaxHeight(), null, (Function1)((Function1)new Function1<Placeable.PlacementScope, Unit>((List<? extends Placeable>)placeables){
                                private final /* synthetic */ List<Placeable> $placeables;
                                {
                                    this.$placeables = $placeables;
                                    super(1);
                                }

                                public final void invoke(@NotNull Placeable.PlacementScope placementScope) {
                                    Intrinsics.checkNotNullParameter((Object)placementScope, (String)"<this>");
                                    List<Placeable> $this$fastForEach$iv = this.$placeables;
                                    boolean $i$f$fastForEach = false;
                                    int n = 0;
                                    int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
                                    if (n <= n2) {
                                        do {
                                            Placeable item$iv;
                                            int index$iv = n++;
                                            Placeable it = item$iv = $this$fastForEach$iv.get(index$iv);
                                            boolean bl = false;
                                            placementScope.place(it, 0, 0);
                                        } while (n <= n2);
                                    }
                                }
                            }), (int)4, null);
                        }
                    };
                    $this$cache$iv$iv.updateValue((Object)value$iv$iv);
                    result$iv$iv = value$iv$iv;
                }
                Object object = result$iv$iv;
                $composer.endReplaceableGroup();
                Object object2 = object;
                LayoutKt.Layout((Function3)function3, modifier, (Function4)((Function4)object2), $composer, (int)1080818267, (int)102, (int)2);
            } while (n <= n2);
        }
        if ((scopeUpdateScope = $composer.endRestartGroup()) != null) {
            scopeUpdateScope.updateScope(new Function3<Composer<?>, Integer, Integer, Unit>(text, inlineContents, $changed){
                private final /* synthetic */ AnnotatedString $text;
                private final /* synthetic */ List<AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>>> $inlineContents;
                private final /* synthetic */ int $$changed;
                {
                    this.$text = $text;
                    this.$inlineContents = $inlineContents;
                    this.$$changed = $$changed;
                    super(3);
                }

                public final void invoke(@Nullable Composer<?> $composer, int $key, int $force) {
                    CoreTextKt.InlineChildren(this.$text, this.$inlineContents, $composer, $key, this.$$changed | 1);
                }
            });
        }
    }

    @NotNull
    public static final HorizontalAlignmentLine getFirstBaseline() {
        return FirstBaseline;
    }

    @NotNull
    public static final HorizontalAlignmentLine getLastBaseline() {
        return LastBaseline;
    }

    @NotNull
    public static final TextDelegate updateTextDelegate(@NotNull TextDelegate current, @NotNull AnnotatedString text, @NotNull TextStyle style, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader, boolean softWrap, @NotNull TextOverflow overflow, int maxLines, @NotNull List<AnnotatedString.Range<Placeholder>> placeholders) {
        TextDelegate textDelegate;
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkNotNullParameter((Object)overflow, (String)"overflow");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        if (!(Intrinsics.areEqual((Object)current.getText(), (Object)text) && Intrinsics.areEqual((Object)current.getStyle(), (Object)style) && current.getSoftWrap() == softWrap && Intrinsics.areEqual((Object)current.getOverflow(), (Object)overflow) && current.getMaxLines() == maxLines && Intrinsics.areEqual((Object)current.getDensity(), (Object)density) && Intrinsics.areEqual((Object)current.getPlaceholders(), placeholders))) {
            AnnotatedString annotatedString = text;
            TextStyle textStyle = style;
            boolean bl = softWrap;
            TextOverflow textOverflow = overflow;
            int n = maxLines;
            Density density2 = density;
            Font.ResourceLoader resourceLoader2 = resourceLoader;
            List<AnnotatedString.Range<Placeholder>> list = placeholders;
            textDelegate = new TextDelegate(annotatedString, textStyle, n, bl, textOverflow, density2, resourceLoader2, list);
        } else {
            textDelegate = current;
        }
        return textDelegate;
    }

    public static /* synthetic */ TextDelegate updateTextDelegate$default(TextDelegate current, AnnotatedString text, TextStyle style, Density density, Font.ResourceLoader resourceLoader, boolean softWrap, TextOverflow overflow, int maxLines, List placeholders, int n, Object object) {
        if ((n & 0x20) != 0) {
            softWrap = true;
        }
        if ((n & 0x40) != 0) {
            overflow = TextOverflow.Clip;
        }
        if ((n & 0x80) != 0) {
            maxLines = Integer.MAX_VALUE;
        }
        return CoreTextKt.updateTextDelegate(current, text, style, density, resourceLoader, softWrap, overflow, maxLines, placeholders);
    }

    @NotNull
    public static final Pair<List<AnnotatedString.Range<Placeholder>>, List<AnnotatedString.Range<Function4<String, Composer<?>, Integer, Integer, Unit>>>> resolveInlineContent(@NotNull AnnotatedString text, @NotNull Map<String, InlineTextContent> inlineContent) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
        if (inlineContent.isEmpty()) {
            List list;
            boolean bl = false;
            List list2 = CollectionsKt.emptyList();
            bl = false;
            List list3 = list = CollectionsKt.emptyList();
            List list4 = list2;
            return new Pair((Object)list4, (Object)list3);
        }
        List inlineContentAnnotations = text.getStringAnnotations("androidx.ui.text.inlineContent", 0, AnnotatedStringKt.getLength((AnnotatedString)text));
        boolean bl = false;
        List placeholders = new ArrayList();
        boolean bl2 = false;
        List inlineComposables = new ArrayList();
        List $this$fastForEach$iv = inlineContentAnnotations;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                AnnotatedString.Range annotation = (AnnotatedString.Range)item$iv;
                boolean bl3 = false;
                InlineTextContent inlineTextContent = inlineContent.get((String)annotation.getItem());
                if (inlineTextContent == null) {
                    continue;
                }
                InlineTextContent inlineTextContent2 = inlineTextContent;
                boolean bl4 = false;
                boolean bl5 = false;
                InlineTextContent inlineTextContent3 = inlineTextContent2;
                boolean bl6 = false;
                placeholders.add(new AnnotatedString.Range((Object)inlineTextContent3.getPlaceholder(), annotation.getStart(), annotation.getEnd()));
                inlineComposables.add(new AnnotatedString.Range(inlineTextContent3.getChildren(), annotation.getStart(), annotation.getEnd()));
            } while (n <= n2);
        }
        return new Pair((Object)placeholders, (Object)inlineComposables);
    }
}

