/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.LayoutDirection;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.input.EditOperation;
import androidx.ui.input.EditProcessor;
import androidx.ui.input.FinishComposingTextEditOp;
import androidx.ui.input.ImeAction;
import androidx.ui.input.KeyboardType;
import androidx.ui.input.OffsetMap;
import androidx.ui.input.SetSelectionEditOp;
import androidx.ui.input.TextFieldValue;
import androidx.ui.input.TextInputService;
import androidx.ui.input.TransformedText;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.InternalTextApi;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.TextDelegate;
import androidx.ui.text.TextFieldDelegateKt;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextPainter;
import androidx.ui.text.TextRange;
import androidx.ui.text.style.TextDecoration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalTextApi
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0003"}, d2={"Landroidx/ui/text/TextFieldDelegate;", "", "Companion", "ui-text_release"})
public final class TextFieldDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Triple<Integer, Integer, TextLayoutResult> layout$ui_text_release$ui_text_release(@NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText) {
        return TextFieldDelegate.Companion.layout$ui_text_release(textDelegate, constraints, layoutDirection, prevResultText);
    }

    @JvmStatic
    @NotNull
    public static final Triple<Integer, Integer, TextLayoutResult> layout$default(@NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText, int n, @Nullable Object object) {
        return androidx.ui.text.TextFieldDelegate$Companion.layout$default(Companion, textDelegate, constraints, layoutDirection, prevResultText, n, object);
    }

    @JvmStatic
    public static final void draw--R-6sDs$ui_text_release$ui_text_release(@NotNull Canvas canvas, @NotNull TextFieldValue value, @NotNull OffsetMap offsetMap, @NotNull TextLayoutResult textLayoutResult, long selectionColor) {
        TextFieldDelegate.Companion.draw--R-6sDs$ui_text_release(canvas, value, offsetMap, textLayoutResult, selectionColor);
    }

    @JvmStatic
    public static final void notifyFocusedRect$ui_text_release$ui_text_release(@NotNull TextFieldValue value, @NotNull TextDelegate textDelegate, @NotNull TextLayoutResult textLayoutResult, @NotNull LayoutCoordinates layoutCoordinates, @NotNull TextInputService textInputService, int token, boolean hasFocus, @NotNull OffsetMap offsetMap) {
        TextFieldDelegate.Companion.notifyFocusedRect$ui_text_release(value, textDelegate, textLayoutResult, layoutCoordinates, textInputService, token, hasFocus, offsetMap);
    }

    @JvmStatic
    public static final void onEditCommand$ui_text_release$ui_text_release(@NotNull List<? extends EditOperation> ops, @NotNull EditProcessor editProcessor, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
        TextFieldDelegate.Companion.onEditCommand$ui_text_release(ops, editProcessor, (Function1<? super TextFieldValue, Unit>)onValueChange);
    }

    @JvmStatic
    public static final void onRelease$ui_text_release$ui_text_release(@NotNull Offset position, @NotNull TextLayoutResult textLayoutResult, @NotNull EditProcessor editProcessor, @NotNull OffsetMap offsetMap, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @Nullable TextInputService textInputService, int token, boolean hasFocus) {
        TextFieldDelegate.Companion.onRelease$ui_text_release(position, textLayoutResult, editProcessor, offsetMap, (Function1<? super TextFieldValue, Unit>)onValueChange, textInputService, token, hasFocus);
    }

    @JvmStatic
    public static final int onFocus$ui_text_release$ui_text_release(@Nullable TextInputService textInputService, @NotNull TextFieldValue value, @NotNull EditProcessor editProcessor, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        return TextFieldDelegate.Companion.onFocus$ui_text_release(textInputService, value, editProcessor, keyboardType, imeAction, (Function1<? super TextFieldValue, Unit>)onValueChange, (Function1<? super ImeAction, Unit>)onImeActionPerformed);
    }

    @JvmStatic
    public static final void onBlur$ui_text_release$ui_text_release(@Nullable TextInputService textInputService, int token, @NotNull EditProcessor editProcessor, boolean hasNextClient, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
        TextFieldDelegate.Companion.onBlur$ui_text_release(textInputService, token, editProcessor, hasNextClient, (Function1<? super TextFieldValue, Unit>)onValueChange);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0007J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014JC\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0001\u00a2\u0006\u0002\b\u001fJQ\u0010 \u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u00060\u0017j\u0002`&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b)JG\u0010*\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010$2\n\u0010%\u001a\u00060\u0017j\u0002`&2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020(2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0/H\u0001\u00a2\u0006\u0002\b0J7\u00101\u001a\u00020\b2\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010+\u001a\u00020,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0/H\u0001\u00a2\u0006\u0002\b5Jc\u00106\u001a\u00060\u0017j\u0002`&2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0/2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\b0/H\u0001\u00a2\u0006\u0002\b<J_\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0/2\b\u0010#\u001a\u0004\u0018\u00010$2\n\u0010%\u001a\u00060\u0017j\u0002`&2\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b@\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Landroidx/ui/text/TextFieldDelegate$Companion;", "", "applyCompositionDecoration", "Landroidx/ui/input/TransformedText;", "compositionRange", "Landroidx/ui/text/TextRange;", "transformed", "draw", "", "canvas", "Landroidx/ui/graphics/Canvas;", "value", "Landroidx/ui/input/TextFieldValue;", "offsetMap", "Landroidx/ui/input/OffsetMap;", "textLayoutResult", "Landroidx/ui/text/TextLayoutResult;", "selectionColor", "Landroidx/ui/graphics/Color;", "draw--R-6sDs$ui_text_release", "(Landroidx/ui/graphics/Canvas;Landroidx/ui/input/TextFieldValue;Landroidx/ui/input/OffsetMap;Landroidx/ui/text/TextLayoutResult;J)V", "layout", "Lkotlin/Triple;", "", "textDelegate", "Landroidx/ui/text/TextDelegate;", "constraints", "Landroidx/ui/core/Constraints;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "prevResultText", "layout$ui_text_release", "notifyFocusedRect", "layoutCoordinates", "Landroidx/ui/core/LayoutCoordinates;", "textInputService", "Landroidx/ui/input/TextInputService;", "token", "Landroidx/ui/input/InputSessionToken;", "hasFocus", "", "notifyFocusedRect$ui_text_release", "onBlur", "editProcessor", "Landroidx/ui/input/EditProcessor;", "hasNextClient", "onValueChange", "Lkotlin/Function1;", "onBlur$ui_text_release", "onEditCommand", "ops", "", "Landroidx/ui/input/EditOperation;", "onEditCommand$ui_text_release", "onFocus", "keyboardType", "Landroidx/ui/input/KeyboardType;", "imeAction", "Landroidx/ui/input/ImeAction;", "onImeActionPerformed", "onFocus$ui_text_release", "onRelease", "position", "Landroidx/ui/geometry/Offset;", "onRelease$ui_text_release", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Triple<Integer, Integer, TextLayoutResult> layout$ui_text_release(@NotNull TextDelegate textDelegate, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResultText) {
            int n;
            boolean isEmptyText;
            Intrinsics.checkNotNullParameter((Object)textDelegate, (String)"textDelegate");
            Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
            Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
            TextLayoutResult layoutResult = textDelegate.layout(constraints, layoutDirection, prevResultText);
            CharSequence charSequence = textDelegate.getText().getText();
            boolean bl = false;
            boolean bl2 = isEmptyText = charSequence.length() == 0;
            if (isEmptyText) {
                int singleLineHeight = TextFieldDelegateKt.access$computeLineHeightForEmptyText(textDelegate.getStyle(), textDelegate.getDensity(), textDelegate.getResourceLoader());
                n = ConstraintsKt.constrainHeight((Constraints)constraints, (int)singleLineHeight);
            } else {
                n = layoutResult.getSize().getHeight();
            }
            int height = n;
            int width = layoutResult.getSize().getWidth();
            return new Triple((Object)width, (Object)height, (Object)layoutResult);
        }

        public static /* synthetic */ Triple layout$default(Companion this_, TextDelegate textDelegate, Constraints constraints, LayoutDirection layoutDirection, TextLayoutResult prevResultText, int n, Object object) {
            if ((n & 8) != 0) {
                prevResultText = null;
            }
            return this_.layout$ui_text_release(textDelegate, constraints, layoutDirection, prevResultText);
        }

        @JvmStatic
        public final void draw--R-6sDs$ui_text_release(@NotNull Canvas canvas, @NotNull TextFieldValue value, @NotNull OffsetMap offsetMap, @NotNull TextLayoutResult textLayoutResult, long selectionColor) {
            int end;
            int start;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)offsetMap, (String)"offsetMap");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            if (!value.getSelection().getCollapsed() && (start = offsetMap.originalToTransformed(value.getSelection().getMin())) != (end = offsetMap.originalToTransformed(value.getSelection().getMax()))) {
                Path selectionPath = textLayoutResult.getPathForRange(start, end);
                Paint paint = new Paint();
                Path path = selectionPath;
                Canvas canvas2 = canvas;
                boolean bl = false;
                boolean bl2 = false;
                Paint $this$draw__R_6sDs_u24lambda_u2d0 = paint;
                boolean bl3 = false;
                $this$draw__R_6sDs_u24lambda_u2d0.setColor-QEYXlZo(selectionColor);
                Paint paint2 = paint;
                canvas2.drawPath(path, paint2);
            }
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void notifyFocusedRect$ui_text_release(@NotNull TextFieldValue value, @NotNull TextDelegate textDelegate, @NotNull TextLayoutResult textLayoutResult, @NotNull LayoutCoordinates layoutCoordinates, @NotNull TextInputService textInputService, int token, boolean hasFocus, @NotNull OffsetMap offsetMap) {
            long l;
            void y$iv;
            void x$iv;
            Rect rect;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)textDelegate, (String)"textDelegate");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
            Intrinsics.checkNotNullParameter((Object)textInputService, (String)"textInputService");
            Intrinsics.checkNotNullParameter((Object)offsetMap, (String)"offsetMap");
            if (!hasFocus) {
                return;
            }
            if (value.getSelection().getMax() < value.getText().length()) {
                rect = textLayoutResult.getBoundingBox(offsetMap.originalToTransformed(value.getSelection().getMax()));
            } else if (value.getSelection().getMax() != 0) {
                rect = textLayoutResult.getBoundingBox(offsetMap.originalToTransformed(value.getSelection().getMax()) - 1);
            } else {
                int lineHeightForEmptyText = TextFieldDelegateKt.access$computeLineHeightForEmptyText(textDelegate.getStyle(), textDelegate.getDensity(), textDelegate.getResourceLoader());
                rect = new Rect(0.0f, 0.0f, 1.0f, (float)lineHeightForEmptyText);
            }
            Rect bbox = rect;
            float f = bbox.getLeft();
            float f2 = bbox.getTop();
            LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            void var15_17 = x$iv;
            boolean bl = false;
            long v1$iv$iv = Float.floatToIntBits((float)var15_17);
            void var19_20 = y$iv;
            boolean bl2 = false;
            long v2$iv$iv = Float.floatToIntBits((float)var19_20);
            long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
            Offset offset = new Offset(l2);
            Offset globalLT = layoutCoordinates2.localToRoot(offset);
            textInputService.notifyFocusedRect(token, Rect.Companion.fromLTWH(globalLT.getX(), globalLT.getY(), bbox.getWidth(), bbox.getHeight()));
        }

        @JvmStatic
        public final void onEditCommand$ui_text_release(@NotNull List<? extends EditOperation> ops, @NotNull EditProcessor editProcessor, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
            Intrinsics.checkNotNullParameter(ops, (String)"ops");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            onValueChange.invoke((Object)editProcessor.onEditCommands(ops));
        }

        @JvmStatic
        public final void onRelease$ui_text_release(@NotNull Offset position, @NotNull TextLayoutResult textLayoutResult, @NotNull EditProcessor editProcessor, @NotNull OffsetMap offsetMap, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @Nullable TextInputService textInputService, int token, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter((Object)offsetMap, (String)"offsetMap");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            TextInputService textInputService2 = textInputService;
            if (textInputService2 != null) {
                textInputService2.showSoftwareKeyboard(token);
            }
            if (hasFocus) {
                int offset = offsetMap.transformedToOriginal(textLayoutResult.getOffsetForPosition(position));
                this.onEditCommand$ui_text_release(CollectionsKt.listOf((Object)new SetSelectionEditOp(offset, offset)), editProcessor, onValueChange);
            }
        }

        @JvmStatic
        public final int onFocus$ui_text_release(@Nullable TextInputService textInputService, @NotNull TextFieldValue value, @NotNull EditProcessor editProcessor, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super TextFieldValue, Unit> onValueChange, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter((Object)keyboardType, (String)"keyboardType");
            Intrinsics.checkNotNullParameter((Object)imeAction, (String)"imeAction");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            Intrinsics.checkNotNullParameter(onImeActionPerformed, (String)"onImeActionPerformed");
            TextInputService textInputService2 = textInputService;
            Integer n = textInputService2 == null ? (Integer)null : Integer.valueOf(textInputService2.startInput(new TextFieldValue(value.getText(), value.getSelection(), value.getComposition()), keyboardType, imeAction, (Function1)new Function1<List<? extends EditOperation>, Unit>(this, editProcessor, onValueChange){
                private final /* synthetic */ Companion $this;
                private final /* synthetic */ EditProcessor $editProcessor;
                private final /* synthetic */ Function1<TextFieldValue, Unit> $onValueChange;
                {
                    this.$this = $receiver;
                    this.$editProcessor = $editProcessor;
                    this.$onValueChange = $onValueChange;
                    super(1);
                }

                public final void invoke(@NotNull List<? extends EditOperation> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.$this.onEditCommand$ui_text_release(it, this.$editProcessor, this.$onValueChange);
                }
            }, onImeActionPerformed));
            return n == null ? -1 : n;
        }

        @JvmStatic
        public final void onBlur$ui_text_release(@Nullable TextInputService textInputService, int token, @NotNull EditProcessor editProcessor, boolean hasNextClient, @NotNull Function1<? super TextFieldValue, Unit> onValueChange) {
            Intrinsics.checkNotNullParameter((Object)editProcessor, (String)"editProcessor");
            Intrinsics.checkNotNullParameter(onValueChange, (String)"onValueChange");
            this.onEditCommand$ui_text_release(CollectionsKt.listOf((Object)new FinishComposingTextEditOp()), editProcessor, onValueChange);
            TextInputService textInputService2 = textInputService;
            if (textInputService2 != null) {
                textInputService2.stopInput(token);
            }
            if (!hasNextClient && (textInputService2 = textInputService) != null) {
                textInputService2.hideSoftwareKeyboard(token);
            }
        }

        @InternalTextApi
        @NotNull
        public final TransformedText applyCompositionDecoration(@NotNull TextRange compositionRange, @NotNull TransformedText transformed) {
            Intrinsics.checkNotNullParameter((Object)compositionRange, (String)"compositionRange");
            Intrinsics.checkNotNullParameter((Object)transformed, (String)"transformed");
            AnnotatedString.Builder builder = new AnnotatedString.Builder(transformed.getTransformedText());
            boolean bl = false;
            boolean bl2 = false;
            AnnotatedString.Builder $this$applyCompositionDecoration_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$applyCompositionDecoration_u24lambda_u2d1.addStyle(new SpanStyle(0L, 0L, null, null, null, null, null, 0L, null, null, null, 0L, TextDecoration.Companion.getUnderline(), null, 12287, null), compositionRange.getStart(), compositionRange.getEnd());
            AnnotatedString.Builder builder2 = builder;
            OffsetMap offsetMap = transformed.getOffsetMap();
            AnnotatedString annotatedString = builder2.toAnnotatedString();
            return new TransformedText(annotatedString, offsetMap);
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

