/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.selection;

import androidx.ui.core.LayoutCoordinates;
import androidx.ui.core.selection.Selectable;
import androidx.ui.core.selection.Selection;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextRange;
import androidx.ui.text.selection.TextSelectionDelegateKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B6\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0016J<\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/ui/text/selection/TextSelectionDelegate;", "Landroidx/ui/core/selection/Selectable;", "selectionRangeUpdate", "Lkotlin/Function1;", "Landroidx/ui/text/TextRange;", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/ui/core/LayoutCoordinates;", "layoutResultCallback", "Landroidx/ui/text/TextLayoutResult;", "getBoundingBox", "Landroidx/ui/geometry/Rect;", "offset", "", "getHandlePosition", "Landroidx/ui/geometry/Offset;", "selection", "Landroidx/ui/core/selection/Selection;", "isStartHandle", "", "getLayoutCoordinates", "getSelection", "startPosition", "endPosition", "containerLayoutCoordinates", "longPress", "previousSelection", "getText", "Landroidx/ui/text/AnnotatedString;", "ui-text_release"})
public final class TextSelectionDelegate
implements Selectable {
    private final Function1<TextRange, Unit> selectionRangeUpdate;
    private final Function0<LayoutCoordinates> coordinatesCallback;
    private final Function0<TextLayoutResult> layoutResultCallback;

    public TextSelectionDelegate(@NotNull Function1<? super TextRange, Unit> selectionRangeUpdate, @NotNull Function0<? extends LayoutCoordinates> coordinatesCallback, @NotNull Function0<TextLayoutResult> layoutResultCallback) {
        Intrinsics.checkNotNullParameter(selectionRangeUpdate, (String)"selectionRangeUpdate");
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectionRangeUpdate = selectionRangeUpdate;
        this.coordinatesCallback = coordinatesCallback;
        this.layoutResultCallback = layoutResultCallback;
    }

    @Nullable
    public Selection getSelection(@NotNull Offset startPosition, @NotNull Offset endPosition, @NotNull LayoutCoordinates containerLayoutCoordinates, boolean longPress, @Nullable Selection previousSelection, boolean isStartHandle) {
        Offset endPx;
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        Intrinsics.checkNotNullParameter((Object)containerLayoutCoordinates, (String)"containerLayoutCoordinates");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return null;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        Offset relativePosition = containerLayoutCoordinates.childToLocal(layoutCoordinates2, Offset.Companion.getZero());
        Offset startPx = startPosition.minus(relativePosition);
        Selection selection = TextSelectionDelegateKt.getTextSelectionInfo(textLayoutResult2, (Pair<Offset, Offset>)new Pair((Object)startPx, (Object)(endPx = endPosition.minus(relativePosition))), this, longPress, previousSelection, isStartHandle);
        if (selection != null) {
            this.selectionRangeUpdate.invoke((Object)selection.toTextRange());
            return selection;
        }
        this.selectionRangeUpdate.invoke(null);
        return null;
    }

    @NotNull
    public Offset getHandlePosition(@NotNull Selection selection, boolean isStartHandle) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && !Intrinsics.areEqual((Object)selection.getStart().getSelectable(), (Object)this) || !isStartHandle && !Intrinsics.areEqual((Object)selection.getEnd().getSelectable(), (Object)this)) {
            return Offset.Companion.getZero();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getZero();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return TextSelectionDelegateKt.access$getSelectionHandleCoordinates(textLayoutResult2, isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset(), isStartHandle, selection.getHandlesCrossed());
    }

    @Nullable
    public LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @NotNull
    public AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getLayoutInput().getText();
    }

    @NotNull
    public Rect getBoundingBox(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getBoundingBox(RangesKt.coerceIn((int)offset, (int)0, (int)(textLayoutResult2.getLayoutInput().getText().getText().length() - 1)));
    }
}

