/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.selection;

import androidx.ui.core.selection.Selectable;
import androidx.ui.core.selection.Selection;
import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextRange;
import androidx.ui.text.selection.SelectionMode;
import androidx.ui.text.style.TextDirection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a0\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001ax\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u001a(\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002\u001aL\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001aD\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001aZ\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002\u001a4\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006&"}, d2={"ensureAtLeastOneChar", "Landroidx/ui/text/TextRange;", "offset", "", "lastOffset", "previousSelection", "Landroidx/ui/core/selection/Selection;", "isStartHandle", "", "getAssembledSelectionInfo", "startOffset", "endOffset", "handlesCrossed", "selectable", "Landroidx/ui/core/selection/Selectable;", "textLayoutResult", "Landroidx/ui/text/TextLayoutResult;", "getRefinedSelectionInfo", "rawStartOffset", "rawEndOffset", "containsWholeSelectionStart", "containsWholeSelectionEnd", "startPosition", "Landroidx/ui/geometry/Offset;", "endPosition", "bounds", "Landroidx/ui/geometry/Rect;", "wordBasedSelection", "getSelectionHandleCoordinates", "isStart", "areHandlesCrossed", "getTextSelectionInfo", "selectionCoordinates", "Lkotlin/Pair;", "processAsSingleComposable", "Lkotlin/Triple;", "processCrossComposable", "updateWordBasedSelection", "ui-text_release"})
public final class TextSelectionDelegateKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Selection getTextSelectionInfo(@NotNull TextLayoutResult textLayoutResult, @NotNull Pair<Offset, Offset> selectionCoordinates, @NotNull Selectable selectable, boolean wordBasedSelection, @Nullable Selection previousSelection, boolean isStartHandle) {
        long l;
        void y$iv;
        void x$iv;
        long l2;
        float y$iv2;
        void x$iv2;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        Intrinsics.checkNotNullParameter(selectionCoordinates, (String)"selectionCoordinates");
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"selectable");
        Offset startPosition = (Offset)selectionCoordinates.getFirst();
        Offset endPosition = (Offset)selectionCoordinates.getSecond();
        Rect bounds = new Rect(0.0f, 0.0f, (float)textLayoutResult.getSize().getWidth(), (float)textLayoutResult.getSize().getHeight());
        int lastOffset = textLayoutResult.getLayoutInput().getText().getText().length();
        float f = startPosition.getX();
        float f2 = startPosition.getY();
        Rect rect = bounds;
        boolean $i$f$Offset22 = false;
        boolean $i$f$packFloats = false;
        void var15_19 = x$iv2;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var15_19);
        void var19_25 = y$iv2;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits((float)var19_25);
        long l3 = l2 = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        Offset offset = new Offset(l3);
        boolean containsWholeSelectionStart = rect.contains(offset);
        y$iv2 = endPosition.getX();
        float $i$f$Offset22 = endPosition.getY();
        rect = bounds;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats2 = false;
        void var16_22 = x$iv;
        boolean bl3 = false;
        long v1$iv$iv2 = Float.floatToIntBits((float)var16_22);
        void var20_27 = y$iv;
        boolean bl4 = false;
        long v2$iv$iv2 = Float.floatToIntBits((float)var20_27);
        long l4 = l = v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL;
        offset = new Offset(l4);
        boolean containsWholeSelectionEnd = rect.contains(offset);
        int rawStartOffset = containsWholeSelectionStart ? RangesKt.coerceIn((int)textLayoutResult.getOffsetForPosition(startPosition), (int)0, (int)lastOffset) : -1;
        int rawEndOffset = containsWholeSelectionEnd ? RangesKt.coerceIn((int)textLayoutResult.getOffsetForPosition(endPosition), (int)0, (int)lastOffset) : -1;
        return TextSelectionDelegateKt.getRefinedSelectionInfo(rawStartOffset, rawEndOffset, containsWholeSelectionStart, containsWholeSelectionEnd, startPosition, endPosition, bounds, textLayoutResult, lastOffset, selectable, wordBasedSelection, previousSelection, isStartHandle);
    }

    public static /* synthetic */ Selection getTextSelectionInfo$default(TextLayoutResult textLayoutResult, Pair selectionCoordinates, Selectable selectable, boolean wordBasedSelection, Selection previousSelection, boolean isStartHandle, int n, Object object) {
        if ((n & 0x10) != 0) {
            previousSelection = null;
        }
        if ((n & 0x20) != 0) {
            isStartHandle = true;
        }
        return TextSelectionDelegateKt.getTextSelectionInfo(textLayoutResult, (Pair<Offset, Offset>)selectionCoordinates, selectable, wordBasedSelection, previousSelection, isStartHandle);
    }

    private static final Selection getRefinedSelectionInfo(int rawStartOffset, int rawEndOffset, boolean containsWholeSelectionStart, boolean containsWholeSelectionEnd, Offset startPosition, Offset endPosition, Rect bounds, TextLayoutResult textLayoutResult, int lastOffset, Selectable selectable, boolean wordBasedSelection, Selection previousSelection, boolean isStartHandle) {
        boolean shouldProcessAsSinglecomposable = containsWholeSelectionStart && containsWholeSelectionEnd;
        Triple<Integer, Integer, Boolean> triple = shouldProcessAsSinglecomposable ? TextSelectionDelegateKt.processAsSingleComposable(rawStartOffset, rawEndOffset, previousSelection, isStartHandle, lastOffset) : TextSelectionDelegateKt.processCrossComposable(startPosition, endPosition, rawStartOffset, rawEndOffset, lastOffset, bounds, containsWholeSelectionStart, containsWholeSelectionEnd);
        int startOffset = ((Number)triple.component1()).intValue();
        int endOffset = ((Number)triple.component2()).intValue();
        boolean handlesCrossed = (Boolean)triple.component3();
        if (startOffset == -1 && endOffset == -1) {
            return null;
        }
        if (wordBasedSelection) {
            Pair<Integer, Integer> pair = TextSelectionDelegateKt.updateWordBasedSelection(textLayoutResult, startOffset, endOffset, handlesCrossed);
            int start = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            startOffset = start;
            endOffset = end;
        }
        return TextSelectionDelegateKt.getAssembledSelectionInfo(startOffset, endOffset, handlesCrossed, selectable, textLayoutResult);
    }

    static /* synthetic */ Selection getRefinedSelectionInfo$default(int rawStartOffset, int rawEndOffset, boolean containsWholeSelectionStart, boolean containsWholeSelectionEnd, Offset startPosition, Offset endPosition, Rect bounds, TextLayoutResult textLayoutResult, int lastOffset, Selectable selectable, boolean wordBasedSelection, Selection previousSelection, boolean isStartHandle, int n, Object object) {
        if ((n & 0x800) != 0) {
            previousSelection = null;
        }
        if ((n & 0x1000) != 0) {
            isStartHandle = true;
        }
        return TextSelectionDelegateKt.getRefinedSelectionInfo(rawStartOffset, rawEndOffset, containsWholeSelectionStart, containsWholeSelectionEnd, startPosition, endPosition, bounds, textLayoutResult, lastOffset, selectable, wordBasedSelection, previousSelection, isStartHandle);
    }

    private static final Selection getAssembledSelectionInfo(int startOffset, int endOffset, boolean handlesCrossed, Selectable selectable, TextLayoutResult textLayoutResult) {
        int n = endOffset - 1;
        int n2 = 0;
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        Selection.AnchorInfo anchorInfo = new Selection.AnchorInfo(textLayoutResult.getBidiRunDirection(startOffset), startOffset, selectable);
        boolean bl = false;
        int n3 = Math.max(n, n2);
        Selectable selectable2 = selectable;
        int n4 = endOffset;
        TextDirection textDirection = textLayoutResult2.getBidiRunDirection(n3);
        boolean bl2 = handlesCrossed;
        Selection.AnchorInfo anchorInfo2 = new Selection.AnchorInfo(textDirection, n4, selectable2);
        Selection.AnchorInfo anchorInfo3 = anchorInfo;
        return new Selection(anchorInfo3, anchorInfo2, bl2);
    }

    private static final Triple<Integer, Integer, Boolean> processAsSingleComposable(int rawStartOffset, int rawEndOffset, Selection previousSelection, boolean isStartHandle, int lastOffset) {
        int startOffset = rawStartOffset;
        int endOffset = rawEndOffset;
        if (startOffset == endOffset) {
            TextRange textRange = TextSelectionDelegateKt.ensureAtLeastOneChar(rawStartOffset, lastOffset, previousSelection, isStartHandle);
            startOffset = textRange.getStart();
            endOffset = textRange.getEnd();
        }
        boolean areHandlesCrossed = startOffset > endOffset;
        return new Triple((Object)startOffset, (Object)endOffset, (Object)areHandlesCrossed);
    }

    private static final Triple<Integer, Integer, Boolean> processCrossComposable(Offset startPosition, Offset endPosition, int rawStartOffset, int rawEndOffset, int lastOffset, Rect bounds, boolean containsWholeSelectionStart, boolean containsWholeSelectionEnd) {
        int n;
        int startOffset;
        int n2;
        int n3;
        boolean handlesCrossed = SelectionMode.Vertical.areHandlesCrossed$ui_text_release(bounds, startPosition, endPosition);
        boolean isSelected = SelectionMode.Vertical.isSelected$ui_text_release(bounds, handlesCrossed ? endPosition : startPosition, handlesCrossed ? startPosition : endPosition);
        if (isSelected && !containsWholeSelectionStart) {
            if (handlesCrossed) {
                int n4 = 0;
                n3 = 0;
                n2 = Math.max(lastOffset, n4);
            } else {
                n2 = 0;
            }
        } else {
            n2 = startOffset = rawStartOffset;
        }
        if (isSelected && !containsWholeSelectionEnd) {
            if (handlesCrossed) {
                n = 0;
            } else {
                n3 = 0;
                boolean bl = false;
                n = Math.max(lastOffset, n3);
            }
        } else {
            n = rawEndOffset;
        }
        int endOffset = n;
        return new Triple((Object)startOffset, (Object)endOffset, (Object)handlesCrossed);
    }

    private static final Pair<Integer, Integer> updateWordBasedSelection(TextLayoutResult textLayoutResult, int startOffset, int endOffset, boolean handlesCrossed) {
        int maxOffset = textLayoutResult.getLayoutInput().getText().getText().length() - 1;
        TextRange startWordBoundary = textLayoutResult.getWordBoundary(RangesKt.coerceIn((int)startOffset, (int)0, (int)maxOffset));
        TextRange endWordBoundary = textLayoutResult.getWordBoundary(RangesKt.coerceIn((int)endOffset, (int)0, (int)maxOffset));
        int start = handlesCrossed ? startWordBoundary.getEnd() : startWordBoundary.getStart();
        int end = handlesCrossed ? endWordBoundary.getStart() : endWordBoundary.getEnd();
        return new Pair((Object)start, (Object)end);
    }

    private static final TextRange ensureAtLeastOneChar(int offset, int lastOffset, Selection previousSelection, boolean isStartHandle) {
        Ref.IntRef newStartOffset = new Ref.IntRef();
        newStartOffset.element = offset;
        Ref.IntRef newEndOffset = new Ref.IntRef();
        newEndOffset.element = offset;
        Selection selection = previousSelection;
        if (selection != null) {
            Selection selection2 = selection;
            boolean bl = false;
            boolean bl2 = false;
            Selection it = selection2;
            boolean bl3 = false;
            if (isStartHandle) {
                newStartOffset.element = it.getHandlesCrossed() ? (newEndOffset.element == 0 || it.getStart().getOffset() == newEndOffset.element + 1 ? newEndOffset.element + 1 : newEndOffset.element - 1) : (newEndOffset.element == lastOffset || it.getStart().getOffset() == newEndOffset.element - 1 ? newEndOffset.element - 1 : newEndOffset.element + 1);
            } else {
                newEndOffset.element = it.getHandlesCrossed() ? (newStartOffset.element == lastOffset || it.getEnd().getOffset() == newStartOffset.element - 1 ? newStartOffset.element - 1 : newStartOffset.element + 1) : (newStartOffset.element == 0 || it.getEnd().getOffset() == newStartOffset.element + 1 ? newStartOffset.element + 1 : newStartOffset.element - 1);
            }
        }
        return new TextRange(newStartOffset.element, newEndOffset.element);
    }

    private static final Offset getSelectionHandleCoordinates(TextLayoutResult textLayoutResult, int offset, boolean isStart, boolean areHandlesCrossed) {
        long l;
        int n;
        int line = textLayoutResult.getLineForOffset(offset);
        if (isStart && !areHandlesCrossed || !isStart && areHandlesCrossed) {
            n = offset;
        } else {
            int n2 = offset - 1;
            int n3 = 0;
            boolean bl = false;
            n = Math.max(n2, n3);
        }
        int offsetToCheck = n;
        TextDirection bidiRunDirection = textLayoutResult.getBidiRunDirection(offsetToCheck);
        TextDirection paragraphDirection = textLayoutResult.getParagraphDirection(offset);
        float x = textLayoutResult.getHorizontalPosition(offset, Intrinsics.areEqual((Object)bidiRunDirection, (Object)paragraphDirection));
        float y = textLayoutResult.getLineBottom(line);
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f);
        float f2 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new Offset(l2);
    }

    public static final /* synthetic */ Offset access$getSelectionHandleCoordinates(TextLayoutResult textLayoutResult, int n, boolean bl, boolean bl2) {
        return TextSelectionDelegateKt.getSelectionHandleCoordinates(textLayoutResult, n, bl, bl2);
    }
}

