/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.tooling.preview;

import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxBounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\nJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001e\u001a\u00020\u001cJ\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006!"}, d2={"Landroidx/ui/tooling/preview/ViewInfo;", "", "fileName", "", "lineNumber", "", "methodName", "bounds", "Landroidx/ui/unit/IntPxBounds;", "children", "", "getBounds", "()Landroidx/ui/unit/IntPxBounds;", "getChildren", "()Ljava/util/List;", "getFileName", "()Ljava/lang/String;", "getLineNumber", "()I", "getMethodName", "allChildren", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hasBounds", "hashCode", "toString", "ui-tooling_release"})
public final class ViewInfo {
    private final String fileName;
    private final int lineNumber;
    private final String methodName;
    private final IntPxBounds bounds;
    private final List<ViewInfo> children;

    public ViewInfo(@NotNull String fileName, int lineNumber, @NotNull String methodName, @NotNull IntPxBounds bounds, @NotNull List<ViewInfo> children) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.methodName = methodName;
        this.bounds = bounds;
        this.children = children;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @NotNull
    public final IntPxBounds getBounds() {
        return this.bounds;
    }

    @NotNull
    public final List<ViewInfo> getChildren() {
        return this.children;
    }

    public final boolean hasBounds() {
        return !IntPx.equals-impl0((int)this.getBounds().getBottom(), (int)IntPx.Companion.getZero()) && !IntPx.equals-impl0((int)this.getBounds().getRight(), (int)IntPx.Companion.getZero());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ViewInfo> allChildren() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.getChildren();
        Collection collection = this.getChildren();
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ViewInfo it = (ViewInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.allChildren();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimMargin$default((String)("(" + this.getFileName() + ":" + this.getLineNumber() + ",\n            |bounds=(top=" + this.getBounds().getTop() + ", left=" + this.getBounds().getLeft() + ",\n            |bottom=" + this.getBounds().getBottom() + ", right=" + this.getBounds().getRight() + "),\n            |childrenCount=" + this.getChildren().size() + ")"), null, (int)1, null);
    }

    @NotNull
    public final String component1() {
        return this.fileName;
    }

    public final int component2() {
        return this.lineNumber;
    }

    @NotNull
    public final String component3() {
        return this.methodName;
    }

    @NotNull
    public final IntPxBounds component4() {
        return this.bounds;
    }

    @NotNull
    public final List<ViewInfo> component5() {
        return this.children;
    }

    @NotNull
    public final ViewInfo copy(@NotNull String fileName, int lineNumber, @NotNull String methodName, @NotNull IntPxBounds bounds, @NotNull List<ViewInfo> children) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new ViewInfo(fileName, lineNumber, methodName, bounds, children);
    }

    public static /* synthetic */ ViewInfo copy$default(ViewInfo this_, String fileName, int lineNumber, String methodName, IntPxBounds bounds, List children, int n, Object object) {
        if ((n & 1) != 0) {
            fileName = this_.fileName;
        }
        if ((n & 2) != 0) {
            lineNumber = this_.lineNumber;
        }
        if ((n & 4) != 0) {
            methodName = this_.methodName;
        }
        if ((n & 8) != 0) {
            bounds = this_.bounds;
        }
        if ((n & 0x10) != 0) {
            children = this_.children;
        }
        return this_.copy(fileName, lineNumber, methodName, bounds, children);
    }

    public int hashCode() {
        return (((this.fileName.hashCode() * 31 + Integer.hashCode(this.lineNumber)) * 31 + this.methodName.hashCode()) * 31 + this.bounds.hashCode()) * 31 + ((Object)this.children).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ViewInfo)) {
            return false;
        }
        Object object = other;
        ViewInfo viewInfo = (ViewInfo)object;
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)viewInfo.fileName)) {
            return false;
        }
        if (this.lineNumber != viewInfo.lineNumber) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)viewInfo.methodName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bounds, (Object)viewInfo.bounds)) {
            return false;
        }
        return Intrinsics.areEqual(this.children, viewInfo.children);
    }
}

