/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.tooling.inspector;

import android.content.Context;
import android.view.View;
import androidx.compose.runtime.SlotTable;
import androidx.compose.ui.unit.AndroidDensityKt;
import androidx.compose.ui.unit.IntBounds;
import androidx.ui.tooling.Group;
import androidx.ui.tooling.ParameterInformation;
import androidx.ui.tooling.R;
import androidx.ui.tooling.SlotTreeKt;
import androidx.ui.tooling.SourceLocation;
import androidx.ui.tooling.inspector.InlineClassConverter;
import androidx.ui.tooling.inspector.InspectorNode;
import androidx.ui.tooling.inspector.LayoutInspectorTree;
import androidx.ui.tooling.inspector.LayoutInspectorTree$getRenderNode$;
import androidx.ui.tooling.inspector.LayoutInspectorTreeKt;
import androidx.ui.tooling.inspector.MutableInspectorNode;
import androidx.ui.tooling.inspector.NodeParameter;
import androidx.ui.tooling.inspector.ParameterFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0000J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u001e\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J4\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u0010\u0010+\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/ui/tooling/inspector/LayoutInspectorTree;", "", "cache", "Ljava/util/ArrayDeque;", "Landroidx/ui/tooling/inspector/MutableInspectorNode;", "generatedId", "", "inlineClassConverter", "Landroidx/ui/tooling/inspector/InlineClassConverter;", "parameterFactory", "Landroidx/ui/tooling/inspector/ParameterFactory;", "addParameter", "", "parameter", "Landroidx/ui/tooling/ParameterInformation;", "node", "addParameters", "parameters", "", "buildToList", "Landroidx/ui/tooling/inspector/InspectorNode;", "parentNode", "input", "result", "", "castValue", "clear", "convert", "view", "Landroid/view/View;", "group", "Landroidx/ui/tooling/Group;", "tables", "", "Landroidx/compose/runtime/SlotTable;", "convertChildren", "getRenderNode", "markUnwanted", "newNode", "parse", "parseCallLocation", "", "release", "unwantedGroup", "ui-tooling_release"})
public final class LayoutInspectorTree {
    private final InlineClassConverter inlineClassConverter = new InlineClassConverter();
    private final ParameterFactory parameterFactory = new ParameterFactory();
    private final ArrayDeque<MutableInspectorNode> cache = new ArrayDeque();
    private long generatedId = -1L;

    @NotNull
    public final List<InspectorNode> convert(@NotNull View view) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        this.parameterFactory.setDensity(AndroidDensityKt.Density((Context)context));
        Object object = view.getTag(R.id.inspection_slot_table_set);
        Set set2 = set = object instanceof Set ? (Set)object : null;
        if (set == null) {
            return CollectionsKt.emptyList();
        }
        Set tables = set;
        this.clear();
        List<InspectorNode> result = this.convert(tables);
        this.clear();
        return result;
    }

    private final void clear() {
        this.cache.clear();
        this.inlineClassConverter.clear();
        this.generatedId = -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final List<InspectorNode> convert(Set<SlotTable> tables) {
        Collection<MutableInspectorNode> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = tables;
        MutableInspectorNode mutableInspectorNode = null;
        LayoutInspectorTree layoutInspectorTree = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SlotTable slotTable = (SlotTable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            MutableInspectorNode mutableInspectorNode2 = this.convert(SlotTreeKt.asTree((SlotTable)it));
            collection.add(mutableInspectorNode2);
        }
        collection = (List)destination$iv$iv;
        boolean bl = false;
        return layoutInspectorTree.buildToList(mutableInspectorNode, (List<MutableInspectorNode>)collection, new ArrayList());
    }

    private final MutableInspectorNode convert(Group group) {
        List<MutableInspectorNode> children = this.convertChildren(group);
        MutableInspectorNode node = this.parse(group);
        this.buildToList(node, children, node.getChildren());
        return node;
    }

    private final List<MutableInspectorNode> convertChildren(Group group) {
        if (group.getChildren().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List result = new ArrayList();
        for (Group child : group.getChildren()) {
            MutableInspectorNode node;
            block6: {
                block5: {
                    node = this.convert(child);
                    Object object = node.getName();
                    boolean bl2 = false;
                    if (object.length() > 0) break block5;
                    object = node.getChildren();
                    bl2 = false;
                    if (!(!object.isEmpty()) && node.getId() == 0L) break block6;
                }
                result.add(node);
                continue;
            }
            this.release(node);
        }
        return result;
    }

    private final List<InspectorNode> buildToList(MutableInspectorNode parentNode, List<MutableInspectorNode> input, List<InspectorNode> result) {
        Long id2 = null;
        Iterable $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableInspectorNode it = (MutableInspectorNode)element$iv;
            boolean bl = false;
            Object object = it.getName();
            boolean bl2 = false;
            if (object.length() == 0) {
                result.addAll((Collection<InspectorNode>)it.getChildren());
                if (it.getId() != 0L) {
                    id2 = id2 == null ? Long.valueOf(it.getId()) : Long.valueOf(0L);
                }
            } else {
                long l;
                if (it.getId() != 0L) {
                    l = it.getId();
                } else {
                    object = this;
                    ((LayoutInspectorTree)object).generatedId += -1L;
                    l = ((LayoutInspectorTree)object).generatedId;
                }
                it.setId(l);
                result.add(it.build());
            }
            this.release(it);
        }
        MutableInspectorNode mutableInspectorNode = parentNode;
        Long l = mutableInspectorNode == null ? (Long)null : Long.valueOf(mutableInspectorNode.getId());
        if (l != null && l == 0L && (mutableInspectorNode = id2) != null) {
            MutableInspectorNode mutableInspectorNode2 = mutableInspectorNode;
            boolean bl = false;
            boolean bl3 = false;
            long it = ((Number)((Object)mutableInspectorNode2)).longValue();
            boolean bl4 = false;
            parentNode.setId(it);
        }
        return result;
    }

    private final MutableInspectorNode parse(Group group) {
        boolean bl;
        CharSequence charSequence;
        MutableInspectorNode node = this.newNode();
        node.setId(this.getRenderNode(group));
        if (!this.parseCallLocation(group, node)) {
            charSequence = group.getName();
            boolean bl2 = false;
            bl = false;
            if (charSequence == null || charSequence.length() == 0) {
                return this.markUnwanted(node);
            }
        }
        if ((charSequence = group.getName()) != null) {
            CharSequence charSequence2 = charSequence;
            bl = false;
            boolean bl3 = false;
            CharSequence it = charSequence2;
            boolean bl4 = false;
            node.setName((String)it);
        }
        if (this.unwantedGroup(node)) {
            return this.markUnwanted(node);
        }
        IntBounds box = group.getBox();
        node.setTop(box.getTop());
        node.setLeft(box.getLeft());
        node.setHeight(box.getBottom() - box.getTop());
        node.setWidth(box.getRight() - box.getLeft());
        if (node.getHeight() <= 0 || node.getWidth() <= 0) {
            return this.markUnwanted(node);
        }
        this.addParameters(group.getParameters(), node);
        return node;
    }

    private final MutableInspectorNode markUnwanted(MutableInspectorNode node) {
        node.resetExceptIdAndChildren();
        return node;
    }

    private final boolean parseCallLocation(Group group, MutableInspectorNode node) {
        SourceLocation sourceLocation = group.getLocation();
        if (sourceLocation == null) {
            return false;
        }
        SourceLocation location = sourceLocation;
        String string = location.getSourceFile();
        if (string == null) {
            return false;
        }
        String fileName = string;
        node.setFileName(fileName);
        node.setPackageHash(location.getPackageHash());
        node.setLineNumber(location.getLineNumber());
        node.setOffset(location.getOffset());
        node.setLength(location.getLength());
        return true;
    }

    private final long getRenderNode(Group group) {
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)group.getModifierInfo()), (Function1)getRenderNode.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getRenderNode$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Long l = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)sequence, (Function1)getRenderNode.2.INSTANCE));
        return l == null ? 0L : l;
    }

    private final void addParameters(List<ParameterInformation> parameters, MutableInspectorNode node) {
        Iterable $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParameterInformation it = (ParameterInformation)element$iv;
            boolean bl = false;
            this.addParameter(it, node);
        }
    }

    private final void addParameter(ParameterInformation parameter, MutableInspectorNode node) {
        Object object = this.castValue(parameter);
        if (object == null) {
            return;
        }
        Object castedValue = object;
        object = this.parameterFactory.create(node, parameter.getName(), castedValue);
        if (object == null) {
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            node.getParameters().add((NodeParameter)it);
        }
    }

    private final Object castValue(ParameterInformation parameter) {
        Object object = parameter.getValue();
        if (object == null) {
            return null;
        }
        Object value = object;
        if (parameter.getInlineClass() == null) {
            return value;
        }
        return this.inlineClassConverter.castParameterValue(parameter.getInlineClass(), value);
    }

    private final boolean unwantedGroup(MutableInspectorNode node) {
        return LayoutInspectorTreeKt.access$getUnwantedPackages$p$s-901057836().contains(node.getPackageHash()) && LayoutInspectorTreeKt.access$getUnwantedCalls$p$s-901057836().contains(node.getName());
    }

    private final MutableInspectorNode newNode() {
        Object object;
        Object object2 = this.cache;
        boolean bl = false;
        if (!object2.isEmpty()) {
            object2 = this.cache.pop();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"cache.pop()");
            object = object2;
        } else {
            object = new MutableInspectorNode();
        }
        return object;
    }

    private final void release(MutableInspectorNode node) {
        node.reset();
        this.cache.add(node);
    }
}

