/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.tooling.inspector;

import androidx.compose.foundation.BorderStroke;
import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.foundation.shape.CornerBasedShape;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.ui.AbsoluteAlignment;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.platform.InspectableParameter;
import androidx.compose.ui.platform.ParameterElement;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontListFontFamily;
import androidx.compose.ui.text.font.FontWeight;
import androidx.compose.ui.text.font.ResourceFont;
import androidx.compose.ui.text.intl.Locale;
import androidx.compose.ui.text.intl.LocaleList;
import androidx.compose.ui.text.style.BaselineShift;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextGeometricTransform;
import androidx.compose.ui.text.style.TextIndent;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitType;
import androidx.ui.tooling.inspector.MutableInspectorNode;
import androidx.ui.tooling.inspector.NodeParameter;
import androidx.ui.tooling.inspector.ParameterFactory$findBestResourceFont$;
import androidx.ui.tooling.inspector.ParameterType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0000J\u001c\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00012\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020#H\u0002J\"\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020%H\u0002J\"\u0010&\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020'H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)J \u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020+H\u0002J \u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020-H\u0002J \u0010.\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020/H\u0002J \u00100\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u000201H\u0002J \u00102\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u000203H\u0002J$\u00104\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u000205H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u0010)J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\f\u001a\u00020!H\u0002J\u001c\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00012\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010=\u001a\u00020:2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006?"}, d2={"Landroidx/ui/tooling/inspector/ParameterFactory;", "", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "setDensity", "(Landroidx/compose/ui/unit/Density;)V", "valueLookup", "", "", "classNameOf", "value", "default", "Ljava/lang/Class;", "create", "Landroidx/ui/tooling/inspector/NodeParameter;", "node", "Landroidx/ui/tooling/inspector/MutableInspectorNode;", "name", "createFromBaselineShift", "Landroidx/compose/ui/text/style/BaselineShift;", "createFromBaselineShift-AZcAi8c", "(Ljava/lang/String;F)Landroidx/ui/tooling/inspector/NodeParameter;", "createFromBorder", "Landroidx/compose/foundation/BorderStroke;", "createFromBrush", "Landroidx/compose/ui/graphics/Brush;", "createFromCornerBasedShape", "Landroidx/compose/foundation/shape/CornerBasedShape;", "createFromCornerSize", "Landroidx/compose/foundation/shape/CornerSize;", "createFromFontListFamily", "Landroidx/compose/ui/text/font/FontListFontFamily;", "createFromInspectableParameter", "Landroidx/compose/ui/platform/InspectableParameter;", "createFromModifier", "Landroidx/compose/ui/Modifier;", "createFromOffset", "Landroidx/compose/ui/geometry/Offset;", "createFromOffset-IraYFvE", "(Ljava/lang/String;J)Landroidx/ui/tooling/inspector/NodeParameter;", "createFromPaddingValues", "Landroidx/compose/foundation/layout/PaddingValues;", "createFromShadow", "Landroidx/compose/ui/graphics/Shadow;", "createFromTextGeometricTransform", "Landroidx/compose/ui/text/style/TextGeometricTransform;", "createFromTextIndent", "Landroidx/compose/ui/text/style/TextIndent;", "createFromTextStyle", "Landroidx/compose/ui/text/TextStyle;", "createFromTextUnit", "Landroidx/compose/ui/unit/TextUnit;", "createFromTextUnit-esivXXI", "findBestResourceFont", "Landroidx/compose/ui/text/font/ResourceFont;", "loadFromCompanion", "", "companionInstance", "ignore", "loadFromInterface", "interfaceClass", "ui-tooling_release"})
public final class ParameterFactory {
    private final Map<Object, String> valueLookup;
    private Density density;

    public ParameterFactory() {
        boolean bl = false;
        this.valueLookup = new LinkedHashMap();
        this.density = DensityKt.Density$default((float)1.0f, (float)0.0f, (int)2, null);
        ParameterFactory.loadFromCompanion$default(this, AbsoluteAlignment.Companion, null, 2, null);
        ParameterFactory.loadFromCompanion$default(this, Alignment.Companion, null, 2, null);
        this.loadFromInterface(Arrangement.class);
        ParameterFactory.loadFromCompanion$default(this, FontFamily.Companion, null, 2, null);
        this.loadFromCompanion(FontWeight.Companion, "getW");
        ParameterFactory.loadFromCompanion$default(this, Shadow.Companion, null, 2, null);
        ParameterFactory.loadFromCompanion$default(this, TextDecoration.Companion, null, 2, null);
        ParameterFactory.loadFromCompanion$default(this, TextIndent.Companion, null, 2, null);
        Map<Object, String> map = this.valueLookup;
        Color color = Color.box-impl((long)Color.Companion.getUnset-0d7_KjU());
        String string = "Unset";
        boolean bl2 = false;
        map.put(color, string);
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    public final void setDensity(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"<set-?>");
        this.density = density;
    }

    @Nullable
    public final NodeParameter create(@NotNull MutableInspectorNode node, @NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return null;
        }
        String text = this.valueLookup.get(value);
        if (text != null) {
            return new NodeParameter(name, ParameterType.String, text);
        }
        Object object = value;
        return object instanceof AnnotatedString ? new NodeParameter(name, ParameterType.String, ((AnnotatedString)value).getText()) : (object instanceof BaselineShift ? this.createFromBaselineShift-AZcAi8c(name, ((BaselineShift)value).unbox-impl()) : (object instanceof Boolean ? new NodeParameter(name, ParameterType.Boolean, value) : (object instanceof BorderStroke ? this.createFromBorder(node, name, (BorderStroke)value) : (object instanceof Brush ? this.createFromBrush(name, (Brush)value) : (object instanceof Color ? new NodeParameter(name, ParameterType.Color, ColorKt.toArgb-8_81llA((long)((Color)value).unbox-impl())) : (object instanceof CornerBasedShape ? this.createFromCornerBasedShape(node, name, (CornerBasedShape)value) : (object instanceof CornerSize ? this.createFromCornerSize(node, name, (CornerSize)value) : (object instanceof Double ? new NodeParameter(name, ParameterType.Double, value) : (object instanceof Dp ? new NodeParameter(name, ParameterType.DimensionDp, Float.valueOf(((Dp)value).unbox-impl())) : (object instanceof Enum ? new NodeParameter(name, ParameterType.String, value.toString()) : (object instanceof Float ? new NodeParameter(name, ParameterType.Float, value) : (object instanceof FontListFontFamily ? this.createFromFontListFamily(name, (FontListFontFamily)value) : (object instanceof FontWeight ? new NodeParameter(name, ParameterType.Int32, ((FontWeight)value).getWeight()) : (object instanceof PaddingValues ? this.createFromPaddingValues(node, name, (PaddingValues)value) : (object instanceof androidx.compose.ui.Modifier ? this.createFromModifier(node, name, (androidx.compose.ui.Modifier)value) : (object instanceof InspectableParameter ? this.createFromInspectableParameter(node, name, (InspectableParameter)value) : (object instanceof Integer ? new NodeParameter(name, ParameterType.Int32, value) : (object instanceof Locale ? new NodeParameter(name, ParameterType.String, value.toString()) : (object instanceof LocaleList ? new NodeParameter(name, ParameterType.String, CollectionsKt.joinToString$default((Iterable)((LocaleList)value).getLocaleList(), null, null, null, (int)0, null, null, (int)63, null)) : (object instanceof Long ? new NodeParameter(name, ParameterType.Int64, value) : (object instanceof Offset ? this.createFromOffset-IraYFvE(name, ((Offset)value).unbox-impl()) : (object instanceof Shadow ? this.createFromShadow(node, name, (Shadow)value) : (object instanceof Shape ? new NodeParameter(name, ParameterType.String, Shape.class.getSimpleName()) : (object instanceof String ? new NodeParameter(name, ParameterType.String, value) : (object instanceof TextGeometricTransform ? this.createFromTextGeometricTransform(node, name, (TextGeometricTransform)value) : (object instanceof TextIndent ? this.createFromTextIndent(node, name, (TextIndent)value) : (object instanceof TextStyle ? this.createFromTextStyle(node, name, (TextStyle)value) : (object instanceof TextUnit ? this.createFromTextUnit-esivXXI(name, ((TextUnit)value).unbox-impl()) : (NodeParameter)null))))))))))))))))))))))))))));
    }

    private final NodeParameter createFromBaselineShift-AZcAi8c(String name, float value) {
        String string;
        float f = value;
        if (f == BaselineShift.Companion.getNone-y9eOQZs()) {
            string = "None";
        } else if (f == BaselineShift.Companion.getSubscript-y9eOQZs()) {
            string = "Subscript";
        } else if (f == BaselineShift.Companion.getSuperscript-y9eOQZs()) {
            string = "Superscript";
        } else {
            return new NodeParameter(name, ParameterType.Float, Float.valueOf(value));
        }
        String converted = string;
        return new NodeParameter(name, ParameterType.String, converted);
    }

    private final NodeParameter createFromBorder(MutableInspectorNode node, String name, BorderStroke value) {
        NodeParameter it;
        boolean bl;
        boolean bl2;
        NodeParameter nodeParameter;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, "BorderStroke");
        List<NodeParameter> elements = parameter.getElements();
        NodeParameter nodeParameter2 = this.create(node, "width", Dp.box-impl((float)value.getWidth-D9Ej5fM()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl3 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "brush", value.getBrush());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl4 = false;
            elements.add(it);
        }
        return parameter;
    }

    private final NodeParameter createFromBrush(String name, Brush value) {
        Brush brush = value;
        return brush instanceof SolidColor ? new NodeParameter(name, ParameterType.Color, ColorKt.toArgb-8_81llA((long)((SolidColor)value).getValue-0d7_KjU())) : new NodeParameter(name, ParameterType.String, this.classNameOf(value, Brush.class));
    }

    private final NodeParameter createFromCornerBasedShape(MutableInspectorNode node, String name, CornerBasedShape value) {
        NodeParameter it;
        boolean bl;
        boolean bl2;
        NodeParameter nodeParameter;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, this.classNameOf(value, CornerBasedShape.class));
        List<NodeParameter> elements = parameter.getElements();
        NodeParameter nodeParameter2 = this.create(node, "topLeft", value.getTopLeft());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl3 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "topRight", value.getTopRight());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl4 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "bottomLeft", value.getBottomLeft());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl5 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "bottomRight", value.getBottomRight());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl6 = false;
            elements.add(it);
        }
        return parameter;
    }

    /*
     * WARNING - void declaration
     */
    private final NodeParameter createFromCornerSize(MutableInspectorNode node, String name, CornerSize value) {
        void $this$createFromCornerSize_u24lambda_u2d6;
        Float f;
        long size = SizeKt.Size((float)node.getWidth(), (float)node.getHeight());
        float pixels = value.toPx-lwCvPpU(size, this.density);
        Density density = this.density;
        boolean bl = false;
        boolean bl2 = false;
        Density density2 = density;
        ParameterType parameterType = ParameterType.DimensionDp;
        String string = name;
        boolean bl3 = false;
        Float f2 = f = Float.valueOf($this$createFromCornerSize_u24lambda_u2d6.toDp-D9Ej5fM(pixels));
        ParameterType parameterType2 = parameterType;
        String string2 = string;
        return new NodeParameter(string2, parameterType2, f2);
    }

    private final NodeParameter createFromFontListFamily(String name, FontListFontFamily value) {
        ResourceFont resourceFont = this.findBestResourceFont(value);
        if (resourceFont != null) {
            ResourceFont resourceFont2 = resourceFont;
            boolean bl = false;
            boolean bl2 = false;
            ResourceFont it = resourceFont2;
            boolean bl3 = false;
            return new NodeParameter(name, ParameterType.Resource, it.getResId());
        }
        return null;
    }

    private final NodeParameter createFromPaddingValues(MutableInspectorNode node, String name, PaddingValues value) {
        NodeParameter it;
        boolean bl;
        boolean bl2;
        NodeParameter nodeParameter;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, "PaddingValues");
        List<NodeParameter> elements = parameter.getElements();
        NodeParameter nodeParameter2 = this.create(node, "start", Dp.box-impl((float)value.getStart-D9Ej5fM()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl3 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "end", Dp.box-impl((float)value.getEnd-D9Ej5fM()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl4 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "top", Dp.box-impl((float)value.getTop-D9Ej5fM()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl5 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "bottom", Dp.box-impl((float)value.getBottom-D9Ej5fM()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl6 = false;
            elements.add(it);
        }
        return parameter;
    }

    private final NodeParameter createFromInspectableParameter(MutableInspectorNode node, String name, InspectableParameter value) {
        CharSequence charSequence;
        Object object = value.getValueOverride();
        Object tempValue = object == null ? "" : object;
        CharSequence charSequence2 = name;
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            charSequence = value.getNameFallback();
        } else {
            charSequence = charSequence2;
        }
        String string = (String)charSequence;
        String parameterName = string == null ? "element" : string;
        Object parameterValue = tempValue instanceof InspectableParameter ? "" : tempValue;
        NodeParameter nodeParameter = this.create(node, parameterName, parameterValue);
        NodeParameter parameter = nodeParameter == null ? new NodeParameter(parameterName, ParameterType.String, "") : nodeParameter;
        List<NodeParameter> elements = parameter.getElements();
        Sequence $this$mapNotNullTo$iv = value.getInspectableElements();
        boolean $i$f$mapNotNullTo = false;
        Sequence $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            NodeParameter nodeParameter2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl4 = false;
            ParameterElement it = (ParameterElement)element$iv;
            boolean bl5 = false;
            if (this.create(node, it.getName(), it.getValue()) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            NodeParameter it$iv = nodeParameter2;
            boolean bl8 = false;
            ((Collection)elements).add(it$iv);
        }
        return parameter;
    }

    private final NodeParameter createFromModifier(MutableInspectorNode node, String name, androidx.compose.ui.Modifier value) {
        NodeParameter nodeParameter;
        CharSequence charSequence = name;
        boolean bl = false;
        if (charSequence.length() > 0) {
            NodeParameter parameter = new NodeParameter(name, ParameterType.String, "");
            List<NodeParameter> elements = parameter.getElements();
            value.foldIn(elements, (Function2)new Function2<List<NodeParameter>, Modifier.Element, List<NodeParameter>>(this, node){
                private final /* synthetic */ ParameterFactory $this;
                private final /* synthetic */ MutableInspectorNode $node;
                {
                    this.$this = $receiver;
                    this.$node = $node;
                    super(2);
                }

                @NotNull
                public final List<NodeParameter> invoke(@NotNull List<NodeParameter> acc, @NotNull Modifier.Element m) {
                    List<NodeParameter> list;
                    Intrinsics.checkNotNullParameter(acc, (String)"acc");
                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                    NodeParameter nodeParameter = this.$this.create(this.$node, "", m);
                    if (nodeParameter == null) {
                        list = acc;
                    } else {
                        List<NodeParameter> list2;
                        NodeParameter nodeParameter2 = nodeParameter;
                        boolean bl = false;
                        boolean bl2 = false;
                        NodeParameter param = nodeParameter2;
                        boolean bl3 = false;
                        List<NodeParameter> list3 = acc;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        List<NodeParameter> $this$invoke_u24lambda_u2d1_u24lambda_u2d0 = list3;
                        boolean bl6 = false;
                        $this$invoke_u24lambda_u2d1_u24lambda_u2d0.add(param);
                        list = list2 = list3;
                    }
                    return list;
                }
            });
            nodeParameter = parameter;
        } else {
            nodeParameter = value instanceof InspectableParameter ? this.createFromInspectableParameter(node, name, (InspectableParameter)value) : (NodeParameter)null;
        }
        return nodeParameter;
    }

    /*
     * WARNING - void declaration
     */
    private final NodeParameter createFromOffset-IraYFvE(String name, long value) {
        void $this$createFromOffset_IraYFvE_u24lambda_u2d15;
        Density $this$createFromOffset_IraYFvE_u24lambda_u2d14;
        Float f;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, Offset.class.getSimpleName());
        List<NodeParameter> elements = parameter.getElements();
        Density density = this.density;
        boolean bl = false;
        boolean bl2 = false;
        Density density2 = density;
        ParameterType parameterType = ParameterType.DimensionDp;
        String string = "x";
        List<NodeParameter> list = elements;
        boolean bl3 = false;
        Float f2 = f = Float.valueOf($this$createFromOffset_IraYFvE_u24lambda_u2d14.toDp-D9Ej5fM(Offset.getX-impl((long)value)));
        ParameterType parameterType2 = parameterType;
        String string2 = string;
        list.add(new NodeParameter(string2, parameterType2, f2));
        density = this.density;
        bl = false;
        bl2 = false;
        $this$createFromOffset_IraYFvE_u24lambda_u2d14 = density;
        parameterType = ParameterType.DimensionDp;
        string = "y";
        list = elements;
        boolean bl4 = false;
        Float f3 = f = Float.valueOf($this$createFromOffset_IraYFvE_u24lambda_u2d15.toDp-D9Ej5fM(Offset.getY-impl((long)value)));
        ParameterType parameterType3 = parameterType;
        String string3 = string;
        list.add(new NodeParameter(string3, parameterType3, f3));
        return parameter;
    }

    private final NodeParameter createFromShadow(MutableInspectorNode node, String name, Shadow value) {
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, Shadow.class.getSimpleName());
        List<NodeParameter> elements = parameter.getElements();
        Object object = this.density;
        boolean bl = false;
        boolean bl2 = false;
        Density $this$createFromShadow_u24lambda_u2d16 = object;
        boolean bl3 = false;
        float blurRadius = $this$createFromShadow_u24lambda_u2d16.toDp-D9Ej5fM(value.getBlurRadius());
        object = this.create(node, "color", Color.box-impl((long)value.getColor-0d7_KjU()));
        if (object == null) {
        } else {
            Object object2 = object;
            bl2 = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            elements.add((NodeParameter)it);
        }
        object = this.create(node, "offset", Offset.box-impl((long)value.getOffset-F1C5BW0()));
        if (object == null) {
        } else {
            Object object3 = object;
            bl2 = false;
            boolean bl6 = false;
            Object it = object3;
            boolean bl7 = false;
            elements.add((NodeParameter)it);
        }
        elements.add(new NodeParameter("blurRadius", ParameterType.DimensionDp, Float.valueOf(blurRadius)));
        return parameter;
    }

    private final NodeParameter createFromTextGeometricTransform(MutableInspectorNode node, String name, TextGeometricTransform value) {
        NodeParameter it;
        boolean bl;
        boolean bl2;
        NodeParameter nodeParameter;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, TextGeometricTransform.class.getSimpleName());
        List<NodeParameter> elements = parameter.getElements();
        NodeParameter nodeParameter2 = this.create(node, "scaleX", Float.valueOf(value.getScaleX()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl3 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "skewX", Float.valueOf(value.getSkewX()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl4 = false;
            elements.add(it);
        }
        return parameter;
    }

    private final NodeParameter createFromTextIndent(MutableInspectorNode node, String name, TextIndent value) {
        NodeParameter it;
        boolean bl;
        boolean bl2;
        NodeParameter nodeParameter;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, TextIndent.class.getSimpleName());
        List<NodeParameter> elements = parameter.getElements();
        NodeParameter nodeParameter2 = this.create(node, "firstLine", TextUnit.box-impl((long)value.getFirstLine-XSAIIZE()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl3 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "restLine", TextUnit.box-impl((long)value.getRestLine-XSAIIZE()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl4 = false;
            elements.add(it);
        }
        return parameter;
    }

    private final NodeParameter createFromTextStyle(MutableInspectorNode node, String name, TextStyle value) {
        NodeParameter it;
        boolean bl;
        boolean bl2;
        NodeParameter nodeParameter;
        NodeParameter parameter = new NodeParameter(name, ParameterType.String, TextStyle.class.getSimpleName());
        List<NodeParameter> elements = parameter.getElements();
        NodeParameter nodeParameter2 = this.create(node, "color", Color.box-impl((long)value.getColor-0d7_KjU()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl3 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "fontSize", TextUnit.box-impl((long)value.getFontSize-XSAIIZE()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl4 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "fontWeight", value.getFontWeight());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl5 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "fontStyle", value.getFontStyle());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl6 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "fontSynthesis", value.getFontSynthesis());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl7 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "fontFamily", value.getFontFamily());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl8 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "fontFeatureSettings", value.getFontFeatureSettings());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl9 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "letterSpacing", TextUnit.box-impl((long)value.getLetterSpacing-XSAIIZE()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl10 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "baselineShift", value.getBaselineShift-5SSeXJ0());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl11 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "textGeometricTransform", value.getTextGeometricTransform());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl12 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "localeList", value.getLocaleList());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl13 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "background", Color.box-impl((long)value.getBackground-0d7_KjU()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl14 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "textDecoration", value.getTextDecoration());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl15 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "shadow", value.getShadow());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl16 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "textAlign", value.getTextAlign());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl17 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "textDirection", value.getTextDirection());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl18 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "lineHeight", TextUnit.box-impl((long)value.getLineHeight-XSAIIZE()));
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl19 = false;
            elements.add(it);
        }
        nodeParameter2 = this.create(node, "textIndent", value.getTextIndent());
        if (nodeParameter2 == null) {
        } else {
            nodeParameter = nodeParameter2;
            bl2 = false;
            bl = false;
            it = nodeParameter;
            boolean bl20 = false;
            elements.add(it);
        }
        return parameter;
    }

    private final NodeParameter createFromTextUnit-esivXXI(String name, long value) {
        NodeParameter nodeParameter;
        TextUnitType textUnitType = TextUnit.getType-impl((long)value);
        int n = WhenMappings.$EnumSwitchMapping$0[textUnitType.ordinal()];
        switch (n) {
            case 1: {
                nodeParameter = new NodeParameter(name, ParameterType.DimensionSp, Float.valueOf(TextUnit.getValue-impl((long)value)));
                break;
            }
            case 2: {
                nodeParameter = new NodeParameter(name, ParameterType.DimensionEm, Float.valueOf(TextUnit.getValue-impl((long)value)));
                break;
            }
            case 3: {
                nodeParameter = new NodeParameter(name, ParameterType.String, "Inherit");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return nodeParameter;
    }

    private final String classNameOf(Object value, Class<?> clazz) {
        CharSequence charSequence;
        CharSequence charSequence2 = value.getClass().getSimpleName();
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            charSequence = clazz.getSimpleName();
        } else {
            charSequence = charSequence2;
        }
        String string = (String)charSequence;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.javaClass.simpleName.ifEmpty { default.simpleName }");
        return string;
    }

    private final ResourceFont findBestResourceFont(FontListFontFamily value) {
        Object v1;
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)value.getFonts());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findBestResourceFont$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence $this$minByOrNull$iv = sequence;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                ResourceFont it = (ResourceFont)minElem$iv;
                boolean bl = false;
                int n = it.getWeight().getWeight() - FontWeight.Companion.getNormal().getWeight();
                boolean bl2 = false;
                int minValue$iv = Math.abs(n) + it.getStyle().ordinal();
                do {
                    Object e$iv = iterator$iv.next();
                    ResourceFont it2 = (ResourceFont)e$iv;
                    $i$a$-minByOrNull-ParameterFactory$findBestResourceFont$1 = false;
                    int n2 = it2.getWeight().getWeight() - FontWeight.Companion.getNormal().getWeight();
                    boolean bl3 = false;
                    int v$iv = Math.abs(n2) + it2.getStyle().ordinal();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadFromInterface(Class<?> interfaceClass) {
        void $this$associateByTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Field[] fieldArray = interfaceClass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"interfaceClass.declaredFields");
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Field field = $this$filterTo$iv$iv;
        int n = ((void)field).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = field[i];
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)"INSTANCE"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map<Object, String> destination$iv = this.valueLookup;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            Field it;
            field = (Field)element$iv;
            Map<Object, String> map = destination$iv;
            boolean bl = false;
            it.setAccessible(true);
            Object object = it.get(null);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            it = (Field)element$iv;
            boolean bl2 = false;
            String string = it.getName();
            map.put(object2, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadFromCompanion(Object companionInstance, String ignore) {
        void $this$associateByTo$iv;
        Sequence sequence = companionInstance.getClass().getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)sequence, (String)"companionInstance::class.java.declaredMethods");
        sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])sequence), (Function1)((Function1)new Function1<Method, Boolean>(ignore){
            private final /* synthetic */ String $ignore;
            {
                this.$ignore = $ignore;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@Nullable Method it) {
                if (!Modifier.isPublic(it.getModifiers())) return false;
                if (Intrinsics.areEqual(it.getReturnType(), Void.TYPE)) return false;
                Class<?>[] classArray = it.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"it.parameterTypes");
                Class<?>[] classArray2 = classArray;
                boolean bl = false;
                if (classArray2.length != 0) return false;
                boolean bl2 = true;
                if (!bl2) return false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!StringsKt.startsWith$default((String)string, (String)"get", (boolean)false, (int)2, null)) return false;
                if (this.$ignore == null) return true;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                if (StringsKt.startsWith$default((String)string2, (String)this.$ignore, (boolean)false, (int)2, null)) return false;
                return true;
            }
        }));
        Map<Object, String> destination$iv = this.valueLookup;
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            String string;
            Method it;
            Method method = (Method)element$iv;
            Map<Object, String> map = destination$iv;
            boolean bl = false;
            Object object = it.invoke(companionInstance, new Object[0]);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            it = (Method)element$iv;
            boolean bl2 = false;
            object = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.name");
            int n = 3;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            map.put(object2, string);
        }
    }

    static /* synthetic */ void loadFromCompanion$default(ParameterFactory parameterFactory, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = null;
        }
        parameterFactory.loadFromCompanion(object, string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextUnitType.values().length];
            nArray[TextUnitType.Sp.ordinal()] = 1;
            nArray[TextUnitType.Em.ordinal()] = 2;
            nArray[TextUnitType.Inherit.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

