/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.tooling;

import androidx.ui.tooling.Parameter;
import androidx.ui.tooling.SourceLocation;
import androidx.ui.tooling.SourceLocationInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BJ\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u0012\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001c"}, d2={"Landroidx/ui/tooling/SourceInformationContext;", "", "name", "", "sourceFile", "packageHash", "", "locations", "", "Landroidx/ui/tooling/SourceLocationInfo;", "repeatOffset", "parameters", "Landroidx/ui/tooling/Parameter;", "isCall", "", "()Z", "getLocations", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "nextLocation", "getPackageHash", "()I", "getParameters", "getRepeatOffset", "getSourceFile", "nextSourceLocation", "Landroidx/ui/tooling/SourceLocation;", "ui-tooling_release"})
final class SourceInformationContext {
    private final String name;
    private final String sourceFile;
    private final int packageHash;
    private final List<SourceLocationInfo> locations;
    private final int repeatOffset;
    private final List<Parameter> parameters;
    private final boolean isCall;
    private int nextLocation;

    public SourceInformationContext(@Nullable String name, @Nullable String sourceFile, int packageHash, @NotNull List<SourceLocationInfo> locations, int repeatOffset, @Nullable List<Parameter> parameters, boolean isCall) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        this.name = name;
        this.sourceFile = sourceFile;
        this.packageHash = packageHash;
        this.locations = locations;
        this.repeatOffset = repeatOffset;
        this.parameters = parameters;
        this.isCall = isCall;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final int getPackageHash() {
        return this.packageHash;
    }

    @NotNull
    public final List<SourceLocationInfo> getLocations() {
        return this.locations;
    }

    public final int getRepeatOffset() {
        return this.repeatOffset;
    }

    @Nullable
    public final List<Parameter> getParameters() {
        return this.parameters;
    }

    public final boolean isCall() {
        return this.isCall;
    }

    @Nullable
    public final SourceLocation nextSourceLocation() {
        if (this.nextLocation >= this.locations.size() && this.repeatOffset >= 0) {
            this.nextLocation = this.repeatOffset;
        }
        if (this.nextLocation < this.locations.size()) {
            Object object = this;
            int n = ((SourceInformationContext)object).nextLocation;
            ((SourceInformationContext)object).nextLocation = n + 1;
            SourceLocationInfo location = this.locations.get(n);
            object = location.getLineNumber();
            int n2 = object == null ? -1 : (Integer)object;
            object = location.getOffset();
            int n3 = object == null ? -1 : (Integer)object;
            object = location.getLength();
            return new SourceLocation(n2, n3, object == null ? -1 : (Integer)object, this.sourceFile, this.packageHash);
        }
        return null;
    }
}

