/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.tooling.inspector;

import androidx.ui.tooling.inspector.InlineClassConverter;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0000J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/ui/tooling/inspector/InlineClassConverter;", "", "notInlineType", "Lkotlin/Function1;", "typeMap", "", "", "castParameterValue", "inlineClassName", "value", "clear", "", "loadClassOrNull", "Ljava/lang/Class;", "className", "loadTypeMapper", "typeMapperFor", "typeName", "ui-tooling_release"})
public final class InlineClassConverter {
    private final Map<String, Function1<Object, Object>> typeMap;
    private final Function1<Object, Object> notInlineType;

    public InlineClassConverter() {
        boolean bl = false;
        this.typeMap = new LinkedHashMap();
        this.notInlineType = notInlineType.1.INSTANCE;
    }

    public final void clear() {
        this.typeMap.clear();
    }

    @Nullable
    public final Object castParameterValue(@Nullable String inlineClassName, @Nullable Object value) {
        return value != null && inlineClassName != null ? this.typeMapperFor(inlineClassName).invoke(value) : value;
    }

    private final Function1<Object, Object> typeMapperFor(String typeName) {
        Function1<Object, Object> function1;
        Map<String, Function1<Object, Object>> $this$getOrPut$iv = this.typeMap;
        boolean $i$f$getOrPut = false;
        Function1<Object, Object> value$iv = $this$getOrPut$iv.get(typeName);
        if (value$iv == null) {
            boolean bl = false;
            Function1<Object, Object> answer$iv = this.loadTypeMapper(StringsKt.replace$default((String)typeName, (char)'.', (char)'/', (boolean)false, (int)4, null));
            $this$getOrPut$iv.put(typeName, answer$iv);
            function1 = answer$iv;
        } else {
            function1 = value$iv;
        }
        return function1;
    }

    private final Function1<Object, Object> loadTypeMapper(String className) {
        Class<?> clazz = this.loadClassOrNull(className);
        if (clazz == null) {
            return this.notInlineType;
        }
        Class<?> javaClass = clazz;
        Object[] objectArray = javaClass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"javaClass.declaredConstructors");
        Constructor constructor = (Constructor)ArraysKt.singleOrNull((Object[])objectArray);
        if (constructor == null) {
            return this.notInlineType;
        }
        Constructor create = constructor;
        create.setAccessible(true);
        return (Function1)new Function1<Object, Object>(create){
            private final /* synthetic */ Constructor<?> $create;
            {
                this.$create = $create;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull Object value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Object[] objectArray = new Object[]{value};
                ? obj = this.$create.newInstance(objectArray);
                Intrinsics.checkNotNullExpressionValue(obj, (String)"create.newInstance(value)");
                return obj;
            }
        };
    }

    private final Class<?> loadClassOrNull(String className) {
        Class<?> clazz;
        try {
            clazz = this.getClass().getClassLoader();
            Intrinsics.checkNotNull((Object)clazz);
            clazz = ((ClassLoader)((Object)clazz)).loadClass(className);
        }
        catch (Exception ex) {
            clazz = null;
        }
        return clazz;
    }
}

