/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.tooling.inspector;

import android.content.Context;
import android.view.View;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.unit.AndroidDensityKt;
import androidx.compose.ui.unit.IntBounds;
import androidx.ui.tooling.Group;
import androidx.ui.tooling.NodeGroup;
import androidx.ui.tooling.ParameterInformation;
import androidx.ui.tooling.R;
import androidx.ui.tooling.SlotTreeKt;
import androidx.ui.tooling.SourceLocation;
import androidx.ui.tooling.inspector.InlineClassConverter;
import androidx.ui.tooling.inspector.InspectorNode;
import androidx.ui.tooling.inspector.LayoutInspectorTree;
import androidx.ui.tooling.inspector.LayoutInspectorTree$getRenderNode$;
import androidx.ui.tooling.inspector.LayoutInspectorTreeKt;
import androidx.ui.tooling.inspector.MutableInspectorNode;
import androidx.ui.tooling.inspector.NodeParameter;
import androidx.ui.tooling.inspector.ParameterFactory;
import androidx.ui.tooling.inspector.RawParameter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0000J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u001e\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u001e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dH\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010%\u001a\u00020\u0017H\u0002J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010'\u001a\u00020(J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020*0\u0014H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001d2\u0006\u0010\u001a\u001a\u00020\bJ\n\u00101\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u00102\u001a\u00020\n2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u00104\u001a\u00020\u0004H\u0002J\u0010\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u00106\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u00107\u001a\u0002082\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0010\u00109\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0006\u0010:\u001a\u00020\u0017J\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dH\u0002J\u0010\u0010=\u001a\u0002082\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Landroidx/ui/tooling/inspector/LayoutInspectorTree;", "", "cache", "Ljava/util/ArrayDeque;", "Landroidx/ui/tooling/inspector/MutableInspectorNode;", "claimedNodes", "Ljava/util/IdentityHashMap;", "Landroidx/compose/ui/node/LayoutNode;", "Landroidx/ui/tooling/inspector/InspectorNode;", "generatedId", "", "inlineClassConverter", "Landroidx/ui/tooling/inspector/InlineClassConverter;", "ownerMap", "", "parameterFactory", "Landroidx/ui/tooling/inspector/ParameterFactory;", "stitched", "", "kotlin.jvm.PlatformType", "", "treeMap", "addParameter", "", "parameter", "Landroidx/ui/tooling/ParameterInformation;", "node", "addParameters", "parameters", "", "addSubTrees", "tree", "addToParent", "parentNode", "input", "buildAndRelease", "castValue", "clear", "convert", "view", "Landroid/view/View;", "table", "Landroidx/compose/runtime/SlotTable;", "group", "Landroidx/ui/tooling/Group;", "tables", "convertChildren", "convertParameters", "Landroidx/ui/tooling/inspector/NodeParameter;", "findDeepParentTree", "getRenderNode", "markUnwanted", "newNode", "copyFrom", "parse", "parseCallLocation", "", "release", "resetGeneratedId", "stitchTreesByLayoutNode", "trees", "unwantedGroup", "ui-tooling_release"})
@StabilityInferred(parameters=0)
public final class LayoutInspectorTree {
    private final InlineClassConverter inlineClassConverter = new InlineClassConverter();
    private final ParameterFactory parameterFactory = new ParameterFactory(this.inlineClassConverter);
    private final ArrayDeque<MutableInspectorNode> cache = new ArrayDeque();
    private long generatedId = -1L;
    private final IdentityHashMap<LayoutNode, InspectorNode> claimedNodes = new IdentityHashMap();
    private final IdentityHashMap<MutableInspectorNode, List<MutableInspectorNode>> treeMap = new IdentityHashMap();
    private final IdentityHashMap<InspectorNode, List<MutableInspectorNode>> ownerMap = new IdentityHashMap();
    private final Set<MutableInspectorNode> stitched = Collections.newSetFromMap(new IdentityHashMap());
    public static final int $stable = 8;

    @NotNull
    public final List<InspectorNode> convert(@NotNull View view) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        this.parameterFactory.setDensity(AndroidDensityKt.Density((Context)context));
        Object object = view.getTag(R.id.inspection_slot_table_set);
        Set set2 = set = object instanceof Set ? (Set)object : null;
        if (set == null) {
            return CollectionsKt.emptyList();
        }
        Set tables = set;
        this.clear();
        List<InspectorNode> result = this.convert(tables);
        this.clear();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NodeParameter> convertParameters(@NotNull InspectorNode node) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable $this$mapNotNull$iv = node.getParameters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NodeParameter nodeParameter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RawParameter it = (RawParameter)element$iv$iv;
            boolean bl2 = false;
            if (this.parameterFactory.create(node, it.getName(), it.getValue()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            NodeParameter it$iv$iv = nodeParameter;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void resetGeneratedId() {
        this.generatedId = -1L;
    }

    private final void clear() {
        this.cache.clear();
        this.inlineClassConverter.clear();
        this.claimedNodes.clear();
        this.treeMap.clear();
        this.ownerMap.clear();
        this.stitched.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final List<InspectorNode> convert(Set<SlotTable> tables) {
        List<InspectorNode> list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = tables;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SlotTable slotTable = (SlotTable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MutableInspectorNode mutableInspectorNode = this.convert((SlotTable)it);
            collection.add(mutableInspectorNode);
        }
        List trees = (List)destination$iv$iv;
        int n = trees.size();
        switch (n) {
            case 0: {
                boolean bl = false;
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = ((MutableInspectorNode)CollectionsKt.first((List)trees)).getChildren();
                break;
            }
            default: {
                list = this.stitchTreesByLayoutNode(trees);
            }
        }
        return list;
    }

    private final List<InspectorNode> stitchTreesByLayoutNode(List<MutableInspectorNode> trees) {
        MutableInspectorNode tree;
        IdentityHashMap layoutToTreeMap = new IdentityHashMap();
        Iterable $this$forEach$iv = trees;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            tree = (MutableInspectorNode)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = tree.getLayoutNodes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LayoutNode it = (LayoutNode)element$iv2;
                boolean bl2 = false;
                Map map = layoutToTreeMap;
                boolean bl3 = false;
                map.put(it, tree);
            }
        }
        $this$forEach$iv = trees;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            LayoutNode parentLayout2;
            Object v0;
            block9: {
                tree = (MutableInspectorNode)element$iv;
                boolean bl = false;
                LayoutNode layout = (LayoutNode)CollectionsKt.lastOrNull(tree.getLayoutNodes());
                Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)layout, (Function1)stitchTreesByLayoutNode.2.parentLayout.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    LayoutNode it = (LayoutNode)element$iv3;
                    boolean bl4 = false;
                    MutableInspectorNode otherTree = (MutableInspectorNode)layoutToTreeMap.get(it);
                    if (!(otherTree != null && !Intrinsics.areEqual((Object)otherTree, (Object)tree))) continue;
                    v0 = element$iv3;
                    break block9;
                }
                v0 = null;
            }
            if ((parentLayout2 = (LayoutNode)v0) == null) continue;
            InspectorNode ownerNode = this.claimedNodes.get(parentLayout2);
            MutableInspectorNode ownerTree = (MutableInspectorNode)layoutToTreeMap.get(parentLayout2);
            if (ownerNode == null || ownerTree == null) continue;
            Map $this$getOrPut$iv = this.ownerMap;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(ownerNode);
            if (value$iv == null) {
                boolean bl = false;
                boolean bl5 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(ownerNode, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((List)object2).add(tree);
            $this$getOrPut$iv = this.treeMap;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(ownerTree);
            if (value$iv == null) {
                boolean bl = false;
                boolean bl6 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(ownerTree, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(tree);
        }
        MutableInspectorNode parentTree = this.findDeepParentTree();
        while (parentTree != null) {
            this.addSubTrees(parentTree);
            this.treeMap.remove(parentTree);
            parentTree = this.findDeepParentTree();
        }
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)trees), (Function1)((Function1)new Function1<MutableInspectorNode, Boolean>(this){
            private final /* synthetic */ LayoutInspectorTree $this;
            {
                this.$this = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull MutableInspectorNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !LayoutInspectorTree.access$getStitched$p(this.$this).contains(it);
            }
        })), (Function1)stitchTreesByLayoutNode.4.INSTANCE));
    }

    private final MutableInspectorNode findDeepParentTree() {
        Set<Map.Entry<MutableInspectorNode, List<MutableInspectorNode>>> set = this.treeMap.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"treeMap.entries");
        Map.Entry entry = (Map.Entry)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<Map.Entry<MutableInspectorNode, List<MutableInspectorNode>>, Boolean>(this){
            private final /* synthetic */ LayoutInspectorTree $this;
            {
                this.$this = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull Map.Entry<MutableInspectorNode, List<MutableInspectorNode>> $dstr$_u24__u24$children) {
                boolean bl;
                block3: {
                    void $this$none$iv;
                    Intrinsics.checkNotNullParameter($dstr$_u24__u24$children, (String)"$dstr$_u24__u24$children");
                    Object object = $dstr$_u24__u24$children;
                    boolean bl2 = false;
                    List<MutableInspectorNode> children = object.getValue();
                    Intrinsics.checkNotNullExpressionValue(children, (String)"children");
                    object = children;
                    LayoutInspectorTree layoutInspectorTree = this.$this;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            MutableInspectorNode it = (MutableInspectorNode)element$iv;
                            boolean bl3 = false;
                            if (!LayoutInspectorTree.access$getTreeMap$p(layoutInspectorTree).containsKey(it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        })));
        return entry == null ? (MutableInspectorNode)null : (MutableInspectorNode)entry.getKey();
    }

    private final void addSubTrees(MutableInspectorNode tree) {
        Iterator<InspectorNode> iterator = tree.getChildren().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            InspectorNode inspectorNode;
            int index = n++;
            InspectorNode child = iterator.next();
            tree.getChildren().set(index, (inspectorNode = this.addSubTrees(child)) == null ? child : inspectorNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final InspectorNode addSubTrees(InspectorNode node) {
        MutableInspectorNode newCopy;
        MutableInspectorNode newNode = null;
        Iterator<InspectorNode> iterator = node.getChildren().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            InspectorNode child = iterator.next();
            InspectorNode newChild = this.addSubTrees(child);
            if (newChild == null) continue;
            MutableInspectorNode mutableInspectorNode = newNode;
            MutableInspectorNode newCopy2 = mutableInspectorNode == null ? this.newNode(node) : mutableInspectorNode;
            newCopy2.getChildren().set(index, newChild);
            newNode = newCopy2;
        }
        List<MutableInspectorNode> trees = this.ownerMap.get(node);
        if (trees == null && newNode == null) {
            return null;
        }
        Object index = newNode;
        MutableInspectorNode mutableInspectorNode = newCopy = index == null ? this.newNode(node) : index;
        if (trees != null) {
            void $this$flatMapTo$iv;
            index = trees;
            Collection destination$iv = newCopy.getChildren();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                MutableInspectorNode it = (MutableInspectorNode)element$iv;
                boolean bl = false;
                Iterable list$iv = it.getChildren();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            this.stitched.addAll((Collection<MutableInspectorNode>)trees);
        }
        return this.buildAndRelease(newCopy);
    }

    private final MutableInspectorNode convert(SlotTable table) {
        MutableInspectorNode fakeParent = this.newNode();
        this.addToParent(fakeParent, CollectionsKt.listOf((Object)this.convert(SlotTreeKt.asTree(table))));
        return fakeParent;
    }

    private final MutableInspectorNode convert(Group group) {
        List<MutableInspectorNode> children = this.convertChildren(group);
        MutableInspectorNode parent = this.parse(group);
        this.addToParent(parent, children);
        return parent;
    }

    private final List<MutableInspectorNode> convertChildren(Group group) {
        if (group.getChildren().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        List result = new ArrayList();
        for (Group child : group.getChildren()) {
            MutableInspectorNode node;
            block6: {
                block5: {
                    node = this.convert(child);
                    Object object = node.getName();
                    boolean bl2 = false;
                    if (object.length() > 0) break block5;
                    object = node.getChildren();
                    bl2 = false;
                    if (!object.isEmpty() || node.getId() != 0L) break block5;
                    object = node.getLayoutNodes();
                    bl2 = false;
                    if (!(!object.isEmpty())) break block6;
                }
                result.add(node);
                continue;
            }
            this.release(node);
        }
        return result;
    }

    private final void addToParent(MutableInspectorNode parentNode, List<MutableInspectorNode> input) {
        Long id2 = null;
        Iterable $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableInspectorNode node = (MutableInspectorNode)element$iv;
            boolean bl = false;
            Object object = node.getName();
            boolean bl2 = false;
            if (object.length() == 0) {
                parentNode.getChildren().addAll((Collection<InspectorNode>)node.getChildren());
                if (node.getId() != 0L) {
                    id2 = id2 == null ? Long.valueOf(node.getId()) : Long.valueOf(0L);
                }
            } else {
                long l;
                if (node.getId() != 0L) {
                    l = node.getId();
                } else {
                    object = this;
                    ((LayoutInspectorTree)object).generatedId += -1L;
                    l = ((LayoutInspectorTree)object).generatedId;
                }
                node.setId(l);
                InspectorNode resultNode = node.build();
                Iterable $this$forEach$iv2 = node.getLayoutNodes();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    LayoutNode it = (LayoutNode)element$iv2;
                    boolean bl3 = false;
                    Map $this$getOrPut$iv = this.claimedNodes;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(it);
                    if (value$iv != null) continue;
                    boolean bl4 = false;
                    InspectorNode answer$iv = resultNode;
                    $this$getOrPut$iv.put(it, answer$iv);
                }
                parentNode.getChildren().add(resultNode);
            }
            parentNode.getLayoutNodes().addAll((Collection<LayoutNode>)node.getLayoutNodes());
            this.release(node);
        }
        Long nodeId = id2;
        parentNode.setId(parentNode.getId() == 0L && nodeId != null ? nodeId.longValue() : parentNode.getId());
    }

    private final MutableInspectorNode parse(Group group) {
        Object it;
        Object object;
        MutableInspectorNode node = this.newNode();
        node.setId(this.getRenderNode(group));
        Group group2 = group;
        NodeGroup nodeGroup = group2 instanceof NodeGroup ? (NodeGroup)group2 : null;
        Object object2 = nodeGroup == null ? null : nodeGroup.getNode();
        Object object3 = object = object2 instanceof LayoutNode ? (LayoutNode)object2 : null;
        if (object == null) {
        } else {
            object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            it = object2;
            boolean bl3 = false;
            node.getLayoutNodes().add((LayoutNode)it);
        }
        if (!this.parseCallLocation(group, node)) {
            object = group.getName();
            boolean bl = false;
            boolean bl4 = false;
            if (object == null || object.length() == 0) {
                return this.markUnwanted(node);
            }
        }
        if ((object = group.getName()) != null) {
            Object object4 = object;
            boolean bl = false;
            boolean bl5 = false;
            it = object4;
            boolean bl6 = false;
            node.setName((String)it);
        }
        if (this.unwantedGroup(node)) {
            return this.markUnwanted(node);
        }
        IntBounds box = group.getBox();
        node.setTop(box.getTop());
        node.setLeft(box.getLeft());
        node.setHeight(box.getBottom() - box.getTop());
        node.setWidth(box.getRight() - box.getLeft());
        if (node.getHeight() <= 0 && node.getWidth() <= 0) {
            return this.markUnwanted(node);
        }
        this.addParameters(group.getParameters(), node);
        return node;
    }

    private final MutableInspectorNode markUnwanted(MutableInspectorNode node) {
        node.resetExceptIdLayoutNodesAndChildren();
        return node;
    }

    private final boolean parseCallLocation(Group group, MutableInspectorNode node) {
        SourceLocation sourceLocation = group.getLocation();
        if (sourceLocation == null) {
            return false;
        }
        SourceLocation location = sourceLocation;
        String string = location.getSourceFile();
        if (string == null) {
            return false;
        }
        String fileName = string;
        node.setFileName(fileName);
        node.setPackageHash(location.getPackageHash());
        node.setLineNumber(location.getLineNumber());
        node.setOffset(location.getOffset());
        node.setLength(location.getLength());
        return true;
    }

    private final long getRenderNode(Group group) {
        Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)group.getModifierInfo()), (Function1)getRenderNode.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getRenderNode$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Long l = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)sequence, (Function1)getRenderNode.2.INSTANCE));
        return l == null ? 0L : l;
    }

    private final void addParameters(List<ParameterInformation> parameters, MutableInspectorNode node) {
        Iterable $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParameterInformation it = (ParameterInformation)element$iv;
            boolean bl = false;
            this.addParameter(it, node);
        }
    }

    private final void addParameter(ParameterInformation parameter, MutableInspectorNode node) {
        Object castedValue = this.castValue(parameter);
        node.getParameters().add(new RawParameter(parameter.getName(), castedValue));
    }

    private final Object castValue(ParameterInformation parameter) {
        Object object = parameter.getValue();
        if (object == null) {
            return null;
        }
        Object value = object;
        if (parameter.getInlineClass() == null) {
            return value;
        }
        return this.inlineClassConverter.castParameterValue(parameter.getInlineClass(), value);
    }

    private final boolean unwantedGroup(MutableInspectorNode node) {
        return LayoutInspectorTreeKt.access$getUnwantedPackages$p$s-901057836().contains(node.getPackageHash()) && LayoutInspectorTreeKt.access$getUnwantedCalls$p$s-901057836().contains(node.getName());
    }

    private final MutableInspectorNode newNode() {
        Object object;
        Object object2 = this.cache;
        boolean bl = false;
        if (!object2.isEmpty()) {
            object2 = this.cache.pop();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"cache.pop()");
            object = object2;
        } else {
            object = new MutableInspectorNode();
        }
        return object;
    }

    private final MutableInspectorNode newNode(InspectorNode copyFrom) {
        return this.newNode().shallowCopy(copyFrom);
    }

    private final void release(MutableInspectorNode node) {
        node.reset();
        this.cache.add(node);
    }

    private final InspectorNode buildAndRelease(MutableInspectorNode node) {
        InspectorNode result = node.build();
        this.release(node);
        return result;
    }

    public static final /* synthetic */ Set access$getStitched$p(LayoutInspectorTree $this) {
        return $this.stitched;
    }

    public static final /* synthetic */ IdentityHashMap access$getTreeMap$p(LayoutInspectorTree $this) {
        return $this.treeMap;
    }
}

