/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import androidx.compose.Immutable;
import androidx.compose.Stable;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001cJ.\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0006J\u0013\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u001c\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Landroidx/ui/core/Constraints;", "", "value", "", "(J)V", "focusIndex", "", "getFocusIndex", "()I", "hasBoundedHeight", "", "getHasBoundedHeight", "()Z", "hasBoundedWidth", "getHasBoundedWidth", "maxHeight", "getMaxHeight", "maxWidth", "getMaxWidth", "minHeight", "getMinHeight", "minWidth", "getMinWidth", "getValue$annotations", "()V", "getValue", "()J", "component1", "component1$ui_unit_release", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "ui-unit_release"})
@Immutable
public final class Constraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    public static final int Infinity = Integer.MAX_VALUE;
    private static final long MinFocusWidth = 0L;
    private static final long MaxFocusWidth = 1L;
    private static final long MinFocusHeight = 2L;
    private static final long MaxFocusHeight = 3L;
    private static final long FocusMask = 3L;
    private static final int MinFocusBits = 16;
    private static final int MinFocusMask = 65535;
    private static final int MinNonFocusBits = 15;
    private static final int MinNonFocusMask = Short.MAX_VALUE;
    private static final int MaxFocusBits = 18;
    private static final int MaxFocusMask = 262143;
    private static final int MaxNonFocusBits = 13;
    private static final int MaxNonFocusMask = 8191;
    private static final int[] MinHeightOffsets;
    private static final int[] WidthMask;
    private static final int[] HeightMask;

    public Constraints(long value) {
        this.value = value;
    }

    public final long getValue() {
        return this.value;
    }

    @PublishedApi
    public static /* synthetic */ void getValue$annotations() {
    }

    private final int getFocusIndex() {
        return (int)(this.getValue() & 3L);
    }

    public final int getMinWidth() {
        int mask = WidthMask[this.getFocusIndex()];
        return (int)(this.getValue() >> 2) & mask;
    }

    public final int getMaxWidth() {
        int mask = WidthMask[this.getFocusIndex()];
        int width = (int)(this.getValue() >> 33) & mask;
        return width == 0 ? Integer.MAX_VALUE : width - 1;
    }

    public final int getMinHeight() {
        int focus = this.getFocusIndex();
        int mask = HeightMask[focus];
        int offset = MinHeightOffsets[focus];
        return (int)(this.getValue() >> offset) & mask;
    }

    public final int getMaxHeight() {
        int focus = this.getFocusIndex();
        int mask = HeightMask[focus];
        int offset = MinHeightOffsets[focus] + 31;
        int height = (int)(this.getValue() >> offset) & mask;
        return height == 0 ? Integer.MAX_VALUE : height - 1;
    }

    public final boolean getHasBoundedWidth() {
        int mask = WidthMask[this.getFocusIndex()];
        return ((int)(this.getValue() >> 33) & mask) != 0;
    }

    public final boolean getHasBoundedHeight() {
        int focus = this.getFocusIndex();
        int mask = HeightMask[focus];
        int offset = MinHeightOffsets[focus] + 31;
        return ((int)(this.getValue() >> offset) & mask) != 0;
    }

    @NotNull
    public final Constraints copy(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        boolean bl = minHeight >= 0 && minWidth >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "minHeight(" + minHeight + ") and minWidth(" + minWidth + ") must be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = maxWidth >= minWidth || maxWidth == Integer.MAX_VALUE;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "maxWidth(" + maxWidth + ") must be >= minWidth(" + minWidth + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = maxHeight >= minHeight || maxHeight == Integer.MAX_VALUE;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "maxHeight(" + maxHeight + ") must be >= minHeight(" + minHeight + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return Companion.createConstraints$ui_unit_release(minWidth, maxWidth, minHeight, maxHeight);
    }

    public static /* synthetic */ Constraints copy$default(Constraints this_, int minWidth, int maxWidth, int minHeight, int maxHeight, int n, Object object) {
        if ((n & 1) != 0) {
            minWidth = this_.getMinWidth();
        }
        if ((n & 2) != 0) {
            maxWidth = this_.getMaxWidth();
        }
        if ((n & 4) != 0) {
            minHeight = this_.getMinHeight();
        }
        if ((n & 8) != 0) {
            maxHeight = this_.getMaxHeight();
        }
        return this_.copy(minWidth, maxWidth, minHeight, maxHeight);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Constraints)) {
            return false;
        }
        return this.getValue() == ((Constraints)other).getValue();
    }

    public int hashCode() {
        return Long.hashCode(this.getValue());
    }

    @NotNull
    public String toString() {
        int maxWidth = this.getMaxWidth();
        String maxWidthStr = maxWidth == Integer.MAX_VALUE ? "Infinity" : String.valueOf(maxWidth);
        int maxHeight = this.getMaxHeight();
        String maxHeightStr = maxHeight == Integer.MAX_VALUE ? "Infinity" : String.valueOf(maxHeight);
        return "Constraints(minWidth = " + this.getMinWidth() + ", maxWidth = " + maxWidthStr + ", minHeight = " + this.getMinHeight() + ", maxHeight = " + maxHeightStr + ")";
    }

    public final long component1$ui_unit_release() {
        return this.value;
    }

    @NotNull
    public final Constraints copy(long value) {
        return new Constraints(value);
    }

    public static /* synthetic */ Constraints copy$default(Constraints this_, long value, int n, Object object) {
        if ((n & 1) != 0) {
            value = this_.value;
        }
        return this_.copy(value);
    }

    static {
        int[] nArray = new int[]{18, 20, 17, 15};
        MinHeightOffsets = nArray;
        nArray = new int[]{65535, 262143, Short.MAX_VALUE, 8191};
        WidthMask = nArray;
        nArray = new int[]{Short.MAX_VALUE, 8191, 65535, 262143};
        HeightMask = nArray;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J-\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001fJ\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0007J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\bH\u0007J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/ui/core/Constraints$Companion;", "", "()V", "FocusMask", "", "HeightMask", "", "Infinity", "", "MaxFocusBits", "MaxFocusHeight", "MaxFocusMask", "MaxFocusWidth", "MaxNonFocusBits", "MaxNonFocusMask", "MinFocusBits", "MinFocusHeight", "MinFocusMask", "MinFocusWidth", "MinHeightOffsets", "MinNonFocusBits", "MinNonFocusMask", "WidthMask", "bitsNeedForSize", "size", "createConstraints", "Landroidx/ui/core/Constraints;", "minWidth", "maxWidth", "minHeight", "maxHeight", "createConstraints$ui_unit_release", "fixed", "width", "height", "fixedHeight", "fixedWidth", "ui-unit_release"})
    public static final class Companion {
        private Companion() {
        }

        @Stable
        @NotNull
        public final Constraints fixed(int width, int height) {
            boolean bl = width >= 0 && height >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "width(" + width + ") and height(" + height + ") must be >= 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.createConstraints$ui_unit_release(width, width, height, height);
        }

        @Stable
        @NotNull
        public final Constraints fixedWidth(int width) {
            boolean bl = width >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "width(" + width + ") must be >= 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.createConstraints$ui_unit_release(width, width, 0, Integer.MAX_VALUE);
        }

        @Stable
        @NotNull
        public final Constraints fixedHeight(int height) {
            boolean bl = height >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "height(" + height + ") must be >= 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return this.createConstraints$ui_unit_release(0, Integer.MAX_VALUE, height, height);
        }

        @NotNull
        public final Constraints createConstraints$ui_unit_release(int minWidth, int maxWidth, int minHeight, int maxHeight) {
            long l;
            int heightVal = maxHeight == Integer.MAX_VALUE ? minHeight : maxHeight;
            int heightBits = this.bitsNeedForSize(heightVal);
            int widthVal = maxWidth == Integer.MAX_VALUE ? minWidth : maxWidth;
            int widthBits = this.bitsNeedForSize(widthVal);
            if (widthBits + heightBits > 31) {
                throw new IllegalArgumentException("Can't represent a width of " + widthVal + " and height of " + heightVal + " in Constraints");
            }
            int n = widthBits;
            switch (n) {
                case 15: {
                    l = 2L;
                    break;
                }
                case 16: {
                    l = 0L;
                    break;
                }
                case 13: {
                    l = 3L;
                    break;
                }
                case 18: {
                    l = 1L;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should only have the provided constants.");
                }
            }
            long focus = l;
            int maxWidthValue = maxWidth == Integer.MAX_VALUE ? 0 : maxWidth + 1;
            int maxHeightValue = maxHeight == Integer.MAX_VALUE ? 0 : maxHeight + 1;
            int minHeightOffset = MinHeightOffsets[(int)focus];
            int maxHeightOffset = minHeightOffset + 31;
            long value = focus | (long)minWidth << 2 | (long)maxWidthValue << 33 | (long)minHeight << minHeightOffset | (long)maxHeightValue << maxHeightOffset;
            return new Constraints(value);
        }

        private final int bitsNeedForSize(int size) {
            int n;
            if (size < 8191) {
                n = 13;
            } else if (size < Short.MAX_VALUE) {
                n = 15;
            } else if (size < 65535) {
                n = 16;
            } else if (size < 262143) {
                n = 18;
            } else {
                throw new IllegalArgumentException("Can't represent a size of " + size + " in Constraints");
            }
            return n;
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

