/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.core;

import androidx.compose.Stable;
import androidx.ui.core.Constraints;
import androidx.ui.unit.IntSize;
import androidx.ui.unit.IntSizeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\u001a0\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u000eH\u0007\u001a\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u001a\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u000eH\u0007\u001a\u0014\u0010\u001a\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u000eH\u0007\u001a\u0014\u0010\u001c\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0002H\u0007\u001a \u0010\u001e\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u001f\u001a\u00020\u000e2\b\b\u0002\u0010 \u001a\u00020\u000eH\u0007\u001a\u0014\u0010!\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\"\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u001e\u0010\u0007\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0004\u001a\u0004\b\t\u0010\u0006\"\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0004\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\""}, d2={"hasFixedHeight", "", "Landroidx/ui/core/Constraints;", "getHasFixedHeight$annotations", "(Landroidx/ui/core/Constraints;)V", "getHasFixedHeight", "(Landroidx/ui/core/Constraints;)Z", "hasFixedWidth", "getHasFixedWidth$annotations", "getHasFixedWidth", "isZero", "isZero$annotations", "Constraints", "minWidth", "", "maxWidth", "minHeight", "maxHeight", "addMaxWithMinimum", "max", "value", "constrain", "Landroidx/ui/unit/IntSize;", "size", "constrainHeight", "height", "constrainWidth", "width", "enforce", "otherConstraints", "offset", "horizontal", "vertical", "satisfiedBy", "ui-unit_release"})
public final class ConstraintsKt {
    @Stable
    @NotNull
    public static final Constraints Constraints(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        boolean bl = maxWidth >= minWidth;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxWidth(" + maxWidth + ") must be >= than minWidth(" + minWidth + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = maxHeight >= minHeight;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "maxHeight(" + maxHeight + ") must be >= than minHeight(" + minHeight + ")";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = minWidth >= 0 && minHeight >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "minWidth(" + minWidth + ") and minHeight(" + minHeight + ") must be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return Constraints.Companion.createConstraints$ui_unit_release(minWidth, maxWidth, minHeight, maxHeight);
    }

    public static /* synthetic */ Constraints Constraints$default(int minWidth, int maxWidth, int minHeight, int maxHeight, int n, Object object) {
        if ((n & 1) != 0) {
            minWidth = 0;
        }
        if ((n & 2) != 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        if ((n & 4) != 0) {
            minHeight = 0;
        }
        if ((n & 8) != 0) {
            maxHeight = Integer.MAX_VALUE;
        }
        return ConstraintsKt.Constraints(minWidth, maxWidth, minHeight, maxHeight);
    }

    public static final boolean getHasFixedWidth(@NotNull Constraints $this$hasFixedWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFixedWidth, (String)"<this>");
        return $this$hasFixedWidth.getMaxWidth() == $this$hasFixedWidth.getMinWidth();
    }

    @Stable
    public static /* synthetic */ void getHasFixedWidth$annotations(@NotNull Constraints $this$getHasFixedWidth_u24annotations) {
    }

    public static final boolean getHasFixedHeight(@NotNull Constraints $this$hasFixedHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFixedHeight, (String)"<this>");
        return $this$hasFixedHeight.getMaxHeight() == $this$hasFixedHeight.getMinHeight();
    }

    @Stable
    public static /* synthetic */ void getHasFixedHeight$annotations(@NotNull Constraints $this$getHasFixedHeight_u24annotations) {
    }

    public static final boolean isZero(@NotNull Constraints $this$isZero) {
        Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
        return $this$isZero.getMaxWidth() == 0 || $this$isZero.getMaxHeight() == 0;
    }

    @Stable
    public static /* synthetic */ void isZero$annotations(@NotNull Constraints $this$isZero_u24annotations) {
    }

    @Stable
    @NotNull
    public static final Constraints enforce(@NotNull Constraints $this$enforce, @NotNull Constraints otherConstraints) {
        Intrinsics.checkNotNullParameter((Object)$this$enforce, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)otherConstraints, (String)"otherConstraints");
        return ConstraintsKt.Constraints(RangesKt.coerceIn((int)$this$enforce.getMinWidth(), (int)otherConstraints.getMinWidth(), (int)otherConstraints.getMaxWidth()), RangesKt.coerceIn((int)$this$enforce.getMaxWidth(), (int)otherConstraints.getMinWidth(), (int)otherConstraints.getMaxWidth()), RangesKt.coerceIn((int)$this$enforce.getMinHeight(), (int)otherConstraints.getMinHeight(), (int)otherConstraints.getMaxHeight()), RangesKt.coerceIn((int)$this$enforce.getMaxHeight(), (int)otherConstraints.getMinHeight(), (int)otherConstraints.getMaxHeight()));
    }

    @Stable
    @NotNull
    public static final IntSize constrain(@NotNull Constraints $this$constrain, @NotNull IntSize size) {
        Intrinsics.checkNotNullParameter((Object)$this$constrain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return IntSizeKt.IntSize(RangesKt.coerceIn((int)size.getWidth(), (int)$this$constrain.getMinWidth(), (int)$this$constrain.getMaxWidth()), RangesKt.coerceIn((int)size.getHeight(), (int)$this$constrain.getMinHeight(), (int)$this$constrain.getMaxHeight()));
    }

    @Stable
    public static final int constrainWidth(@NotNull Constraints $this$constrainWidth, int width) {
        Intrinsics.checkNotNullParameter((Object)$this$constrainWidth, (String)"<this>");
        return RangesKt.coerceIn((int)width, (int)$this$constrainWidth.getMinWidth(), (int)$this$constrainWidth.getMaxWidth());
    }

    @Stable
    public static final int constrainHeight(@NotNull Constraints $this$constrainHeight, int height) {
        Intrinsics.checkNotNullParameter((Object)$this$constrainHeight, (String)"<this>");
        return RangesKt.coerceIn((int)height, (int)$this$constrainHeight.getMinHeight(), (int)$this$constrainHeight.getMaxHeight());
    }

    @Stable
    public static final boolean satisfiedBy(@NotNull Constraints $this$satisfiedBy, @NotNull IntSize size) {
        Intrinsics.checkNotNullParameter((Object)$this$satisfiedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new IntRange($this$satisfiedBy.getMinWidth(), $this$satisfiedBy.getMaxWidth()).contains(size.getWidth()) && new IntRange($this$satisfiedBy.getMinHeight(), $this$satisfiedBy.getMaxHeight()).contains(size.getHeight());
    }

    @Stable
    @NotNull
    public static final Constraints offset(@NotNull Constraints $this$offset, int horizontal, int vertical) {
        Intrinsics.checkNotNullParameter((Object)$this$offset, (String)"<this>");
        return ConstraintsKt.Constraints(RangesKt.coerceAtLeast((int)($this$offset.getMinWidth() + horizontal), (int)0), ConstraintsKt.addMaxWithMinimum($this$offset.getMaxWidth(), horizontal), RangesKt.coerceAtLeast((int)($this$offset.getMinHeight() + vertical), (int)0), ConstraintsKt.addMaxWithMinimum($this$offset.getMaxHeight(), vertical));
    }

    public static /* synthetic */ Constraints offset$default(Constraints $this$offset_u24default, int horizontal, int vertical, int n, Object object) {
        if ((n & 1) != 0) {
            horizontal = 0;
        }
        if ((n & 2) != 0) {
            vertical = 0;
        }
        return ConstraintsKt.offset($this$offset_u24default, horizontal, vertical);
    }

    private static final int addMaxWithMinimum(int max, int value) {
        return max == Integer.MAX_VALUE ? max : RangesKt.coerceAtLeast((int)(max + value), (int)0);
    }
}

