/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.unit;

import androidx.compose.Immutable;
import androidx.compose.Stable;
import androidx.ui.unit.Durations;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H\u0097\u0002J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0087\u0002J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bH\u0087\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00d6\u0001J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0087\u0002J\u0011\u0010\u0014\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0087\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000eH\u0087\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0087\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Landroidx/ui/unit/Duration;", "", "nanoseconds", "", "(J)V", "getNanoseconds", "()J", "compareTo", "", "other", "component1", "copy", "div", "quotient", "", "equals", "", "", "hashCode", "minus", "plus", "times", "factor", "toString", "", "Companion", "ui-unit_release"})
@Immutable
public final class Duration
implements Comparable<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long nanoseconds;
    private static final Duration Zero = new Duration(0L);

    public Duration(long nanoseconds) {
        this.nanoseconds = nanoseconds;
    }

    public final long getNanoseconds() {
        return this.nanoseconds;
    }

    @Stable
    @NotNull
    public final Duration plus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(this.getNanoseconds() + other.getNanoseconds());
    }

    @Stable
    @NotNull
    public final Duration minus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(this.getNanoseconds() - other.getNanoseconds());
    }

    @Stable
    @NotNull
    public final Duration times(int factor) {
        return new Duration(this.getNanoseconds() * (long)factor);
    }

    @Stable
    @NotNull
    public final Duration times(double factor) {
        return new Duration((long)((double)this.getNanoseconds() * factor));
    }

    @Stable
    @NotNull
    public final Duration div(int quotient) {
        return new Duration(this.getNanoseconds() / (long)quotient);
    }

    @Stable
    @NotNull
    public final Duration div(double quotient) {
        return new Duration((long)((double)this.getNanoseconds() / quotient));
    }

    @Override
    @Stable
    public int compareTo(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getNanoseconds() < other.getNanoseconds() ? -1 : (this.getNanoseconds() == other.getNanoseconds() ? 0 : 1);
    }

    @Stable
    @NotNull
    public String toString() {
        if (Durations.inMicroseconds(this) < 0L) {
            return Intrinsics.stringPlus((String)"-", (Object)new Duration(-this.getNanoseconds()));
        }
        String twoDigitMinutes = StringsKt.padStart((String)String.valueOf(Durations.inMinutes(this) % 60L), (int)2, (char)'0');
        String twoDigitSeconds = StringsKt.padStart((String)String.valueOf(Durations.inSeconds(this) % 60L), (int)2, (char)'0');
        String sixDigitUs = StringsKt.padStart((String)String.valueOf(Durations.inMicroseconds(this) % 1000000L), (int)6, (char)'0');
        return Durations.inHours(this) + ":" + twoDigitMinutes + ":" + twoDigitSeconds + "." + sixDigitUs;
    }

    public final long component1() {
        return this.nanoseconds;
    }

    @NotNull
    public final Duration copy(long nanoseconds) {
        return new Duration(nanoseconds);
    }

    public static /* synthetic */ Duration copy$default(Duration this_, long nanoseconds, int n, Object object) {
        if ((n & 1) != 0) {
            nanoseconds = this_.nanoseconds;
        }
        return this_.copy(nanoseconds);
    }

    public int hashCode() {
        return Long.hashCode(this.nanoseconds);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Object object = other;
        Duration duration = (Duration)object;
        return this.nanoseconds == duration.nanoseconds;
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/ui/unit/Duration$Companion;", "", "()V", "Zero", "Landroidx/ui/unit/Duration;", "getZero$annotations", "getZero", "()Landroidx/ui/unit/Duration;", "ui-unit_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getZero() {
            return Zero;
        }

        @Stable
        public static /* synthetic */ void getZero$annotations() {
        }

        public /* synthetic */ Companion(@NotNull DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

