/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.util;

import androidx.annotation.NonNull;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\u0011\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u0015\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u001aJ\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020\u0003J\b\u0010(\u001a\u00020)H\u0007J\u0006\u0010*\u001a\u00020\u000bJ\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\u000bJ\u0006\u0010.\u001a\u00020\bJ\b\u0010/\u001a\u00020)H\u0016J\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\r\u00a8\u00063"}, d2={"Landroidx/ui/util/Float16;", "", "value", "", "(F)V", "", "(D)V", "halfValue", "", "(S)V", "exponent", "", "getExponent", "()I", "getHalfValue", "()S", "sign", "getSign", "()Landroidx/ui/util/Float16;", "significand", "getSignificand", "absoluteValue", "ceil", "compareTo", "other", "equals", "", "", "floor", "hashCode", "isFinite", "isInfinite", "isNaN", "isNormalized", "round", "toBits", "toByte", "", "toDouble", "toFloat", "toHexString", "", "toInt", "toLong", "", "toRawBits", "toShort", "toString", "trunc", "withSign", "Companion", "ui-util_release"})
public final class Float16
implements Comparable<Float16> {
    private final short halfValue;
    public static final int Size = 16;
    @NotNull
    private static final Float16 Epsilon;
    public static final int MaxExponent = 15;
    public static final int MinExponent = -14;
    @NotNull
    private static final Float16 LowestValue;
    @NotNull
    private static final Float16 MaxValue;
    @NotNull
    private static final Float16 MinNormal;
    @NotNull
    private static final Float16 MinValue;
    @NotNull
    private static final Float16 NaN;
    @NotNull
    private static final Float16 NegativeInfinity;
    @NotNull
    private static final Float16 NegativeZero;
    @NotNull
    private static final Float16 PositiveInfinity;
    @NotNull
    private static final Float16 PositiveZero;
    private static final Float16 One;
    private static final Float16 NegativeOne;
    private static final int FP16_SIGN_SHIFT = 15;
    private static final int FP16_SIGN_MASK = 32768;
    private static final int FP16_EXPONENT_SHIFT = 10;
    private static final int FP16_EXPONENT_MASK = 31;
    private static final int FP16_SIGNIFICAND_MASK = 1023;
    private static final int FP16_EXPONENT_BIAS = 15;
    private static final int FP16_COMBINED = Short.MAX_VALUE;
    private static final int FP16_EXPONENT_MAX = 31744;
    private static final int FP32_SIGN_SHIFT = 31;
    private static final int FP32_EXPONENT_SHIFT = 23;
    private static final int FP32_EXPONENT_MASK = 255;
    private static final int FP32_SIGNIFICAND_MASK = 0x7FFFFF;
    private static final int FP32_EXPONENT_BIAS = 127;
    private static final int FP32_QNAN_MASK = 0x400000;
    private static final int FP32_DENORMAL_MAGIC = 0x3F000000;
    private static final float FP32_DENORMAL_FLOAT;
    public static final Companion Companion;

    public final byte toByte() {
        return (byte)this.toFloat();
    }

    public final short toShort() {
        return (short)this.toFloat();
    }

    public final int toInt() {
        return (int)this.toFloat();
    }

    public final long toLong() {
        return (long)this.toFloat();
    }

    public final float toFloat() {
        int bits = this.halfValue & 0xFFFF;
        int s = bits & 0x8000;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        int outE = 0;
        int outM = 0;
        if (e == 0) {
            if (m != 0) {
                FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
                int n = 0x3F000000 + m;
                boolean bl = false;
                float o = Float.intBitsToFloat(n);
                return s == 0 ? o : -(o -= FP32_DENORMAL_FLOAT);
            }
        } else {
            outM = m << 13;
            if (e == 31) {
                outE = 255;
                if (outM != 0) {
                    outM |= 0x400000;
                }
            } else {
                outE = e - 15 + 127;
            }
        }
        int out = s << 16 | outE << 23 | outM;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        boolean bl = false;
        return Float.intBitsToFloat(out);
    }

    public final double toDouble() {
        return this.toFloat();
    }

    public final int toBits() {
        return this.isNaN() ? Float16.NaN.halfValue : this.halfValue & 0xFFFF;
    }

    public final int toRawBits() {
        return this.halfValue & 0xFFFF;
    }

    public boolean equals(@androidx.annotation.Nullable @Nullable Object other) {
        return other instanceof Float16 && ((Float16)other).toBits() == this.toBits();
    }

    public int hashCode() {
        return this.toBits();
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.toFloat());
    }

    @Override
    public int compareTo(@NotNull Float16 other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (this.isNaN()) {
            return other.isNaN() ? 0 : 1;
        }
        if (other.isNaN()) {
            return -1;
        }
        return Intrinsics.compare((int)Float16.Companion.toCompareValue(this.halfValue), (int)Float16.Companion.toCompareValue(other.halfValue));
    }

    @NotNull
    public final Float16 getSign() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.compareTo(NegativeZero) < 0) {
            return NegativeOne;
        }
        if (this.compareTo(PositiveZero) > 0) {
            return One;
        }
        return this;
    }

    @NotNull
    public final Float16 withSign(@NotNull Float16 sign) {
        Intrinsics.checkParameterIsNotNull((Object)sign, (String)"sign");
        return new Float16((short)(sign.halfValue & 0x8000 | this.halfValue & Short.MAX_VALUE));
    }

    @NotNull
    public final Float16 absoluteValue() {
        return new Float16((short)(this.halfValue & Short.MAX_VALUE));
    }

    @NotNull
    public final Float16 round() {
        int bits = this.halfValue & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & (e >= 14336 ? 65535 : 0);
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result += 1 << e - 1;
            result &= ~mask;
        }
        return new Float16((short)result);
    }

    @NotNull
    public final Float16 ceil() {
        int bits = this.halfValue & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & -(~(bits >> 15) & (e != 0 ? 1 : 0));
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result += mask & (bits >> 15) - 1;
            result &= ~mask;
        }
        return new Float16((short)result);
    }

    @NotNull
    public final Float16 floor() {
        int bits = this.halfValue & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & (bits > 32768 ? 65535 : 0);
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result += mask & -(bits >> 15);
            result &= ~mask;
        }
        return new Float16((short)result);
    }

    @NotNull
    public final Float16 trunc() {
        int bits = this.halfValue & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result &= ~mask;
        }
        return new Float16((short)result);
    }

    public final int getExponent() {
        return (this.halfValue >>> 10 & 0x1F) - 15;
    }

    public final int getSignificand() {
        return this.halfValue & 0x3FF;
    }

    public final boolean isNaN() {
        return (this.halfValue & Short.MAX_VALUE) > 31744;
    }

    public final boolean isInfinite() {
        return (this.halfValue & Short.MAX_VALUE) == 31744;
    }

    public final boolean isFinite() {
        return (this.halfValue & Short.MAX_VALUE) != 31744;
    }

    public final boolean isNormalized() {
        return (this.halfValue & 0x7C00) != 0 && (this.halfValue & 0x7C00) != 31744;
    }

    @NonNull
    @NotNull
    public final String toHexString() {
        StringBuilder o = new StringBuilder();
        int bits = this.halfValue & 0xFFFF;
        int s = bits >>> 15;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        if (e == 31) {
            if (m == 0) {
                if (s != 0) {
                    o.append('-');
                }
                o.append("Infinity");
            } else {
                o.append("NaN");
            }
        } else {
            if (s == 1) {
                o.append('-');
            }
            if (e == 0) {
                if (m == 0) {
                    o.append("0x0.0p0");
                } else {
                    o.append("0x0.");
                    String string = Integer.toHexString(m);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toHexString(m)");
                    String significand = string;
                    CharSequence charSequence = significand;
                    String string2 = "0{2,}$";
                    StringBuilder stringBuilder = o;
                    boolean bl = false;
                    Object object = new Regex(string2);
                    string2 = object;
                    String string3 = "";
                    boolean bl2 = false;
                    object = string2.replaceFirst(charSequence, string3);
                    stringBuilder.append((String)object);
                    o.append("p-14");
                }
            } else {
                o.append("0x1.");
                String string = Integer.toHexString(m);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toHexString(m)");
                String significand = string;
                CharSequence charSequence = significand;
                String string4 = "0{2,}$";
                StringBuilder stringBuilder = o;
                boolean bl = false;
                Object object = new Regex(string4);
                string4 = object;
                String string5 = "";
                boolean bl3 = false;
                object = string4.replaceFirst(charSequence, string5);
                stringBuilder.append((String)object);
                o.append('p');
                o.append(Integer.toString(e - 15));
            }
        }
        String string = o.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.toString()");
        return string;
    }

    public final short getHalfValue() {
        return this.halfValue;
    }

    public Float16(short halfValue) {
        this.halfValue = halfValue;
    }

    public Float16(float value) {
        this(Float16.Companion.floatToHalf(value));
    }

    public Float16(double value) {
        this((float)value);
    }

    static {
        Companion = new Companion(null);
        Epsilon = new Float16((short)5120);
        LowestValue = new Float16((short)64511);
        MaxValue = new Float16((short)31743);
        MinNormal = new Float16((short)1024);
        MinValue = new Float16((short)1);
        NaN = new Float16((short)32256);
        NegativeInfinity = new Float16((short)64512);
        NegativeZero = new Float16((short)32768);
        PositiveInfinity = new Float16((short)31744);
        PositiveZero = new Float16((short)0);
        One = new Float16(1.0f);
        NegativeOne = new Float16(-1.0f);
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = 0x3F000000;
        boolean bl = false;
        FP32_DENORMAL_FLOAT = Float.intBitsToFloat(n);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u001f\n\u0002\u0010\n\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0011H\u0002J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000201H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u000e\u0010\u001b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u000e\u0010\u001e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u000e\u0010'\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0006R\u000e\u0010*\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0011\u0010-\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u000e\u0010/\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Landroidx/ui/util/Float16$Companion;", "", "()V", "Epsilon", "Landroidx/ui/util/Float16;", "getEpsilon", "()Landroidx/ui/util/Float16;", "FP16_COMBINED", "", "FP16_EXPONENT_BIAS", "FP16_EXPONENT_MASK", "FP16_EXPONENT_MAX", "FP16_EXPONENT_SHIFT", "FP16_SIGNIFICAND_MASK", "FP16_SIGN_MASK", "FP16_SIGN_SHIFT", "FP32_DENORMAL_FLOAT", "", "FP32_DENORMAL_MAGIC", "FP32_EXPONENT_BIAS", "FP32_EXPONENT_MASK", "FP32_EXPONENT_SHIFT", "FP32_QNAN_MASK", "FP32_SIGNIFICAND_MASK", "FP32_SIGN_SHIFT", "LowestValue", "getLowestValue", "MaxExponent", "MaxValue", "getMaxValue", "MinExponent", "MinNormal", "getMinNormal", "MinValue", "getMinValue", "NaN", "getNaN", "NegativeInfinity", "getNegativeInfinity", "NegativeOne", "NegativeZero", "getNegativeZero", "One", "PositiveInfinity", "getPositiveInfinity", "PositiveZero", "getPositiveZero", "Size", "floatToHalf", "", "f", "toCompareValue", "value", "ui-util_release"})
    public static final class Companion {
        @NotNull
        public final Float16 getEpsilon() {
            return Epsilon;
        }

        @NotNull
        public final Float16 getLowestValue() {
            return LowestValue;
        }

        @NotNull
        public final Float16 getMaxValue() {
            return MaxValue;
        }

        @NotNull
        public final Float16 getMinNormal() {
            return MinNormal;
        }

        @NotNull
        public final Float16 getMinValue() {
            return MinValue;
        }

        @NotNull
        public final Float16 getNaN() {
            return NaN;
        }

        @NotNull
        public final Float16 getNegativeInfinity() {
            return NegativeInfinity;
        }

        @NotNull
        public final Float16 getNegativeZero() {
            return NegativeZero;
        }

        @NotNull
        public final Float16 getPositiveInfinity() {
            return PositiveInfinity;
        }

        @NotNull
        public final Float16 getPositiveZero() {
            return PositiveZero;
        }

        private final int toCompareValue(short value) {
            return (value & 0x8000) != 0 ? 32768 - (value & 0xFFFF) : value & 0xFFFF;
        }

        private final short floatToHalf(float f) {
            int bits = Float.floatToRawIntBits(f);
            int s = bits >>> 31;
            int e = bits >>> 23 & 0xFF;
            int m = bits & 0x7FFFFF;
            int outE = 0;
            int outM = 0;
            if (e == 255) {
                outE = 31;
                outM = m != 0 ? 512 : 0;
            } else if ((e = e - 127 + 15) >= 31) {
                outE = 49;
            } else if (e <= 0) {
                if (e >= -10) {
                    if (((m = (m | 0x800000) >> 1 - e) & 0x1000) != 0) {
                        m += 8192;
                    }
                    outM = m >> 13;
                }
            } else {
                outE = e;
                outM = m >> 13;
                if ((m & 0x1000) != 0) {
                    int out = outE << 10 | outM;
                    return (short)(++out | s << 15);
                }
            }
            return (short)(s << 15 | outE << 10 | outM);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

