/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector;

import android.graphics.Matrix;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.vector.PathNode;
import androidx.ui.graphics.vector.PathParser;
import androidx.ui.graphics.vector.VNode;
import androidx.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010@\u001a\u00020\u00142\u0006\u0010A\u001a\u00020BH\u0016J\u0016\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020\u0001J\u001e\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u0002042\u0006\u0010H\u001a\u0002042\u0006\u0010I\u001a\u000204J\u0016\u0010J\u001a\u00020\u00142\u0006\u0010D\u001a\u0002042\u0006\u0010I\u001a\u000204J\b\u0010K\u001a\u00020\u0003H\u0016J\b\u0010L\u001a\u00020\u0014H\u0002J\b\u0010M\u001a\u00020\u0014H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R$\u0010*\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010$\"\u0004\b,\u0010&R$\u0010-\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&R$\u00100\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010$\"\u0004\b2\u0010&R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R$\u00107\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010$\"\u0004\b9\u0010&R$\u0010:\u001a\u00020!2\u0006\u0010\t\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010$\"\u0004\b<\u0010&R\u0014\u0010=\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006N"}, d2={"Landroidx/ui/graphics/vector/GroupComponent;", "Landroidx/ui/graphics/vector/VNode;", "name", "", "(Ljava/lang/String;)V", "children", "", "clipPath", "Landroidx/ui/graphics/Path;", "value", "", "Landroidx/ui/graphics/vector/PathNode;", "clipPathData", "getClipPathData", "()Ljava/util/List;", "setClipPathData", "(Ljava/util/List;)V", "groupMatrix", "Landroid/graphics/Matrix;", "Lkotlin/Function0;", "", "invalidateListener", "getInvalidateListener", "()Lkotlin/jvm/functions/Function0;", "setInvalidateListener", "(Lkotlin/jvm/functions/Function0;)V", "isClipPathDirty", "", "isMatrixDirty", "getName", "()Ljava/lang/String;", "parser", "Landroidx/ui/graphics/vector/PathParser;", "", "pivotX", "getPivotX", "()F", "setPivotX", "(F)V", "pivotY", "getPivotY", "setPivotY", "rotation", "getRotation", "setRotation", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "size", "", "getSize", "()I", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "willClipPath", "getWillClipPath", "()Z", "draw", "canvas", "Landroidx/ui/graphics/Canvas;", "insertAt", "index", "instance", "move", "from", "to", "count", "remove", "toString", "updateClipPath", "updateMatrix", "ui-vector_release"})
public final class GroupComponent
extends VNode {
    private Matrix groupMatrix;
    private final List<VNode> children;
    @NotNull
    private List<PathNode> clipPathData;
    private boolean isClipPathDirty;
    private Path clipPath;
    private PathParser parser;
    @Nullable
    private Function0<Unit> invalidateListener;
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX;
    private float scaleY;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty;
    @NotNull
    private final String name;

    @NotNull
    public final List<PathNode> getClipPathData() {
        return this.clipPathData;
    }

    public final void setClipPathData(@NotNull List<PathNode> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        if (Intrinsics.areEqual(this.clipPathData, value) ^ true) {
            this.clipPathData = value;
            this.isClipPathDirty = true;
            this.invalidate();
        }
    }

    private final boolean getWillClipPath() {
        Collection collection = this.clipPathData;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    @Nullable
    public Function0<Unit> getInvalidateListener() {
        return this.invalidateListener;
    }

    @Override
    public void setInvalidateListener(@Nullable Function0<Unit> value) {
        this.invalidateListener = value;
        for (VNode child : this.children) {
            child.setInvalidateListener(value);
        }
    }

    private final void updateClipPath() {
        if (this.getWillClipPath()) {
            PathParser targetParser = this.parser;
            if (targetParser == null) {
                this.parser = targetParser = new PathParser();
            } else {
                targetParser.clear();
            }
            Path targetClip = this.clipPath;
            if (targetClip == null) {
                this.clipPath = targetClip = new Path(null, 1, null);
            } else {
                targetClip.reset();
            }
            targetParser.addPathNodes(this.clipPathData).toPath(targetClip);
        }
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float value) {
        if (this.rotation != value) {
            this.rotation = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getPivotX() {
        return this.pivotX;
    }

    public final void setPivotX(float value) {
        if (this.pivotX != value) {
            this.pivotX = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getPivotY() {
        return this.pivotY;
    }

    public final void setPivotY(float value) {
        if (this.pivotY != value) {
            this.pivotY = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float value) {
        if (this.scaleX != value) {
            this.scaleX = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float value) {
        if (this.scaleY != value) {
            this.scaleY = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float value) {
        if (this.translationX != value) {
            this.translationX = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float value) {
        if (this.translationY != value) {
            this.translationY = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    private final void updateMatrix() {
        Matrix matrix = null;
        Matrix target = this.groupMatrix;
        if (target == null) {
            this.groupMatrix = matrix = new Matrix();
        } else {
            matrix = target;
        }
        boolean bl = false;
        boolean bl2 = false;
        Matrix $this$with = matrix;
        boolean bl3 = false;
        $this$with.reset();
        $this$with.postTranslate(-this.pivotX, -this.pivotY);
        $this$with.postScale(this.scaleX, this.scaleY);
        $this$with.postRotate(this.rotation, 0.0f, 0.0f);
        $this$with.postTranslate(this.translationX + this.pivotX, this.translationY + this.pivotY);
    }

    public final void insertAt(int index, @NotNull VNode instance) {
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        if (index < this.getSize()) {
            this.children.set(index, instance);
        } else {
            this.children.add(instance);
        }
        instance.setInvalidateListener(this.getInvalidateListener());
        this.invalidate();
    }

    public final void move(int from, int to, int count) {
        if (from > to) {
            int current = to;
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = count;
            while (n < n2) {
                int it = n++;
                boolean bl2 = false;
                VNode node = this.children.get(from);
                this.children.remove(from);
                this.children.add(current, node);
                int n3 = current;
                current = n3 + 1;
            }
        } else {
            boolean bl = false;
            int n = 0;
            n = 0;
            int n4 = count;
            while (n < n4) {
                int it = n++;
                boolean bl3 = false;
                VNode node = this.children.get(from);
                this.children.remove(from);
                this.children.add(to - 1, node);
            }
        }
        this.invalidate();
    }

    public final void remove(int index, int count) {
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = count;
        while (n < n2) {
            int it = n++;
            boolean bl2 = false;
            this.children.get(index).setInvalidateListener((Function0<Unit>)((Function0)null));
            this.children.remove(index);
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.isMatrixDirty) {
            this.updateMatrix();
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            this.updateClipPath();
            this.isClipPathDirty = false;
        }
        Canvas $this$withSave$iv = canvas;
        try {
            Matrix matrix;
            $this$withSave$iv.save();
            boolean bl = false;
            Path targetClip = this.clipPath;
            if (this.getWillClipPath() && targetClip != null) {
                canvas.clipPath(targetClip);
            }
            if ((matrix = this.groupMatrix) != null) {
                canvas.getNativeCanvas().concat(matrix);
            }
            for (VNode node : this.children) {
                node.draw(canvas);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withSave$iv.restore();
        }
    }

    public final int getSize() {
        return this.children.size();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("VGroup: ").append(this.name);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"StringBuilder().append(\"VGroup: \").append(name)");
        StringBuilder sb = stringBuilder;
        for (VNode node : this.children) {
            sb.append("\t").append(node.toString()).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public GroupComponent(@NotNull String name) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(null);
        this.name = name;
        GroupComponent groupComponent = this;
        boolean bl = false;
        groupComponent.children = list = (List)new ArrayList();
        this.clipPathData = VectorKt.getEmptyPath();
        this.isClipPathDirty = true;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.isMatrixDirty = true;
    }

    public /* synthetic */ GroupComponent(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string);
    }

    public GroupComponent() {
        this(null, 1, null);
    }
}

