/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector;

import androidx.ui.graphics.Brush;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.PaintingStyle;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.StrokeCap;
import androidx.ui.graphics.StrokeJoin;
import androidx.ui.graphics.vector.PathNode;
import androidx.ui.graphics.vector.PathParser;
import androidx.ui.graphics.vector.VNode;
import androidx.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010<\u001a\u00020\u0013H\u0002J\b\u0010=\u001a\u00020\u0013H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u0003H\u0016J!\u0010C\u001a\u00020?2\u0017\u0010D\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020?0E\u00a2\u0006\u0002\bFH\u0002J\b\u0010G\u001a\u00020?H\u0002J\"\u0010H\u001a\u00020?2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020?0E\u00a2\u0006\u0002\bFH\u0082\bR(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R(\u0010#\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\t\"\u0004\b%\u0010\u000bR$\u0010&\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010\u0011R$\u0010*\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R$\u00100\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020/@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u000f\"\u0004\b7\u0010\u0011R$\u00108\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u000f\"\u0004\b:\u0010\u0011R\u0010\u0010;\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Landroidx/ui/graphics/vector/PathComponent;", "Landroidx/ui/graphics/vector/VNode;", "name", "", "(Ljava/lang/String;)V", "value", "Landroidx/ui/graphics/Brush;", "fill", "getFill", "()Landroidx/ui/graphics/Brush;", "setFill", "(Landroidx/ui/graphics/Brush;)V", "", "fillAlpha", "getFillAlpha", "()F", "setFillAlpha", "(F)V", "fillPaint", "Landroidx/ui/graphics/Paint;", "isPathDirty", "", "getName", "()Ljava/lang/String;", "parser", "Landroidx/ui/graphics/vector/PathParser;", "path", "Landroidx/ui/graphics/Path;", "", "Landroidx/ui/graphics/vector/PathNode;", "pathData", "getPathData", "()Ljava/util/List;", "setPathData", "(Ljava/util/List;)V", "stroke", "getStroke", "setStroke", "strokeAlpha", "getStrokeAlpha", "setStrokeAlpha", "Landroidx/ui/graphics/StrokeCap;", "strokeLineCap", "getStrokeLineCap", "()Landroidx/ui/graphics/StrokeCap;", "setStrokeLineCap", "(Landroidx/ui/graphics/StrokeCap;)V", "Landroidx/ui/graphics/StrokeJoin;", "strokeLineJoin", "getStrokeLineJoin", "()Landroidx/ui/graphics/StrokeJoin;", "setStrokeLineJoin", "(Landroidx/ui/graphics/StrokeJoin;)V", "strokeLineMiter", "getStrokeLineMiter", "setStrokeLineMiter", "strokeLineWidth", "getStrokeLineWidth", "setStrokeLineWidth", "strokePaint", "createFillPaint", "createStrokePaint", "draw", "", "canvas", "Landroidx/ui/graphics/Canvas;", "toString", "updateFillPaint", "fillPaintUpdater", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "updatePath", "updateStrokePaint", "strokePaintUpdater", "ui-vector_release"})
public final class PathComponent
extends VNode {
    @Nullable
    private Brush fill;
    private float fillAlpha;
    @NotNull
    private List<PathNode> pathData;
    private float strokeAlpha;
    private float strokeLineWidth;
    @Nullable
    private Brush stroke;
    @NotNull
    private StrokeCap strokeLineCap;
    @NotNull
    private StrokeJoin strokeLineJoin;
    private float strokeLineMiter;
    private boolean isPathDirty;
    private final Path path;
    private Paint fillPaint;
    private Paint strokePaint;
    private final PathParser parser;
    @NotNull
    private final String name;

    @Nullable
    public final Brush getFill() {
        return this.fill;
    }

    public final void setFill(@Nullable Brush value) {
        if (Intrinsics.areEqual((Object)this.fill, (Object)value) ^ true) {
            this.fill = value;
            this.updateFillPaint((Function1<? super Paint, Unit>)((Function1)new Function1<Paint, Unit>(this){
                final /* synthetic */ PathComponent this$0;

                public final void invoke(@NotNull Paint $this$updateFillPaint) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)$this$updateFillPaint, (String)"$receiver");
                        Brush brush = PathComponent.access$getFill$lp(this.this$0);
                        if (brush == null) break block0;
                        brush.applyTo($this$updateFillPaint);
                    }
                }
                {
                    this.this$0 = pathComponent;
                    super(1);
                }
            }));
            this.invalidate();
        }
    }

    public final float getFillAlpha() {
        return this.fillAlpha;
    }

    public final void setFillAlpha(float value) {
        if (this.fillAlpha != value) {
            this.fillAlpha = value;
            this.updateFillPaint((Function1<? super Paint, Unit>)((Function1)new Function1<Paint, Unit>(this){
                final /* synthetic */ PathComponent this$0;

                public final void invoke(@NotNull Paint $this$updateFillPaint) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$updateFillPaint, (String)"$receiver");
                    $this$updateFillPaint.setAlpha(PathComponent.access$getFillAlpha$lp(this.this$0));
                }
                {
                    this.this$0 = pathComponent;
                    super(1);
                }
            }));
            this.invalidate();
        }
    }

    @NotNull
    public final List<PathNode> getPathData() {
        return this.pathData;
    }

    public final void setPathData(@NotNull List<PathNode> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        if (Intrinsics.areEqual(this.pathData, value) ^ true) {
            this.pathData = value;
            this.isPathDirty = true;
            this.invalidate();
        }
    }

    public final float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public final void setStrokeAlpha(float value) {
        if (this.strokeAlpha != value) {
            this.strokeAlpha = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$updateStrokePaint = paint;
                    boolean bl = false;
                    $this$updateStrokePaint.setAlpha(this.strokeAlpha);
                }
            }
            this.invalidate();
        }
    }

    public final float getStrokeLineWidth() {
        return this.strokeLineWidth;
    }

    public final void setStrokeLineWidth(float value) {
        if (this.strokeLineWidth != value) {
            this.strokeLineWidth = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$updateStrokePaint = paint;
                    boolean bl = false;
                    $this$updateStrokePaint.setStrokeWidth(this.strokeLineWidth);
                }
            }
            this.invalidate();
        }
    }

    @Nullable
    public final Brush getStroke() {
        return this.stroke;
    }

    public final void setStroke(@Nullable Brush value) {
        if (Intrinsics.areEqual((Object)this.stroke, (Object)value) ^ true) {
            this.stroke = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$updateStrokePaint = paint;
                    boolean bl = false;
                    Brush brush = this.stroke;
                    if (brush != null) {
                        brush.applyTo($this$updateStrokePaint);
                    }
                }
            }
            this.invalidate();
        }
    }

    @NotNull
    public final StrokeCap getStrokeLineCap() {
        return this.strokeLineCap;
    }

    public final void setStrokeLineCap(@NotNull StrokeCap value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.strokeLineCap != value) {
            this.strokeLineCap = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$updateStrokePaint = paint;
                    boolean bl = false;
                    $this$updateStrokePaint.setStrokeCap(this.strokeLineCap);
                }
            }
            this.invalidate();
        }
    }

    @NotNull
    public final StrokeJoin getStrokeLineJoin() {
        return this.strokeLineJoin;
    }

    public final void setStrokeLineJoin(@NotNull StrokeJoin value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.strokeLineJoin != value) {
            this.strokeLineJoin = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$updateStrokePaint = paint;
                    boolean bl = false;
                    $this$updateStrokePaint.setStrokeJoin(this.strokeLineJoin);
                }
            }
            this.invalidate();
        }
    }

    public final float getStrokeLineMiter() {
        return this.strokeLineMiter;
    }

    public final void setStrokeLineMiter(float value) {
        if (this.strokeLineMiter != value) {
            this.strokeLineMiter = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$updateStrokePaint = paint;
                    boolean bl = false;
                    $this$updateStrokePaint.setStrokeMiterLimit(this.strokeLineMiter);
                }
            }
            this.invalidate();
        }
    }

    private final void updateStrokePaint(Function1<? super Paint, Unit> strokePaintUpdater) {
        block1: {
            block0: {
                int $i$f$updateStrokePaint = 0;
                if (this.strokePaint != null) break block0;
                this.strokePaint = this.createStrokePaint();
                break block1;
            }
            Paint paint = this.strokePaint;
            if (paint == null) break block1;
            Unit cfr_ignored_0 = (Unit)strokePaintUpdater.invoke((Object)paint);
        }
    }

    private final Paint createStrokePaint() {
        Paint paint;
        block0: {
            paint = new Paint();
            boolean bl = false;
            boolean bl2 = false;
            Paint $this$apply = paint;
            boolean bl3 = false;
            $this$apply.setAntiAlias(true);
            $this$apply.setStyle(PaintingStyle.stroke);
            $this$apply.setAlpha(this.strokeAlpha);
            $this$apply.setStrokeWidth(this.strokeLineWidth);
            $this$apply.setStrokeCap(this.strokeLineCap);
            $this$apply.setStrokeJoin(this.strokeLineJoin);
            $this$apply.setStrokeMiterLimit(this.strokeLineMiter);
            Brush brush = this.stroke;
            if (brush == null) break block0;
            brush.applyTo($this$apply);
        }
        return paint;
    }

    private final void updateFillPaint(Function1<? super Paint, Unit> fillPaintUpdater) {
        block1: {
            block0: {
                if (this.fillPaint != null) break block0;
                this.fillPaint = this.createFillPaint();
                break block1;
            }
            Paint paint = this.fillPaint;
            if (paint == null) break block1;
            Unit cfr_ignored_0 = (Unit)fillPaintUpdater.invoke((Object)paint);
        }
    }

    private final Paint createFillPaint() {
        Paint paint;
        block0: {
            paint = new Paint();
            boolean bl = false;
            boolean bl2 = false;
            Paint $this$apply = paint;
            boolean bl3 = false;
            $this$apply.setAntiAlias(true);
            $this$apply.setAlpha(this.fillAlpha);
            $this$apply.setStyle(PaintingStyle.fill);
            Brush brush = this.fill;
            if (brush == null) break block0;
            brush.applyTo($this$apply);
        }
        return paint;
    }

    private final void updatePath() {
        this.parser.clear();
        this.path.reset();
        this.parser.addPathNodes(this.pathData).toPath(this.path);
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Brush strokeBrush;
        Brush fillBrush;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.isPathDirty) {
            this.updatePath();
            this.isPathDirty = false;
        }
        if ((fillBrush = this.fill) != null) {
            Paint targetFillPaint = this.fillPaint;
            if (targetFillPaint == null) {
                this.fillPaint = targetFillPaint = this.createFillPaint();
            }
            canvas.drawPath(this.path, targetFillPaint);
        }
        if ((strokeBrush = this.stroke) != null) {
            Paint targetStrokePaint = this.strokePaint;
            if (targetStrokePaint == null) {
                this.strokePaint = targetStrokePaint = this.createStrokePaint();
            }
            canvas.drawPath(this.path, targetStrokePaint);
        }
    }

    @NotNull
    public String toString() {
        return this.path.toString();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public PathComponent(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        super(null);
        this.name = name;
        this.fillAlpha = 1.0f;
        this.pathData = VectorKt.getEmptyPath();
        this.strokeAlpha = 1.0f;
        this.strokeLineCap = VectorKt.getDefaultStrokeLineCap();
        this.strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
        this.strokeLineMiter = 4.0f;
        this.isPathDirty = true;
        this.path = new Path(null, 1, null);
        this.parser = new PathParser();
    }

    public static final /* synthetic */ Brush access$getFill$lp(PathComponent $this) {
        return $this.fill;
    }

    public static final /* synthetic */ void access$setFill$lp(PathComponent $this, Brush brush) {
        $this.fill = brush;
    }

    public static final /* synthetic */ float access$getFillAlpha$lp(PathComponent $this) {
        return $this.fillAlpha;
    }

    public static final /* synthetic */ void access$setFillAlpha$lp(PathComponent $this, float f) {
        $this.fillAlpha = f;
    }
}

