/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector;

import androidx.ui.core.Px;
import androidx.ui.engine.geometry.Offset;
import androidx.ui.graphics.AndroidCanvasKt;
import androidx.ui.graphics.AndroidImageKt;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorFilter;
import androidx.ui.graphics.Image;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.vector.GroupComponent;
import androidx.ui.graphics.vector.VNode;
import androidx.ui.graphics.vector.VectorKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\"\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.J\u001a\u0010/\u001a\u00020 2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.H\u0002J\b\u00100\u001a\u00020\u0003H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\"\"\u0004\b&\u0010$\u00a8\u00061"}, d2={"Landroidx/ui/graphics/vector/VectorComponent;", "Landroidx/ui/graphics/vector/VNode;", "name", "", "viewportWidth", "", "viewportHeight", "defaultWidth", "Landroidx/ui/core/Px;", "defaultHeight", "(Ljava/lang/String;FFLandroidx/ui/core/Px;Landroidx/ui/core/Px;)V", "cachedImage", "Landroidx/ui/graphics/Image;", "getDefaultHeight", "()Landroidx/ui/core/Px;", "setDefaultHeight", "(Landroidx/ui/core/Px;)V", "getDefaultWidth", "setDefaultWidth", "isDirty", "", "getName", "()Ljava/lang/String;", "root", "Landroidx/ui/graphics/vector/GroupComponent;", "getRoot", "()Landroidx/ui/graphics/vector/GroupComponent;", "size", "", "getSize", "()I", "tintPaint", "Landroidx/ui/graphics/Paint;", "getViewportHeight", "()F", "setViewportHeight", "(F)V", "getViewportWidth", "setViewportWidth", "draw", "", "canvas", "Landroidx/ui/graphics/Canvas;", "tintColor", "Landroidx/ui/graphics/Color;", "blendMode", "Landroidx/ui/graphics/BlendMode;", "obtainTintPaint", "toString", "ui-vector_release"})
public final class VectorComponent
extends VNode {
    @NotNull
    private final GroupComponent root;
    private boolean isDirty;
    private Paint tintPaint;
    private Image cachedImage;
    @NotNull
    private final String name;
    private float viewportWidth;
    private float viewportHeight;
    @NotNull
    private Px defaultWidth;
    @NotNull
    private Px defaultHeight;

    @NotNull
    public final GroupComponent getRoot() {
        return this.root;
    }

    public final int getSize() {
        return this.root.getSize();
    }

    public final void draw(@NotNull Canvas canvas, @NotNull Color tintColor, @NotNull BlendMode blendMode) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)tintColor, (String)"tintColor");
        Intrinsics.checkParameterIsNotNull((Object)blendMode, (String)"blendMode");
        Image targetImage = this.cachedImage;
        if (targetImage == null) {
            float f = this.defaultWidth.getValue();
            boolean bl = false;
            int n = (int)Math.ceil(f);
            f = this.defaultHeight.getValue();
            int n2 = n;
            bl = false;
            float f2 = (float)Math.ceil(f);
            this.cachedImage = targetImage = AndroidImageKt.Image$default((int)n2, (int)((int)f2), null, (boolean)false, null, (int)28, null);
        }
        if (this.isDirty) {
            this.root.draw(AndroidCanvasKt.Canvas((Image)targetImage));
            this.isDirty = false;
        }
        canvas.drawImage(targetImage, Offset.Companion.getZero(), this.obtainTintPaint(tintColor, blendMode));
    }

    public static /* synthetic */ void draw$default(VectorComponent vectorComponent, Canvas canvas, Color color, BlendMode blendMode, int n, Object object) {
        if ((n & 2) != 0) {
            color = VectorKt.getDefaultTintColor();
        }
        if ((n & 4) != 0) {
            blendMode = VectorKt.getDefaultTintBlendMode();
        }
        vectorComponent.draw(canvas, color, blendMode);
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.draw(canvas, VectorKt.getDefaultTintColor(), VectorKt.getDefaultTintBlendMode());
    }

    @NotNull
    public String toString() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("Params: ");
        $this$buildString.append("\tname: ").append(this.name).append("\n");
        $this$buildString.append("\twidth: ").append(this.defaultWidth).append("\n");
        $this$buildString.append("\theight: ").append(this.defaultHeight).append("\n");
        $this$buildString.append("\tviewportWidth: ").append(this.viewportWidth).append("\n");
        $this$buildString.append("\tviewportHeight: ").append(this.viewportHeight).append("\n");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Paint obtainTintPaint(Color tintColor, BlendMode blendMode) {
        Paint paint;
        if (tintColor.getAlpha() == 0.0f) {
            paint = VectorKt.getEmptyPaint();
        } else {
            void var3_8;
            ColorFilter colorFilter;
            Paint paint2 = this.tintPaint;
            if (paint2 == null) {
                Paint paint3 = new Paint();
                boolean bl = false;
                boolean bl2 = false;
                Paint it = paint3;
                boolean bl3 = false;
                this.tintPaint = it;
                paint2 = paint3;
            }
            Paint targetPaint = paint2;
            ColorFilter colorFilter2 = colorFilter = targetPaint.getColorFilter();
            if (Intrinsics.areEqual((Object)(colorFilter2 != null ? colorFilter2.getColor() : null), (Object)tintColor) ^ true || colorFilter.getBlendMode() != blendMode) {
                targetPaint.setColorFilter(new ColorFilter(tintColor, blendMode));
            }
            paint = var3_8;
        }
        return paint;
    }

    static /* synthetic */ Paint obtainTintPaint$default(VectorComponent vectorComponent, Color color, BlendMode blendMode, int n, Object object) {
        if ((n & 2) != 0) {
            blendMode = VectorKt.getDefaultTintBlendMode();
        }
        return vectorComponent.obtainTintPaint(color, blendMode);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final float getViewportWidth() {
        return this.viewportWidth;
    }

    public final void setViewportWidth(float f) {
        this.viewportWidth = f;
    }

    public final float getViewportHeight() {
        return this.viewportHeight;
    }

    public final void setViewportHeight(float f) {
        this.viewportHeight = f;
    }

    @NotNull
    public final Px getDefaultWidth() {
        return this.defaultWidth;
    }

    public final void setDefaultWidth(@NotNull Px px) {
        Intrinsics.checkParameterIsNotNull((Object)px, (String)"<set-?>");
        this.defaultWidth = px;
    }

    @NotNull
    public final Px getDefaultHeight() {
        return this.defaultHeight;
    }

    public final void setDefaultHeight(@NotNull Px px) {
        Intrinsics.checkParameterIsNotNull((Object)px, (String)"<set-?>");
        this.defaultHeight = px;
    }

    public VectorComponent(@NotNull String name, float viewportWidth, float viewportHeight, @NotNull Px defaultWidth, @NotNull Px defaultHeight) {
        GroupComponent groupComponent;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)defaultWidth, (String)"defaultWidth");
        Intrinsics.checkParameterIsNotNull((Object)defaultHeight, (String)"defaultHeight");
        super(null);
        this.name = name;
        this.viewportWidth = viewportWidth;
        this.viewportHeight = viewportHeight;
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
        GroupComponent groupComponent2 = new GroupComponent(this.name);
        VectorComponent vectorComponent = this;
        boolean bl = false;
        boolean bl2 = false;
        GroupComponent $this$apply = groupComponent2;
        boolean bl3 = false;
        $this$apply.setPivotX(0.0f);
        $this$apply.setPivotY(0.0f);
        $this$apply.setScaleX(this.defaultWidth.getValue() / this.viewportWidth);
        $this$apply.setScaleY(this.defaultHeight.getValue() / this.viewportHeight);
        $this$apply.setInvalidateListener((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ VectorComponent this$0;
            {
                this.this$0 = vectorComponent;
                super(0);
            }

            public final void invoke() {
                VectorComponent.access$setDirty$p(this.this$0, true);
            }
        }));
        vectorComponent.root = groupComponent = groupComponent2;
        this.isDirty = true;
    }

    public /* synthetic */ VectorComponent(String string, float f, float f2, Px px, Px px2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        this(string, f, f2, px, px2);
    }

    public static final /* synthetic */ boolean access$isDirty$p(VectorComponent $this) {
        return $this.isDirty;
    }

    public static final /* synthetic */ void access$setDirty$p(VectorComponent $this, boolean bl) {
        $this.isDirty = bl;
    }
}

