/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector;

import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Brush;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.PaintingStyle;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.StrokeCap;
import androidx.ui.graphics.StrokeJoin;
import androidx.ui.graphics.vector.PathNode;
import androidx.ui.graphics.vector.PathParser;
import androidx.ui.graphics.vector.VNode;
import androidx.ui.graphics.vector.VectorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\b\u0010=\u001a\u00020\u0012H\u0002J\b\u0010>\u001a\u00020\u0012H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\u0013\u0010C\u001a\u00020\u00142\b\u0010D\u001a\u0004\u0018\u00010EH\u00d6\u0003J\t\u0010F\u001a\u00020GH\u00d6\u0001J\b\u0010H\u001a\u00020\u0003H\u0016J!\u0010I\u001a\u00020@2\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020@0K\u00a2\u0006\u0002\bLH\u0002J\b\u0010M\u001a\u00020@H\u0002J\"\u0010N\u001a\u00020@2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020@0K\u00a2\u0006\u0002\bLH\u0082\bR(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R(\u0010\"\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR$\u0010%\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010\u0010R$\u0010)\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010/\u001a\u00020.2\u0006\u0010\u0004\u001a\u00020.@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00104\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u000e\"\u0004\b6\u0010\u0010R$\u00107\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u000e\"\u0004\b9\u0010\u0010R\u0010\u0010:\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Landroidx/ui/graphics/vector/PathComponent;", "Landroidx/ui/graphics/vector/VNode;", "name", "", "value", "Landroidx/ui/graphics/Brush;", "fill", "getFill", "()Landroidx/ui/graphics/Brush;", "setFill", "(Landroidx/ui/graphics/Brush;)V", "", "fillAlpha", "getFillAlpha", "()F", "setFillAlpha", "(F)V", "fillPaint", "Landroidx/ui/graphics/Paint;", "isPathDirty", "", "getName", "()Ljava/lang/String;", "parser", "Landroidx/ui/graphics/vector/PathParser;", "path", "Landroidx/ui/graphics/Path;", "", "Landroidx/ui/graphics/vector/PathNode;", "pathData", "getPathData", "()Ljava/util/List;", "setPathData", "(Ljava/util/List;)V", "stroke", "getStroke", "setStroke", "strokeAlpha", "getStrokeAlpha", "setStrokeAlpha", "Landroidx/ui/graphics/StrokeCap;", "strokeLineCap", "getStrokeLineCap", "()Landroidx/ui/graphics/StrokeCap;", "setStrokeLineCap", "(Landroidx/ui/graphics/StrokeCap;)V", "Landroidx/ui/graphics/StrokeJoin;", "strokeLineJoin", "getStrokeLineJoin", "()Landroidx/ui/graphics/StrokeJoin;", "setStrokeLineJoin", "(Landroidx/ui/graphics/StrokeJoin;)V", "strokeLineMiter", "getStrokeLineMiter", "setStrokeLineMiter", "strokeLineWidth", "getStrokeLineWidth", "setStrokeLineWidth", "strokePaint", "component1", "copy", "createFillPaint", "createStrokePaint", "draw", "", "canvas", "Landroidx/ui/graphics/Canvas;", "equals", "other", "", "hashCode", "", "toString", "updateFillPaint", "fillPaintUpdater", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "updatePath", "updateStrokePaint", "strokePaintUpdater", "ui-vector_release"})
public final class PathComponent
extends VNode {
    private final String name;
    private Brush fill;
    private float fillAlpha;
    private List<? extends PathNode> pathData;
    private float strokeAlpha;
    private float strokeLineWidth;
    private Brush stroke;
    private StrokeCap strokeLineCap;
    private StrokeJoin strokeLineJoin;
    private float strokeLineMiter;
    private boolean isPathDirty;
    private final Path path;
    private Paint fillPaint;
    private Paint strokePaint;
    private final PathParser parser;

    public PathComponent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null);
        this.name = name;
        this.fillAlpha = 1.0f;
        this.pathData = VectorKt.getEmptyPath();
        this.strokeAlpha = 1.0f;
        this.strokeLineCap = VectorKt.getDefaultStrokeLineCap();
        this.strokeLineJoin = VectorKt.getDefaultStrokeLineJoin();
        this.strokeLineMiter = 4.0f;
        this.isPathDirty = true;
        this.path = AndroidPathKt.Path();
        this.parser = new PathParser();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Brush getFill() {
        return this.fill;
    }

    public final void setFill(@Nullable Brush value) {
        if (!Intrinsics.areEqual((Object)this.fill, (Object)value)) {
            this.fill = value;
            this.updateFillPaint((Function1<? super Paint, Unit>)((Function1)new Function1<Paint, Unit>(this){
                private final /* synthetic */ PathComponent $this;
                {
                    this.$this = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Paint paint) {
                    Intrinsics.checkNotNullParameter((Object)paint, (String)"<this>");
                    Brush brush = PathComponent.access$getFill$p(this.$this);
                    if (brush != null) {
                        brush.applyTo(paint);
                    }
                }
            }));
            this.invalidate();
        }
    }

    public final float getFillAlpha() {
        return this.fillAlpha;
    }

    public final void setFillAlpha(float value) {
        if (!(this.fillAlpha == value)) {
            this.fillAlpha = value;
            this.updateFillPaint((Function1<? super Paint, Unit>)((Function1)new Function1<Paint, Unit>(this){
                private final /* synthetic */ PathComponent $this;
                {
                    this.$this = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Paint paint) {
                    Intrinsics.checkNotNullParameter((Object)paint, (String)"<this>");
                    paint.setAlpha(PathComponent.access$getFillAlpha$p(this.$this));
                }
            }));
            this.invalidate();
        }
    }

    @NotNull
    public final List<PathNode> getPathData() {
        return this.pathData;
    }

    public final void setPathData(@NotNull List<? extends PathNode> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.pathData, value)) {
            this.pathData = value;
            this.isPathDirty = true;
            this.invalidate();
        }
    }

    public final float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public final void setStrokeAlpha(float value) {
        if (!(this.strokeAlpha == value)) {
            this.strokeAlpha = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$_set_strokeAlpha__u24lambda_u2d0 = paint;
                    boolean bl = false;
                    $this$_set_strokeAlpha__u24lambda_u2d0.setAlpha(this.strokeAlpha);
                }
            }
            this.invalidate();
        }
    }

    public final float getStrokeLineWidth() {
        return this.strokeLineWidth;
    }

    public final void setStrokeLineWidth(float value) {
        if (!(this.strokeLineWidth == value)) {
            this.strokeLineWidth = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$_set_strokeLineWidth__u24lambda_u2d1 = paint;
                    boolean bl = false;
                    $this$_set_strokeLineWidth__u24lambda_u2d1.setStrokeWidth(this.strokeLineWidth);
                }
            }
            this.invalidate();
        }
    }

    @Nullable
    public final Brush getStroke() {
        return this.stroke;
    }

    public final void setStroke(@Nullable Brush value) {
        if (!Intrinsics.areEqual((Object)this.stroke, (Object)value)) {
            this.stroke = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$_set_stroke__u24lambda_u2d2 = paint;
                    boolean bl = false;
                    Brush brush = this.stroke;
                    if (brush != null) {
                        brush.applyTo($this$_set_stroke__u24lambda_u2d2);
                    }
                }
            }
            this.invalidate();
        }
    }

    @NotNull
    public final StrokeCap getStrokeLineCap() {
        return this.strokeLineCap;
    }

    public final void setStrokeLineCap(@NotNull StrokeCap value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.strokeLineCap, (Object)value)) {
            this.strokeLineCap = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$_set_strokeLineCap__u24lambda_u2d3 = paint;
                    boolean bl = false;
                    $this$_set_strokeLineCap__u24lambda_u2d3.setStrokeCap(this.strokeLineCap);
                }
            }
            this.invalidate();
        }
    }

    @NotNull
    public final StrokeJoin getStrokeLineJoin() {
        return this.strokeLineJoin;
    }

    public final void setStrokeLineJoin(@NotNull StrokeJoin value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)this.strokeLineJoin, (Object)value)) {
            this.strokeLineJoin = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$_set_strokeLineJoin__u24lambda_u2d4 = paint;
                    boolean bl = false;
                    $this$_set_strokeLineJoin__u24lambda_u2d4.setStrokeJoin(this.strokeLineJoin);
                }
            }
            this.invalidate();
        }
    }

    public final float getStrokeLineMiter() {
        return this.strokeLineMiter;
    }

    public final void setStrokeLineMiter(float value) {
        if (!(this.strokeLineMiter == value)) {
            this.strokeLineMiter = value;
            PathComponent this_$iv = this;
            boolean $i$f$updateStrokePaint = false;
            if (this_$iv.strokePaint == null) {
                this_$iv.strokePaint = this_$iv.createStrokePaint();
            } else {
                Paint paint = this_$iv.strokePaint;
                if (paint != null) {
                    Paint $this$_set_strokeLineMiter__u24lambda_u2d5 = paint;
                    boolean bl = false;
                    $this$_set_strokeLineMiter__u24lambda_u2d5.setStrokeMiterLimit(this.strokeLineMiter);
                }
            }
            this.invalidate();
        }
    }

    private final void updateStrokePaint(Function1<? super Paint, Unit> strokePaintUpdater) {
        boolean $i$f$updateStrokePaint = false;
        if (this.strokePaint == null) {
            this.strokePaint = this.createStrokePaint();
        } else {
            Paint paint = this.strokePaint;
            if (paint != null) {
                strokePaintUpdater.invoke((Object)paint);
            }
        }
    }

    private final Paint createStrokePaint() {
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$createStrokePaint_u24lambda_u2d6 = paint;
        boolean bl3 = false;
        $this$createStrokePaint_u24lambda_u2d6.setAntiAlias(true);
        $this$createStrokePaint_u24lambda_u2d6.setStyle(PaintingStyle.stroke);
        $this$createStrokePaint_u24lambda_u2d6.setAlpha(this.getStrokeAlpha());
        $this$createStrokePaint_u24lambda_u2d6.setStrokeWidth(this.getStrokeLineWidth());
        $this$createStrokePaint_u24lambda_u2d6.setStrokeCap(this.getStrokeLineCap());
        $this$createStrokePaint_u24lambda_u2d6.setStrokeJoin(this.getStrokeLineJoin());
        $this$createStrokePaint_u24lambda_u2d6.setStrokeMiterLimit(this.getStrokeLineMiter());
        Brush brush = this.getStroke();
        if (brush != null) {
            brush.applyTo($this$createStrokePaint_u24lambda_u2d6);
        }
        return paint;
    }

    private final void updateFillPaint(Function1<? super Paint, Unit> fillPaintUpdater) {
        if (this.fillPaint == null) {
            this.fillPaint = this.createFillPaint();
        } else {
            Paint paint = this.fillPaint;
            if (paint != null) {
                fillPaintUpdater.invoke((Object)paint);
            }
        }
    }

    private final Paint createFillPaint() {
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$createFillPaint_u24lambda_u2d7 = paint;
        boolean bl3 = false;
        $this$createFillPaint_u24lambda_u2d7.setAntiAlias(true);
        $this$createFillPaint_u24lambda_u2d7.setAlpha(this.getFillAlpha());
        $this$createFillPaint_u24lambda_u2d7.setStyle(PaintingStyle.fill);
        Brush brush = this.getFill();
        if (brush != null) {
            brush.applyTo($this$createFillPaint_u24lambda_u2d7);
        }
        return paint;
    }

    private final void updatePath() {
        this.parser.clear();
        this.path.reset();
        this.parser.addPathNodes(this.getPathData()).toPath(this.path);
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Brush strokeBrush;
        Brush fillBrush;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.isPathDirty) {
            this.updatePath();
            this.isPathDirty = false;
        }
        if ((fillBrush = this.getFill()) != null) {
            Paint targetFillPaint = this.fillPaint;
            if (targetFillPaint == null) {
                this.fillPaint = targetFillPaint = this.createFillPaint();
            }
            canvas.drawPath(this.path, targetFillPaint);
        }
        if ((strokeBrush = this.getStroke()) != null) {
            Paint targetStrokePaint = this.strokePaint;
            if (targetStrokePaint == null) {
                this.strokePaint = targetStrokePaint = this.createStrokePaint();
            }
            canvas.drawPath(this.path, targetStrokePaint);
        }
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.path);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final PathComponent copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new PathComponent(name);
    }

    public static /* synthetic */ PathComponent copy$default(PathComponent this_, String name, int n, Object object) {
        if ((n & 1) != 0) {
            name = this_.name;
        }
        return this_.copy(name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathComponent)) {
            return false;
        }
        Object object = other;
        PathComponent pathComponent = (PathComponent)object;
        return Intrinsics.areEqual((Object)this.name, (Object)pathComponent.name);
    }

    public static final /* synthetic */ Brush access$getFill$p(PathComponent pathComponent) {
        return pathComponent.fill;
    }

    public static final /* synthetic */ float access$getFillAlpha$p(PathComponent pathComponent) {
        return pathComponent.fillAlpha;
    }
}

