/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.graphics.vector;

import android.graphics.Matrix;
import androidx.ui.graphics.AndroidPathKt;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.vector.PathNode;
import androidx.ui.graphics.vector.PathParser;
import androidx.ui.graphics.vector.VNode;
import androidx.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B\n\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003J\t\u0010?\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020CH\u0016J\u0013\u0010D\u001a\u00020\u001a2\b\u0010E\u001a\u0004\u0018\u00010FH\u00d6\u0003J\t\u0010G\u001a\u000203H\u00d6\u0001J\u0016\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u0002032\u0006\u0010J\u001a\u00020\u0001J\u001e\u0010K\u001a\u00020\u00132\u0006\u0010L\u001a\u0002032\u0006\u0010M\u001a\u0002032\u0006\u0010N\u001a\u000203J\u0016\u0010O\u001a\u00020\u00132\u0006\u0010I\u001a\u0002032\u0006\u0010N\u001a\u000203J\b\u0010P\u001a\u00020\u0003H\u0016J\b\u0010Q\u001a\u00020\u0013H\u0002J\b\u0010R\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R$\u0010)\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R$\u0010,\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R$\u0010/\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010#\"\u0004\b1\u0010%R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R$\u00106\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010#\"\u0004\b8\u0010%R$\u00109\u001a\u00020 2\u0006\u0010\b\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010#\"\u0004\b;\u0010%R\u0014\u0010<\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006S"}, d2={"Landroidx/ui/graphics/vector/GroupComponent;", "Landroidx/ui/graphics/vector/VNode;", "name", "", "children", "", "clipPath", "Landroidx/ui/graphics/Path;", "value", "", "Landroidx/ui/graphics/vector/PathNode;", "clipPathData", "getClipPathData", "()Ljava/util/List;", "setClipPathData", "(Ljava/util/List;)V", "groupMatrix", "Landroid/graphics/Matrix;", "Lkotlin/Function0;", "", "invalidateListener", "getInvalidateListener", "()Lkotlin/jvm/functions/Function0;", "setInvalidateListener", "(Lkotlin/jvm/functions/Function0;)V", "isClipPathDirty", "", "isMatrixDirty", "getName", "()Ljava/lang/String;", "parser", "Landroidx/ui/graphics/vector/PathParser;", "", "pivotX", "getPivotX", "()F", "setPivotX", "(F)V", "pivotY", "getPivotY", "setPivotY", "rotation", "getRotation", "setRotation", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "size", "", "getSize", "()I", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "willClipPath", "getWillClipPath", "()Z", "component1", "copy", "draw", "canvas", "Landroidx/ui/graphics/Canvas;", "equals", "other", "", "hashCode", "insertAt", "index", "instance", "move", "from", "to", "count", "remove", "toString", "updateClipPath", "updateMatrix", "ui-vector_release"})
public final class GroupComponent
extends VNode {
    private final String name;
    private Matrix groupMatrix;
    private final List<VNode> children;
    private List<? extends PathNode> clipPathData;
    private boolean isClipPathDirty;
    private Path clipPath;
    private PathParser parser;
    private Function0<Unit> invalidateListener;
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX;
    private float scaleY;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty;

    public GroupComponent(@NotNull String name) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null);
        this.name = name;
        GroupComponent groupComponent = this;
        boolean bl = false;
        groupComponent.children = list = (List)new ArrayList();
        this.clipPathData = VectorKt.getEmptyPath();
        this.isClipPathDirty = true;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.isMatrixDirty = true;
    }

    public /* synthetic */ GroupComponent(String name, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            name = "";
        }
        this(name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<PathNode> getClipPathData() {
        return this.clipPathData;
    }

    public final void setClipPathData(@NotNull List<? extends PathNode> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.clipPathData, value)) {
            this.clipPathData = value;
            this.isClipPathDirty = true;
            this.invalidate();
        }
    }

    private final boolean getWillClipPath() {
        Collection collection = this.getClipPathData();
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    @Nullable
    public Function0<Unit> getInvalidateListener() {
        return this.invalidateListener;
    }

    @Override
    public void setInvalidateListener(@Nullable Function0<Unit> value) {
        this.invalidateListener = value;
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                VNode item$iv;
                int index$iv = n++;
                VNode child = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                child.setInvalidateListener(value);
            } while (n <= n2);
        }
    }

    private final void updateClipPath() {
        if (this.getWillClipPath()) {
            PathParser targetParser = this.parser;
            if (targetParser == null) {
                this.parser = targetParser = new PathParser();
            } else {
                targetParser.clear();
            }
            Path targetClip = this.clipPath;
            if (targetClip == null) {
                this.clipPath = targetClip = AndroidPathKt.Path();
            } else {
                targetClip.reset();
            }
            targetParser.addPathNodes(this.getClipPathData()).toPath(targetClip);
        }
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float value) {
        if (!(this.rotation == value)) {
            this.rotation = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getPivotX() {
        return this.pivotX;
    }

    public final void setPivotX(float value) {
        if (!(this.pivotX == value)) {
            this.pivotX = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getPivotY() {
        return this.pivotY;
    }

    public final void setPivotY(float value) {
        if (!(this.pivotY == value)) {
            this.pivotY = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float value) {
        if (!(this.scaleX == value)) {
            this.scaleX = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float value) {
        if (!(this.scaleY == value)) {
            this.scaleY = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float value) {
        if (!(this.translationX == value)) {
            this.translationX = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float value) {
        if (!(this.translationY == value)) {
            this.translationY = value;
            this.isMatrixDirty = true;
            this.invalidate();
        }
    }

    private final void updateMatrix() {
        Matrix matrix;
        Matrix target = this.groupMatrix;
        if (target == null) {
            this.groupMatrix = matrix = new Matrix();
        } else {
            matrix = target;
        }
        boolean bl = false;
        boolean bl2 = false;
        Matrix $this$updateMatrix_u24lambda_u2d1 = matrix;
        boolean bl3 = false;
        $this$updateMatrix_u24lambda_u2d1.reset();
        $this$updateMatrix_u24lambda_u2d1.postTranslate(-this.getPivotX(), -this.getPivotY());
        $this$updateMatrix_u24lambda_u2d1.postScale(this.getScaleX(), this.getScaleY());
        $this$updateMatrix_u24lambda_u2d1.postRotate(this.getRotation(), 0.0f, 0.0f);
        $this$updateMatrix_u24lambda_u2d1.postTranslate(this.getTranslationX() + this.getPivotX(), this.getTranslationY() + this.getPivotY());
    }

    public final void insertAt(int index, @NotNull VNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (index < this.getSize()) {
            this.children.set(index, instance);
        } else {
            this.children.add(instance);
        }
        instance.setInvalidateListener(this.getInvalidateListener());
        this.invalidate();
    }

    public final void move(int from, int to, int count) {
        if (from > to) {
            Ref.IntRef current = new Ref.IntRef();
            current.element = to;
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = count;
            while (n < n2) {
                int it = n++;
                boolean bl2 = false;
                VNode node = this.children.get(from);
                this.children.remove(from);
                this.children.add(current.element, node);
                int n3 = current.element;
                current.element = n3 + 1;
            }
        } else {
            boolean bl = false;
            int n = 0;
            n = 0;
            int n4 = count;
            while (n < n4) {
                int it = n++;
                boolean bl3 = false;
                VNode node = this.children.get(from);
                this.children.remove(from);
                this.children.add(to - 1, node);
            }
        }
        this.invalidate();
    }

    public final void remove(int index, int count) {
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = count;
        while (n < n2) {
            int it = n++;
            boolean bl2 = false;
            this.children.get(index).setInvalidateListener((Function0<Unit>)((Function0)null));
            this.children.remove(index);
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.isMatrixDirty) {
            this.updateMatrix();
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            this.updateClipPath();
            this.isClipPathDirty = false;
        }
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        try {
            Matrix matrix;
            $this$withSave$iv.save();
            boolean bl = false;
            Path targetClip = this.clipPath;
            if (this.getWillClipPath() && targetClip != null) {
                Canvas.DefaultImpls.clipPath$default((Canvas)canvas, (Path)targetClip, null, (int)2, null);
            }
            if ((matrix = this.groupMatrix) != null) {
                canvas.getNativeCanvas().concat(matrix);
            }
            List<VNode> $this$fastForEach$iv = this.children;
            boolean $i$f$fastForEach = false;
            int n = 0;
            int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
            if (n <= n2) {
                do {
                    VNode item$iv;
                    int index$iv = n++;
                    VNode node = item$iv = $this$fastForEach$iv.get(index$iv);
                    boolean bl2 = false;
                    node.draw(canvas);
                } while (n <= n2);
            }
        }
        finally {
            $this$withSave$iv.restore();
        }
    }

    public final int getSize() {
        return this.children.size();
    }

    @NotNull
    public String toString() {
        CharSequence charSequence = new StringBuilder().append("VGroup: ").append(this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"StringBuilder().append(\"VGroup: \").append(name)");
        StringBuilder sb = charSequence;
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = 0;
        int n2 = ((Collection)$this$fastForEach$iv).size() + -1;
        if (n <= n2) {
            do {
                VNode item$iv;
                int index$iv = n++;
                VNode node = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                sb.append("\t").append(String.valueOf(node)).append("\n");
            } while (n <= n2);
        }
        charSequence = String.valueOf(sb);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final GroupComponent copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new GroupComponent(name);
    }

    public static /* synthetic */ GroupComponent copy$default(GroupComponent this_, String name, int n, Object object) {
        if ((n & 1) != 0) {
            name = this_.name;
        }
        return this_.copy(name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GroupComponent)) {
            return false;
        }
        Object object = other;
        GroupComponent groupComponent = (GroupComponent)object;
        return Intrinsics.areEqual((Object)this.name, (Object)groupComponent.name);
    }

    public GroupComponent() {
        this(null, 1, null);
    }
}

