/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.compose.materialcore;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006#"}, d2={"Landroidx/wear/compose/materialcore/PagesState;", "", "totalPages", "", "pagesOnScreen", "(II)V", "firstAlpha", "", "firstSize", "hiddenPagesToTheLeft", "lastAlpha", "lastButOneSize", "lastSize", "leftSpacerSizeRatio", "getLeftSpacerSizeRatio", "()F", "getPagesOnScreen", "()I", "rightSpacerSizeRatio", "getRightSpacerSizeRatio", "secondSize", "smoothProgress", "getTotalPages", "<set-?>", "visibleDotIndex", "getVisibleDotIndex", "alpha", "page", "calculateSelectedRatio", "targetPage", "offset", "recalculateState", "", "selectedPage", "sizeRatio", "compose-material-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class PagesState {
    private final int totalPages;
    private final int pagesOnScreen;
    private float firstAlpha;
    private float lastAlpha;
    private float firstSize;
    private float secondSize;
    private float lastSize;
    private float lastButOneSize;
    private float smoothProgress;
    private int hiddenPagesToTheLeft;
    private int visibleDotIndex;
    public static final int $stable = 8;

    public PagesState(int totalPages, int pagesOnScreen) {
        this.totalPages = totalPages;
        this.pagesOnScreen = pagesOnScreen;
        this.firstAlpha = 1.0f;
        this.firstSize = 1.0f;
        this.secondSize = 1.0f;
        this.lastSize = 1.0f;
        this.lastButOneSize = 1.0f;
    }

    public final int getTotalPages() {
        return this.totalPages;
    }

    public final int getPagesOnScreen() {
        return this.pagesOnScreen;
    }

    public final int getVisibleDotIndex() {
        return this.visibleDotIndex;
    }

    public final float getLeftSpacerSizeRatio() {
        return 1.0f - this.smoothProgress;
    }

    public final float getRightSpacerSizeRatio() {
        return this.smoothProgress;
    }

    public final float alpha(int page) {
        int n = page;
        return n == 0 ? this.firstAlpha : (n == this.pagesOnScreen ? this.lastAlpha : 1.0f);
    }

    public final float sizeRatio(int page) {
        int n = page;
        return n == 0 ? this.firstSize : (n == 1 ? this.secondSize : (n == this.pagesOnScreen - 1 ? this.lastButOneSize : (n == this.pagesOnScreen ? this.lastSize : 1.0f)));
    }

    public final float calculateSelectedRatio(int targetPage, float offset) {
        return RangesKt.coerceAtLeast((float)(1.0f - Math.abs((float)this.visibleDotIndex + offset - (float)targetPage)), (float)0.0f);
    }

    public final void recalculateState(int selectedPage, float offset) {
        float pageWithOffset = (float)selectedPage + offset;
        if (selectedPage > this.hiddenPagesToTheLeft + this.pagesOnScreen - 2) {
            this.hiddenPagesToTheLeft = RangesKt.coerceAtMost((int)(selectedPage - (this.pagesOnScreen - 2)), (int)(this.totalPages - this.pagesOnScreen));
        } else if (pageWithOffset <= (float)this.hiddenPagesToTheLeft) {
            this.hiddenPagesToTheLeft = RangesKt.coerceAtLeast((int)(selectedPage - 1), (int)0);
        }
        boolean scrolledToTheRight = pageWithOffset > (float)(this.hiddenPagesToTheLeft + this.pagesOnScreen - 2) && pageWithOffset < (float)(this.totalPages - 2);
        boolean scrolledToTheLeft = pageWithOffset > 1.0f && pageWithOffset < (float)(this.hiddenPagesToTheLeft + 1);
        this.smoothProgress = scrolledToTheLeft || scrolledToTheRight ? offset : 0.0f;
        this.firstAlpha = 1.0f - this.smoothProgress;
        this.lastAlpha = this.smoothProgress;
        this.secondSize = 1.0f - 0.5f * this.smoothProgress;
        this.firstSize = this.hiddenPagesToTheLeft == 0 || this.hiddenPagesToTheLeft == 1 && scrolledToTheLeft ? 1.0f - this.smoothProgress : 0.5f * (1.0f - this.smoothProgress);
        float f = this.lastSize = this.hiddenPagesToTheLeft == this.totalPages - this.pagesOnScreen - 1 && scrolledToTheRight || this.hiddenPagesToTheLeft == this.totalPages - this.pagesOnScreen && scrolledToTheLeft ? this.smoothProgress : 0.5f * this.smoothProgress;
        this.lastButOneSize = scrolledToTheRight || scrolledToTheLeft ? 0.5f * (1.0f + this.smoothProgress) : (this.hiddenPagesToTheLeft < this.totalPages - this.pagesOnScreen ? 0.5f : 1.0f);
        this.visibleDotIndex = scrolledToTheLeft ? 1 : selectedPage - this.hiddenPagesToTheLeft;
    }
}

