/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.material;

import android.content.Context;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.protolayout.proto.ModifiersProto;
import androidx.wear.tiles.ColorBuilders;
import androidx.wear.tiles.LayoutElementBuilders;
import androidx.wear.tiles.ModifiersBuilders;
import androidx.wear.tiles.material.Colors;
import androidx.wear.tiles.material.Helper;
import androidx.wear.tiles.material.Typography;

@Deprecated
public class Text
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG = "TXT";
    @NonNull
    private final LayoutElementBuilders.Text mText;

    Text(@NonNull LayoutElementBuilders.Text mText) {
        this.mText = mText;
    }

    @NonNull
    public String getText() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getText()).getValue());
    }

    @NonNull
    public ColorBuilders.ColorProp getColor() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getColor());
    }

    @NonNull
    public LayoutElementBuilders.FontStyle getFontStyle() {
        return Helper.checkNotNull(this.mText.getFontStyle());
    }

    public float getLineHeight() {
        return Helper.checkNotNull(this.mText.getLineHeight()).getValue();
    }

    public int getMaxLines() {
        return Helper.checkNotNull(this.mText.getMaxLines()).getValue();
    }

    public int getMultilineAlignment() {
        return Helper.checkNotNull(this.mText.getMultilineAlignment()).getValue();
    }

    @NonNull
    public ModifiersBuilders.Modifiers getModifiers() {
        return Helper.checkNotNull(this.mText.getModifiers());
    }

    public int getOverflow() {
        return Helper.checkNotNull(this.mText.getOverflow()).getValue();
    }

    public int getWeight() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getWeight()).getValue();
    }

    public boolean isItalic() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getItalic()).getValue();
    }

    public boolean isUnderline() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getUnderline()).getValue();
    }

    @NonNull
    String getMetadataTag() {
        return Helper.getMetadataTagName(Helper.checkNotNull(Helper.checkNotNull(this.getModifiers()).getMetadata()));
    }

    @Nullable
    public static Text fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof Text) {
            return (Text)element;
        }
        if (!(element instanceof LayoutElementBuilders.Text)) {
            return null;
        }
        LayoutElementBuilders.Text textElement = (LayoutElementBuilders.Text)element;
        if (!Helper.checkTag(textElement.getModifiers(), METADATA_TAG)) {
            return null;
        }
        return new Text(textElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mText.toLayoutElementProto();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final Context mContext;
        @NonNull
        private String mTextContent = "";
        @NonNull
        private ColorBuilders.ColorProp mColor = ColorBuilders.argb((int)Colors.DEFAULT.getOnPrimary());
        private int mTypographyName = 1;
        private boolean mItalic = false;
        private int mMaxLines = 1;
        private boolean mUnderline = false;
        private int mMultilineAlignment = 2;
        @NonNull
        private ModifiersBuilders.Modifiers mModifiers = new ModifiersBuilders.Modifiers.Builder().build();
        private int mOverflow = 2;
        private boolean mIsScalable = true;
        @Nullable
        private Integer mCustomWeight = null;

        public Builder(@NonNull Context context, @NonNull String text) {
            this.mContext = context;
            this.mTextContent = text;
        }

        @NonNull
        public Builder setTypography(int typography) {
            this.mTypographyName = typography;
            return this;
        }

        Builder setIsScalable(boolean isScalable) {
            this.mIsScalable = isScalable;
            return this;
        }

        @NonNull
        public Builder setColor(@NonNull ColorBuilders.ColorProp color) {
            this.mColor = color;
            return this;
        }

        @NonNull
        public Builder setItalic(boolean italic) {
            this.mItalic = italic;
            return this;
        }

        @NonNull
        public Builder setUnderline(boolean underline) {
            this.mUnderline = underline;
            return this;
        }

        @NonNull
        public Builder setMaxLines(@IntRange(from=1L) int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        @NonNull
        public Builder setMultilineAlignment(int multilineAlignment) {
            this.mMultilineAlignment = multilineAlignment;
            return this;
        }

        @NonNull
        public Builder setModifiers(@NonNull ModifiersBuilders.Modifiers modifiers) {
            this.mModifiers = modifiers;
            return this;
        }

        @NonNull
        public Builder setOverflow(int overflow) {
            this.mOverflow = overflow;
            return this;
        }

        @NonNull
        public Builder setWeight(int weight) {
            this.mCustomWeight = weight;
            return this;
        }

        @NonNull
        public Text build() {
            LayoutElementBuilders.FontStyle.Builder fontStyleBuilder = Typography.getFontStyleBuilder(this.mTypographyName, this.mContext, this.mIsScalable).setColor(this.mColor).setItalic(this.mItalic).setUnderline(this.mUnderline);
            if (this.mCustomWeight != null) {
                fontStyleBuilder.setWeight(this.mCustomWeight.intValue());
            }
            LayoutElementBuilders.Text.Builder text = new LayoutElementBuilders.Text.Builder().setText(this.mTextContent).setFontStyle(fontStyleBuilder.build()).setLineHeight(Typography.getLineHeightForTypography(this.mTypographyName)).setMaxLines(this.mMaxLines).setMultilineAlignment(this.mMultilineAlignment).setModifiers(Builder.addTagToModifiers(this.mModifiers)).setOverflow(this.mOverflow);
            return new Text(text.build());
        }

        @NonNull
        static ModifiersBuilders.Modifiers addTagToModifiers(ModifiersBuilders.Modifiers modifiers) {
            return ModifiersBuilders.Modifiers.fromProto((ModifiersProto.Modifiers)((ModifiersProto.Modifiers)ModifiersProto.Modifiers.newBuilder((ModifiersProto.Modifiers)modifiers.toProto()).setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(Helper.getTagBytes(Text.METADATA_TAG)).build().toProto()).build()));
        }
    }
}

