/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.material.layouts;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.tiles.DeviceParametersBuilders;
import androidx.wear.tiles.DimensionBuilders;
import androidx.wear.tiles.LayoutElementBuilders;
import androidx.wear.tiles.ModifiersBuilders;
import androidx.wear.tiles.material.CircularProgressIndicator;
import androidx.wear.tiles.material.Helper;
import androidx.wear.tiles.material.ProgressIndicatorDefaults;
import java.util.Arrays;
import java.util.List;

@Deprecated
public class EdgeContentLayout
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG_PREFIX = "ECL_";
    static final int FLAG_INDEX = "ECL_".length();
    static final byte[] METADATA_TAG_BASE = Arrays.copyOf(Helper.getTagBytes("ECL_"), FLAG_INDEX + 1);
    static final int EDGE_CONTENT_PRESENT = 1;
    static final int PRIMARY_LABEL_PRESENT = 2;
    static final int SECONDARY_LABEL_PRESENT = 4;
    static final int CONTENT_PRESENT = 8;
    @NonNull
    private final LayoutElementBuilders.Box mImpl;
    @NonNull
    private final List<LayoutElementBuilders.LayoutElement> mContents;
    @NonNull
    private final List<LayoutElementBuilders.LayoutElement> mInnerColumn;

    EdgeContentLayout(@NonNull LayoutElementBuilders.Box layoutElement) {
        this.mImpl = layoutElement;
        this.mContents = this.mImpl.getContents();
        this.mInnerColumn = ((LayoutElementBuilders.Column)((LayoutElementBuilders.Box)this.mContents.get(0)).getContents().get(0)).getContents();
    }

    private boolean areElementsPresent(int elementFlag) {
        return (this.getMetadataTag()[FLAG_INDEX] & elementFlag) == elementFlag;
    }

    @NonNull
    byte[] getMetadataTag() {
        return Helper.getMetadataTagBytes(Helper.checkNotNull(Helper.checkNotNull(this.mImpl.getModifiers()).getMetadata()));
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getContent() {
        if (!this.areElementsPresent(8)) {
            return null;
        }
        int contentPosition = this.areElementsPresent(2) ? 2 : 0;
        return (LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)this.mInnerColumn.get(contentPosition)).getContents().get(0);
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getPrimaryLabelTextContent() {
        if (!this.areElementsPresent(2)) {
            return null;
        }
        return this.mInnerColumn.get(0);
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getSecondaryLabelTextContent() {
        if (!this.areElementsPresent(4)) {
            return null;
        }
        return this.mInnerColumn.get(this.mInnerColumn.size() - 1);
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getEdgeContent() {
        if (this.areElementsPresent(1)) {
            return this.mContents.get(1);
        }
        return null;
    }

    @Nullable
    public static EdgeContentLayout fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof EdgeContentLayout) {
            return (EdgeContentLayout)element;
        }
        if (!(element instanceof LayoutElementBuilders.Box)) {
            return null;
        }
        LayoutElementBuilders.Box boxElement = (LayoutElementBuilders.Box)element;
        if (!Helper.checkTag(boxElement.getModifiers(), METADATA_TAG_PREFIX, METADATA_TAG_BASE)) {
            return null;
        }
        return new EdgeContentLayout(boxElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mImpl.toLayoutElementProto();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final DeviceParametersBuilders.DeviceParameters mDeviceParameters;
        @Nullable
        private LayoutElementBuilders.LayoutElement mEdgeContent = null;
        @Nullable
        private LayoutElementBuilders.LayoutElement mPrimaryLabelText = null;
        @Nullable
        private LayoutElementBuilders.LayoutElement mSecondaryLabelText = null;
        @Nullable
        private LayoutElementBuilders.LayoutElement mContent = null;
        private byte mMetadataContentByte = 0;

        public Builder(@NonNull DeviceParametersBuilders.DeviceParameters deviceParameters) {
            this.mDeviceParameters = deviceParameters;
        }

        @NonNull
        public Builder setEdgeContent(@NonNull LayoutElementBuilders.LayoutElement edgeContent) {
            this.mEdgeContent = edgeContent;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 1);
            return this;
        }

        @NonNull
        public Builder setPrimaryLabelTextContent(@NonNull LayoutElementBuilders.LayoutElement primaryLabelText) {
            this.mPrimaryLabelText = primaryLabelText;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 2);
            return this;
        }

        @NonNull
        public Builder setSecondaryLabelTextContent(@NonNull LayoutElementBuilders.LayoutElement secondaryLabelText) {
            this.mSecondaryLabelText = secondaryLabelText;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 4);
            return this;
        }

        @NonNull
        public Builder setContent(@NonNull LayoutElementBuilders.LayoutElement content) {
            this.mContent = content;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 8);
            return this;
        }

        @NonNull
        public EdgeContentLayout build() {
            float thicknessDp = this.mEdgeContent instanceof CircularProgressIndicator ? ((CircularProgressIndicator)this.mEdgeContent).getStrokeWidth().getValue() : 0.0f;
            float horizontalPaddingDp = Helper.isRoundDevice(this.mDeviceParameters) ? 14.0f : 16.0f;
            float indicatorWidth = 2.0f * (thicknessDp + ProgressIndicatorDefaults.DEFAULT_PADDING.getValue());
            float mainContentHeightDp = (float)this.mDeviceParameters.getScreenHeightDp() - indicatorWidth;
            float mainContentWidthDp = (float)this.mDeviceParameters.getScreenWidthDp() - indicatorWidth;
            DimensionBuilders.DpProp mainContentHeight = DimensionBuilders.dp((float)Math.min(mainContentHeightDp, mainContentWidthDp));
            DimensionBuilders.DpProp mainContentWidth = DimensionBuilders.dp((float)Math.min(mainContentHeightDp, mainContentWidthDp));
            ModifiersBuilders.Modifiers modifiers = new ModifiersBuilders.Modifiers.Builder().setPadding(new ModifiersBuilders.Padding.Builder().setStart(DimensionBuilders.dp((float)horizontalPaddingDp)).setEnd(DimensionBuilders.dp((float)horizontalPaddingDp)).build()).build();
            byte[] metadata = (byte[])METADATA_TAG_BASE.clone();
            metadata[EdgeContentLayout.FLAG_INDEX] = this.mMetadataContentByte;
            LayoutElementBuilders.Box.Builder mainBoxBuilder = new LayoutElementBuilders.Box.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setModifiers(new ModifiersBuilders.Modifiers.Builder().setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(metadata).build()).build()).setHorizontalAlignment(2).setVerticalAlignment(2);
            LayoutElementBuilders.Column.Builder innerContentBuilder = new LayoutElementBuilders.Column.Builder().setHorizontalAlignment(2);
            if (this.mPrimaryLabelText != null) {
                innerContentBuilder.addContent(this.mPrimaryLabelText);
                innerContentBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Spacer.Builder().setHeight((DimensionBuilders.SpacerDimension)DimensionBuilders.dp((float)6.0f)).build());
            }
            if (this.mContent != null) {
                innerContentBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Box.Builder().setVerticalAlignment(2).addContent(this.mContent).build());
            }
            if (this.mSecondaryLabelText != null) {
                innerContentBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Spacer.Builder().setHeight((DimensionBuilders.SpacerDimension)DimensionBuilders.dp((float)8.0f)).build());
                innerContentBuilder.addContent(this.mSecondaryLabelText);
            }
            mainBoxBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Box.Builder().setModifiers(modifiers).setVerticalAlignment(2).setHorizontalAlignment(2).setHeight((DimensionBuilders.ContainerDimension)mainContentHeight).setWidth((DimensionBuilders.ContainerDimension)mainContentWidth).addContent((LayoutElementBuilders.LayoutElement)innerContentBuilder.build()).build());
            if (this.mEdgeContent != null) {
                mainBoxBuilder.addContent(this.mEdgeContent);
            }
            return new EdgeContentLayout(mainBoxBuilder.build());
        }
    }
}

