/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.material.layouts;

import android.annotation.SuppressLint;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.tiles.DeviceParametersBuilders;
import androidx.wear.tiles.DimensionBuilders;
import androidx.wear.tiles.LayoutElementBuilders;
import androidx.wear.tiles.ModifiersBuilders;
import androidx.wear.tiles.material.ChipDefaults;
import androidx.wear.tiles.material.Helper;
import androidx.wear.tiles.material.layouts.LayoutDefaults;
import java.util.Arrays;
import java.util.List;

@Deprecated
public class PrimaryLayout
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG_PREFIX = "PL_";
    static final int FLAG_INDEX = "PL_".length();
    static final byte[] METADATA_TAG_BASE = Arrays.copyOf(Helper.getTagBytes("PL_"), FLAG_INDEX + 1);
    static final int CHIP_PRESENT = 1;
    static final int PRIMARY_LABEL_PRESENT = 2;
    static final int SECONDARY_LABEL_PRESENT = 4;
    static final int CONTENT_PRESENT = 8;
    static final int PRIMARY_LABEL_POSITION = 1;
    static final int CONTENT_ONLY_POSITION = 0;
    static final int PRIMARY_CHIP_POSITION = 1;
    @NonNull
    private final LayoutElementBuilders.Box mImpl;
    @NonNull
    private final List<LayoutElementBuilders.LayoutElement> mAllContent;
    @NonNull
    private final List<LayoutElementBuilders.LayoutElement> mPrimaryLabel;
    @NonNull
    private final List<LayoutElementBuilders.LayoutElement> mContentAndSecondaryLabel;

    PrimaryLayout(@NonNull LayoutElementBuilders.Box layoutElement) {
        this.mImpl = layoutElement;
        this.mAllContent = ((LayoutElementBuilders.Column)layoutElement.getContents().get(0)).getContents();
        List innerContent = ((LayoutElementBuilders.Column)this.mAllContent.get(0)).getContents();
        this.mPrimaryLabel = ((LayoutElementBuilders.Column)innerContent.get(0)).getContents();
        this.mContentAndSecondaryLabel = ((LayoutElementBuilders.Column)((LayoutElementBuilders.Box)innerContent.get(1)).getContents().get(0)).getContents();
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getPrimaryLabelTextContent() {
        if (!this.areElementsPresent(2)) {
            return null;
        }
        return this.mPrimaryLabel.get(1);
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getSecondaryLabelTextContent() {
        if (!this.areElementsPresent(4)) {
            return null;
        }
        return this.mContentAndSecondaryLabel.get(this.mContentAndSecondaryLabel.size() - 1);
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getContent() {
        if (!this.areElementsPresent(8)) {
            return null;
        }
        return (LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)this.mContentAndSecondaryLabel.get(0)).getContents().get(0);
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getPrimaryChipContent() {
        if (this.areElementsPresent(1)) {
            return (LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)this.mAllContent.get(1)).getContents().get(0);
        }
        return null;
    }

    @SuppressLint(value={"ResourceType"})
    @Dimension(unit=0)
    public float getVerticalSpacerHeight() {
        DimensionBuilders.SpacerDimension height;
        LayoutElementBuilders.LayoutElement element;
        if (this.areElementsPresent(4) && (element = this.mContentAndSecondaryLabel.get(1)) instanceof LayoutElementBuilders.Spacer && (height = ((LayoutElementBuilders.Spacer)element).getHeight()) instanceof DimensionBuilders.DpProp) {
            return ((DimensionBuilders.DpProp)height).getValue();
        }
        return LayoutDefaults.DEFAULT_VERTICAL_SPACER_HEIGHT.getValue();
    }

    private boolean areElementsPresent(int elementFlag) {
        return (this.getMetadataTag()[FLAG_INDEX] & elementFlag) == elementFlag;
    }

    @NonNull
    byte[] getMetadataTag() {
        return Helper.getMetadataTagBytes(Helper.checkNotNull(Helper.checkNotNull(this.mImpl.getModifiers()).getMetadata()));
    }

    @Nullable
    public static PrimaryLayout fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof PrimaryLayout) {
            return (PrimaryLayout)element;
        }
        if (!(element instanceof LayoutElementBuilders.Box)) {
            return null;
        }
        LayoutElementBuilders.Box boxElement = (LayoutElementBuilders.Box)element;
        if (!Helper.checkTag(boxElement.getModifiers(), METADATA_TAG_PREFIX, METADATA_TAG_BASE)) {
            return null;
        }
        return new PrimaryLayout(boxElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mImpl.toLayoutElementProto();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final DeviceParametersBuilders.DeviceParameters mDeviceParameters;
        @Nullable
        private LayoutElementBuilders.LayoutElement mPrimaryChip = null;
        @Nullable
        private LayoutElementBuilders.LayoutElement mPrimaryLabelText = null;
        @Nullable
        private LayoutElementBuilders.LayoutElement mSecondaryLabelText = null;
        @NonNull
        private LayoutElementBuilders.LayoutElement mContent = new LayoutElementBuilders.Box.Builder().build();
        @NonNull
        private DimensionBuilders.DpProp mVerticalSpacerHeight = LayoutDefaults.DEFAULT_VERTICAL_SPACER_HEIGHT;
        private byte mMetadataContentByte = 0;

        public Builder(@NonNull DeviceParametersBuilders.DeviceParameters deviceParameters) {
            this.mDeviceParameters = deviceParameters;
        }

        @NonNull
        public Builder setPrimaryChipContent(@NonNull LayoutElementBuilders.LayoutElement compactChip) {
            this.mPrimaryChip = compactChip;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 1);
            return this;
        }

        @NonNull
        public Builder setPrimaryLabelTextContent(@NonNull LayoutElementBuilders.LayoutElement primaryLabelText) {
            this.mPrimaryLabelText = primaryLabelText;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 2);
            return this;
        }

        @NonNull
        public Builder setSecondaryLabelTextContent(@NonNull LayoutElementBuilders.LayoutElement secondaryLabelText) {
            this.mSecondaryLabelText = secondaryLabelText;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 4);
            return this;
        }

        @NonNull
        public Builder setContent(@NonNull LayoutElementBuilders.LayoutElement content) {
            this.mContent = content;
            this.mMetadataContentByte = (byte)(this.mMetadataContentByte | 8);
            return this;
        }

        @NonNull
        @SuppressLint(value={"ResourceType"})
        public Builder setVerticalSpacerHeight(@Dimension(unit=0) float height) {
            this.mVerticalSpacerHeight = DimensionBuilders.dp((float)height);
            return this;
        }

        @SuppressLint(value={"ResourceType"})
        @NonNull
        public PrimaryLayout build() {
            float topPadding = this.getTopPadding();
            float bottomPadding = this.getBottomPadding();
            float horizontalPadding = this.getHorizontalPadding();
            float horizontalChipPadding = this.getChipHorizontalPadding();
            float primaryChipHeight = this.mPrimaryChip != null ? ChipDefaults.COMPACT_HEIGHT_TAPPABLE.getValue() : 0.0f;
            DimensionBuilders.DpProp mainContentHeight = DimensionBuilders.dp((float)((float)this.mDeviceParameters.getScreenHeightDp() - primaryChipHeight - bottomPadding - topPadding));
            LayoutElementBuilders.Column.Builder layoutBuilder = new LayoutElementBuilders.Column.Builder();
            LayoutElementBuilders.Column.Builder contentAreaBuilder = new LayoutElementBuilders.Column.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)mainContentHeight).setHorizontalAlignment(2);
            LayoutElementBuilders.Column.Builder contentSecondaryLabelBuilder = new LayoutElementBuilders.Column.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setHorizontalAlignment(2);
            LayoutElementBuilders.Column.Builder primaryLabelBuilder = new LayoutElementBuilders.Column.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap());
            if (this.mPrimaryLabelText != null) {
                primaryLabelBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Spacer.Builder().setHeight((DimensionBuilders.SpacerDimension)this.getPrimaryLabelTopSpacerHeight()).build());
                primaryLabelBuilder.addContent(this.mPrimaryLabelText);
            }
            contentAreaBuilder.addContent((LayoutElementBuilders.LayoutElement)primaryLabelBuilder.build());
            contentSecondaryLabelBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Box.Builder().setVerticalAlignment(2).setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).addContent(this.mContent).build());
            if (this.mSecondaryLabelText != null) {
                contentSecondaryLabelBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Spacer.Builder().setHeight((DimensionBuilders.SpacerDimension)this.mVerticalSpacerHeight).build());
                contentSecondaryLabelBuilder.addContent(this.mSecondaryLabelText);
            }
            contentAreaBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Box.Builder().setVerticalAlignment(2).setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).addContent((LayoutElementBuilders.LayoutElement)contentSecondaryLabelBuilder.build()).build());
            layoutBuilder.setModifiers(new ModifiersBuilders.Modifiers.Builder().setPadding(new ModifiersBuilders.Padding.Builder().setStart(DimensionBuilders.dp((float)horizontalPadding)).setEnd(DimensionBuilders.dp((float)horizontalPadding)).setTop(DimensionBuilders.dp((float)topPadding)).setBottom(DimensionBuilders.dp((float)bottomPadding)).build()).build()).setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHorizontalAlignment(2);
            layoutBuilder.addContent((LayoutElementBuilders.LayoutElement)contentAreaBuilder.build());
            if (this.mPrimaryChip != null) {
                layoutBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Box.Builder().setVerticalAlignment(3).setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setModifiers(new ModifiersBuilders.Modifiers.Builder().setPadding(new ModifiersBuilders.Padding.Builder().setStart(DimensionBuilders.dp((float)horizontalChipPadding)).setEnd(DimensionBuilders.dp((float)horizontalChipPadding)).build()).build()).addContent(this.mPrimaryChip).build());
            }
            byte[] metadata = (byte[])METADATA_TAG_BASE.clone();
            metadata[PrimaryLayout.FLAG_INDEX] = this.mMetadataContentByte;
            LayoutElementBuilders.Box.Builder element = new LayoutElementBuilders.Box.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.expand()).setModifiers(new ModifiersBuilders.Modifiers.Builder().setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(metadata).build()).build()).setVerticalAlignment(3).addContent((LayoutElementBuilders.LayoutElement)layoutBuilder.build());
            return new PrimaryLayout(element.build());
        }

        private float getBottomPadding() {
            return this.mPrimaryChip != null ? (float)this.mDeviceParameters.getScreenHeightDp() * (Helper.isRoundDevice(this.mDeviceParameters) ? 0.021f : 0.0f) : this.getTopPadding();
        }

        @Dimension(unit=0)
        private float getTopPadding() {
            return (float)this.mDeviceParameters.getScreenHeightDp() * (Helper.isRoundDevice(this.mDeviceParameters) ? 0.16700001f : 0.133f);
        }

        @Dimension(unit=0)
        private float getHorizontalPadding() {
            return (float)this.mDeviceParameters.getScreenWidthDp() * (Helper.isRoundDevice(this.mDeviceParameters) ? 0.063f : 0.027999999f);
        }

        @Dimension(unit=0)
        private float getChipHorizontalPadding() {
            return Helper.isRoundDevice(this.mDeviceParameters) ? 30.0f : 0.0f;
        }

        @NonNull
        private DimensionBuilders.DpProp getPrimaryLabelTopSpacerHeight() {
            return Helper.isRoundDevice(this.mDeviceParameters) ? LayoutDefaults.PRIMARY_LAYOUT_PRIMARY_LABEL_SPACER_HEIGHT_ROUND_DP : LayoutDefaults.PRIMARY_LAYOUT_PRIMARY_LABEL_SPACER_HEIGHT_SQUARE_DP;
        }
    }
}

