/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.material;

import android.content.Context;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.tiles.ColorBuilders;
import androidx.wear.tiles.DimensionBuilders;
import androidx.wear.tiles.LayoutElementBuilders;
import androidx.wear.tiles.ModifiersBuilders;
import androidx.wear.tiles.material.ButtonColors;
import androidx.wear.tiles.material.ButtonDefaults;
import androidx.wear.tiles.material.Helper;
import androidx.wear.tiles.material.Text;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class Button
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG_TEXT = "TXTBTN";
    static final String METADATA_TAG_ICON = "ICNBTN";
    static final String METADATA_TAG_IMAGE = "IMGBTN";
    static final String METADATA_TAG_CUSTOM_CONTENT = "CSTBTN";
    @NonNull
    private final LayoutElementBuilders.Box mElement;

    Button(@NonNull LayoutElementBuilders.Box element) {
        this.mElement = element;
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getCustomContent() {
        if (!this.getMetadataTag().equals(METADATA_TAG_CUSTOM_CONTENT)) {
            return null;
        }
        return this.getAnyContent();
    }

    @Nullable
    public String getIconContent() {
        LayoutElementBuilders.Image icon = this.getIconContentObject();
        return icon != null ? Helper.checkNotNull(icon.getResourceId()).getValue() : null;
    }

    @Nullable
    public String getImageContent() {
        LayoutElementBuilders.Image image = this.getImageContentObject();
        return image != null ? Helper.checkNotNull(image.getResourceId()).getValue() : null;
    }

    @Nullable
    public String getTextContent() {
        Text text = this.getTextContentObject();
        return text != null ? text.getText() : null;
    }

    @NonNull
    private LayoutElementBuilders.LayoutElement getAnyContent() {
        return Helper.checkNotNull((LayoutElementBuilders.LayoutElement)this.mElement.getContents().get(0));
    }

    @Nullable
    private LayoutElementBuilders.Image getIconContentObject() {
        if (!this.getMetadataTag().equals(METADATA_TAG_ICON)) {
            return null;
        }
        return (LayoutElementBuilders.Image)this.getAnyContent();
    }

    @Nullable
    private Text getTextContentObject() {
        if (!this.getMetadataTag().equals(METADATA_TAG_TEXT)) {
            return null;
        }
        return Text.fromLayoutElement(this.getAnyContent());
    }

    @Nullable
    private LayoutElementBuilders.Image getImageContentObject() {
        if (!this.getMetadataTag().equals(METADATA_TAG_IMAGE)) {
            return null;
        }
        return (LayoutElementBuilders.Image)this.getAnyContent();
    }

    @NonNull
    public ModifiersBuilders.Clickable getClickable() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getClickable());
    }

    @Nullable
    public CharSequence getContentDescription() {
        ModifiersBuilders.Semantics semantics = Helper.checkNotNull(this.mElement.getModifiers()).getSemantics();
        if (semantics == null) {
            return null;
        }
        return semantics.getContentDescription();
    }

    @NonNull
    public DimensionBuilders.ContainerDimension getSize() {
        return Helper.checkNotNull(this.mElement.getWidth());
    }

    private ColorBuilders.ColorProp getBackgroundColor() {
        return Helper.checkNotNull(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getBackground()).getColor());
    }

    @NonNull
    public ButtonColors getButtonColors() {
        ColorBuilders.ColorProp backgroundColor = this.getBackgroundColor();
        ColorBuilders.ColorProp contentColor = null;
        switch (this.getMetadataTag()) {
            case "TXTBTN": {
                contentColor = Helper.checkNotNull(this.getTextContentObject()).getColor();
                break;
            }
            case "ICNBTN": {
                contentColor = Helper.checkNotNull(Helper.checkNotNull(this.getIconContentObject()).getColorFilter()).getTint();
                break;
            }
            case "IMGBTN": {
                contentColor = Helper.checkNotNull(Helper.checkNotNull(this.getImageContentObject()).getColorFilter()).getTint();
                break;
            }
        }
        if (contentColor == null) {
            contentColor = new ColorBuilders.ColorProp.Builder().build();
        }
        return new ButtonColors(backgroundColor, contentColor);
    }

    @NonNull
    String getMetadataTag() {
        return Helper.getMetadataTagName(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getMetadata()));
    }

    @Nullable
    public static Button fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof Button) {
            return (Button)element;
        }
        if (!(element instanceof LayoutElementBuilders.Box)) {
            return null;
        }
        LayoutElementBuilders.Box boxElement = (LayoutElementBuilders.Box)element;
        if (!Helper.checkTag(boxElement.getModifiers(), Builder.TYPE_TO_TAG.values())) {
            return null;
        }
        return new Button(boxElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return Helper.checkNotNull(this.mElement.toLayoutElementProto());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Fingerprint getFingerprint() {
        return this.mElement.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        private static final int NOT_SET = -1;
        private static final int ICON = 0;
        private static final int TEXT = 1;
        private static final int IMAGE = 2;
        private static final int CUSTOM_CONTENT = 3;
        @NonNull
        static final Map<Integer, String> TYPE_TO_TAG = new HashMap<Integer, String>();
        @NonNull
        private final Context mContext;
        @Nullable
        private LayoutElementBuilders.LayoutElement mCustomContent;
        @NonNull
        private final ModifiersBuilders.Clickable mClickable;
        @NonNull
        private CharSequence mContentDescription = "";
        @NonNull
        private DimensionBuilders.DpProp mSize = ButtonDefaults.DEFAULT_SIZE;
        @Nullable
        private String mText = null;
        @Nullable
        private Integer mTypographyName = null;
        @Nullable
        private String mIcon = null;
        @Nullable
        private DimensionBuilders.DpProp mIconSize = null;
        @Nullable
        private String mImage = null;
        @NonNull
        private ButtonColors mButtonColors = ButtonDefaults.PRIMARY_COLORS;
        private int mType = -1;

        public Builder(@NonNull Context context, @NonNull ModifiersBuilders.Clickable clickable) {
            this.mClickable = clickable;
            this.mContext = context;
        }

        @NonNull
        public Builder setContentDescription(@NonNull CharSequence contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        @NonNull
        public Builder setSize(@NonNull DimensionBuilders.DpProp size) {
            this.mSize = size;
            return this;
        }

        @NonNull
        public Builder setSize(@Dimension(unit=0) float size) {
            this.mSize = DimensionBuilders.dp((float)size);
            return this;
        }

        @NonNull
        public Builder setButtonColors(@NonNull ButtonColors buttonColors) {
            this.mButtonColors = buttonColors;
            return this;
        }

        @NonNull
        public Builder setCustomContent(@NonNull LayoutElementBuilders.LayoutElement content) {
            this.resetContent();
            this.mCustomContent = content;
            this.mType = 3;
            return this;
        }

        @NonNull
        public Builder setIconContent(@NonNull String imageResourceId, @NonNull DimensionBuilders.DpProp size) {
            this.resetContent();
            this.mIcon = imageResourceId;
            this.mType = 0;
            this.mIconSize = size;
            return this;
        }

        @NonNull
        public Builder setIconContent(@NonNull String imageResourceId) {
            this.resetContent();
            this.mIcon = imageResourceId;
            this.mType = 0;
            return this;
        }

        @NonNull
        public Builder setTextContent(@NonNull String text) {
            this.resetContent();
            this.mText = text;
            this.mType = 1;
            return this;
        }

        @NonNull
        public Builder setTextContent(@NonNull String text, int typographyName) {
            this.resetContent();
            this.mText = text;
            this.mTypographyName = typographyName;
            this.mType = 1;
            return this;
        }

        @NonNull
        public Builder setImageContent(@NonNull String imageResourceId) {
            this.resetContent();
            this.mImage = imageResourceId;
            this.mType = 2;
            return this;
        }

        private void resetContent() {
            this.mText = null;
            this.mTypographyName = null;
            this.mIcon = null;
            this.mImage = null;
            this.mCustomContent = null;
            this.mIconSize = null;
        }

        @NonNull
        public Button build() {
            ModifiersBuilders.Modifiers.Builder modifiers = new ModifiersBuilders.Modifiers.Builder().setClickable(this.mClickable).setBackground(new ModifiersBuilders.Background.Builder().setColor(this.mButtonColors.getBackgroundColor()).setCorner(new ModifiersBuilders.Corner.Builder().setRadius(Helper.radiusOf(this.mSize)).build()).build()).setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(Helper.getTagBytes(Helper.checkNotNull(TYPE_TO_TAG.get(this.mType)))).build());
            if (this.mContentDescription.length() > 0) {
                modifiers.setSemantics(new ModifiersBuilders.Semantics.Builder().setContentDescription(this.mContentDescription.toString()).build());
            }
            LayoutElementBuilders.Box.Builder element = new LayoutElementBuilders.Box.Builder().setHeight((DimensionBuilders.ContainerDimension)this.mSize).setWidth((DimensionBuilders.ContainerDimension)this.mSize).setModifiers(modifiers.build());
            element.addContent(this.getCorrectContent());
            return new Button(element.build());
        }

        @NonNull
        private LayoutElementBuilders.LayoutElement getCorrectContent() {
            switch (this.mType) {
                case 0: {
                    DimensionBuilders.DpProp iconSize = this.mIconSize != null ? this.mIconSize : ButtonDefaults.recommendedIconSize(this.mSize);
                    LayoutElementBuilders.Image.Builder content = new LayoutElementBuilders.Image.Builder().setResourceId(Helper.checkNotNull(this.mIcon)).setHeight((DimensionBuilders.ImageDimension)Helper.checkNotNull(iconSize)).setWidth((DimensionBuilders.ImageDimension)iconSize).setContentScaleMode(3).setColorFilter(new LayoutElementBuilders.ColorFilter.Builder().setTint(this.mButtonColors.getContentColor()).build());
                    return content.build();
                }
                case 1: {
                    int typographyName = this.mTypographyName != null ? this.mTypographyName : Builder.getDefaultTypographyForSize(this.mSize);
                    Text.Builder content = new Text.Builder(this.mContext, Helper.checkNotNull(this.mText)).setMaxLines(1).setTypography(typographyName).setColor(this.mButtonColors.getContentColor());
                    return content.build();
                }
                case 2: {
                    LayoutElementBuilders.Image.Builder content = new LayoutElementBuilders.Image.Builder().setResourceId(Helper.checkNotNull(this.mImage)).setHeight((DimensionBuilders.ImageDimension)this.mSize).setWidth((DimensionBuilders.ImageDimension)this.mSize).setContentScaleMode(3);
                    return content.build();
                }
                case 3: {
                    return Helper.checkNotNull(this.mCustomContent);
                }
            }
            throw new IllegalArgumentException("Wrong Button type");
        }

        private static int getDefaultTypographyForSize(@NonNull DimensionBuilders.DpProp size) {
            if (size.getValue() == ButtonDefaults.LARGE_SIZE.getValue()) {
                return 4;
            }
            if (size.getValue() == ButtonDefaults.EXTRA_LARGE_SIZE.getValue()) {
                return 3;
            }
            return 5;
        }

        static {
            TYPE_TO_TAG.put(0, Button.METADATA_TAG_ICON);
            TYPE_TO_TAG.put(1, Button.METADATA_TAG_TEXT);
            TYPE_TO_TAG.put(2, Button.METADATA_TAG_IMAGE);
            TYPE_TO_TAG.put(3, Button.METADATA_TAG_CUSTOM_CONTENT);
        }
    }
}

