/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.material.layouts;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.tiles.DimensionBuilders;
import androidx.wear.tiles.LayoutElementBuilders;
import androidx.wear.tiles.ModifiersBuilders;
import androidx.wear.tiles.material.Helper;
import androidx.wear.tiles.material.layouts.LayoutDefaults;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class MultiButtonLayout
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG = "MBL";
    public static final int FIVE_BUTTON_DISTRIBUTION_TOP_HEAVY = 1;
    public static final int FIVE_BUTTON_DISTRIBUTION_BOTTOM_HEAVY = 2;
    @NonNull
    private final LayoutElementBuilders.Box mElement;

    MultiButtonLayout(@NonNull LayoutElementBuilders.Box mElement) {
        this.mElement = mElement;
    }

    @NonNull
    public List<LayoutElementBuilders.LayoutElement> getButtonContents() {
        ArrayList<LayoutElementBuilders.LayoutElement> buttons = new ArrayList<LayoutElementBuilders.LayoutElement>();
        List contents = this.mElement.getContents();
        if (contents.isEmpty()) {
            return buttons;
        }
        LayoutElementBuilders.LayoutElement innerContent = (LayoutElementBuilders.LayoutElement)contents.get(0);
        if (innerContent instanceof LayoutElementBuilders.Column) {
            for (LayoutElementBuilders.LayoutElement row : ((LayoutElementBuilders.Column)innerContent).getContents()) {
                if (!(row instanceof LayoutElementBuilders.Row)) continue;
                buttons.addAll(this.getButtonsFromRow((LayoutElementBuilders.Row)row));
            }
        } else {
            if (innerContent instanceof LayoutElementBuilders.Row) {
                return this.getButtonsFromRow((LayoutElementBuilders.Row)innerContent);
            }
            if (innerContent instanceof LayoutElementBuilders.Box) {
                buttons.add((LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)innerContent).getContents().get(0));
            }
        }
        return buttons;
    }

    @NonNull
    String getMetadataTag() {
        return Helper.getMetadataTagName(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getMetadata()));
    }

    public int getFiveButtonDistribution() {
        LayoutElementBuilders.LayoutElement firstElement;
        List contents = this.mElement.getContents();
        if (this.getButtonContents().size() != 5) {
            return 2;
        }
        LayoutElementBuilders.LayoutElement innerContent = (LayoutElementBuilders.LayoutElement)contents.get(0);
        if (innerContent instanceof LayoutElementBuilders.Column && ((LayoutElementBuilders.Column)innerContent).getContents().size() == 3 && (firstElement = (LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Column)innerContent).getContents().get(0)) instanceof LayoutElementBuilders.Row && ((LayoutElementBuilders.Row)firstElement).getContents().size() == 5) {
            return 1;
        }
        return 2;
    }

    private List<LayoutElementBuilders.LayoutElement> getButtonsFromRow(LayoutElementBuilders.Row row) {
        ArrayList<LayoutElementBuilders.LayoutElement> buttons = new ArrayList<LayoutElementBuilders.LayoutElement>();
        for (LayoutElementBuilders.LayoutElement element : row.getContents()) {
            if (!(element instanceof LayoutElementBuilders.Box)) continue;
            buttons.add((LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)element).getContents().get(0));
        }
        return buttons;
    }

    @Nullable
    public static MultiButtonLayout fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof MultiButtonLayout) {
            return (MultiButtonLayout)element;
        }
        if (!(element instanceof LayoutElementBuilders.Box)) {
            return null;
        }
        LayoutElementBuilders.Box boxElement = (LayoutElementBuilders.Box)element;
        if (!Helper.checkTag(boxElement.getModifiers(), METADATA_TAG)) {
            return null;
        }
        return new MultiButtonLayout(boxElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mElement.toLayoutElementProto();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Fingerprint getFingerprint() {
        return this.mElement.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final List<LayoutElementBuilders.LayoutElement> mButtonsContent = new ArrayList<LayoutElementBuilders.LayoutElement>();
        private int mFiveButtonDistribution = 2;

        @NonNull
        public Builder addButtonContent(@NonNull LayoutElementBuilders.LayoutElement buttonContent) {
            this.mButtonsContent.add(buttonContent);
            return this;
        }

        @NonNull
        public Builder setFiveButtonDistribution(int fiveButtonDistribution) {
            this.mFiveButtonDistribution = fiveButtonDistribution;
            return this;
        }

        @NonNull
        public MultiButtonLayout build() {
            int buttonNum = this.mButtonsContent.size();
            if (buttonNum > 7) {
                throw new IllegalArgumentException("Too many buttons are added. Maximum number is 7.");
            }
            LayoutElementBuilders.LayoutElement buttons = this.buildButtons(buttonNum);
            LayoutElementBuilders.Box.Builder elementBuilder = new LayoutElementBuilders.Box.Builder().setModifiers(new ModifiersBuilders.Modifiers.Builder().setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(Helper.getTagBytes(MultiButtonLayout.METADATA_TAG)).build()).build()).addContent(buttons);
            return new MultiButtonLayout(elementBuilder.build());
        }

        @NonNull
        private LayoutElementBuilders.LayoutElement buildButtons(int buttonNum) {
            switch (buttonNum) {
                case 1: {
                    return this.wrapButton(this.mButtonsContent.get(0), LayoutDefaults.MULTI_BUTTON_1_SIZE);
                }
                case 2: {
                    return this.build2ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), LayoutDefaults.MULTI_BUTTON_2_SIZE);
                }
                case 3: {
                    return this.build3ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), this.mButtonsContent.get(2));
                }
                case 4: {
                    return new LayoutElementBuilders.Column.Builder().addContent((LayoutElementBuilders.LayoutElement)this.build2ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).addContent((LayoutElementBuilders.LayoutElement)this.buildVerticalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.build2ButtonRow(this.mButtonsContent.get(2), this.mButtonsContent.get(3), LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).build();
                }
                case 5: {
                    return new LayoutElementBuilders.Column.Builder().addContent((LayoutElementBuilders.LayoutElement)(this.mFiveButtonDistribution == 1 ? this.build3ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), this.mButtonsContent.get(2)) : this.build2ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE))).addContent((LayoutElementBuilders.LayoutElement)this.buildVerticalSpacer()).addContent((LayoutElementBuilders.LayoutElement)(this.mFiveButtonDistribution == 1 ? this.build2ButtonRow(this.mButtonsContent.get(3), this.mButtonsContent.get(4), LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE) : this.build3ButtonRow(this.mButtonsContent.get(2), this.mButtonsContent.get(3), this.mButtonsContent.get(4)))).build();
                }
                case 6: {
                    return new LayoutElementBuilders.Column.Builder().addContent((LayoutElementBuilders.LayoutElement)this.build3ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), this.mButtonsContent.get(2))).addContent((LayoutElementBuilders.LayoutElement)this.buildVerticalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.build3ButtonRow(this.mButtonsContent.get(3), this.mButtonsContent.get(4), this.mButtonsContent.get(5))).build();
                }
                case 7: {
                    return new LayoutElementBuilders.Column.Builder().addContent((LayoutElementBuilders.LayoutElement)this.build2ButtonRow(this.mButtonsContent.get(0), this.mButtonsContent.get(1), LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).addContent((LayoutElementBuilders.LayoutElement)this.buildVerticalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.build3ButtonRow(this.mButtonsContent.get(2), this.mButtonsContent.get(3), this.mButtonsContent.get(4))).addContent((LayoutElementBuilders.LayoutElement)this.buildVerticalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.build2ButtonRow(this.mButtonsContent.get(5), this.mButtonsContent.get(6), LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).build();
                }
            }
            return new LayoutElementBuilders.Box.Builder().build();
        }

        @NonNull
        private LayoutElementBuilders.Row build3ButtonRow(@NonNull LayoutElementBuilders.LayoutElement button1, @NonNull LayoutElementBuilders.LayoutElement button2, @NonNull LayoutElementBuilders.LayoutElement button3) {
            return new LayoutElementBuilders.Row.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).addContent((LayoutElementBuilders.LayoutElement)this.wrapButton(button1, LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).addContent((LayoutElementBuilders.LayoutElement)this.buildHorizontalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.wrapButton(button2, LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).addContent((LayoutElementBuilders.LayoutElement)this.buildHorizontalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.wrapButton(button3, LayoutDefaults.MULTI_BUTTON_3_PLUS_SIZE)).build();
        }

        @NonNull
        private LayoutElementBuilders.Row build2ButtonRow(@NonNull LayoutElementBuilders.LayoutElement button1, @NonNull LayoutElementBuilders.LayoutElement button2, @NonNull DimensionBuilders.DpProp size) {
            return new LayoutElementBuilders.Row.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).addContent((LayoutElementBuilders.LayoutElement)this.wrapButton(button1, size)).addContent((LayoutElementBuilders.LayoutElement)this.buildHorizontalSpacer()).addContent((LayoutElementBuilders.LayoutElement)this.wrapButton(button2, size)).build();
        }

        @NonNull
        private LayoutElementBuilders.Spacer buildHorizontalSpacer() {
            return new LayoutElementBuilders.Spacer.Builder().setWidth((DimensionBuilders.SpacerDimension)LayoutDefaults.MULTI_BUTTON_SPACER_WIDTH).build();
        }

        @NonNull
        private LayoutElementBuilders.Spacer buildVerticalSpacer() {
            return new LayoutElementBuilders.Spacer.Builder().setHeight((DimensionBuilders.SpacerDimension)LayoutDefaults.MULTI_BUTTON_SPACER_HEIGHT).build();
        }

        @NonNull
        private LayoutElementBuilders.Box wrapButton(@NonNull LayoutElementBuilders.LayoutElement button, @NonNull DimensionBuilders.DpProp size) {
            return new LayoutElementBuilders.Box.Builder().setWidth((DimensionBuilders.ContainerDimension)size).setHeight((DimensionBuilders.ContainerDimension)size).addContent(button).build();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ButtonDistribution {
    }
}

