/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.proto;

import androidx.wear.tiles.protobuf.ByteString;
import androidx.wear.tiles.protobuf.CodedInputStream;
import androidx.wear.tiles.protobuf.ExtensionRegistryLite;
import androidx.wear.tiles.protobuf.GeneratedMessageLite;
import androidx.wear.tiles.protobuf.Internal;
import androidx.wear.tiles.protobuf.InvalidProtocolBufferException;
import androidx.wear.tiles.protobuf.MessageLiteOrBuilder;
import androidx.wear.tiles.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class DeviceParametersProto {
    private DeviceParametersProto() {
    }

    public static void registerAllExtensions(ExtensionRegistryLite registry) {
    }

    public static final class DeviceParameters
    extends GeneratedMessageLite<DeviceParameters, Builder>
    implements DeviceParametersOrBuilder {
        public static final int SCREEN_WIDTH_DP_FIELD_NUMBER = 1;
        private int screenWidthDp_;
        public static final int SCREEN_HEIGHT_DP_FIELD_NUMBER = 2;
        private int screenHeightDp_;
        public static final int SCREEN_DENSITY_FIELD_NUMBER = 3;
        private float screenDensity_;
        public static final int DEVICE_PLATFORM_FIELD_NUMBER = 4;
        private int devicePlatform_;
        public static final int SCREEN_SHAPE_FIELD_NUMBER = 5;
        private int screenShape_;
        private static final DeviceParameters DEFAULT_INSTANCE;
        private static volatile Parser<DeviceParameters> PARSER;

        private DeviceParameters() {
        }

        @Override
        public int getScreenWidthDp() {
            return this.screenWidthDp_;
        }

        private void setScreenWidthDp(int value) {
            this.screenWidthDp_ = value;
        }

        private void clearScreenWidthDp() {
            this.screenWidthDp_ = 0;
        }

        @Override
        public int getScreenHeightDp() {
            return this.screenHeightDp_;
        }

        private void setScreenHeightDp(int value) {
            this.screenHeightDp_ = value;
        }

        private void clearScreenHeightDp() {
            this.screenHeightDp_ = 0;
        }

        @Override
        public float getScreenDensity() {
            return this.screenDensity_;
        }

        private void setScreenDensity(float value) {
            this.screenDensity_ = value;
        }

        private void clearScreenDensity() {
            this.screenDensity_ = 0.0f;
        }

        @Override
        public int getDevicePlatformValue() {
            return this.devicePlatform_;
        }

        @Override
        public DevicePlatform getDevicePlatform() {
            DevicePlatform result = DevicePlatform.forNumber(this.devicePlatform_);
            return result == null ? DevicePlatform.UNRECOGNIZED : result;
        }

        private void setDevicePlatformValue(int value) {
            this.devicePlatform_ = value;
        }

        private void setDevicePlatform(DevicePlatform value) {
            this.devicePlatform_ = value.getNumber();
        }

        private void clearDevicePlatform() {
            this.devicePlatform_ = 0;
        }

        @Override
        public int getScreenShapeValue() {
            return this.screenShape_;
        }

        @Override
        public ScreenShape getScreenShape() {
            ScreenShape result = ScreenShape.forNumber(this.screenShape_);
            return result == null ? ScreenShape.UNRECOGNIZED : result;
        }

        private void setScreenShapeValue(int value) {
            this.screenShape_ = value;
        }

        private void setScreenShape(ScreenShape value) {
            this.screenShape_ = value.getNumber();
        }

        private void clearScreenShape() {
            this.screenShape_ = 0;
        }

        public static DeviceParameters parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static DeviceParameters parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static DeviceParameters parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static DeviceParameters parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static DeviceParameters parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static DeviceParameters parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static DeviceParameters parseFrom(InputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static DeviceParameters parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static DeviceParameters parseDelimitedFrom(InputStream input) throws IOException {
            return DeviceParameters.parseDelimitedFrom(DEFAULT_INSTANCE, input);
        }

        public static DeviceParameters parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return DeviceParameters.parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static DeviceParameters parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static DeviceParameters parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Builder newBuilder() {
            return (Builder)DEFAULT_INSTANCE.createBuilder();
        }

        public static Builder newBuilder(DeviceParameters prototype) {
            return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
            switch (method) {
                case NEW_MUTABLE_INSTANCE: {
                    return new DeviceParameters();
                }
                case NEW_BUILDER: {
                    return new Builder();
                }
                case BUILD_MESSAGE_INFO: {
                    Object[] objects = new Object[]{"screenWidthDp_", "screenHeightDp_", "screenDensity_", "devicePlatform_", "screenShape_"};
                    String info = "\u0000\u0005\u0000\u0000\u0001\u0005\u0005\u0000\u0000\u0000\u0001\u000b\u0002\u000b\u0003\u0001\u0004\f\u0005\f";
                    return DeviceParameters.newMessageInfo(DEFAULT_INSTANCE, info, objects);
                }
                case GET_DEFAULT_INSTANCE: {
                    return DEFAULT_INSTANCE;
                }
                case GET_PARSER: {
                    Parser<DeviceParameters> parser = PARSER;
                    if (parser != null) return parser;
                    Class<DeviceParameters> clazz = DeviceParameters.class;
                    synchronized (DeviceParameters.class) {
                        parser = PARSER;
                        if (parser != null) return parser;
                        PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<DeviceParameters>(DEFAULT_INSTANCE);
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        return parser;
                    }
                }
                case GET_MEMOIZED_IS_INITIALIZED: {
                    return (byte)1;
                }
                case SET_MEMOIZED_IS_INITIALIZED: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static DeviceParameters getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<DeviceParameters> parser() {
            return DEFAULT_INSTANCE.getParserForType();
        }

        static {
            DeviceParameters defaultInstance;
            DEFAULT_INSTANCE = defaultInstance = new DeviceParameters();
            GeneratedMessageLite.registerDefaultInstance(DeviceParameters.class, defaultInstance);
        }

        public static final class Builder
        extends GeneratedMessageLite.Builder<DeviceParameters, Builder>
        implements DeviceParametersOrBuilder {
            private Builder() {
                super(DEFAULT_INSTANCE);
            }

            @Override
            public int getScreenWidthDp() {
                return ((DeviceParameters)this.instance).getScreenWidthDp();
            }

            public Builder setScreenWidthDp(int value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setScreenWidthDp(value);
                return this;
            }

            public Builder clearScreenWidthDp() {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).clearScreenWidthDp();
                return this;
            }

            @Override
            public int getScreenHeightDp() {
                return ((DeviceParameters)this.instance).getScreenHeightDp();
            }

            public Builder setScreenHeightDp(int value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setScreenHeightDp(value);
                return this;
            }

            public Builder clearScreenHeightDp() {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).clearScreenHeightDp();
                return this;
            }

            @Override
            public float getScreenDensity() {
                return ((DeviceParameters)this.instance).getScreenDensity();
            }

            public Builder setScreenDensity(float value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setScreenDensity(value);
                return this;
            }

            public Builder clearScreenDensity() {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).clearScreenDensity();
                return this;
            }

            @Override
            public int getDevicePlatformValue() {
                return ((DeviceParameters)this.instance).getDevicePlatformValue();
            }

            public Builder setDevicePlatformValue(int value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setDevicePlatformValue(value);
                return this;
            }

            @Override
            public DevicePlatform getDevicePlatform() {
                return ((DeviceParameters)this.instance).getDevicePlatform();
            }

            public Builder setDevicePlatform(DevicePlatform value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setDevicePlatform(value);
                return this;
            }

            public Builder clearDevicePlatform() {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).clearDevicePlatform();
                return this;
            }

            @Override
            public int getScreenShapeValue() {
                return ((DeviceParameters)this.instance).getScreenShapeValue();
            }

            public Builder setScreenShapeValue(int value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setScreenShapeValue(value);
                return this;
            }

            @Override
            public ScreenShape getScreenShape() {
                return ((DeviceParameters)this.instance).getScreenShape();
            }

            public Builder setScreenShape(ScreenShape value) {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).setScreenShape(value);
                return this;
            }

            public Builder clearScreenShape() {
                this.copyOnWrite();
                ((DeviceParameters)this.instance).clearScreenShape();
                return this;
            }
        }
    }

    public static interface DeviceParametersOrBuilder
    extends MessageLiteOrBuilder {
        public int getScreenWidthDp();

        public int getScreenHeightDp();

        public float getScreenDensity();

        public int getDevicePlatformValue();

        public DevicePlatform getDevicePlatform();

        public int getScreenShapeValue();

        public ScreenShape getScreenShape();
    }

    public static enum ScreenShape implements Internal.EnumLite
    {
        SCREEN_SHAPE_UNDEFINED(0),
        SCREEN_SHAPE_ROUND(1),
        SCREEN_SHAPE_RECT(2),
        UNRECOGNIZED(-1);

        public static final int SCREEN_SHAPE_UNDEFINED_VALUE = 0;
        public static final int SCREEN_SHAPE_ROUND_VALUE = 1;
        public static final int SCREEN_SHAPE_RECT_VALUE = 2;
        private static final Internal.EnumLiteMap<ScreenShape> internalValueMap;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ScreenShape valueOf(int value) {
            return ScreenShape.forNumber(value);
        }

        public static ScreenShape forNumber(int value) {
            switch (value) {
                case 0: {
                    return SCREEN_SHAPE_UNDEFINED;
                }
                case 1: {
                    return SCREEN_SHAPE_ROUND;
                }
                case 2: {
                    return SCREEN_SHAPE_RECT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ScreenShape> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return ScreenShapeVerifier.INSTANCE;
        }

        private ScreenShape(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ScreenShape>(){

                @Override
                public ScreenShape findValueByNumber(int number) {
                    return ScreenShape.forNumber(number);
                }
            };
        }

        private static final class ScreenShapeVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new ScreenShapeVerifier();

            private ScreenShapeVerifier() {
            }

            @Override
            public boolean isInRange(int number) {
                return ScreenShape.forNumber(number) != null;
            }
        }
    }

    public static enum DevicePlatform implements Internal.EnumLite
    {
        DEVICE_PLATFORM_UNDEFINED(0),
        DEVICE_PLATFORM_WEAR_OS(1),
        UNRECOGNIZED(-1);

        public static final int DEVICE_PLATFORM_UNDEFINED_VALUE = 0;
        public static final int DEVICE_PLATFORM_WEAR_OS_VALUE = 1;
        private static final Internal.EnumLiteMap<DevicePlatform> internalValueMap;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static DevicePlatform valueOf(int value) {
            return DevicePlatform.forNumber(value);
        }

        public static DevicePlatform forNumber(int value) {
            switch (value) {
                case 0: {
                    return DEVICE_PLATFORM_UNDEFINED;
                }
                case 1: {
                    return DEVICE_PLATFORM_WEAR_OS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<DevicePlatform> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return DevicePlatformVerifier.INSTANCE;
        }

        private DevicePlatform(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<DevicePlatform>(){

                @Override
                public DevicePlatform findValueByNumber(int number) {
                    return DevicePlatform.forNumber(number);
                }
            };
        }

        private static final class DevicePlatformVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new DevicePlatformVerifier();

            private DevicePlatformVerifier() {
            }

            @Override
            public boolean isInRange(int number) {
                return DevicePlatform.forNumber(number) != null;
            }
        }
    }
}

