/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.proto;

import androidx.wear.tiles.protobuf.ByteString;
import androidx.wear.tiles.protobuf.CodedInputStream;
import androidx.wear.tiles.protobuf.ExtensionRegistryLite;
import androidx.wear.tiles.protobuf.GeneratedMessageLite;
import androidx.wear.tiles.protobuf.Internal;
import androidx.wear.tiles.protobuf.InvalidProtocolBufferException;
import androidx.wear.tiles.protobuf.MapEntryLite;
import androidx.wear.tiles.protobuf.MapFieldLite;
import androidx.wear.tiles.protobuf.MessageLiteOrBuilder;
import androidx.wear.tiles.protobuf.Parser;
import androidx.wear.tiles.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;

public final class ResourceProto {
    private ResourceProto() {
    }

    public static void registerAllExtensions(ExtensionRegistryLite registry) {
    }

    public static final class Resources
    extends GeneratedMessageLite<Resources, Builder>
    implements ResourcesOrBuilder {
        public static final int VERSION_FIELD_NUMBER = 1;
        private String version_ = "";
        public static final int ID_TO_IMAGE_FIELD_NUMBER = 2;
        private MapFieldLite<String, ImageResource> idToImage_ = MapFieldLite.emptyMapField();
        private static final Resources DEFAULT_INSTANCE;
        private static volatile Parser<Resources> PARSER;

        private Resources() {
        }

        @Override
        public String getVersion() {
            return this.version_;
        }

        @Override
        public ByteString getVersionBytes() {
            return ByteString.copyFromUtf8(this.version_);
        }

        private void setVersion(String value) {
            Class<?> valueClass = value.getClass();
            this.version_ = value;
        }

        private void clearVersion() {
            this.version_ = Resources.getDefaultInstance().getVersion();
        }

        private void setVersionBytes(ByteString value) {
            Resources.checkByteStringIsUtf8(value);
            this.version_ = value.toStringUtf8();
        }

        private MapFieldLite<String, ImageResource> internalGetIdToImage() {
            return this.idToImage_;
        }

        private MapFieldLite<String, ImageResource> internalGetMutableIdToImage() {
            if (!this.idToImage_.isMutable()) {
                this.idToImage_ = this.idToImage_.mutableCopy();
            }
            return this.idToImage_;
        }

        @Override
        public int getIdToImageCount() {
            return this.internalGetIdToImage().size();
        }

        @Override
        public boolean containsIdToImage(String key) {
            Class<?> keyClass = key.getClass();
            return this.internalGetIdToImage().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, ImageResource> getIdToImage() {
            return this.getIdToImageMap();
        }

        @Override
        public Map<String, ImageResource> getIdToImageMap() {
            return Collections.unmodifiableMap(this.internalGetIdToImage());
        }

        @Override
        public ImageResource getIdToImageOrDefault(String key, ImageResource defaultValue) {
            Class<?> keyClass = key.getClass();
            MapFieldLite<String, ImageResource> map = this.internalGetIdToImage();
            return map.containsKey(key) ? (ImageResource)map.get(key) : defaultValue;
        }

        @Override
        public ImageResource getIdToImageOrThrow(String key) {
            Class<?> keyClass = key.getClass();
            MapFieldLite<String, ImageResource> map = this.internalGetIdToImage();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (ImageResource)map.get(key);
        }

        private Map<String, ImageResource> getMutableIdToImageMap() {
            return this.internalGetMutableIdToImage();
        }

        public static Resources parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static Resources parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static Resources parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static Resources parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static Resources parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static Resources parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static Resources parseFrom(InputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static Resources parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Resources parseDelimitedFrom(InputStream input) throws IOException {
            return Resources.parseDelimitedFrom(DEFAULT_INSTANCE, input);
        }

        public static Resources parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return Resources.parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Resources parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static Resources parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Builder newBuilder() {
            return (Builder)DEFAULT_INSTANCE.createBuilder();
        }

        public static Builder newBuilder(Resources prototype) {
            return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
            switch (method) {
                case NEW_MUTABLE_INSTANCE: {
                    return new Resources();
                }
                case NEW_BUILDER: {
                    return new Builder();
                }
                case BUILD_MESSAGE_INFO: {
                    Object[] objects = new Object[]{"version_", "idToImage_", IdToImageDefaultEntryHolder.defaultEntry};
                    String info = "\u0000\u0002\u0000\u0000\u0001\u0002\u0002\u0001\u0000\u0000\u0001\u0208\u00022";
                    return Resources.newMessageInfo(DEFAULT_INSTANCE, info, objects);
                }
                case GET_DEFAULT_INSTANCE: {
                    return DEFAULT_INSTANCE;
                }
                case GET_PARSER: {
                    Parser<Resources> parser = PARSER;
                    if (parser != null) return parser;
                    Class<Resources> clazz = Resources.class;
                    synchronized (Resources.class) {
                        parser = PARSER;
                        if (parser != null) return parser;
                        PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<Resources>(DEFAULT_INSTANCE);
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        return parser;
                    }
                }
                case GET_MEMOIZED_IS_INITIALIZED: {
                    return (byte)1;
                }
                case SET_MEMOIZED_IS_INITIALIZED: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static Resources getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Resources> parser() {
            return DEFAULT_INSTANCE.getParserForType();
        }

        static {
            Resources defaultInstance;
            DEFAULT_INSTANCE = defaultInstance = new Resources();
            GeneratedMessageLite.registerDefaultInstance(Resources.class, defaultInstance);
        }

        public static final class Builder
        extends GeneratedMessageLite.Builder<Resources, Builder>
        implements ResourcesOrBuilder {
            private Builder() {
                super(DEFAULT_INSTANCE);
            }

            @Override
            public String getVersion() {
                return ((Resources)this.instance).getVersion();
            }

            @Override
            public ByteString getVersionBytes() {
                return ((Resources)this.instance).getVersionBytes();
            }

            public Builder setVersion(String value) {
                this.copyOnWrite();
                ((Resources)this.instance).setVersion(value);
                return this;
            }

            public Builder clearVersion() {
                this.copyOnWrite();
                ((Resources)this.instance).clearVersion();
                return this;
            }

            public Builder setVersionBytes(ByteString value) {
                this.copyOnWrite();
                ((Resources)this.instance).setVersionBytes(value);
                return this;
            }

            @Override
            public int getIdToImageCount() {
                return ((Resources)this.instance).getIdToImageMap().size();
            }

            @Override
            public boolean containsIdToImage(String key) {
                Class<?> keyClass = key.getClass();
                return ((Resources)this.instance).getIdToImageMap().containsKey(key);
            }

            public Builder clearIdToImage() {
                this.copyOnWrite();
                ((Resources)this.instance).getMutableIdToImageMap().clear();
                return this;
            }

            public Builder removeIdToImage(String key) {
                Class<?> keyClass = key.getClass();
                this.copyOnWrite();
                ((Resources)this.instance).getMutableIdToImageMap().remove(key);
                return this;
            }

            @Override
            @Deprecated
            public Map<String, ImageResource> getIdToImage() {
                return this.getIdToImageMap();
            }

            @Override
            public Map<String, ImageResource> getIdToImageMap() {
                return Collections.unmodifiableMap(((Resources)this.instance).getIdToImageMap());
            }

            @Override
            public ImageResource getIdToImageOrDefault(String key, ImageResource defaultValue) {
                Class<?> keyClass = key.getClass();
                Map<String, ImageResource> map = ((Resources)this.instance).getIdToImageMap();
                return map.containsKey(key) ? map.get(key) : defaultValue;
            }

            @Override
            public ImageResource getIdToImageOrThrow(String key) {
                Class<?> keyClass = key.getClass();
                Map<String, ImageResource> map = ((Resources)this.instance).getIdToImageMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return map.get(key);
            }

            public Builder putIdToImage(String key, ImageResource value) {
                Class<?> keyClass = key.getClass();
                Class<?> valueClass = value.getClass();
                this.copyOnWrite();
                ((Resources)this.instance).getMutableIdToImageMap().put(key, value);
                return this;
            }

            public Builder putAllIdToImage(Map<String, ImageResource> values) {
                this.copyOnWrite();
                ((Resources)this.instance).getMutableIdToImageMap().putAll(values);
                return this;
            }
        }

        private static final class IdToImageDefaultEntryHolder {
            static final MapEntryLite<String, ImageResource> defaultEntry = MapEntryLite.newDefaultInstance(WireFormat.FieldType.STRING, "", WireFormat.FieldType.MESSAGE, ImageResource.getDefaultInstance());

            private IdToImageDefaultEntryHolder() {
            }
        }
    }

    public static interface ResourcesOrBuilder
    extends MessageLiteOrBuilder {
        public String getVersion();

        public ByteString getVersionBytes();

        public int getIdToImageCount();

        public boolean containsIdToImage(String var1);

        @Deprecated
        public Map<String, ImageResource> getIdToImage();

        public Map<String, ImageResource> getIdToImageMap();

        public ImageResource getIdToImageOrDefault(String var1, ImageResource var2);

        public ImageResource getIdToImageOrThrow(String var1);
    }

    public static final class ImageResource
    extends GeneratedMessageLite<ImageResource, Builder>
    implements ImageResourceOrBuilder {
        public static final int ANDROID_RESOURCE_BY_RES_ID_FIELD_NUMBER = 1;
        private AndroidImageResourceByResId androidResourceByResId_;
        public static final int INLINE_RESOURCE_FIELD_NUMBER = 2;
        private InlineImageResource inlineResource_;
        private static final ImageResource DEFAULT_INSTANCE;
        private static volatile Parser<ImageResource> PARSER;

        private ImageResource() {
        }

        @Override
        public boolean hasAndroidResourceByResId() {
            return this.androidResourceByResId_ != null;
        }

        @Override
        public AndroidImageResourceByResId getAndroidResourceByResId() {
            return this.androidResourceByResId_ == null ? AndroidImageResourceByResId.getDefaultInstance() : this.androidResourceByResId_;
        }

        private void setAndroidResourceByResId(AndroidImageResourceByResId value) {
            value.getClass();
            this.androidResourceByResId_ = value;
        }

        private void mergeAndroidResourceByResId(AndroidImageResourceByResId value) {
            value.getClass();
            this.androidResourceByResId_ = this.androidResourceByResId_ != null && this.androidResourceByResId_ != AndroidImageResourceByResId.getDefaultInstance() ? (AndroidImageResourceByResId)((AndroidImageResourceByResId.Builder)AndroidImageResourceByResId.newBuilder(this.androidResourceByResId_).mergeFrom(value)).buildPartial() : value;
        }

        private void clearAndroidResourceByResId() {
            this.androidResourceByResId_ = null;
        }

        @Override
        public boolean hasInlineResource() {
            return this.inlineResource_ != null;
        }

        @Override
        public InlineImageResource getInlineResource() {
            return this.inlineResource_ == null ? InlineImageResource.getDefaultInstance() : this.inlineResource_;
        }

        private void setInlineResource(InlineImageResource value) {
            value.getClass();
            this.inlineResource_ = value;
        }

        private void mergeInlineResource(InlineImageResource value) {
            value.getClass();
            this.inlineResource_ = this.inlineResource_ != null && this.inlineResource_ != InlineImageResource.getDefaultInstance() ? (InlineImageResource)((InlineImageResource.Builder)InlineImageResource.newBuilder(this.inlineResource_).mergeFrom(value)).buildPartial() : value;
        }

        private void clearInlineResource() {
            this.inlineResource_ = null;
        }

        public static ImageResource parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static ImageResource parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static ImageResource parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static ImageResource parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static ImageResource parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static ImageResource parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static ImageResource parseFrom(InputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static ImageResource parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static ImageResource parseDelimitedFrom(InputStream input) throws IOException {
            return ImageResource.parseDelimitedFrom(DEFAULT_INSTANCE, input);
        }

        public static ImageResource parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return ImageResource.parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static ImageResource parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static ImageResource parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Builder newBuilder() {
            return (Builder)DEFAULT_INSTANCE.createBuilder();
        }

        public static Builder newBuilder(ImageResource prototype) {
            return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
            switch (method) {
                case NEW_MUTABLE_INSTANCE: {
                    return new ImageResource();
                }
                case NEW_BUILDER: {
                    return new Builder();
                }
                case BUILD_MESSAGE_INFO: {
                    Object[] objects = new Object[]{"androidResourceByResId_", "inlineResource_"};
                    String info = "\u0000\u0002\u0000\u0000\u0001\u0002\u0002\u0000\u0000\u0000\u0001\t\u0002\t";
                    return ImageResource.newMessageInfo(DEFAULT_INSTANCE, info, objects);
                }
                case GET_DEFAULT_INSTANCE: {
                    return DEFAULT_INSTANCE;
                }
                case GET_PARSER: {
                    Parser<ImageResource> parser = PARSER;
                    if (parser != null) return parser;
                    Class<ImageResource> clazz = ImageResource.class;
                    synchronized (ImageResource.class) {
                        parser = PARSER;
                        if (parser != null) return parser;
                        PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<ImageResource>(DEFAULT_INSTANCE);
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        return parser;
                    }
                }
                case GET_MEMOIZED_IS_INITIALIZED: {
                    return (byte)1;
                }
                case SET_MEMOIZED_IS_INITIALIZED: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static ImageResource getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ImageResource> parser() {
            return DEFAULT_INSTANCE.getParserForType();
        }

        static {
            ImageResource defaultInstance;
            DEFAULT_INSTANCE = defaultInstance = new ImageResource();
            GeneratedMessageLite.registerDefaultInstance(ImageResource.class, defaultInstance);
        }

        public static final class Builder
        extends GeneratedMessageLite.Builder<ImageResource, Builder>
        implements ImageResourceOrBuilder {
            private Builder() {
                super(DEFAULT_INSTANCE);
            }

            @Override
            public boolean hasAndroidResourceByResId() {
                return ((ImageResource)this.instance).hasAndroidResourceByResId();
            }

            @Override
            public AndroidImageResourceByResId getAndroidResourceByResId() {
                return ((ImageResource)this.instance).getAndroidResourceByResId();
            }

            public Builder setAndroidResourceByResId(AndroidImageResourceByResId value) {
                this.copyOnWrite();
                ((ImageResource)this.instance).setAndroidResourceByResId(value);
                return this;
            }

            public Builder setAndroidResourceByResId(AndroidImageResourceByResId.Builder builderForValue) {
                this.copyOnWrite();
                ((ImageResource)this.instance).setAndroidResourceByResId((AndroidImageResourceByResId)builderForValue.build());
                return this;
            }

            public Builder mergeAndroidResourceByResId(AndroidImageResourceByResId value) {
                this.copyOnWrite();
                ((ImageResource)this.instance).mergeAndroidResourceByResId(value);
                return this;
            }

            public Builder clearAndroidResourceByResId() {
                this.copyOnWrite();
                ((ImageResource)this.instance).clearAndroidResourceByResId();
                return this;
            }

            @Override
            public boolean hasInlineResource() {
                return ((ImageResource)this.instance).hasInlineResource();
            }

            @Override
            public InlineImageResource getInlineResource() {
                return ((ImageResource)this.instance).getInlineResource();
            }

            public Builder setInlineResource(InlineImageResource value) {
                this.copyOnWrite();
                ((ImageResource)this.instance).setInlineResource(value);
                return this;
            }

            public Builder setInlineResource(InlineImageResource.Builder builderForValue) {
                this.copyOnWrite();
                ((ImageResource)this.instance).setInlineResource((InlineImageResource)builderForValue.build());
                return this;
            }

            public Builder mergeInlineResource(InlineImageResource value) {
                this.copyOnWrite();
                ((ImageResource)this.instance).mergeInlineResource(value);
                return this;
            }

            public Builder clearInlineResource() {
                this.copyOnWrite();
                ((ImageResource)this.instance).clearInlineResource();
                return this;
            }
        }
    }

    public static interface ImageResourceOrBuilder
    extends MessageLiteOrBuilder {
        public boolean hasAndroidResourceByResId();

        public AndroidImageResourceByResId getAndroidResourceByResId();

        public boolean hasInlineResource();

        public InlineImageResource getInlineResource();
    }

    public static final class InlineImageResource
    extends GeneratedMessageLite<InlineImageResource, Builder>
    implements InlineImageResourceOrBuilder {
        public static final int DATA_FIELD_NUMBER = 1;
        private ByteString data_ = ByteString.EMPTY;
        public static final int WIDTH_PX_FIELD_NUMBER = 2;
        private int widthPx_;
        public static final int HEIGHT_PX_FIELD_NUMBER = 3;
        private int heightPx_;
        public static final int FORMAT_FIELD_NUMBER = 4;
        private int format_;
        private static final InlineImageResource DEFAULT_INSTANCE;
        private static volatile Parser<InlineImageResource> PARSER;

        private InlineImageResource() {
        }

        @Override
        public ByteString getData() {
            return this.data_;
        }

        private void setData(ByteString value) {
            Class<?> valueClass = value.getClass();
            this.data_ = value;
        }

        private void clearData() {
            this.data_ = InlineImageResource.getDefaultInstance().getData();
        }

        @Override
        public int getWidthPx() {
            return this.widthPx_;
        }

        private void setWidthPx(int value) {
            this.widthPx_ = value;
        }

        private void clearWidthPx() {
            this.widthPx_ = 0;
        }

        @Override
        public int getHeightPx() {
            return this.heightPx_;
        }

        private void setHeightPx(int value) {
            this.heightPx_ = value;
        }

        private void clearHeightPx() {
            this.heightPx_ = 0;
        }

        @Override
        public int getFormatValue() {
            return this.format_;
        }

        @Override
        public ImageFormat getFormat() {
            ImageFormat result = ImageFormat.forNumber(this.format_);
            return result == null ? ImageFormat.UNRECOGNIZED : result;
        }

        private void setFormatValue(int value) {
            this.format_ = value;
        }

        private void setFormat(ImageFormat value) {
            this.format_ = value.getNumber();
        }

        private void clearFormat() {
            this.format_ = 0;
        }

        public static InlineImageResource parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static InlineImageResource parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static InlineImageResource parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static InlineImageResource parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static InlineImageResource parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static InlineImageResource parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static InlineImageResource parseFrom(InputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static InlineImageResource parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static InlineImageResource parseDelimitedFrom(InputStream input) throws IOException {
            return InlineImageResource.parseDelimitedFrom(DEFAULT_INSTANCE, input);
        }

        public static InlineImageResource parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return InlineImageResource.parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static InlineImageResource parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static InlineImageResource parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Builder newBuilder() {
            return (Builder)DEFAULT_INSTANCE.createBuilder();
        }

        public static Builder newBuilder(InlineImageResource prototype) {
            return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
            switch (method) {
                case NEW_MUTABLE_INSTANCE: {
                    return new InlineImageResource();
                }
                case NEW_BUILDER: {
                    return new Builder();
                }
                case BUILD_MESSAGE_INFO: {
                    Object[] objects = new Object[]{"data_", "widthPx_", "heightPx_", "format_"};
                    String info = "\u0000\u0004\u0000\u0000\u0001\u0004\u0004\u0000\u0000\u0000\u0001\n\u0002\u0004\u0003\u0004\u0004\f";
                    return InlineImageResource.newMessageInfo(DEFAULT_INSTANCE, info, objects);
                }
                case GET_DEFAULT_INSTANCE: {
                    return DEFAULT_INSTANCE;
                }
                case GET_PARSER: {
                    Parser<InlineImageResource> parser = PARSER;
                    if (parser != null) return parser;
                    Class<InlineImageResource> clazz = InlineImageResource.class;
                    synchronized (InlineImageResource.class) {
                        parser = PARSER;
                        if (parser != null) return parser;
                        PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<InlineImageResource>(DEFAULT_INSTANCE);
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        return parser;
                    }
                }
                case GET_MEMOIZED_IS_INITIALIZED: {
                    return (byte)1;
                }
                case SET_MEMOIZED_IS_INITIALIZED: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static InlineImageResource getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<InlineImageResource> parser() {
            return DEFAULT_INSTANCE.getParserForType();
        }

        static {
            InlineImageResource defaultInstance;
            DEFAULT_INSTANCE = defaultInstance = new InlineImageResource();
            GeneratedMessageLite.registerDefaultInstance(InlineImageResource.class, defaultInstance);
        }

        public static final class Builder
        extends GeneratedMessageLite.Builder<InlineImageResource, Builder>
        implements InlineImageResourceOrBuilder {
            private Builder() {
                super(DEFAULT_INSTANCE);
            }

            @Override
            public ByteString getData() {
                return ((InlineImageResource)this.instance).getData();
            }

            public Builder setData(ByteString value) {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).setData(value);
                return this;
            }

            public Builder clearData() {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).clearData();
                return this;
            }

            @Override
            public int getWidthPx() {
                return ((InlineImageResource)this.instance).getWidthPx();
            }

            public Builder setWidthPx(int value) {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).setWidthPx(value);
                return this;
            }

            public Builder clearWidthPx() {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).clearWidthPx();
                return this;
            }

            @Override
            public int getHeightPx() {
                return ((InlineImageResource)this.instance).getHeightPx();
            }

            public Builder setHeightPx(int value) {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).setHeightPx(value);
                return this;
            }

            public Builder clearHeightPx() {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).clearHeightPx();
                return this;
            }

            @Override
            public int getFormatValue() {
                return ((InlineImageResource)this.instance).getFormatValue();
            }

            public Builder setFormatValue(int value) {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).setFormatValue(value);
                return this;
            }

            @Override
            public ImageFormat getFormat() {
                return ((InlineImageResource)this.instance).getFormat();
            }

            public Builder setFormat(ImageFormat value) {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).setFormat(value);
                return this;
            }

            public Builder clearFormat() {
                this.copyOnWrite();
                ((InlineImageResource)this.instance).clearFormat();
                return this;
            }
        }
    }

    public static interface InlineImageResourceOrBuilder
    extends MessageLiteOrBuilder {
        public ByteString getData();

        public int getWidthPx();

        public int getHeightPx();

        public int getFormatValue();

        public ImageFormat getFormat();
    }

    public static final class AndroidImageResourceByResId
    extends GeneratedMessageLite<AndroidImageResourceByResId, Builder>
    implements AndroidImageResourceByResIdOrBuilder {
        public static final int RESOURCE_ID_FIELD_NUMBER = 1;
        private int resourceId_;
        private static final AndroidImageResourceByResId DEFAULT_INSTANCE;
        private static volatile Parser<AndroidImageResourceByResId> PARSER;

        private AndroidImageResourceByResId() {
        }

        @Override
        public int getResourceId() {
            return this.resourceId_;
        }

        private void setResourceId(int value) {
            this.resourceId_ = value;
        }

        private void clearResourceId() {
            this.resourceId_ = 0;
        }

        public static AndroidImageResourceByResId parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static AndroidImageResourceByResId parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static AndroidImageResourceByResId parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static AndroidImageResourceByResId parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static AndroidImageResourceByResId parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data);
        }

        public static AndroidImageResourceByResId parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, data, extensionRegistry);
        }

        public static AndroidImageResourceByResId parseFrom(InputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static AndroidImageResourceByResId parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static AndroidImageResourceByResId parseDelimitedFrom(InputStream input) throws IOException {
            return AndroidImageResourceByResId.parseDelimitedFrom(DEFAULT_INSTANCE, input);
        }

        public static AndroidImageResourceByResId parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return AndroidImageResourceByResId.parseDelimitedFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static AndroidImageResourceByResId parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input);
        }

        public static AndroidImageResourceByResId parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageLite.parseFrom(DEFAULT_INSTANCE, input, extensionRegistry);
        }

        public static Builder newBuilder() {
            return (Builder)DEFAULT_INSTANCE.createBuilder();
        }

        public static Builder newBuilder(AndroidImageResourceByResId prototype) {
            return (Builder)DEFAULT_INSTANCE.createBuilder(prototype);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
            switch (method) {
                case NEW_MUTABLE_INSTANCE: {
                    return new AndroidImageResourceByResId();
                }
                case NEW_BUILDER: {
                    return new Builder();
                }
                case BUILD_MESSAGE_INFO: {
                    Object[] objects = new Object[]{"resourceId_"};
                    String info = "\u0000\u0001\u0000\u0000\u0001\u0001\u0001\u0000\u0000\u0000\u0001\u0004";
                    return AndroidImageResourceByResId.newMessageInfo(DEFAULT_INSTANCE, info, objects);
                }
                case GET_DEFAULT_INSTANCE: {
                    return DEFAULT_INSTANCE;
                }
                case GET_PARSER: {
                    Parser<AndroidImageResourceByResId> parser = PARSER;
                    if (parser != null) return parser;
                    Class<AndroidImageResourceByResId> clazz = AndroidImageResourceByResId.class;
                    synchronized (AndroidImageResourceByResId.class) {
                        parser = PARSER;
                        if (parser != null) return parser;
                        PARSER = parser = new GeneratedMessageLite.DefaultInstanceBasedParser<AndroidImageResourceByResId>(DEFAULT_INSTANCE);
                        // ** MonitorExit[var5_7] (shouldn't be in output)
                        return parser;
                    }
                }
                case GET_MEMOIZED_IS_INITIALIZED: {
                    return (byte)1;
                }
                case SET_MEMOIZED_IS_INITIALIZED: {
                    return null;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static AndroidImageResourceByResId getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AndroidImageResourceByResId> parser() {
            return DEFAULT_INSTANCE.getParserForType();
        }

        static {
            AndroidImageResourceByResId defaultInstance;
            DEFAULT_INSTANCE = defaultInstance = new AndroidImageResourceByResId();
            GeneratedMessageLite.registerDefaultInstance(AndroidImageResourceByResId.class, defaultInstance);
        }

        public static final class Builder
        extends GeneratedMessageLite.Builder<AndroidImageResourceByResId, Builder>
        implements AndroidImageResourceByResIdOrBuilder {
            private Builder() {
                super(DEFAULT_INSTANCE);
            }

            @Override
            public int getResourceId() {
                return ((AndroidImageResourceByResId)this.instance).getResourceId();
            }

            public Builder setResourceId(int value) {
                this.copyOnWrite();
                ((AndroidImageResourceByResId)this.instance).setResourceId(value);
                return this;
            }

            public Builder clearResourceId() {
                this.copyOnWrite();
                ((AndroidImageResourceByResId)this.instance).clearResourceId();
                return this;
            }
        }
    }

    public static interface AndroidImageResourceByResIdOrBuilder
    extends MessageLiteOrBuilder {
        public int getResourceId();
    }

    public static enum ImageFormat implements Internal.EnumLite
    {
        IMAGE_FORMAT_UNDEFINED(0),
        IMAGE_FORMAT_RGB_565(1),
        UNRECOGNIZED(-1);

        public static final int IMAGE_FORMAT_UNDEFINED_VALUE = 0;
        public static final int IMAGE_FORMAT_RGB_565_VALUE = 1;
        private static final Internal.EnumLiteMap<ImageFormat> internalValueMap;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ImageFormat valueOf(int value) {
            return ImageFormat.forNumber(value);
        }

        public static ImageFormat forNumber(int value) {
            switch (value) {
                case 0: {
                    return IMAGE_FORMAT_UNDEFINED;
                }
                case 1: {
                    return IMAGE_FORMAT_RGB_565;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ImageFormat> internalGetValueMap() {
            return internalValueMap;
        }

        public static Internal.EnumVerifier internalGetVerifier() {
            return ImageFormatVerifier.INSTANCE;
        }

        private ImageFormat(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ImageFormat>(){

                @Override
                public ImageFormat findValueByNumber(int number) {
                    return ImageFormat.forNumber(number);
                }
            };
        }

        private static final class ImageFormatVerifier
        implements Internal.EnumVerifier {
            static final Internal.EnumVerifier INSTANCE = new ImageFormatVerifier();

            private ImageFormatVerifier() {
            }

            @Override
            public boolean isInRange(int number) {
                return ImageFormat.forNumber(number) != null;
            }
        }
    }
}

