/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.tiles.tooling;

import android.content.Context;
import android.util.DisplayMetrics;
import androidx.wear.protolayout.DeviceParametersBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.TimelineBuilders;
import androidx.wear.protolayout.expression.DynamicDataBuilders;
import androidx.wear.protolayout.expression.PlatformDataValues;
import androidx.wear.protolayout.expression.PlatformHealthSources;
import androidx.wear.tiles.timeline.TilesTimelineCache;
import androidx.wear.tiles.tooling.TileServiceViewAdapterKt;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001aE\u0010\u0007\u001a\u00020\b*\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00012\"\u0010\f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\r\"\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\u0010\u000e\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0004\u0018\u00010\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"TOOLS_NS_URI", "", "defaultPlatformDataValues", "Landroidx/wear/protolayout/expression/PlatformDataValues;", "buildDeviceParameters", "Landroidx/wear/protolayout/DeviceParametersBuilders$DeviceParameters;", "Landroid/content/Context;", "findMethod", "Ljava/lang/reflect/Method;", "Ljava/lang/Class;", "", "name", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getCurrentLayout", "Landroidx/wear/protolayout/LayoutElementBuilders$Layout;", "Landroidx/wear/protolayout/TimelineBuilders$Timeline;", "tiles-tooling_release"})
public final class TileServiceViewAdapterKt {
    @NotNull
    private static final String TOOLS_NS_URI = "http://schemas.android.com/tools";
    @NotNull
    private static final PlatformDataValues defaultPlatformDataValues;

    @NotNull
    public static final Method findMethod(@NotNull Class<? extends Object> $this$findMethod, @NotNull String name, Class<? extends Object> ... parameterTypes) {
        Intrinsics.checkNotNullParameter($this$findMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        for (Class<? extends Object> currentClass = $this$findMethod; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Method method = currentClass.getDeclaredMethod(name, Arrays.copyOf(parameterTypes, parameterTypes.length));
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"currentClass.getDeclared\u2026od(name, *parameterTypes)");
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        String methodSignature2 = name + '(' + ArraysKt.joinToString$default((Object[])parameterTypes, null, null, null, (int)0, null, (Function1)findMethod.methodSignature.1.INSTANCE, (int)31, null) + ')';
        throw new NoSuchMethodException("Could not find method " + methodSignature2 + " neither in " + $this$findMethod + " nor in its superclasses.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final LayoutElementBuilders.Layout getCurrentLayout(@Nullable TimelineBuilders.Timeline $this$getCurrentLayout) {
        TimelineBuilders.TimelineEntry timelineEntry;
        long now = System.currentTimeMillis();
        if ($this$getCurrentLayout == null) return null;
        TimelineBuilders.Timeline it = $this$getCurrentLayout;
        boolean bl = false;
        TilesTimelineCache cache = new TilesTimelineCache(it);
        TimelineBuilders.TimelineEntry timelineEntry2 = cache.findTileTimelineEntryForTime(now);
        if (timelineEntry2 == null) {
            timelineEntry2 = cache.findClosestTileTimelineEntry(now);
        }
        if ((timelineEntry = timelineEntry2) == null) return null;
        LayoutElementBuilders.Layout layout = timelineEntry.getLayout();
        return layout;
    }

    @NotNull
    public static final DeviceParametersBuilders.DeviceParameters buildDeviceParameters(@NotNull Context $this$buildDeviceParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$buildDeviceParameters, (String)"<this>");
        DisplayMetrics displayMetrics = $this$buildDeviceParameters.getResources().getDisplayMetrics();
        boolean isScreenRound = $this$buildDeviceParameters.getResources().getConfiguration().isScreenRound();
        DeviceParametersBuilders.DeviceParameters deviceParameters = new DeviceParametersBuilders.DeviceParameters.Builder().setScreenWidthDp(MathKt.roundToInt((float)((float)displayMetrics.widthPixels / displayMetrics.density))).setScreenHeightDp(MathKt.roundToInt((float)((float)displayMetrics.heightPixels / displayMetrics.density))).setScreenDensity(displayMetrics.density).setScreenShape(isScreenRound ? 1 : 2).setDevicePlatform(1).setFontScale($this$buildDeviceParameters.getResources().getConfiguration().fontScale).build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceParameters, (String)"Builder()\n        .setSc\u2026ntScale)\n        .build()");
        return deviceParameters;
    }

    public static final /* synthetic */ PlatformDataValues access$getDefaultPlatformDataValues$p() {
        return defaultPlatformDataValues;
    }

    static {
        PlatformDataValues platformDataValues = new PlatformDataValues.Builder().put(PlatformHealthSources.Keys.HEART_RATE_BPM, DynamicDataBuilders.DynamicDataValue.fromFloat((float)80.0f)).put(PlatformHealthSources.Keys.HEART_RATE_ACCURACY, PlatformHealthSources.DynamicHeartRateAccuracy.dynamicDataValueOf((int)4)).put(PlatformHealthSources.Keys.DAILY_STEPS, DynamicDataBuilders.DynamicDataValue.fromInt((int)4710)).put(PlatformHealthSources.Keys.DAILY_FLOORS, DynamicDataBuilders.DynamicDataValue.fromFloat((float)12.5f)).put(PlatformHealthSources.Keys.DAILY_CALORIES, DynamicDataBuilders.DynamicDataValue.fromFloat((float)245.3f)).put(PlatformHealthSources.Keys.DAILY_DISTANCE_METERS, DynamicDataBuilders.DynamicDataValue.fromFloat((float)3670.8f)).build();
        Intrinsics.checkNotNullExpressionValue((Object)platformDataValues, (String)"Builder()\n        .put(P\u2026670.8f))\n        .build()");
        defaultPlatformDataValues = platformDataValues;
    }
}

