/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/wear/watchface/BroadcastReceivers;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "actionBatteryLowReceiver", "Landroid/content/BroadcastReceiver;", "actionBatteryOkayReceiver", "actionPowerConnectedReceiver", "actionTimeReceiver", "actionTimeTickReceiver", "actionTimeZoneReceiver", "mockTimeReceiver", "onDestroy", "", "BroadcastEventObserver", "Companion", "wear-watchface_release"})
public final class BroadcastReceivers {
    private final BroadcastReceiver actionTimeTickReceiver;
    private final BroadcastReceiver actionTimeZoneReceiver;
    private final BroadcastReceiver actionTimeReceiver;
    private final BroadcastReceiver actionBatteryLowReceiver;
    private final BroadcastReceiver actionBatteryOkayReceiver;
    private final BroadcastReceiver actionPowerConnectedReceiver;
    private final BroadcastReceiver mockTimeReceiver;
    private final Context context;
    @NotNull
    private static final HashSet<BroadcastEventObserver> broadcastEventObservers;
    @Nullable
    private static BroadcastReceivers broadcastReceivers;
    @NotNull
    public static final Companion Companion;

    public final void onDestroy() {
        this.context.unregisterReceiver(this.actionTimeTickReceiver);
        this.context.unregisterReceiver(this.actionTimeZoneReceiver);
        this.context.unregisterReceiver(this.actionTimeReceiver);
        this.context.unregisterReceiver(this.actionBatteryLowReceiver);
        this.context.unregisterReceiver(this.actionBatteryOkayReceiver);
        this.context.unregisterReceiver(this.actionPowerConnectedReceiver);
        this.context.unregisterReceiver(this.mockTimeReceiver);
    }

    private BroadcastReceivers(Context context) {
        this.context = context;
        this.actionTimeTickReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onActionTimeTick();
                }
            }
        };
        this.actionTimeZoneReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onActionTimeZoneChanged();
                }
            }
        };
        this.actionTimeReceiver = new BroadcastReceiver(){

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onActionTimeChanged();
                }
            }
        };
        this.actionBatteryLowReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onActionBatteryLow();
                }
            }
        };
        this.actionBatteryOkayReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onActionBatteryOkay();
                }
            }
        };
        this.actionPowerConnectedReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onActionPowerConnected();
                }
            }
        };
        this.mockTimeReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                for (BroadcastEventObserver observer : BroadcastReceivers.Companion.getBroadcastEventObservers()) {
                    observer.onMockTime(intent);
                }
            }
        };
        this.context.registerReceiver(this.actionTimeTickReceiver, new IntentFilter("android.intent.action.TIME_TICK"));
        this.context.registerReceiver(this.actionTimeZoneReceiver, new IntentFilter("android.intent.action.TIMEZONE_CHANGED"));
        this.context.registerReceiver(this.actionTimeReceiver, new IntentFilter("android.intent.action.TIME_SET"));
        this.context.registerReceiver(this.actionBatteryLowReceiver, new IntentFilter("android.intent.action.BATTERY_LOW"));
        this.context.registerReceiver(this.actionBatteryOkayReceiver, new IntentFilter("android.intent.action.BATTERY_OKAY"));
        this.context.registerReceiver(this.actionPowerConnectedReceiver, new IntentFilter("android.intent.action.ACTION_POWER_CONNECTED"));
        this.context.registerReceiver(this.mockTimeReceiver, new IntentFilter("androidx.wear.watchface.MockTime"));
    }

    static {
        Companion = new Companion(null);
        broadcastEventObservers = new HashSet();
    }

    public /* synthetic */ BroadcastReceivers(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'J\b\u0010\u0004\u001a\u00020\u0003H'J\b\u0010\u0005\u001a\u00020\u0003H'J\b\u0010\u0006\u001a\u00020\u0003H'J\b\u0010\u0007\u001a\u00020\u0003H'J\b\u0010\b\u001a\u00020\u0003H'J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH'\u00a8\u0006\f"}, d2={"Landroidx/wear/watchface/BroadcastReceivers$BroadcastEventObserver;", "", "onActionBatteryLow", "", "onActionBatteryOkay", "onActionPowerConnected", "onActionTimeChanged", "onActionTimeTick", "onActionTimeZoneChanged", "onMockTime", "intent", "Landroid/content/Intent;", "wear-watchface_release"})
    public static interface BroadcastEventObserver {
        @UiThread
        public void onActionTimeTick();

        @UiThread
        public void onActionTimeZoneChanged();

        @UiThread
        public void onActionTimeChanged();

        @UiThread
        public void onActionBatteryLow();

        @UiThread
        public void onActionBatteryOkay();

        @UiThread
        public void onActionPowerConnected();

        @UiThread
        public void onMockTime(@NotNull Intent var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Landroidx/wear/watchface/BroadcastReceivers$Companion;", "", "()V", "broadcastEventObservers", "Ljava/util/HashSet;", "Landroidx/wear/watchface/BroadcastReceivers$BroadcastEventObserver;", "Lkotlin/collections/HashSet;", "getBroadcastEventObservers", "()Ljava/util/HashSet;", "broadcastReceivers", "Landroidx/wear/watchface/BroadcastReceivers;", "getBroadcastReceivers", "()Landroidx/wear/watchface/BroadcastReceivers;", "setBroadcastReceivers", "(Landroidx/wear/watchface/BroadcastReceivers;)V", "addBroadcastEventObserver", "", "context", "Landroid/content/Context;", "observer", "removeBroadcastEventObserver", "sendOnActionBatteryLowForTesting", "intent", "Landroid/content/Intent;", "sendOnActionBatteryOkayForTesting", "sendOnActionPowerConnectedForTesting", "sendOnMockTimeForTesting", "wear-watchface_release"})
    public static final class Companion {
        @NotNull
        public final HashSet<BroadcastEventObserver> getBroadcastEventObservers() {
            return broadcastEventObservers;
        }

        @Nullable
        public final BroadcastReceivers getBroadcastReceivers() {
            return broadcastReceivers;
        }

        public final void setBroadcastReceivers(@Nullable BroadcastReceivers broadcastReceivers) {
            BroadcastReceivers.broadcastReceivers = broadcastReceivers;
        }

        @UiThread
        public final void addBroadcastEventObserver(@NotNull Context context, @NotNull BroadcastEventObserver observer) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
            this.getBroadcastEventObservers().add(observer);
            if (this.getBroadcastReceivers() == null) {
                this.setBroadcastReceivers(new BroadcastReceivers(context, null));
            }
        }

        @UiThread
        public final void removeBroadcastEventObserver(@NotNull BroadcastEventObserver observer) {
            Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
            this.getBroadcastEventObservers().remove(observer);
            if (this.getBroadcastEventObservers().isEmpty()) {
                BroadcastReceivers broadcastReceivers = this.getBroadcastReceivers();
                Intrinsics.checkNotNull((Object)broadcastReceivers);
                broadcastReceivers.onDestroy();
                this.setBroadcastReceivers(null);
            }
        }

        @VisibleForTesting
        public final void sendOnActionBatteryLowForTesting(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            boolean bl = Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.intent.action.BATTERY_LOW");
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection collection = this.getBroadcastEventObservers();
            bl2 = false;
            boolean bl6 = !collection.isEmpty();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl6) {
                boolean bl7 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            for (BroadcastEventObserver observer : this.getBroadcastEventObservers()) {
                observer.onActionBatteryLow();
            }
        }

        @VisibleForTesting
        public final void sendOnActionBatteryOkayForTesting(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            boolean bl = Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.intent.action.BATTERY_OKAY");
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection collection = this.getBroadcastEventObservers();
            bl2 = false;
            boolean bl6 = !collection.isEmpty();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl6) {
                boolean bl7 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            for (BroadcastEventObserver observer : this.getBroadcastEventObservers()) {
                observer.onActionBatteryOkay();
            }
        }

        @VisibleForTesting
        public final void sendOnActionPowerConnectedForTesting(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            boolean bl = Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.intent.action.ACTION_POWER_CONNECTED");
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection collection = this.getBroadcastEventObservers();
            bl2 = false;
            boolean bl6 = !collection.isEmpty();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl6) {
                boolean bl7 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            for (BroadcastEventObserver observer : this.getBroadcastEventObservers()) {
                observer.onActionPowerConnected();
            }
        }

        @VisibleForTesting
        public final void sendOnMockTimeForTesting(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            boolean bl = Intrinsics.areEqual((Object)intent.getAction(), (Object)"androidx.wear.watchface.MockTime");
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection collection = this.getBroadcastEventObservers();
            bl2 = false;
            boolean bl6 = !collection.isEmpty();
            bl2 = false;
            bl3 = false;
            bl3 = false;
            bl4 = false;
            if (!bl6) {
                boolean bl7 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            for (BroadcastEventObserver observer : this.getBroadcastEventObservers()) {
                observer.onMockTime(intent);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

