/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.icu.util.Calendar;
import androidx.annotation.ColorInt;
import androidx.annotation.UiThread;
import androidx.wear.complications.data.IdAndComplicationData;
import androidx.wear.watchface.CanvasComplication;
import androidx.wear.watchface.CanvasComplicationDrawable$WhenMappings;
import androidx.wear.watchface.Complication;
import androidx.wear.watchface.ComplicationOutlineRenderer;
import androidx.wear.watchface.LayerMode;
import androidx.wear.watchface.Observer;
import androidx.wear.watchface.RenderParameters;
import androidx.wear.watchface.WatchState;
import androidx.wear.watchface.complications.rendering.ComplicationDrawable;
import androidx.wear.watchface.style.Layer;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\nH\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J(\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010*\u001a\u00020\u0012H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00128W@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/wear/watchface/CanvasComplicationDrawable;", "Landroidx/wear/watchface/CanvasComplication;", "drawable", "Landroidx/wear/watchface/complications/rendering/ComplicationDrawable;", "watchState", "Landroidx/wear/watchface/WatchState;", "(Landroidx/wear/watchface/complications/rendering/ComplicationDrawable;Landroidx/wear/watchface/WatchState;)V", "_idAndData", "Landroidx/wear/complications/data/IdAndComplicationData;", "attachedComplication", "Landroidx/wear/watchface/Complication;", "value", "getDrawable", "()Landroidx/wear/watchface/complications/rendering/ComplicationDrawable;", "setDrawable", "(Landroidx/wear/watchface/complications/rendering/ComplicationDrawable;)V", "isAmbientObserver", "Landroidx/wear/watchface/Observer;", "", "isHighlighted", "()Z", "setIsHighlighted", "(Z)V", "drawOutline", "", "canvas", "Landroid/graphics/Canvas;", "bounds", "Landroid/graphics/Rect;", "calendar", "Landroid/icu/util/Calendar;", "color", "", "getIdAndData", "onAttach", "complication", "onDetach", "render", "renderParameters", "Landroidx/wear/watchface/RenderParameters;", "setIdAndData", "idAndComplicationData", "loadDrawablesAsynchronous", "wear-watchface_release"})
public class CanvasComplicationDrawable
implements CanvasComplication {
    @NotNull
    private ComplicationDrawable drawable;
    private final Observer<Boolean> isAmbientObserver;
    private Complication attachedComplication;
    private IdAndComplicationData _idAndData;
    private final WatchState watchState;

    @NotNull
    public final ComplicationDrawable getDrawable() {
        return this.drawable;
    }

    public final void setDrawable(@NotNull ComplicationDrawable value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.drawable = value;
            value.setInAmbientMode(this.watchState.isAmbient().getValue().booleanValue());
            value.setLowBitAmbient(this.watchState.hasLowBitAmbient());
            value.setBurnInProtection(this.watchState.hasBurnInProtection());
            Complication complication = this.attachedComplication;
            if (complication == null) break block0;
            complication.scheduleUpdateComplications$wear_watchface_release();
        }
    }

    @Override
    public void onAttach(@NotNull Complication complication) {
        Intrinsics.checkNotNullParameter((Object)complication, (String)"complication");
        this.attachedComplication = complication;
        this.watchState.isAmbient().addObserver(this.isAmbientObserver);
    }

    @Override
    public void onDetach() {
        this.watchState.isAmbient().removeObserver(this.isAmbientObserver);
        this.attachedComplication = null;
    }

    @Override
    public void render(@NotNull Canvas canvas, @NotNull Rect bounds, @NotNull Calendar calendar, @NotNull RenderParameters renderParameters) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)renderParameters, (String)"renderParameters");
        LayerMode layerMode = renderParameters.getLayerParameters().get(Layer.COMPLICATIONS);
        if (layerMode != null) {
            switch (CanvasComplicationDrawable$WhenMappings.$EnumSwitchMapping$0[layerMode.ordinal()]) {
                case 1: {
                    this.drawable.setBounds(bounds);
                    this.drawable.setCurrentTimeMillis(calendar.getTimeInMillis());
                    this.drawable.draw(canvas);
                    break;
                }
                case 2: {
                    this.drawable.setBounds(bounds);
                    this.drawable.setCurrentTimeMillis(calendar.getTimeInMillis());
                    boolean wasHighlighted = this.drawable.isHighlighted();
                    IdAndComplicationData idAndComplicationData = this.getIdAndData();
                    this.drawable.setHighlighted(Intrinsics.areEqual((Object)renderParameters.getSelectedComplicationId(), (Object)(idAndComplicationData != null ? Integer.valueOf(idAndComplicationData.getComplicationId()) : null)));
                    this.drawable.draw(canvas);
                    this.drawable.setHighlighted(wasHighlighted);
                    Complication complication = this.attachedComplication;
                    if (complication != null && complication.getBoundsType() == 1) break;
                    this.drawOutline(canvas, bounds, calendar, renderParameters.getOutlineTint());
                    break;
                }
                case 3: {
                    return;
                }
            }
        }
    }

    public void drawOutline(@NotNull Canvas canvas, @NotNull Rect bounds, @NotNull Calendar calendar, @ColorInt int color) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Complication complication = this.attachedComplication;
        Intrinsics.checkNotNull((Object)complication);
        if (!complication.isFixedComplicationProvider()) {
            ComplicationOutlineRenderer.Companion.drawComplicationSelectOutline(canvas, bounds, color);
        }
    }

    @Override
    @JvmName(name="isHighlighted")
    @UiThread
    public boolean isHighlighted() {
        return this.drawable.isHighlighted();
    }

    @Override
    @JvmName(name="setIsHighlighted")
    @UiThread
    public void setIsHighlighted(boolean value) {
        this.drawable.setHighlighted(value);
    }

    @Override
    @Nullable
    public IdAndComplicationData getIdAndData() {
        return this._idAndData;
    }

    @Override
    public void setIdAndData(@Nullable IdAndComplicationData idAndComplicationData, boolean loadDrawablesAsynchronous) {
        this._idAndData = idAndComplicationData;
        IdAndComplicationData idAndComplicationData2 = idAndComplicationData;
        this.drawable.setComplicationData(idAndComplicationData2 != null && (idAndComplicationData2 = idAndComplicationData2.getComplicationData()) != null ? idAndComplicationData2.asWireComplicationData() : null, loadDrawablesAsynchronous);
    }

    public CanvasComplicationDrawable(@NotNull ComplicationDrawable drawable, @NotNull WatchState watchState) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)watchState, (String)"watchState");
        this.watchState = watchState;
        drawable.setCallback(new Drawable.Callback(){

            public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
                Intrinsics.checkNotNullParameter((Object)who, (String)"who");
                Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            }

            @SuppressLint(value={"SyntheticAccessor"})
            public void invalidateDrawable(@NotNull Drawable who) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)who, (String)"who");
                    Complication complication = attachedComplication;
                    if (complication == null) break block0;
                    complication.invalidate();
                }
            }

            public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
                Intrinsics.checkNotNullParameter((Object)who, (String)"who");
                Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            }
        });
        this.drawable = drawable;
        this.isAmbientObserver = new Observer<Boolean>(drawable){
            final /* synthetic */ ComplicationDrawable $drawable;

            public final void onChanged(boolean it) {
                this.$drawable.setInAmbientMode(it);
            }
            {
                this.$drawable = complicationDrawable;
            }
        };
    }

    public static final /* synthetic */ void access$setAttachedComplication$p(CanvasComplicationDrawable $this, Complication complication) {
        $this.attachedComplication = complication;
    }
}

