/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.support.wearable.watchface.accessibility.AccessibilityUtils;
import android.support.wearable.watchface.accessibility.ContentDescriptionLabel;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.wear.complications.ComplicationBounds;
import androidx.wear.complications.ComplicationHelperActivity;
import androidx.wear.complications.DefaultComplicationProviderPolicy;
import androidx.wear.complications.data.ComplicationData;
import androidx.wear.complications.data.ComplicationType;
import androidx.wear.complications.data.IdAndComplicationData;
import androidx.wear.watchface.CancellableUniqueTask;
import androidx.wear.watchface.Complication;
import androidx.wear.watchface.ComplicationsManagerKt;
import androidx.wear.watchface.IndentingPrintWriter;
import androidx.wear.watchface.MutableObservableWatchData;
import androidx.wear.watchface.Renderer;
import androidx.wear.watchface.WatchFaceHostApi;
import androidx.wear.watchface.style.UserStyle;
import androidx.wear.watchface.style.UserStyleRepository;
import androidx.wear.watchface.style.UserStyleSetting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002CDB%\b\u0011\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0007J\u0015\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0013H\u0007J\u0015\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(J\u0013\u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020\u0013H\u0086\u0002J\b\u0010+\u001a\u0004\u0018\u00010\u0004J\u0018\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0013J\u0015\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0000\u00a2\u0006\u0004\b2\u00103J-\u00104\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;H\u0001\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b>J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0007J\r\u0010@\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bAJ\b\u0010B\u001a\u00020\u001dH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00170\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Landroidx/wear/watchface/ComplicationsManager;", "", "complicationCollection", "", "Landroidx/wear/watchface/Complication;", "userStyleRepository", "Landroidx/wear/watchface/style/UserStyleRepository;", "renderer", "Landroidx/wear/watchface/Renderer;", "(Ljava/util/Collection;Landroidx/wear/watchface/style/UserStyleRepository;Landroidx/wear/watchface/Renderer;)V", "(Ljava/util/Collection;Landroidx/wear/watchface/style/UserStyleRepository;)V", "calendar", "Landroid/icu/util/Calendar;", "complicationListeners", "Ljava/util/HashSet;", "Landroidx/wear/watchface/ComplicationsManager$TapCallback;", "Lkotlin/collections/HashSet;", "complications", "", "", "getComplications", "()Ljava/util/Map;", "initialComplicationConfigs", "Landroidx/wear/watchface/ComplicationsManager$InitialComplicationConfig;", "pendingUpdate", "Landroidx/wear/watchface/CancellableUniqueTask;", "watchFaceHostApi", "Landroidx/wear/watchface/WatchFaceHostApi;", "addTapListener", "", "tapCallback", "applyComplicationsStyleCategoryOption", "styleOption", "Landroidx/wear/watchface/style/UserStyleSetting$ComplicationsUserStyleSetting$ComplicationsOption;", "applyComplicationsStyleCategoryOption$wear_watchface_release", "bringAttentionToComplication", "complicationId", "dump", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "dump$wear_watchface_release", "get", "id", "getBackgroundComplication", "getComplicationAt", "x", "y", "getContentDescriptionLabels", "", "Landroid/support/wearable/watchface/accessibility/ContentDescriptionLabel;", "getContentDescriptionLabels$wear_watchface_release", "()[Landroid/support/wearable/watchface/accessibility/ContentDescriptionLabel;", "init", "complicationInvalidateListener", "Landroidx/wear/watchface/Complication$InvalidateListener;", "init$wear_watchface_release", "onComplicationDataUpdate", "watchFaceComplicationId", "data", "Landroidx/wear/complications/data/ComplicationData;", "onComplicationDataUpdate$wear_watchface_release", "onComplicationSingleTapped", "onComplicationSingleTapped$wear_watchface_release", "removeTapListener", "scheduleUpdate", "scheduleUpdate$wear_watchface_release", "updateComplications", "InitialComplicationConfig", "TapCallback", "wear-watchface_release"})
public final class ComplicationsManager {
    private WatchFaceHostApi watchFaceHostApi;
    private Calendar calendar;
    private Renderer renderer;
    private CancellableUniqueTask pendingUpdate;
    @NotNull
    private final Map<Integer, Complication> complications;
    private final Map<Integer, InitialComplicationConfig> initialComplicationConfigs;
    private final HashSet<TapCallback> complicationListeners;
    private final UserStyleRepository userStyleRepository;

    @NotNull
    public final Map<Integer, Complication> getComplications() {
        return this.complications;
    }

    /*
     * WARNING - void declaration
     */
    public final void init$wear_watchface_release(@NotNull WatchFaceHostApi watchFaceHostApi, @NotNull Calendar calendar, @NotNull Renderer renderer, @NotNull Complication.InvalidateListener complicationInvalidateListener) {
        Object v0;
        Iterable $this$firstOrNull$iv;
        block3: {
            Intrinsics.checkNotNullParameter((Object)watchFaceHostApi, (String)"watchFaceHostApi");
            Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            Intrinsics.checkNotNullParameter((Object)complicationInvalidateListener, (String)"complicationInvalidateListener");
            this.watchFaceHostApi = watchFaceHostApi;
            this.calendar = calendar;
            this.renderer = renderer;
            this.pendingUpdate = new CancellableUniqueTask(watchFaceHostApi.getHandler());
            Map<Integer, Complication> map = this.complications;
            boolean bl = false;
            Iterator<Map.Entry<Integer, Complication>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, Complication> entry;
                Map.Entry<Integer, Complication> entry2 = entry = iterator.next();
                boolean bl2 = false;
                Complication complication = entry2.getValue();
                complication.init$wear_watchface_release(this, complicationInvalidateListener);
            }
            $this$firstOrNull$iv = this.userStyleRepository.getSchema().getUserStyleSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UserStyleSetting it = (UserStyleSetting)element$iv;
                boolean bl3 = false;
                if (!(it instanceof UserStyleSetting.ComplicationsUserStyleSetting)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        UserStyleSetting complicationsStyleCategory = v0;
        if (complicationsStyleCategory != null) {
            void previousOption;
            $this$firstOrNull$iv = new Ref.ObjectRef();
            ((Ref.ObjectRef)$this$firstOrNull$iv).element = null;
            this.userStyleRepository.addUserStyleListener(new UserStyleRepository.UserStyleListener(this, complicationsStyleCategory, (Ref.ObjectRef)previousOption){
                final /* synthetic */ ComplicationsManager this$0;
                final /* synthetic */ UserStyleSetting $complicationsStyleCategory;
                final /* synthetic */ Ref.ObjectRef $previousOption;

                public void onUserStyleChanged(@NotNull UserStyle userStyle) {
                    Intrinsics.checkNotNullParameter((Object)userStyle, (String)"userStyle");
                    UserStyleSetting.Option option = userStyle.get(this.$complicationsStyleCategory);
                    Object object = option != null ? option.toComplicationsOption() : null;
                    Intrinsics.checkNotNull((Object)object);
                    UserStyleSetting.ComplicationsUserStyleSetting.ComplicationsOption newlySelectedOption = object;
                    if (Intrinsics.areEqual((Object)((UserStyleSetting.ComplicationsUserStyleSetting.ComplicationsOption)this.$previousOption.element), (Object)newlySelectedOption) ^ true) {
                        this.$previousOption.element = newlySelectedOption;
                        this.this$0.applyComplicationsStyleCategoryOption$wear_watchface_release(newlySelectedOption);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$complicationsStyleCategory = $captured_local_variable$1;
                    this.$previousOption = $captured_local_variable$2;
                }
            });
        }
        this.scheduleUpdate$wear_watchface_release();
    }

    /*
     * WARNING - void declaration
     */
    public final void applyComplicationsStyleCategoryOption$wear_watchface_release(@NotNull UserStyleSetting.ComplicationsUserStyleSetting.ComplicationsOption styleOption) {
        Intrinsics.checkNotNullParameter((Object)styleOption, (String)"styleOption");
        Map<Integer, Complication> map = this.complications;
        boolean bl = false;
        Iterator<Map.Entry<Integer, Complication>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            InitialComplicationConfig initialConfig;
            Object v0;
            void id;
            Complication complication;
            block3: {
                Map.Entry<Integer, Complication> entry;
                Map.Entry<Integer, Complication> entry2 = entry = iterator.next();
                boolean bl2 = false;
                int n = ((Number)entry2.getKey()).intValue();
                entry2 = entry;
                bl2 = false;
                complication = entry2.getValue();
                Iterable iterable = styleOption.getComplicationOverlays();
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                boolean bl4 = false;
                for (Object t : iterable2) {
                    UserStyleSetting.ComplicationsUserStyleSetting.ComplicationOverlay it = (UserStyleSetting.ComplicationsUserStyleSetting.ComplicationOverlay)t;
                    boolean bl5 = false;
                    if (!(it.getComplicationId() == id)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            UserStyleSetting.ComplicationsUserStyleSetting.ComplicationOverlay override = v0;
            Intrinsics.checkNotNull((Object)this.initialComplicationConfigs.get((int)id));
            UserStyleSetting.ComplicationsUserStyleSetting.ComplicationOverlay complicationOverlay = override;
            if (complicationOverlay == null || (complicationOverlay = complicationOverlay.getComplicationBounds()) == null) {
                complicationOverlay = initialConfig.getComplicationBounds();
            }
            complication.setComplicationBounds((ComplicationBounds)complicationOverlay);
            Object object = override;
            complication.setEnabled$wear_watchface_release(object != null && (object = object.isEnabled()) != null ? ((Boolean)object).booleanValue() : initialConfig.getEnabled());
        }
    }

    @Nullable
    public final Complication get(int id) {
        return this.complications.get(id);
    }

    public final void scheduleUpdate$wear_watchface_release() {
        CancellableUniqueTask cancellableUniqueTask = this.pendingUpdate;
        if (cancellableUniqueTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pendingUpdate");
        }
        if (!cancellableUniqueTask.isPending()) {
            CancellableUniqueTask cancellableUniqueTask2 = this.pendingUpdate;
            if (cancellableUniqueTask2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pendingUpdate");
            }
            cancellableUniqueTask2.postUnique((Function0<Unit>)((Function0)new Function0<Unit>(this){

                public final void invoke() {
                    ComplicationsManager.access$updateComplications((ComplicationsManager)this.receiver);
                }
            }));
        }
    }

    @NotNull
    public final ContentDescriptionLabel[] getContentDescriptionLabels$wear_watchface_release() {
        boolean bl = false;
        List labels = new ArrayList();
        Renderer renderer = this.renderer;
        if (renderer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
        }
        Rect rect = renderer.getMainClockElementBounds();
        WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
        if (watchFaceHostApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
        }
        labels.add(new ContentDescriptionLabel(rect, AccessibilityUtils.makeTimeAsComplicationText((Context)watchFaceHostApi.getContext())));
        Map<Integer, Complication> map = this.complications;
        boolean bl2 = false;
        Iterator<Map.Entry<Integer, Complication>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            IdAndComplicationData idAndComplicationData;
            IdAndComplicationData idAndComplicationData2 = idAndComplicationData = iterator.next();
            boolean bl3 = false;
            Complication complication = idAndComplicationData2.getValue();
            if (!complication.isEnabled() || complication.getBoundsType() == 1) continue;
            IdAndComplicationData idAndComplicationData3 = complication.getRenderer().getIdAndData();
            if (idAndComplicationData3 == null) continue;
            idAndComplicationData2 = idAndComplicationData3;
            bl3 = false;
            boolean bl4 = false;
            IdAndComplicationData it = idAndComplicationData2;
            boolean bl5 = false;
            WatchFaceHostApi watchFaceHostApi2 = this.watchFaceHostApi;
            if (watchFaceHostApi2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            Context context = watchFaceHostApi2.getContext();
            Renderer renderer2 = this.renderer;
            if (renderer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
            }
            labels.add(new ContentDescriptionLabel(context, complication.computeBounds(renderer2.getScreenBounds()), it.getComplicationData().asWireComplicationData()));
        }
        Collection $this$toTypedArray$iv = labels;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ContentDescriptionLabel[] contentDescriptionLabelArray = thisCollection$iv.toArray(new ContentDescriptionLabel[0]);
        if (contentDescriptionLabelArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return contentDescriptionLabelArray;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateComplications() {
        boolean bl = false;
        List activeKeys = new ArrayList();
        boolean enabledDirty = false;
        boolean labelsDirty = false;
        Map<Integer, Complication> map = this.complications;
        boolean bl2 = false;
        Iterator<Map.Entry<Integer, Complication>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Complication> entry;
            Map.Entry<Integer, Complication> entry2 = entry = iterator.next();
            boolean bl3 = false;
            int n = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl3 = false;
            Complication complication = entry2.getValue();
            enabledDirty = enabledDirty || complication.getEnabledDirty$wear_watchface_release();
            boolean bl4 = labelsDirty = labelsDirty || complication.getEnabledDirty$wear_watchface_release();
            if (complication.isEnabled()) {
                void id;
                activeKeys.add((int)id);
                boolean bl5 = labelsDirty = labelsDirty || complication.getDataDirty$wear_watchface_release() || complication.getComplicationBoundsDirty$wear_watchface_release();
                if (complication.getDefaultProviderPolicyDirty$wear_watchface_release() || complication.getDefaultProviderTypeDirty$wear_watchface_release()) {
                    WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
                    if (watchFaceHostApi == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
                    }
                    watchFaceHostApi.setDefaultComplicationProviderWithFallbacks(complication.getId$wear_watchface_release(), complication.getDefaultProviderPolicy().providersAsList(), complication.getDefaultProviderPolicy().getSystemProviderFallback(), complication.getDefaultProviderType().asWireComplicationType());
                }
                complication.setDataDirty$wear_watchface_release(false);
                complication.setComplicationBoundsDirty$wear_watchface_release(false);
                complication.setSupportedTypesDirty$wear_watchface_release(false);
                complication.setDefaultProviderPolicyDirty$wear_watchface_release(false);
                complication.setDefaultProviderTypeDirty$wear_watchface_release(false);
            }
            complication.setEnabledDirty$wear_watchface_release(false);
        }
        if (enabledDirty) {
            WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
            if (watchFaceHostApi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            watchFaceHostApi.setActiveComplications(CollectionsKt.toIntArray((Collection)activeKeys));
        }
        if (labelsDirty) {
            WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
            if (watchFaceHostApi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            watchFaceHostApi.setContentDescriptionLabels(this.getContentDescriptionLabels$wear_watchface_release());
        }
    }

    /*
     * Unable to fully structure code
     */
    @UiThread
    public final void onComplicationDataUpdate$wear_watchface_release(int watchFaceComplicationId, @NotNull ComplicationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        v0 = this.complications.get(watchFaceComplicationId);
        if (v0 == null) {
            return;
        }
        complication = v0;
        if (complication.getDataDirty$wear_watchface_release()) ** GOTO lbl-1000
        v1 = complication.getRenderer().getIdAndData();
        if (Intrinsics.areEqual((Object)(v1 != null ? v1.getComplicationData() : null), (Object)data) ^ true) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        complication.setDataDirty$wear_watchface_release(v2);
        complication.getRenderer().setIdAndData(new IdAndComplicationData(watchFaceComplicationId, data), true);
        v3 = complication.getComplicationData();
        if (v3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.wear.watchface.MutableObservableWatchData<androidx.wear.complications.data.ComplicationData>");
        }
        ((MutableObservableWatchData)v3).setValue(data);
    }

    @UiThread
    public final void bringAttentionToComplication(int complicationId) {
        Complication complication = this.complications.get(complicationId);
        boolean bl = false;
        boolean bl2 = false;
        if (complication == null) {
            boolean bl3 = false;
            String string = "No complication found with ID " + complicationId;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Complication complication2 = complication;
        complication2.setIsHighlighted$wear_watchface_release(true);
        WeakReference<ComplicationsManager> weakRef = new WeakReference<ComplicationsManager>(this);
        WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
        if (watchFaceHostApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
        }
        watchFaceHostApi.getHandler().postDelayed(new Runnable(weakRef, complication2){
            final /* synthetic */ WeakReference $weakRef;
            final /* synthetic */ Complication $complication;

            public final void run() {
                if (this.$weakRef.get() != null) {
                    this.$complication.setIsHighlighted$wear_watchface_release(false);
                }
            }
            {
                this.$weakRef = weakReference;
                this.$complication = complication;
            }
        }, 300L);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Complication getComplicationAt(int x, int y) {
        block4: {
            $this$firstOrNull$iv = this.complications.entrySet();
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (Map.Entry)element$iv;
                $i$a$-firstOrNull-ComplicationsManager$getComplicationAt$1 = false;
                if (!((Complication)it.getValue()).isEnabled() || ((Complication)it.getValue()).getBoundsType() == 1) ** GOTO lbl-1000
                v0 = (Complication)it.getValue();
                v1 = this.renderer;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"renderer");
                }
                if (v0.computeBounds(v1.getScreenBounds()).contains(x, y)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        v4 = v3;
        return v4 != null ? (Complication)v4.getValue() : null;
    }

    @Nullable
    public final Complication getBackgroundComplication() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.complications.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!(((Complication)it.getValue()).getBoundsType() == 1)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (Complication)entry.getValue() : null;
    }

    @UiThread
    public final void onComplicationSingleTapped$wear_watchface_release(int complicationId) {
        Object object = this.complications.get(complicationId);
        if (object == null || (object = ((Complication)object).getRenderer()) == null || (object = object.getIdAndData()) == null) {
            return;
        }
        Object data = object;
        if (data.getComplicationData().getType() == ComplicationType.NO_PERMISSION) {
            WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
            if (watchFaceHostApi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            Context context = watchFaceHostApi.getContext();
            WatchFaceHostApi watchFaceHostApi2 = this.watchFaceHostApi;
            if (watchFaceHostApi2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            Context context2 = watchFaceHostApi2.getContext();
            WatchFaceHostApi watchFaceHostApi3 = this.watchFaceHostApi;
            if (watchFaceHostApi3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            context.startActivity(ComplicationHelperActivity.createPermissionRequestHelperIntent((Context)context2, (ComponentName)ComplicationsManagerKt.access$getComponentName(watchFaceHostApi3.getContext())).addFlags(0x10000000));
            return;
        }
        PendingIntent pendingIntent = data.getComplicationData().getTapAction();
        if (pendingIntent != null) {
            pendingIntent.send();
        }
        for (TapCallback complicationListener : this.complicationListeners) {
            complicationListener.onComplicationSingleTapped(complicationId);
        }
    }

    @UiThread
    @SuppressLint(value={"ExecutorRegistration"})
    public final void addTapListener(@NotNull TapCallback tapCallback) {
        Intrinsics.checkNotNullParameter((Object)tapCallback, (String)"tapCallback");
        this.complicationListeners.add(tapCallback);
    }

    @UiThread
    public final void removeTapListener(@NotNull TapCallback tapCallback) {
        Intrinsics.checkNotNullParameter((Object)tapCallback, (String)"tapCallback");
        this.complicationListeners.remove(tapCallback);
    }

    @UiThread
    public final void dump$wear_watchface_release(@NotNull IndentingPrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.println("ComplicationsManager:");
        writer.increaseIndent();
        Map<Integer, Complication> map = this.complications;
        boolean bl = false;
        Iterator<Map.Entry<Integer, Complication>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Complication> entry;
            Map.Entry<Integer, Complication> entry2 = entry = iterator.next();
            boolean bl2 = false;
            Complication complication = entry2.getValue();
            complication.dump$wear_watchface_release(writer);
        }
        writer.decreaseIndent();
    }

    public ComplicationsManager(@NotNull Collection<Complication> complicationCollection, @NotNull UserStyleRepository userStyleRepository) {
        Integer n;
        Complication receiver;
        Map map;
        Iterable $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(complicationCollection, (String)"complicationCollection");
        Intrinsics.checkNotNullParameter((Object)userStyleRepository, (String)"userStyleRepository");
        this.userStyleRepository = userStyleRepository;
        Iterable iterable = complicationCollection;
        ComplicationsManager complicationsManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            map = destination$iv$iv;
            boolean bl = false;
            n = ((Complication)receiver).getId$wear_watchface_release();
            map.put(n, element$iv$iv);
        }
        complicationsManager.complications = map = destination$iv$iv;
        $this$associateBy$iv = complicationCollection;
        complicationsManager = this;
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Complication it;
            receiver = (Complication)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            n = it.getId$wear_watchface_release();
            it = (Complication)element$iv$iv;
            boolean bl2 = false;
            InitialComplicationConfig initialComplicationConfig = new InitialComplicationConfig(it.getComplicationBounds(), it.isEnabled(), it.getSupportedTypes(), it.getDefaultProviderPolicy(), it.getDefaultProviderType());
            map.put(n, initialComplicationConfig);
        }
        complicationsManager.initialComplicationConfigs = map = destination$iv$iv;
        this.complicationListeners = new HashSet();
    }

    @VisibleForTesting
    public ComplicationsManager(@NotNull Collection<Complication> complicationCollection, @NotNull UserStyleRepository userStyleRepository, @NotNull Renderer renderer) {
        Intrinsics.checkNotNullParameter(complicationCollection, (String)"complicationCollection");
        Intrinsics.checkNotNullParameter((Object)userStyleRepository, (String)"userStyleRepository");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this(complicationCollection, userStyleRepository);
        this.renderer = renderer;
    }

    public static final /* synthetic */ void access$updateComplications(ComplicationsManager $this) {
        $this.updateComplications();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Landroidx/wear/watchface/ComplicationsManager$TapCallback;", "", "onComplicationSingleTapped", "", "complicationId", "", "wear-watchface_release"})
    public static interface TapCallback {
        public void onComplicationSingleTapped(int var1);

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onComplicationSingleTapped(@NotNull TapCallback $this, int complicationId) {
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Landroidx/wear/watchface/ComplicationsManager$InitialComplicationConfig;", "", "complicationBounds", "Landroidx/wear/complications/ComplicationBounds;", "enabled", "", "supportedTypes", "", "Landroidx/wear/complications/data/ComplicationType;", "defaultProviderPolicy", "Landroidx/wear/complications/DefaultComplicationProviderPolicy;", "defaultProviderType", "(Landroidx/wear/complications/ComplicationBounds;ZLjava/util/List;Landroidx/wear/complications/DefaultComplicationProviderPolicy;Landroidx/wear/complications/data/ComplicationType;)V", "getComplicationBounds", "()Landroidx/wear/complications/ComplicationBounds;", "getDefaultProviderPolicy", "()Landroidx/wear/complications/DefaultComplicationProviderPolicy;", "getDefaultProviderType", "()Landroidx/wear/complications/data/ComplicationType;", "getEnabled", "()Z", "getSupportedTypes", "()Ljava/util/List;", "wear-watchface_release"})
    private static final class InitialComplicationConfig {
        @NotNull
        private final ComplicationBounds complicationBounds;
        private final boolean enabled;
        @NotNull
        private final List<ComplicationType> supportedTypes;
        @NotNull
        private final DefaultComplicationProviderPolicy defaultProviderPolicy;
        @NotNull
        private final ComplicationType defaultProviderType;

        @NotNull
        public final ComplicationBounds getComplicationBounds() {
            return this.complicationBounds;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final List<ComplicationType> getSupportedTypes() {
            return this.supportedTypes;
        }

        @NotNull
        public final DefaultComplicationProviderPolicy getDefaultProviderPolicy() {
            return this.defaultProviderPolicy;
        }

        @NotNull
        public final ComplicationType getDefaultProviderType() {
            return this.defaultProviderType;
        }

        public InitialComplicationConfig(@NotNull ComplicationBounds complicationBounds, boolean enabled2, @NotNull List<? extends ComplicationType> supportedTypes2, @NotNull DefaultComplicationProviderPolicy defaultProviderPolicy2, @NotNull ComplicationType defaultProviderType2) {
            Intrinsics.checkNotNullParameter((Object)complicationBounds, (String)"complicationBounds");
            Intrinsics.checkNotNullParameter(supportedTypes2, (String)"supportedTypes");
            Intrinsics.checkNotNullParameter((Object)defaultProviderPolicy2, (String)"defaultProviderPolicy");
            Intrinsics.checkNotNullParameter((Object)defaultProviderType2, (String)"defaultProviderType");
            this.complicationBounds = complicationBounds;
            this.enabled = enabled2;
            this.supportedTypes = supportedTypes2;
            this.defaultProviderPolicy = defaultProviderPolicy2;
            this.defaultProviderType = defaultProviderType2;
        }
    }
}

