/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import androidx.annotation.Px;
import androidx.wear.watchface.CanvasComplication;
import androidx.wear.watchface.RenderParameters;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/wear/watchface/GlesTextureComplication;", "", "canvasComplication", "Landroidx/wear/watchface/CanvasComplication;", "textureWidth", "", "textureHeight", "textureType", "(Landroidx/wear/watchface/CanvasComplication;III)V", "bitmap", "Landroid/graphics/Bitmap;", "kotlin.jvm.PlatformType", "bounds", "Landroid/graphics/Rect;", "canvas", "Landroid/graphics/Canvas;", "getCanvasComplication", "()Landroidx/wear/watchface/CanvasComplication;", "texture", "bind", "", "createTexture", "renderToTexture", "calendar", "Landroid/icu/util/Calendar;", "renderParameters", "Landroidx/wear/watchface/RenderParameters;", "wear-watchface_release"})
public final class GlesTextureComplication {
    private final int texture;
    private final Bitmap bitmap;
    private final Canvas canvas;
    private final Rect bounds;
    @NotNull
    private final CanvasComplication canvasComplication;
    private final int textureType;

    public final void renderToTexture(@NotNull Calendar calendar, @NotNull RenderParameters renderParameters) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        Intrinsics.checkNotNullParameter((Object)renderParameters, (String)"renderParameters");
        this.canvas.drawColor(-16777216);
        this.canvasComplication.render(this.canvas, this.bounds, calendar, renderParameters);
        this.bind();
        GLUtils.texImage2D((int)this.textureType, (int)0, (Bitmap)this.bitmap, (int)0);
    }

    public final void bind() {
        GLES20.glBindTexture((int)this.textureType, (int)this.texture);
    }

    private final int createTexture(int textureType) {
        int[] handle = new int[1];
        GLES20.glGenTextures((int)1, (int[])handle, (int)0);
        GLES20.glBindTexture((int)textureType, (int)handle[0]);
        GLES20.glTexParameteri((int)textureType, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)textureType, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)textureType, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)textureType, (int)10241, (int)9729);
        return handle[0];
    }

    @NotNull
    public final CanvasComplication getCanvasComplication() {
        return this.canvasComplication;
    }

    public GlesTextureComplication(@NotNull CanvasComplication canvasComplication, @Px int textureWidth, @Px int textureHeight, int textureType) {
        Intrinsics.checkNotNullParameter((Object)canvasComplication, (String)"canvasComplication");
        this.canvasComplication = canvasComplication;
        this.textureType = textureType;
        this.texture = this.createTexture(this.textureType);
        this.bitmap = Bitmap.createBitmap((int)textureWidth, (int)textureHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.bitmap);
        this.bounds = new Rect(0, 0, textureWidth, textureHeight);
    }
}

