/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import androidx.annotation.ColorInt;
import androidx.annotation.RestrictTo;
import androidx.wear.watchface.DrawMode;
import androidx.wear.watchface.IndentingPrintWriter;
import androidx.wear.watchface.LayerMode;
import androidx.wear.watchface.RenderParameters;
import androidx.wear.watchface.data.RenderParametersWireFormat;
import androidx.wear.watchface.style.Layer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0001\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\fH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Landroidx/wear/watchface/RenderParameters;", "", "drawMode", "Landroidx/wear/watchface/DrawMode;", "layerParameters", "", "Landroidx/wear/watchface/style/Layer;", "Landroidx/wear/watchface/LayerMode;", "selectedComplicationId", "", "(Landroidx/wear/watchface/DrawMode;Ljava/util/Map;Ljava/lang/Integer;)V", "wireFormat", "Landroidx/wear/watchface/data/RenderParametersWireFormat;", "(Landroidx/wear/watchface/data/RenderParametersWireFormat;)V", "outlineTint", "(Landroidx/wear/watchface/DrawMode;Ljava/util/Map;Ljava/lang/Integer;I)V", "getDrawMode", "()Landroidx/wear/watchface/DrawMode;", "getLayerParameters", "()Ljava/util/Map;", "getOutlineTint", "()I", "getSelectedComplicationId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "dump", "", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "dump$wear_watchface_release", "toWireFormat", "Companion", "wear-watchface_release"})
public final class RenderParameters {
    @NotNull
    private final DrawMode drawMode;
    @NotNull
    private final Map<Layer, LayerMode> layerParameters;
    @Nullable
    private final Integer selectedComplicationId;
    private final int outlineTint;
    @JvmField
    @NotNull
    public static final Map<Layer, LayerMode> DRAW_ALL_LAYERS;
    @JvmField
    @NotNull
    public static final RenderParameters DEFAULT_INTERACTIVE;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public final RenderParametersWireFormat toWireFormat() {
        Collection<RenderParametersWireFormat.LayerParameterWireFormat> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<Layer, LayerMode> map = this.layerParameters;
        int n = this.drawMode.ordinal();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            RenderParametersWireFormat.LayerParameterWireFormat layerParameterWireFormat = new RenderParametersWireFormat.LayerParameterWireFormat(((Layer)it.getKey()).ordinal(), ((LayerMode)((Object)it.getValue())).ordinal());
            collection.add(layerParameterWireFormat);
        }
        collection = (List)destination$iv$iv;
        int n2 = this.outlineTint;
        Integer n3 = this.selectedComplicationId;
        List list = collection;
        int n4 = n;
        return new RenderParametersWireFormat(n4, list, n3, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void dump$wear_watchface_release(@NotNull IndentingPrintWriter writer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.println("RenderParameters:");
        writer.increaseIndent();
        writer.println("drawMode=" + this.drawMode.name());
        writer.println("selectedComplicationId=" + this.selectedComplicationId);
        writer.println("outlineTint=" + this.outlineTint);
        Map<Layer, LayerMode> $this$map$iv = this.layerParameters;
        boolean $i$f$map = false;
        Map<Layer, LayerMode> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_7.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (Layer)it.getKey() + " -> " + ((LayerMode)((Object)it.getValue())).name();
            collection.add(string);
        }
        String params2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)dump.params.2.INSTANCE, (int)31, null);
        writer.println("layerParameters=[" + params2 + ']');
        writer.decreaseIndent();
    }

    @NotNull
    public final DrawMode getDrawMode() {
        return this.drawMode;
    }

    @NotNull
    public final Map<Layer, LayerMode> getLayerParameters() {
        return this.layerParameters;
    }

    @Nullable
    public final Integer getSelectedComplicationId() {
        return this.selectedComplicationId;
    }

    public final int getOutlineTint() {
        return this.outlineTint;
    }

    public RenderParameters(@NotNull DrawMode drawMode, @NotNull Map<Layer, ? extends LayerMode> layerParameters, @Nullable Integer selectedComplicationId, @ColorInt int outlineTint) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawMode), (String)"drawMode");
        Intrinsics.checkNotNullParameter(layerParameters, (String)"layerParameters");
        this.drawMode = drawMode;
        this.layerParameters = layerParameters;
        this.selectedComplicationId = selectedComplicationId;
        this.outlineTint = outlineTint;
    }

    public RenderParameters(@NotNull DrawMode drawMode, @NotNull Map<Layer, ? extends LayerMode> layerParameters, @Nullable Integer selectedComplicationId) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawMode), (String)"drawMode");
        Intrinsics.checkNotNullParameter(layerParameters, (String)"layerParameters");
        this(drawMode, layerParameters, selectedComplicationId, -65536);
        for (LayerMode layerMode : layerParameters.values()) {
            boolean bl = layerMode != LayerMode.DRAW_OUTLINED;
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) continue;
            boolean bl4 = false;
            String string = "LayerMode.DRAW_OUTLINED is not supported by this constructor, use the primary one instead";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public RenderParameters(@NotNull RenderParametersWireFormat wireFormat) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)wireFormat, (String)"wireFormat");
        DrawMode drawMode = DrawMode.values()[wireFormat.getDrawMode()];
        List list = wireFormat.getLayerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"wireFormat.layerParameters");
        Iterable iterable = list;
        DrawMode drawMode2 = drawMode;
        RenderParameters renderParameters = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            RenderParametersWireFormat.LayerParameterWireFormat it;
            RenderParametersWireFormat.LayerParameterWireFormat layerParameterWireFormat = (RenderParametersWireFormat.LayerParameterWireFormat)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Layer[] layerArray = Layer.values();
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            Layer layer = layerArray[v3.getLayer()];
            it = (RenderParametersWireFormat.LayerParameterWireFormat)element$iv$iv;
            boolean bl2 = false;
            LayerMode[] layerModeArray = LayerMode.values();
            RenderParametersWireFormat.LayerParameterWireFormat layerParameterWireFormat2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)layerParameterWireFormat2, (String)"it");
            LayerMode layerMode = layerModeArray[layerParameterWireFormat2.getLayerMode()];
            map.put(layer, layerMode);
        }
        map = destination$iv$iv;
        renderParameters(drawMode2, map, wireFormat.getSelectedComplicationId(), wireFormat.getOutlineTint());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        Layer[] $this$associateBy$iv = Layer.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Layer[] layerArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        void var6_6 = $this$associateByTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var10_10 = element$iv$iv = var6_6[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            void var13_13 = it;
            it = element$iv$iv;
            boolean bl2 = false;
            LayerMode layerMode = LayerMode.DRAW;
            map.put(var13_13, layerMode);
        }
        DRAW_ALL_LAYERS = destination$iv$iv;
        DEFAULT_INTERACTIVE = new RenderParameters(DrawMode.INTERACTIVE, DRAW_ALL_LAYERS, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/wear/watchface/RenderParameters$Companion;", "", "()V", "DEFAULT_INTERACTIVE", "Landroidx/wear/watchface/RenderParameters;", "DRAW_ALL_LAYERS", "", "Landroidx/wear/watchface/style/Layer;", "Landroidx/wear/watchface/LayerMode;", "wear-watchface_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

