/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import androidx.annotation.CallSuper;
import androidx.annotation.IntRange;
import androidx.annotation.Px;
import androidx.annotation.UiThread;
import androidx.wear.watchface.CanvasType;
import androidx.wear.watchface.IndentingPrintWriter;
import androidx.wear.watchface.RenderParameters;
import androidx.wear.watchface.RendererKt;
import androidx.wear.watchface.WatchFaceHostApi;
import androidx.wear.watchface.WatchState;
import androidx.wear.watchface.style.UserStyleRepository;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002@AB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0015\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H!\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020\u001dH\u0017J\b\u00101\u001a\u00020,H\u0007J\b\u00102\u001a\u00020,H\u0017J\r\u00103\u001a\u00020,H\u0010\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0017H\u0015J\u0006\u00106\u001a\u00020,J\u0015\u00107\u001a\u00020,2\u0006\u00108\u001a\u000209H!\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020<H\u0017J\u001d\u0010=\u001a\u00020>2\u0006\u00108\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u0017H!\u00a2\u0006\u0002\b?R \u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u0082\u0001\u0002BC\u00a8\u0006D"}, d2={"Landroidx/wear/watchface/Renderer;", "", "surfaceHolder", "Landroid/view/SurfaceHolder;", "userStyleRepository", "Landroidx/wear/watchface/style/UserStyleRepository;", "watchState", "Landroidx/wear/watchface/WatchState;", "interactiveDrawModeUpdateDelayMillis", "", "(Landroid/view/SurfaceHolder;Landroidx/wear/watchface/style/UserStyleRepository;Landroidx/wear/watchface/WatchState;J)V", "<set-?>", "", "centerX", "getCenterX", "()F", "centerY", "getCenterY", "getInteractiveDrawModeUpdateDelayMillis", "()J", "setInteractiveDrawModeUpdateDelayMillis", "(J)V", "value", "Landroidx/wear/watchface/RenderParameters;", "renderParameters", "getRenderParameters", "()Landroidx/wear/watchface/RenderParameters;", "setRenderParameters$wear_watchface_release", "(Landroidx/wear/watchface/RenderParameters;)V", "Landroid/graphics/Rect;", "screenBounds", "getScreenBounds", "()Landroid/graphics/Rect;", "getSurfaceHolder", "()Landroid/view/SurfaceHolder;", "watchFaceHostApi", "Landroidx/wear/watchface/WatchFaceHostApi;", "getWatchFaceHostApi$wear_watchface_release", "()Landroidx/wear/watchface/WatchFaceHostApi;", "setWatchFaceHostApi$wear_watchface_release", "(Landroidx/wear/watchface/WatchFaceHostApi;)V", "getWatchState$wear_watchface_release", "()Landroidx/wear/watchface/WatchState;", "dump", "", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "dump$wear_watchface_release", "getMainClockElementBounds", "invalidate", "onDestroy", "onPostCreate", "onPostCreate$wear_watchface_release", "onRenderParametersChanged", "postInvalidate", "renderInternal", "calendar", "Landroid/icu/util/Calendar;", "renderInternal$wear_watchface_release", "shouldAnimate", "", "takeScreenshot", "Landroid/graphics/Bitmap;", "takeScreenshot$wear_watchface_release", "CanvasRenderer", "GlesRenderer", "Landroidx/wear/watchface/Renderer$CanvasRenderer;", "Landroidx/wear/watchface/Renderer$GlesRenderer;", "wear-watchface_release"})
public abstract class Renderer {
    public WatchFaceHostApi watchFaceHostApi;
    @NotNull
    private Rect screenBounds;
    @Px
    private float centerX;
    @Px
    private float centerY;
    @NotNull
    private RenderParameters renderParameters;
    @NotNull
    private final SurfaceHolder surfaceHolder;
    private final UserStyleRepository userStyleRepository;
    @NotNull
    private final WatchState watchState;
    private long interactiveDrawModeUpdateDelayMillis;

    @NotNull
    public final WatchFaceHostApi getWatchFaceHostApi$wear_watchface_release() {
        WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
        if (watchFaceHostApi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
        }
        return watchFaceHostApi;
    }

    public final void setWatchFaceHostApi$wear_watchface_release(@NotNull WatchFaceHostApi watchFaceHostApi) {
        Intrinsics.checkNotNullParameter((Object)watchFaceHostApi, (String)"<set-?>");
        this.watchFaceHostApi = watchFaceHostApi;
    }

    @NotNull
    public final Rect getScreenBounds() {
        return this.screenBounds;
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    @NotNull
    public final RenderParameters getRenderParameters() {
        return this.renderParameters;
    }

    public final void setRenderParameters$wear_watchface_release(@NotNull RenderParameters value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)this.renderParameters) ^ true) {
            this.renderParameters = value;
            this.onRenderParametersChanged(value);
        }
    }

    public void onPostCreate$wear_watchface_release() {
    }

    @UiThread
    public void onDestroy() {
    }

    @UiThread
    public abstract void renderInternal$wear_watchface_release(@NotNull Calendar var1);

    @UiThread
    @NotNull
    public abstract Bitmap takeScreenshot$wear_watchface_release(@NotNull Calendar var1, @NotNull RenderParameters var2);

    @UiThread
    protected void onRenderParametersChanged(@NotNull RenderParameters renderParameters) {
        Intrinsics.checkNotNullParameter((Object)renderParameters, (String)"renderParameters");
    }

    @UiThread
    @NotNull
    public Rect getMainClockElementBounds() {
        float quarterX = this.centerX / (float)2;
        float quarterY = this.centerY / (float)2;
        return new Rect((int)(this.centerX - quarterX), (int)(this.centerY - quarterY), (int)(this.centerX + quarterX), (int)(this.centerY + quarterY));
    }

    @UiThread
    public boolean shouldAnimate() {
        return this.watchState.isVisible().getValue() != false && this.watchState.isAmbient().getValue() == false;
    }

    @UiThread
    public final void invalidate() {
        if (this.watchFaceHostApi != null) {
            WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
            if (watchFaceHostApi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            watchFaceHostApi.invalidate();
        }
    }

    public final void postInvalidate() {
        if (this.watchFaceHostApi != null) {
            WatchFaceHostApi watchFaceHostApi = this.watchFaceHostApi;
            if (watchFaceHostApi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"watchFaceHostApi");
            }
            watchFaceHostApi.getHandler().post(new Runnable(this){
                final /* synthetic */ Renderer this$0;

                public final void run() {
                    this.this$0.getWatchFaceHostApi$wear_watchface_release().invalidate();
                }
                {
                    this.this$0 = renderer;
                }
            });
        }
    }

    @UiThread
    public abstract void dump$wear_watchface_release(@NotNull IndentingPrintWriter var1);

    @NotNull
    public final SurfaceHolder getSurfaceHolder() {
        return this.surfaceHolder;
    }

    @NotNull
    public final WatchState getWatchState$wear_watchface_release() {
        return this.watchState;
    }

    public final long getInteractiveDrawModeUpdateDelayMillis() {
        return this.interactiveDrawModeUpdateDelayMillis;
    }

    public final void setInteractiveDrawModeUpdateDelayMillis(long l) {
        this.interactiveDrawModeUpdateDelayMillis = l;
    }

    private Renderer(SurfaceHolder surfaceHolder, UserStyleRepository userStyleRepository, WatchState watchState, @IntRange(from=0L, to=60000L) long interactiveDrawModeUpdateDelayMillis) {
        this.surfaceHolder = surfaceHolder;
        this.userStyleRepository = userStyleRepository;
        this.watchState = watchState;
        this.interactiveDrawModeUpdateDelayMillis = interactiveDrawModeUpdateDelayMillis;
        this.surfaceHolder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Rect rect = holder.getSurfaceFrame();
                Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"holder.surfaceFrame");
                screenBounds = rect;
                centerX = this.getScreenBounds().exactCenterX();
                centerY = this.getScreenBounds().exactCenterY();
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }
        });
        Rect rect = this.surfaceHolder.getSurfaceFrame();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"surfaceHolder.surfaceFrame");
        this.screenBounds = rect;
        this.centerX = this.screenBounds.exactCenterX();
        this.centerY = this.screenBounds.exactCenterY();
        this.renderParameters = RenderParameters.DEFAULT_INTERACTIVE;
    }

    public /* synthetic */ Renderer(SurfaceHolder surfaceHolder, UserStyleRepository userStyleRepository, WatchState watchState, long interactiveDrawModeUpdateDelayMillis, DefaultConstructorMarker $constructor_marker) {
        this(surfaceHolder, userStyleRepository, watchState, interactiveDrawModeUpdateDelayMillis);
    }

    public static final /* synthetic */ Rect access$getScreenBounds$p(Renderer $this) {
        return $this.screenBounds;
    }

    public static final /* synthetic */ float access$getCenterX$p(Renderer $this) {
        return $this.centerX;
    }

    public static final /* synthetic */ float access$getCenterY$p(Renderer $this) {
        return $this.centerY;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0010\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H'J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b\u001fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/wear/watchface/Renderer$CanvasRenderer;", "Landroidx/wear/watchface/Renderer;", "surfaceHolder", "Landroid/view/SurfaceHolder;", "userStyleRepository", "Landroidx/wear/watchface/style/UserStyleRepository;", "watchState", "Landroidx/wear/watchface/WatchState;", "canvasType", "", "interactiveDrawModeUpdateDelayMillis", "", "(Landroid/view/SurfaceHolder;Landroidx/wear/watchface/style/UserStyleRepository;Landroidx/wear/watchface/WatchState;IJ)V", "dump", "", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "dump$wear_watchface_release", "render", "canvas", "Landroid/graphics/Canvas;", "bounds", "Landroid/graphics/Rect;", "calendar", "Landroid/icu/util/Calendar;", "renderInternal", "renderInternal$wear_watchface_release", "takeScreenshot", "Landroid/graphics/Bitmap;", "renderParameters", "Landroidx/wear/watchface/RenderParameters;", "takeScreenshot$wear_watchface_release", "wear-watchface_release"})
    public static abstract class CanvasRenderer
    extends Renderer {
        private final int canvasType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void renderInternal$wear_watchface_release(@NotNull Calendar calendar) {
            Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
            Canvas canvas = this.canvasType == 1 && Build.VERSION.SDK_INT >= 26 ? this.getSurfaceHolder().lockHardwareCanvas() : this.getSurfaceHolder().lockCanvas();
            if (canvas == null) {
                return;
            }
            Canvas canvas2 = canvas;
            try {
                if (this.getWatchState$wear_watchface_release().isVisible().getValue().booleanValue()) {
                    Rect rect = this.getSurfaceHolder().getSurfaceFrame();
                    Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"surfaceHolder.surfaceFrame");
                    this.render(canvas2, rect, calendar);
                } else {
                    canvas2.drawColor(-16777216);
                }
            }
            finally {
                this.getSurfaceHolder().unlockCanvasAndPost(canvas2);
            }
        }

        @Override
        @NotNull
        public Bitmap takeScreenshot$wear_watchface_release(@NotNull Calendar calendar, @NotNull RenderParameters renderParameters) {
            Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
            Intrinsics.checkNotNullParameter((Object)renderParameters, (String)"renderParameters");
            Bitmap bitmap = Bitmap.createBitmap((int)this.getScreenBounds().width(), (int)this.getScreenBounds().height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            RenderParameters prevRenderParameters = this.getRenderParameters();
            this.setRenderParameters$wear_watchface_release(renderParameters);
            this.render(new Canvas(bitmap), this.getScreenBounds(), calendar);
            this.setRenderParameters$wear_watchface_release(prevRenderParameters);
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
            return bitmap2;
        }

        @UiThread
        public abstract void render(@NotNull Canvas var1, @NotNull Rect var2, @NotNull Calendar var3);

        @Override
        public void dump$wear_watchface_release(@NotNull IndentingPrintWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.println("CanvasRenderer:");
            writer.increaseIndent();
            writer.println("canvasType=" + this.canvasType);
            writer.println("screenBounds=" + this.getScreenBounds());
            writer.println("interactiveDrawModeUpdateDelayMillis=" + this.getInteractiveDrawModeUpdateDelayMillis());
            writer.println("shouldAnimate=" + this.shouldAnimate());
            this.getRenderParameters().dump$wear_watchface_release(writer);
            writer.decreaseIndent();
        }

        public CanvasRenderer(@NotNull SurfaceHolder surfaceHolder, @NotNull UserStyleRepository userStyleRepository, @NotNull WatchState watchState, @CanvasType int canvasType, @IntRange(from=0L, to=10000L) long interactiveDrawModeUpdateDelayMillis) {
            Intrinsics.checkNotNullParameter((Object)surfaceHolder, (String)"surfaceHolder");
            Intrinsics.checkNotNullParameter((Object)userStyleRepository, (String)"userStyleRepository");
            Intrinsics.checkNotNullParameter((Object)watchState, (String)"watchState");
            super(surfaceHolder, userStyleRepository, watchState, interactiveDrawModeUpdateDelayMillis, null);
            this.canvasType = canvasType;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 52\u00020\u0001:\u00015B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0015\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0010\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020\u001aH\u0017J\b\u0010$\u001a\u00020\u001aH\u0017J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0017J\r\u0010&\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H'J\u0015\u0010+\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0010\u00a2\u0006\u0002\b,J\u001d\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0010\u00a2\u0006\u0002\b1J \u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u0002042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Landroidx/wear/watchface/Renderer$GlesRenderer;", "Landroidx/wear/watchface/Renderer;", "surfaceHolder", "Landroid/view/SurfaceHolder;", "userStyleRepository", "Landroidx/wear/watchface/style/UserStyleRepository;", "watchState", "Landroidx/wear/watchface/WatchState;", "interactiveDrawModeUpdateDelayMillis", "", "eglConfigAttribList", "", "eglSurfaceAttribList", "(Landroid/view/SurfaceHolder;Landroidx/wear/watchface/style/UserStyleRepository;Landroidx/wear/watchface/WatchState;J[I[I)V", "calledOnGlContextCreated", "", "eglConfig", "Landroid/opengl/EGLConfig;", "eglContext", "Landroid/opengl/EGLContext;", "eglDisplay", "Landroid/opengl/EGLDisplay;", "eglSurface", "Landroid/opengl/EGLSurface;", "chooseEglConfig", "createWindowSurface", "", "width", "", "height", "dump", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "dump$wear_watchface_release", "makeContextCurrent", "onDestroy", "onGlContextCreated", "onGlSurfaceCreated", "onPostCreate", "onPostCreate$wear_watchface_release", "render", "calendar", "Landroid/icu/util/Calendar;", "renderInternal", "renderInternal$wear_watchface_release", "takeScreenshot", "Landroid/graphics/Bitmap;", "renderParameters", "Landroidx/wear/watchface/RenderParameters;", "takeScreenshot$wear_watchface_release", "verticalFlip", "buffer", "Ljava/nio/ByteBuffer;", "Companion", "wear-watchface_release"})
    public static abstract class GlesRenderer
    extends Renderer {
        private EGLDisplay eglDisplay;
        private EGLConfig eglConfig;
        private EGLContext eglContext;
        private EGLSurface eglSurface;
        private boolean calledOnGlContextCreated;
        private final int[] eglConfigAttribList;
        private final int[] eglSurfaceAttribList;
        @Deprecated
        private static final String TAG = "Gles2WatchFace";
        @NotNull
        private static final Companion Companion = new Companion(null);

        private final EGLConfig chooseEglConfig(EGLDisplay eglDisplay) {
            EGLConfig[] eglConfigs = new EGLConfig[1];
            int[] numEglConfigs = new int[1];
            if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])this.eglConfigAttribList, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)eglConfigs.length, (int[])numEglConfigs, (int)0)) {
                throw (Throwable)new RuntimeException("eglChooseConfig failed");
            }
            if (numEglConfigs[0] == 0) {
                throw (Throwable)new RuntimeException("no matching EGL configs");
            }
            EGLConfig eGLConfig = eglConfigs[0];
            Intrinsics.checkNotNull((Object)eGLConfig);
            return eGLConfig;
        }

        private final void createWindowSurface(int width, int height) {
            if (this.eglSurface != null && !EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface)) {
                Log.w((String)TAG, (String)"eglDestroySurface failed");
            }
            this.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (Object)this.getSurfaceHolder().getSurface(), (int[])this.eglSurfaceAttribList, (int)0);
            if (Intrinsics.areEqual((Object)this.eglSurface, (Object)EGL14.EGL_NO_SURFACE)) {
                throw (Throwable)new RuntimeException("eglCreateWindowSurface failed");
            }
            this.makeContextCurrent();
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            if (!this.calledOnGlContextCreated) {
                this.calledOnGlContextCreated = true;
                this.onGlContextCreated();
            }
            this.onGlSurfaceCreated(width, height);
        }

        @Override
        @CallSuper
        public void onDestroy() {
            if (this.eglSurface != null) {
                if (!EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface)) {
                    Log.w((String)TAG, (String)"eglDestroySurface failed");
                }
                this.eglSurface = null;
            }
            if (this.eglContext != null) {
                if (!EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext)) {
                    Log.w((String)TAG, (String)"eglDestroyContext failed");
                }
                this.eglContext = null;
            }
            if (this.eglDisplay != null) {
                if (!EGL14.eglTerminate((EGLDisplay)this.eglDisplay)) {
                    Log.w((String)TAG, (String)"eglTerminate failed");
                }
                this.eglDisplay = null;
            }
        }

        private final void makeContextCurrent() {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
                throw (Throwable)new RuntimeException("eglMakeCurrent failed");
            }
        }

        @Override
        public void onPostCreate$wear_watchface_release() {
            this.getSurfaceHolder().addCallback(new SurfaceHolder.Callback(this){
                final /* synthetic */ GlesRenderer this$0;

                @SuppressLint(value={"SyntheticAccessor"})
                public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    GlesRenderer.access$createWindowSurface(this.this$0, width, height);
                }

                @SuppressLint(value={"SyntheticAccessor"})
                public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    if (!EGL14.eglDestroySurface((EGLDisplay)GlesRenderer.access$getEglDisplay$p(this.this$0), (EGLSurface)GlesRenderer.access$getEglSurface$p(this.this$0))) {
                        GlesRenderer.access$Companion();
                        Log.w((String)"Gles2WatchFace", (String)"eglDestroySurface failed");
                    }
                    GlesRenderer.access$setEglSurface$p(this.this$0, null);
                }

                public void surfaceCreated(@NotNull SurfaceHolder holder) {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                }
                {
                    this.this$0 = this$0;
                }
            });
            this.createWindowSurface(this.getSurfaceHolder().getSurfaceFrame().width(), this.getSurfaceHolder().getSurfaceFrame().height());
        }

        @UiThread
        public void onGlContextCreated() {
        }

        @UiThread
        public void onGlSurfaceCreated(int width, int height) {
        }

        @Override
        public void renderInternal$wear_watchface_release(@NotNull Calendar calendar) {
            Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
            this.makeContextCurrent();
            this.render(calendar);
            if (!EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface)) {
                Log.w((String)TAG, (String)"eglSwapBuffers failed");
            }
        }

        @Override
        @NotNull
        public Bitmap takeScreenshot$wear_watchface_release(@NotNull Calendar calendar, @NotNull RenderParameters renderParameters) {
            Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
            Intrinsics.checkNotNullParameter((Object)renderParameters, (String)"renderParameters");
            int width = this.getScreenBounds().width();
            int height = this.getScreenBounds().height();
            ByteBuffer pixelBuf = ByteBuffer.allocateDirect(width * height * 4);
            this.makeContextCurrent();
            RenderParameters prevRenderParameters = this.getRenderParameters();
            this.setRenderParameters$wear_watchface_release(renderParameters);
            this.render(calendar);
            this.setRenderParameters$wear_watchface_release(prevRenderParameters);
            GLES20.glFinish();
            GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)pixelBuf);
            ByteBuffer byteBuffer = pixelBuf;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"pixelBuf");
            this.verticalFlip(byteBuffer, width, height);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)pixelBuf);
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
            return bitmap2;
        }

        private final void verticalFlip(ByteBuffer buffer, int width, int height) {
            int i = 0;
            byte[] tmp = new byte[width * 4];
            while (i++ < height / 2) {
                buffer.get(tmp);
                System.arraycopy(buffer.array(), buffer.limit() - buffer.position(), buffer.array(), buffer.position() - width * 4, width * 4);
                System.arraycopy(tmp, 0, buffer.array(), buffer.limit() - buffer.position(), width * 4);
            }
            buffer.rewind();
        }

        @UiThread
        public abstract void render(@NotNull Calendar var1);

        @Override
        public void dump$wear_watchface_release(@NotNull IndentingPrintWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.println("GlesRenderer:");
            writer.increaseIndent();
            writer.println("screenBounds=" + this.getScreenBounds());
            writer.println("interactiveDrawModeUpdateDelayMillis=" + this.getInteractiveDrawModeUpdateDelayMillis());
            writer.println("shouldAnimate=" + this.shouldAnimate());
            this.getRenderParameters().dump$wear_watchface_release(writer);
            writer.decreaseIndent();
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public GlesRenderer(@NotNull SurfaceHolder surfaceHolder, @NotNull UserStyleRepository userStyleRepository, @NotNull WatchState watchState, @IntRange(from=0L, to=10000L) long interactiveDrawModeUpdateDelayMillis, @NotNull int[] eglConfigAttribList, @NotNull int[] eglSurfaceAttribList) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)surfaceHolder, (String)"surfaceHolder");
            Intrinsics.checkNotNullParameter((Object)userStyleRepository, (String)"userStyleRepository");
            Intrinsics.checkNotNullParameter((Object)watchState, (String)"watchState");
            Intrinsics.checkNotNullParameter((Object)eglConfigAttribList, (String)"eglConfigAttribList");
            Intrinsics.checkNotNullParameter((Object)eglSurfaceAttribList, (String)"eglSurfaceAttribList");
            super(surfaceHolder, userStyleRepository, watchState, interactiveDrawModeUpdateDelayMillis, null);
            this.eglConfigAttribList = eglConfigAttribList;
            this.eglSurfaceAttribList = eglSurfaceAttribList;
            EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
            boolean bl = false;
            boolean bl2 = false;
            EGLDisplay eGLDisplay2 = eGLDisplay;
            GlesRenderer glesRenderer = this;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)$this$apply, (Object)EGL14.EGL_NO_DISPLAY)) {
                throw (Throwable)new RuntimeException("eglGetDisplay returned EGL_NO_DISPLAY");
            }
            int[] version = new int[2];
            if (!EGL14.eglInitialize((EGLDisplay)$this$apply, (int[])version, (int)0, (int[])version, (int)1)) {
                throw (Throwable)new RuntimeException("eglInitialize failed");
            }
            Unit unit = Unit.INSTANCE;
            glesRenderer.eglDisplay = eGLDisplay;
            EGLDisplay eGLDisplay3 = this.eglDisplay;
            Intrinsics.checkNotNull((Object)eGLDisplay3);
            this.eglConfig = this.chooseEglConfig(eGLDisplay3);
            this.eglContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)this.eglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])RendererKt.access$getEGL_CONTEXT_ATTRIB_LIST$p(), (int)0);
            if (Intrinsics.areEqual((Object)this.eglContext, (Object)EGL14.EGL_NO_CONTEXT)) {
                throw (Throwable)new RuntimeException("eglCreateContext failed");
            }
        }

        public /* synthetic */ GlesRenderer(SurfaceHolder surfaceHolder, UserStyleRepository userStyleRepository, WatchState watchState, long l, int[] nArray, int[] nArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                nArray = RendererKt.getEGL_CONFIG_ATTRIB_LIST();
            }
            if ((n & 0x20) != 0) {
                nArray2 = RendererKt.getEGL_SURFACE_ATTRIB_LIST();
            }
            this(surfaceHolder, userStyleRepository, watchState, l, nArray, nArray2);
        }

        @JvmOverloads
        public GlesRenderer(@NotNull SurfaceHolder surfaceHolder, @NotNull UserStyleRepository userStyleRepository, @NotNull WatchState watchState, @IntRange(from=0L, to=10000L) long interactiveDrawModeUpdateDelayMillis, @NotNull int[] eglConfigAttribList) {
            this(surfaceHolder, userStyleRepository, watchState, interactiveDrawModeUpdateDelayMillis, eglConfigAttribList, null, 32, null);
        }

        @JvmOverloads
        public GlesRenderer(@NotNull SurfaceHolder surfaceHolder, @NotNull UserStyleRepository userStyleRepository, @NotNull WatchState watchState, @IntRange(from=0L, to=10000L) long interactiveDrawModeUpdateDelayMillis) {
            this(surfaceHolder, userStyleRepository, watchState, interactiveDrawModeUpdateDelayMillis, null, null, 48, null);
        }

        public static final /* synthetic */ void access$createWindowSurface(GlesRenderer $this, int width, int height) {
            $this.createWindowSurface(width, height);
        }

        public static final /* synthetic */ EGLDisplay access$getEglDisplay$p(GlesRenderer $this) {
            return $this.eglDisplay;
        }

        public static final /* synthetic */ void access$setEglDisplay$p(GlesRenderer $this, EGLDisplay eGLDisplay) {
            $this.eglDisplay = eGLDisplay;
        }

        public static final /* synthetic */ EGLSurface access$getEglSurface$p(GlesRenderer $this) {
            return $this.eglSurface;
        }

        public static final /* synthetic */ void access$setEglSurface$p(GlesRenderer $this, EGLSurface eGLSurface) {
            $this.eglSurface = eGLSurface;
        }

        public static final /* synthetic */ Companion access$Companion() {
            return Companion;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/wear/watchface/Renderer$GlesRenderer$Companion;", "", "()V", "TAG", "", "wear-watchface_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

