/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.watchface;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.icu.util.Calendar;
import android.icu.util.TimeZone;
import android.os.Build;
import android.support.wearable.watchface.WatchFaceStyle;
import android.view.Surface;
import android.view.ViewConfiguration;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.wear.complications.data.ComplicationData;
import androidx.wear.complications.data.IdAndComplicationData;
import androidx.wear.complications.data.NoDataComplicationData;
import androidx.wear.watchface.BroadcastReceivers;
import androidx.wear.watchface.CancellableUniqueTask;
import androidx.wear.watchface.Complication;
import androidx.wear.watchface.ComplicationsManager;
import androidx.wear.watchface.DrawMode;
import androidx.wear.watchface.IndentingPrintWriter;
import androidx.wear.watchface.MutableObservableWatchData;
import androidx.wear.watchface.ObservableWatchData;
import androidx.wear.watchface.Observer;
import androidx.wear.watchface.RenderParameters;
import androidx.wear.watchface.Renderer;
import androidx.wear.watchface.TapType;
import androidx.wear.watchface.WatchFace;
import androidx.wear.watchface.WatchFaceHostApi;
import androidx.wear.watchface.WatchFaceImpl;
import androidx.wear.watchface.WatchFaceKt;
import androidx.wear.watchface.WatchState;
import androidx.wear.watchface.style.UserStyle;
import androidx.wear.watchface.style.UserStyleRepository;
import androidx.wear.watchface.style.data.UserStyleWireFormat;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c5\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u000e\b\u0001\u0018\u0000 n2\u00020\u0001:\u0003nopB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010@\u001a\u00020AH\u0002J\u001d\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020+H\u0001\u00a2\u0006\u0002\bEJ\r\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020KH\u0007J\r\u0010L\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\r\u0010O\u001a\u00020AH\u0001\u00a2\u0006\u0002\bPJ\u001d\u0010Q\u001a\u00020A2\u0006\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020TH\u0001\u00a2\u0006\u0002\bUJ\r\u0010V\u001a\u00020AH\u0000\u00a2\u0006\u0002\bWJ\r\u0010X\u001a\u00020AH\u0001\u00a2\u0006\u0002\bYJ\u0015\u0010Z\u001a\u00020A2\u0006\u0010[\u001a\u00020\\H\u0000\u00a2\u0006\u0002\b]J\r\u0010^\u001a\u00020AH\u0000\u00a2\u0006\u0002\b_J'\u0010`\u001a\u00020A2\b\b\u0001\u0010a\u001a\u00020 2\u0006\u0010b\u001a\u00020 2\u0006\u0010c\u001a\u00020 H\u0001\u00a2\u0006\u0002\bdJ\b\u0010e\u001a\u00020AH\u0002J\b\u0010f\u001a\u00020AH\u0002J\u0010\u0010g\u001a\u00020A2\u0006\u0010h\u001a\u00020+H\u0002J\u0017\u0010i\u001a\u00020A2\b\u0010j\u001a\u0004\u0018\u00010kH\u0000\u00a2\u0006\u0002\blJ\b\u0010m\u001a\u00020AH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u000204X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020<X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Landroidx/wear/watchface/WatchFaceImpl;", "", "watchface", "Landroidx/wear/watchface/WatchFace;", "watchFaceHostApi", "Landroidx/wear/watchface/WatchFaceHostApi;", "watchState", "Landroidx/wear/watchface/WatchState;", "(Landroidx/wear/watchface/WatchFace;Landroidx/wear/watchface/WatchFaceHostApi;Landroidx/wear/watchface/WatchState;)V", "ambientObserver", "Landroidx/wear/watchface/Observer;", "", "batteryLowAndNotChargingObserver", "broadcastEventObserver", "androidx/wear/watchface/WatchFaceImpl$broadcastEventObserver$1", "Landroidx/wear/watchface/WatchFaceImpl$broadcastEventObserver$1;", "calendar", "Landroid/icu/util/Calendar;", "getCalendar$annotations", "()V", "getCalendar", "()Landroid/icu/util/Calendar;", "complicationsManager", "Landroidx/wear/watchface/ComplicationsManager;", "getComplicationsManager$wear_watchface_release", "()Landroidx/wear/watchface/ComplicationsManager;", "componentName", "Landroid/content/ComponentName;", "getComponentName$wear_watchface_release", "()Landroid/content/ComponentName;", "inOnSetStyle", "interruptionFilterObserver", "", "lastTappedComplicationId", "Ljava/lang/Integer;", "lastTappedPosition", "Landroid/graphics/Point;", "legacyWatchFaceStyle", "Landroidx/wear/watchface/WatchFace$LegacyWatchFaceOverlayStyle;", "mockTime", "Landroidx/wear/watchface/WatchFaceImpl$MockTime;", "muteMode", "nextDrawTimeMillis", "", "pendingSingleTap", "Landroidx/wear/watchface/CancellableUniqueTask;", "pendingUpdateTime", "previewReferenceTimeMillis", "getPreviewReferenceTimeMillis", "()J", "registeredReceivers", "renderer", "Landroidx/wear/watchface/Renderer;", "getRenderer$wear_watchface_release", "()Landroidx/wear/watchface/Renderer;", "systemTimeProvider", "Landroidx/wear/watchface/WatchFace$SystemTimeProvider;", "tapListener", "Landroidx/wear/watchface/WatchFace$TapListener;", "userStyleRepository", "Landroidx/wear/watchface/style/UserStyleRepository;", "getUserStyleRepository$wear_watchface_release", "()Landroidx/wear/watchface/style/UserStyleRepository;", "visibilityObserver", "clearGesture", "", "computeDelayTillNextFrame", "beginFrameTimeMillis", "currentTimeMillis", "computeDelayTillNextFrame$wear_watchface_release", "createWFEditorDelegate", "Landroidx/wear/watchface/WatchFace$EditorDelegate;", "createWFEditorDelegate$wear_watchface_release", "dump", "writer", "Landroidx/wear/watchface/IndentingPrintWriter;", "getWatchFaceStyle", "Landroid/support/wearable/watchface/WatchFaceStyle;", "getWatchFaceStyle$wear_watchface_release", "maybeUpdateDrawMode", "maybeUpdateDrawMode$wear_watchface_release", "onComplicationDataUpdate", "watchFaceComplicationId", "data", "Landroidx/wear/complications/data/ComplicationData;", "onComplicationDataUpdate$wear_watchface_release", "onDestroy", "onDestroy$wear_watchface_release", "onDraw", "onDraw$wear_watchface_release", "onSetStyleInternal", "style", "Landroidx/wear/watchface/style/UserStyle;", "onSetStyleInternal$wear_watchface_release", "onSurfaceRedrawNeeded", "onSurfaceRedrawNeeded$wear_watchface_release", "onTapCommand", "originalTapType", "x", "y", "onTapCommand$wear_watchface_release", "registerReceivers", "scheduleDraw", "setCalendarTime", "timeMillis", "setIsBatteryLowAndNotChargingFromBatteryStatus", "batteryStatus", "Landroid/content/Intent;", "setIsBatteryLowAndNotChargingFromBatteryStatus$wear_watchface_release", "unregisterReceivers", "Companion", "MockTime", "WFEditorDelegate", "wear-watchface_release"})
@SuppressLint(value={"SyntheticAccessor"})
public final class WatchFaceImpl {
    private final WatchFace.SystemTimeProvider systemTimeProvider;
    private final WatchFace.LegacyWatchFaceOverlayStyle legacyWatchFaceStyle;
    @NotNull
    private final UserStyleRepository userStyleRepository;
    @NotNull
    private final Renderer renderer;
    @NotNull
    private final ComplicationsManager complicationsManager;
    private final WatchFace.TapListener tapListener;
    private MockTime mockTime;
    private Integer lastTappedComplicationId;
    private Point lastTappedPosition;
    private boolean registeredReceivers;
    private boolean muteMode;
    private long nextDrawTimeMillis;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final Calendar calendar;
    private final CancellableUniqueTask pendingSingleTap;
    private final CancellableUniqueTask pendingUpdateTime;
    @NotNull
    private final ComponentName componentName;
    private final broadcastEventObserver.1 broadcastEventObserver;
    private final long previewReferenceTimeMillis;
    private boolean inOnSetStyle;
    private final Observer<Boolean> ambientObserver;
    private final Observer<Integer> interruptionFilterObserver;
    private final Observer<Boolean> visibilityObserver;
    @SuppressLint(value={"NewApi"})
    private final Observer<Boolean> batteryLowAndNotChargingObserver;
    private final WatchFaceHostApi watchFaceHostApi;
    private final WatchState watchState;
    public static final int NO_DEFAULT_PROVIDER = -1;
    @NotNull
    public static final String MOCK_TIME_INTENT = "androidx.wear.watchface.MockTime";
    @NotNull
    public static final String EXTRA_MOCK_TIME_SPEED_MULTIPLIER = "androidx.wear.watchface.extra.MOCK_TIME_SPEED_MULTIPLIER";
    private static final float MOCK_TIME_DEFAULT_SPEED_MULTIPLIER = 1.0f;
    @NotNull
    public static final String EXTRA_MOCK_TIME_WRAPPING_MIN_TIME = "androidx.wear.watchface.extra.MOCK_TIME_WRAPPING_MIN_TIME";
    private static final long MOCK_TIME_WRAPPING_MIN_TIME_DEFAULT = -1L;
    @NotNull
    public static final String EXTRA_MOCK_TIME_WRAPPING_MAX_TIME = "androidx.wear.watchface.extra.MOCK_TIME_WRAPPING_MAX_TIME";
    public static final long MAX_LOW_POWER_INTERACTIVE_UPDATE_RATE_MS = 100L;
    public static final long CANCEL_COMPLICATION_HIGHLIGHTED_DELAY_MS = 300L;
    public static final float INITIAL_LOW_BATTERY_THRESHOLD = 15.0f;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final UserStyleRepository getUserStyleRepository$wear_watchface_release() {
        return this.userStyleRepository;
    }

    @NotNull
    public final Renderer getRenderer$wear_watchface_release() {
        return this.renderer;
    }

    @NotNull
    public final ComplicationsManager getComplicationsManager$wear_watchface_release() {
        return this.complicationsManager;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getCalendar$annotations() {
    }

    @NotNull
    public final Calendar getCalendar() {
        return this.calendar;
    }

    @NotNull
    public final ComponentName getComponentName$wear_watchface_release() {
        return this.componentName;
    }

    @NotNull
    public final WatchFaceStyle getWatchFaceStyle$wear_watchface_release() {
        return new WatchFaceStyle(this.componentName, this.legacyWatchFaceStyle.getViewProtectionMode(), this.legacyWatchFaceStyle.getStatusBarGravity(), this.legacyWatchFaceStyle.getAccentColor(), false, false, this.legacyWatchFaceStyle.isTapEventsAccepted(), null, 128, null);
    }

    public final long getPreviewReferenceTimeMillis() {
        return this.previewReferenceTimeMillis;
    }

    @NotNull
    public final WatchFace.EditorDelegate createWFEditorDelegate$wear_watchface_release() {
        return new WFEditorDelegate();
    }

    public final void setIsBatteryLowAndNotChargingFromBatteryStatus$wear_watchface_release(@Nullable Intent batteryStatus) {
        float f;
        Intent intent = batteryStatus;
        int status = intent != null ? intent.getIntExtra("status", -1) : -1;
        boolean isCharging = status == 2 || status == 5;
        Intent intent2 = batteryStatus;
        if (intent2 != null) {
            Intent intent3 = intent2;
            boolean bl = false;
            boolean bl2 = false;
            Intent intent4 = intent3;
            boolean bl3 = false;
            int level = intent4.getIntExtra("level", -1);
            int scale = intent4.getIntExtra("scale", -1);
            f = (float)(level * 100) / (float)scale;
        } else {
            f = 100.0f;
        }
        float batteryPercent = f;
        ObservableWatchData<Boolean> observableWatchData = this.watchState.isBatteryLowAndNotCharging();
        if (observableWatchData == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.wear.watchface.MutableObservableWatchData<kotlin.Boolean>");
        }
        MutableObservableWatchData isBatteryLowAndNotCharging = (MutableObservableWatchData)observableWatchData;
        isBatteryLowAndNotCharging.setValue(batteryPercent < 15.0f && !isCharging);
    }

    public final void onSetStyleInternal$wear_watchface_release(@NotNull UserStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.inOnSetStyle = true;
        this.userStyleRepository.setUserStyle(style);
        this.inOnSetStyle = false;
    }

    public final void onDestroy$wear_watchface_release() {
        this.pendingSingleTap.cancel();
        this.pendingUpdateTime.cancel();
        this.renderer.onDestroy();
        this.watchState.isAmbient().removeObserver(this.ambientObserver);
        if (Build.VERSION.SDK_INT >= 30 && !this.watchState.isHeadless()) {
            this.watchState.isBatteryLowAndNotCharging().removeObserver(this.batteryLowAndNotChargingObserver);
        }
        this.watchState.getInterruptionFilter().removeObserver(this.interruptionFilterObserver);
        this.watchState.isVisible().removeObserver(this.visibilityObserver);
        if (!this.watchState.isHeadless()) {
            WatchFace.Companion.unregisterEditorDelegate$wear_watchface_release(this.componentName);
        }
        this.unregisterReceivers();
    }

    private final void registerReceivers() {
        if (this.registeredReceivers) {
            return;
        }
        this.registeredReceivers = true;
        BroadcastReceivers.Companion.addBroadcastEventObserver(this.watchFaceHostApi.getContext(), this.broadcastEventObserver);
    }

    private final void unregisterReceivers() {
        if (!this.registeredReceivers) {
            return;
        }
        this.registeredReceivers = false;
        BroadcastReceivers.Companion.removeBroadcastEventObserver(this.broadcastEventObserver);
    }

    private final void scheduleDraw() {
        if (!this.watchState.isAmbient().hasValue() || !this.watchState.isVisible().hasValue()) {
            return;
        }
        this.setCalendarTime(this.systemTimeProvider.getSystemTimeMillis());
        if (this.renderer.shouldAnimate()) {
            this.pendingUpdateTime.postUnique((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ WatchFaceImpl this$0;

                public final void invoke() {
                    WatchFaceImpl.access$getWatchFaceHostApi$p(this.this$0).invalidate();
                }
                {
                    this.this$0 = watchFaceImpl;
                    super(0);
                }
            }));
        }
    }

    private final void setCalendarTime(long timeMillis) {
        long range;
        long millis = (long)(this.mockTime.getSpeed() * (double)(timeMillis - this.mockTime.getMinTime()));
        long delta = millis % (range = this.mockTime.getMaxTime() - this.mockTime.getMinTime());
        if (delta < 0L) {
            delta += range;
        }
        this.calendar.setTimeInMillis(this.mockTime.getMinTime() + delta);
    }

    @UiThread
    public final void maybeUpdateDrawMode$wear_watchface_release() {
        DrawMode newDrawMode;
        DrawMode drawMode = newDrawMode = this.watchState.isBatteryLowAndNotCharging().getValueOr(false) != false ? DrawMode.LOW_BATTERY_INTERACTIVE : DrawMode.INTERACTIVE;
        if (this.watchState.isAmbient().getValue().booleanValue() && !this.renderer.shouldAnimate()) {
            newDrawMode = DrawMode.AMBIENT;
        } else if (this.muteMode) {
            newDrawMode = DrawMode.MUTE;
        }
        this.renderer.setRenderParameters$wear_watchface_release(new RenderParameters(newDrawMode, RenderParameters.DRAW_ALL_LAYERS, null, -16777216));
    }

    @UiThread
    public final void onDraw$wear_watchface_release() {
        this.setCalendarTime(this.systemTimeProvider.getSystemTimeMillis());
        this.maybeUpdateDrawMode$wear_watchface_release();
        this.renderer.renderInternal$wear_watchface_release(this.calendar);
        long currentTimeMillis = this.systemTimeProvider.getSystemTimeMillis();
        this.setCalendarTime(currentTimeMillis);
        if (this.renderer.shouldAnimate()) {
            long delayMillis = this.computeDelayTillNextFrame$wear_watchface_release(this.nextDrawTimeMillis, currentTimeMillis);
            this.nextDrawTimeMillis = currentTimeMillis + delayMillis;
            this.pendingUpdateTime.postDelayedUnique(delayMillis, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ WatchFaceImpl this$0;

                public final void invoke() {
                    WatchFaceImpl.access$getWatchFaceHostApi$p(this.this$0).invalidate();
                }
                {
                    this.this$0 = watchFaceImpl;
                    super(0);
                }
            }));
        }
    }

    public final void onSurfaceRedrawNeeded$wear_watchface_release() {
        this.setCalendarTime(this.systemTimeProvider.getSystemTimeMillis());
        this.maybeUpdateDrawMode$wear_watchface_release();
        this.renderer.renderInternal$wear_watchface_release(this.calendar);
    }

    @UiThread
    public final long computeDelayTillNextFrame$wear_watchface_release(long beginFrameTimeMillis, long currentTimeMillis) {
        long l;
        if (this.watchState.isBatteryLowAndNotCharging().getValueOr(false).booleanValue()) {
            long l2 = this.renderer.getInteractiveDrawModeUpdateDelayMillis();
            long l3 = 100L;
            boolean bl = false;
            l = Math.max(l2, l3);
        } else {
            l = this.renderer.getInteractiveDrawModeUpdateDelayMillis();
        }
        long updateRateMillis = l;
        long nextFrameTimeMillis = Math.min(beginFrameTimeMillis, currentTimeMillis) + updateRateMillis;
        if (nextFrameTimeMillis <= currentTimeMillis) {
            long phaseAdjust = updateRateMillis + (nextFrameTimeMillis - currentTimeMillis) % updateRateMillis;
            nextFrameTimeMillis = currentTimeMillis + phaseAdjust;
        }
        return nextFrameTimeMillis - currentTimeMillis;
    }

    @UiThread
    public final void onComplicationDataUpdate$wear_watchface_release(int watchFaceComplicationId, @NotNull ComplicationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.complicationsManager.onComplicationDataUpdate$wear_watchface_release(watchFaceComplicationId, data);
        this.watchFaceHostApi.invalidate();
    }

    @UiThread
    public final void onTapCommand$wear_watchface_release(@TapType int originalTapType, int x, int y) {
        Complication tappedComplication = this.complicationsManager.getComplicationAt(x, y);
        if (tappedComplication == null) {
            System.out.println("<<< tappedComplication == null");
            this.clearGesture();
            WatchFace.TapListener tapListener = this.tapListener;
            if (tapListener != null) {
                tapListener.onTap(originalTapType, x, y);
            }
            return;
        }
        int tapType = originalTapType;
        switch (tapType) {
            case 0: {
                this.lastTappedPosition = new Point(x, y);
                break;
            }
            case 1: {
                Point point = this.lastTappedPosition;
                if (point != null) {
                    Point point2 = point;
                    boolean bl = false;
                    boolean bl2 = false;
                    Point safeLastTappedPosition = point2;
                    boolean bl3 = false;
                    if (safeLastTappedPosition.x == x && safeLastTappedPosition.y == y) {
                        tapType = 2;
                    }
                }
                this.lastTappedPosition = null;
                break;
            }
        }
        switch (tapType) {
            case 2: {
                Integer n = this.lastTappedComplicationId;
                if ((n == null || tappedComplication.getId$wear_watchface_release() != n.intValue()) && this.lastTappedComplicationId != null) {
                    this.clearGesture();
                    return;
                }
                if (this.pendingSingleTap.isPending()) break;
                this.complicationsManager.bringAttentionToComplication(tappedComplication.getId$wear_watchface_release());
                this.lastTappedComplicationId = tappedComplication.getId$wear_watchface_release();
                this.pendingSingleTap.postDelayedUnique(ViewConfiguration.getDoubleTapTimeout(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tappedComplication){
                    final /* synthetic */ WatchFaceImpl this$0;
                    final /* synthetic */ Complication $tappedComplication;

                    public final void invoke() {
                        this.this$0.getComplicationsManager$wear_watchface_release().onComplicationSingleTapped$wear_watchface_release(this.$tappedComplication.getId$wear_watchface_release());
                        WatchFaceImpl.access$getWatchFaceHostApi$p(this.this$0).invalidate();
                        WatchFaceImpl.access$clearGesture(this.this$0);
                    }
                    {
                        this.this$0 = watchFaceImpl;
                        this.$tappedComplication = complication;
                        super(0);
                    }
                }));
                break;
            }
            case 0: {
                Integer n = this.lastTappedComplicationId;
                if ((n == null || tappedComplication.getId$wear_watchface_release() != n.intValue()) && this.lastTappedComplicationId != null) {
                    this.clearGesture();
                }
                this.lastTappedComplicationId = tappedComplication.getId$wear_watchface_release();
                break;
            }
            default: {
                this.clearGesture();
            }
        }
    }

    private final void clearGesture() {
        this.lastTappedComplicationId = null;
        this.pendingSingleTap.cancel();
    }

    @UiThread
    public final void dump(@NotNull IndentingPrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.println("WatchFaceImpl (" + this.componentName + "): ");
        writer.increaseIndent();
        writer.println("calendar=" + this.calendar);
        writer.println("mockTime.maxTime=" + this.mockTime.getMaxTime());
        writer.println("mockTime.minTime=" + this.mockTime.getMinTime());
        writer.println("mockTime.speed=" + this.mockTime.getSpeed());
        writer.println("nextDrawTimeMillis=" + this.nextDrawTimeMillis);
        writer.println("muteMode=" + this.muteMode);
        writer.println("pendingSingleTap=" + this.pendingSingleTap.isPending());
        writer.println("pendingUpdateTime=" + this.pendingUpdateTime.isPending());
        writer.println("lastTappedComplicationId=" + this.lastTappedComplicationId);
        writer.println("lastTappedPosition=" + this.lastTappedPosition);
        writer.println("userStyleRepository.userStyle=" + this.userStyleRepository.getUserStyle());
        writer.println("userStyleRepository.schema=" + this.userStyleRepository.getSchema());
        this.watchState.dump$wear_watchface_release(writer);
        this.complicationsManager.dump$wear_watchface_release(writer);
        this.renderer.dump$wear_watchface_release(writer);
        writer.decreaseIndent();
    }

    /*
     * WARNING - void declaration
     */
    public WatchFaceImpl(@NotNull WatchFace watchface, @NotNull WatchFaceHostApi watchFaceHostApi, @NotNull WatchState watchState) {
        void initFinished;
        void iFilter;
        long l;
        Intrinsics.checkNotNullParameter((Object)watchface, (String)"watchface");
        Intrinsics.checkNotNullParameter((Object)watchFaceHostApi, (String)"watchFaceHostApi");
        Intrinsics.checkNotNullParameter((Object)watchState, (String)"watchState");
        this.watchFaceHostApi = watchFaceHostApi;
        this.watchState = watchState;
        this.systemTimeProvider = watchface.getSystemTimeProvider$wear_watchface_release();
        this.legacyWatchFaceStyle = watchface.getLegacyWatchFaceStyle();
        this.userStyleRepository = watchface.getUserStyleRepository();
        this.renderer = watchface.getRenderer$wear_watchface_release();
        this.complicationsManager = watchface.getComplicationsManager$wear_watchface_release();
        this.tapListener = watchface.getTapListener$wear_watchface_release();
        this.mockTime = new MockTime(1.0, 0L, Long.MAX_VALUE);
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        this.calendar = calendar;
        this.pendingSingleTap = new CancellableUniqueTask(this.watchFaceHostApi.getHandler());
        this.pendingUpdateTime = new CancellableUniqueTask(this.watchFaceHostApi.getHandler());
        this.componentName = new ComponentName(this.watchFaceHostApi.getContext().getPackageName(), this.watchFaceHostApi.getContext().getClass().getName());
        this.broadcastEventObserver = new BroadcastReceivers.BroadcastEventObserver(this){
            final /* synthetic */ WatchFaceImpl this$0;

            public void onActionTimeTick() {
                if (!WatchFaceImpl.access$getWatchState$p(this.this$0).isAmbient().getValue().booleanValue()) {
                    this.this$0.getRenderer$wear_watchface_release().invalidate();
                }
            }

            public void onActionTimeZoneChanged() {
                this.this$0.getCalendar().setTimeZone(TimeZone.getDefault());
                this.this$0.getRenderer$wear_watchface_release().invalidate();
            }

            public void onActionTimeChanged() {
                WatchFaceImpl.access$setNextDrawTimeMillis$p(this.this$0, WatchFaceImpl.access$getSystemTimeProvider$p(this.this$0).getSystemTimeMillis());
                this.this$0.getRenderer$wear_watchface_release().invalidate();
            }

            public void onActionBatteryLow() {
                this.updateBatteryLowAndNotChargingStatus(true);
            }

            public void onActionBatteryOkay() {
                this.updateBatteryLowAndNotChargingStatus(false);
            }

            public void onActionPowerConnected() {
                this.updateBatteryLowAndNotChargingStatus(false);
            }

            public void onMockTime(@NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                WatchFaceImpl.access$getMockTime$p(this.this$0).setSpeed(intent.getFloatExtra("androidx.wear.watchface.extra.MOCK_TIME_SPEED_MULTIPLIER", 1.0f));
                WatchFaceImpl.access$getMockTime$p(this.this$0).setMinTime(intent.getLongExtra("androidx.wear.watchface.extra.MOCK_TIME_WRAPPING_MIN_TIME", -1L));
                if (WatchFaceImpl.access$getMockTime$p(this.this$0).getMinTime() == -1L) {
                    WatchFaceImpl.access$getMockTime$p(this.this$0).setMinTime(WatchFaceImpl.access$getSystemTimeProvider$p(this.this$0).getSystemTimeMillis());
                }
                WatchFaceImpl.access$getMockTime$p(this.this$0).setMaxTime(intent.getLongExtra("androidx.wear.watchface.extra.MOCK_TIME_WRAPPING_MAX_TIME", Long.MAX_VALUE));
            }

            private final void updateBatteryLowAndNotChargingStatus(boolean value) {
                ObservableWatchData<Boolean> observableWatchData = WatchFaceImpl.access$getWatchState$p(this.this$0).isBatteryLowAndNotCharging();
                if (observableWatchData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.wear.watchface.MutableObservableWatchData<kotlin.Boolean>");
                }
                MutableObservableWatchData isBatteryLowAndNotCharging = (MutableObservableWatchData)observableWatchData;
                if (!isBatteryLowAndNotCharging.hasValue() || value != (Boolean)isBatteryLowAndNotCharging.getValue()) {
                    isBatteryLowAndNotCharging.setValue(value);
                    this.this$0.getRenderer$wear_watchface_release().invalidate();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        Long l2 = watchface.getOverridePreviewReferenceTimeMillis();
        if (l2 != null) {
            l = l2;
        } else {
            switch (watchface.getWatchFaceType$wear_watchface_release()) {
                case 0: {
                    l = this.watchState.getAnalogPreviewReferenceTimeMillis();
                    break;
                }
                case 1: {
                    l = this.watchState.getDigitalPreviewReferenceTimeMillis();
                    break;
                }
                default: {
                    throw (Throwable)new InvalidParameterException("Unrecognized watchFaceType");
                }
            }
        }
        this.previewReferenceTimeMillis = l;
        UserStyleWireFormat storedUserStyle = this.watchFaceHostApi.getInitialUserStyle();
        if (storedUserStyle != null) {
            this.userStyleRepository.setUserStyle(new UserStyle(storedUserStyle, this.userStyleRepository.getSchema()));
        } else {
            final String preferencesFile = "watchface_prefs_" + this.watchFaceHostApi.getContext().getClass().getName() + ".txt";
            this.userStyleRepository.setUserStyle(new UserStyle(WatchFaceKt.access$readPrefs(this.watchFaceHostApi.getContext(), preferencesFile), this.userStyleRepository.getSchema()));
            this.userStyleRepository.addUserStyleListener(new UserStyleRepository.UserStyleListener(){

                @SuppressLint(value={"SyntheticAccessor"})
                public void onUserStyleChanged(@NotNull UserStyle userStyle) {
                    Intrinsics.checkNotNullParameter((Object)userStyle, (String)"userStyle");
                    WatchFaceKt.access$writePrefs(watchFaceHostApi.getContext(), preferencesFile, userStyle);
                }
            });
        }
        this.renderer.setWatchFaceHostApi$wear_watchface_release(this.watchFaceHostApi);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        boolean bl = false;
        boolean bl2 = false;
        IntentFilter intentFilter2 = intentFilter;
        WatchFaceImpl watchFaceImpl = this;
        boolean bl3 = false;
        Intent intent = this.watchFaceHostApi.getContext().registerReceiver(null, (IntentFilter)iFilter);
        watchFaceImpl.setIsBatteryLowAndNotChargingFromBatteryStatus$wear_watchface_release(intent);
        WatchFace.Companion.maybeCreatePendingEditorDelegate$wear_watchface_release(this);
        this.ambientObserver = new Observer<Boolean>(this){
            final /* synthetic */ WatchFaceImpl this$0;

            public final void onChanged(boolean it) {
                WatchFaceImpl.access$scheduleDraw(this.this$0);
                WatchFaceImpl.access$getWatchFaceHostApi$p(this.this$0).invalidate();
            }
            {
                this.this$0 = watchFaceImpl;
            }
        };
        this.interruptionFilterObserver = new Observer<Integer>(this){
            final /* synthetic */ WatchFaceImpl this$0;

            public final void onChanged(int it) {
                boolean inMuteMode;
                boolean bl = inMuteMode = it == 3;
                if (WatchFaceImpl.access$getMuteMode$p(this.this$0) != inMuteMode) {
                    WatchFaceImpl.access$setMuteMode$p(this.this$0, inMuteMode);
                    WatchFaceImpl.access$getWatchFaceHostApi$p(this.this$0).invalidate();
                }
            }
            {
                this.this$0 = watchFaceImpl;
            }
        };
        this.visibilityObserver = new Observer<Boolean>(this){
            final /* synthetic */ WatchFaceImpl this$0;

            public final void onChanged(boolean it) {
                if (it) {
                    WatchFaceImpl.access$registerReceivers(this.this$0);
                    this.this$0.getCalendar().setTimeZone(TimeZone.getDefault());
                    WatchFaceImpl.access$getWatchFaceHostApi$p(this.this$0).invalidate();
                } else {
                    WatchFaceImpl.access$unregisterReceivers(this.this$0);
                }
                WatchFaceImpl.access$scheduleDraw(this.this$0);
            }
            {
                this.this$0 = watchFaceImpl;
            }
        };
        this.batteryLowAndNotChargingObserver = new Observer<Boolean>(this){
            final /* synthetic */ WatchFaceImpl this$0;

            public final void onChanged(boolean it) {
                Surface surface = this.this$0.getRenderer$wear_watchface_release().getSurfaceHolder().getSurface();
                Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"renderer.surfaceHolder.surface");
                if (surface.isValid()) {
                    this.this$0.getRenderer$wear_watchface_release().getSurfaceHolder().getSurface().setFrameRate(it ? 10.0f : 0.0f, 0);
                }
            }
            {
                this.this$0 = watchFaceImpl;
            }
        };
        storedUserStyle = new Ref.BooleanRef();
        storedUserStyle.element = false;
        this.complicationsManager.init$wear_watchface_release(this.watchFaceHostApi, this.calendar, this.renderer, new Complication.InvalidateListener((Ref.BooleanRef)initFinished){
            final /* synthetic */ Ref.BooleanRef $initFinished;

            @Override
            public void onInvalidate() {
                if (this.getRenderer$wear_watchface_release().shouldAnimate() && this.computeDelayTillNextFrame$wear_watchface_release(nextDrawTimeMillis, systemTimeProvider.getSystemTimeMillis()) < (long)100) {
                    return;
                }
                if (this.$initFinished.element) {
                    watchFaceHostApi.invalidate();
                }
            }
            {
                this.$initFinished = $captured_local_variable$1;
            }
        });
        if (!this.watchState.isHeadless()) {
            WatchFace.Companion.registerEditorDelegate(this.componentName, new WFEditorDelegate());
        }
        this.watchState.isAmbient().addObserver(this.ambientObserver);
        if (Build.VERSION.SDK_INT >= 30 && !this.watchState.isHeadless()) {
            this.watchState.isBatteryLowAndNotCharging().addObserver(this.batteryLowAndNotChargingObserver);
        }
        this.watchState.getInterruptionFilter().addObserver(this.interruptionFilterObserver);
        this.watchState.isVisible().addObserver(this.visibilityObserver);
        initFinished.element = true;
    }

    public static final /* synthetic */ void access$clearGesture(WatchFaceImpl $this) {
        $this.clearGesture();
    }

    public static final /* synthetic */ void access$setNextDrawTimeMillis$p(WatchFaceImpl $this, long l) {
        $this.nextDrawTimeMillis = l;
    }

    public static final /* synthetic */ MockTime access$getMockTime$p(WatchFaceImpl $this) {
        return $this.mockTime;
    }

    public static final /* synthetic */ void access$setMockTime$p(WatchFaceImpl $this, MockTime mockTime) {
        $this.mockTime = mockTime;
    }

    public static final /* synthetic */ void access$scheduleDraw(WatchFaceImpl $this) {
        $this.scheduleDraw();
    }

    public static final /* synthetic */ boolean access$getMuteMode$p(WatchFaceImpl $this) {
        return $this.muteMode;
    }

    public static final /* synthetic */ void access$setMuteMode$p(WatchFaceImpl $this, boolean bl) {
        $this.muteMode = bl;
    }

    public static final /* synthetic */ void access$registerReceivers(WatchFaceImpl $this) {
        $this.registerReceivers();
    }

    public static final /* synthetic */ void access$unregisterReceivers(WatchFaceImpl $this) {
        $this.unregisterReceivers();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Landroidx/wear/watchface/WatchFaceImpl$MockTime;", "", "speed", "", "minTime", "", "maxTime", "(DJJ)V", "getMaxTime", "()J", "setMaxTime", "(J)V", "getMinTime", "setMinTime", "getSpeed", "()D", "setSpeed", "(D)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "wear-watchface_release"})
    private static final class MockTime {
        private double speed;
        private long minTime;
        private long maxTime;

        public final double getSpeed() {
            return this.speed;
        }

        public final void setSpeed(double d) {
            this.speed = d;
        }

        public final long getMinTime() {
            return this.minTime;
        }

        public final void setMinTime(long l) {
            this.minTime = l;
        }

        public final long getMaxTime() {
            return this.maxTime;
        }

        public final void setMaxTime(long l) {
            this.maxTime = l;
        }

        public MockTime(double speed, long minTime, long maxTime) {
            this.speed = speed;
            this.minTime = minTime;
            this.maxTime = maxTime;
        }

        public final double component1() {
            return this.speed;
        }

        public final long component2() {
            return this.minTime;
        }

        public final long component3() {
            return this.maxTime;
        }

        @NotNull
        public final MockTime copy(double speed, long minTime, long maxTime) {
            return new MockTime(speed, minTime, maxTime);
        }

        public static /* synthetic */ MockTime copy$default(MockTime mockTime, double d, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                d = mockTime.speed;
            }
            if ((n & 2) != 0) {
                l = mockTime.minTime;
            }
            if ((n & 4) != 0) {
                l2 = mockTime.maxTime;
            }
            return mockTime.copy(d, l, l2);
        }

        @NotNull
        public String toString() {
            return "MockTime(speed=" + this.speed + ", minTime=" + this.minTime + ", maxTime=" + this.maxTime + ")";
        }

        public int hashCode() {
            return (Double.hashCode(this.speed) * 31 + Long.hashCode(this.minTime)) * 31 + Long.hashCode(this.maxTime);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MockTime)) break block3;
                    MockTime mockTime = (MockTime)object;
                    if (Double.compare(this.speed, mockTime.speed) != 0 || this.minTime != mockTime.minTime || this.maxTime != mockTime.maxTime) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Landroidx/wear/watchface/WatchFaceImpl$WFEditorDelegate;", "Landroidx/wear/watchface/WatchFace$EditorDelegate;", "(Landroidx/wear/watchface/WatchFaceImpl;)V", "complicationsManager", "Landroidx/wear/watchface/ComplicationsManager;", "getComplicationsManager", "()Landroidx/wear/watchface/ComplicationsManager;", "previewReferenceTimeMillis", "", "getPreviewReferenceTimeMillis", "()J", "screenBounds", "Landroid/graphics/Rect;", "getScreenBounds", "()Landroid/graphics/Rect;", "userStyleRepository", "Landroidx/wear/watchface/style/UserStyleRepository;", "getUserStyleRepository", "()Landroidx/wear/watchface/style/UserStyleRepository;", "onDestroy", "", "takeScreenshot", "Landroid/graphics/Bitmap;", "renderParameters", "Landroidx/wear/watchface/RenderParameters;", "calendarTimeMillis", "idToComplicationData", "", "", "Landroidx/wear/complications/data/ComplicationData;", "wear-watchface_release"})
    public final class WFEditorDelegate
    implements WatchFace.EditorDelegate {
        @Override
        @NotNull
        public UserStyleRepository getUserStyleRepository() {
            return WatchFaceImpl.this.getUserStyleRepository$wear_watchface_release();
        }

        @Override
        @NotNull
        public ComplicationsManager getComplicationsManager() {
            return WatchFaceImpl.this.getComplicationsManager$wear_watchface_release();
        }

        @Override
        @NotNull
        public Rect getScreenBounds() {
            return WatchFaceImpl.this.getRenderer$wear_watchface_release().getScreenBounds();
        }

        @Override
        public long getPreviewReferenceTimeMillis() {
            return WatchFaceImpl.this.getPreviewReferenceTimeMillis();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Bitmap takeScreenshot(@NotNull RenderParameters renderParameters, long calendarTimeMillis, @Nullable Map<Integer, ? extends ComplicationData> idToComplicationData) {
            void $this$apply;
            IdAndComplicationData idAndComplicationData;
            Object object;
            Object object2;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)renderParameters, (String)"renderParameters");
            Object $this$map$iv = this.getComplicationsManager().getComplications().values();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object2 = (Complication)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                IdAndComplicationData idAndComplicationData2 = it.getRenderer().getIdAndData();
                if (idAndComplicationData2 == null) {
                    idAndComplicationData2 = new IdAndComplicationData(it.getId$wear_watchface_release(), (ComplicationData)new NoDataComplicationData());
                }
                idAndComplicationData = idAndComplicationData2;
                object.add(idAndComplicationData);
            }
            List oldComplicationData = (List)destination$iv$iv;
            Map<Integer, ? extends ComplicationData> map = idToComplicationData;
            if (map != null) {
                $this$map$iv = map;
                $i$f$map22 = false;
                boolean bl = false;
                Object it = $this$map$iv;
                boolean bl2 = false;
                Object object3 = it;
                boolean item$iv$iv = false;
                object2 = object3.entrySet().iterator();
                while (object2.hasNext()) {
                    void id;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = (Map.Entry)object2.next();
                    boolean bl3 = false;
                    int n = ((Number)entry2.getKey()).intValue();
                    entry2 = entry;
                    bl3 = false;
                    ComplicationData complicationData = (ComplicationData)entry2.getValue();
                    Complication complication = this.getComplicationsManager().get((int)id);
                    Intrinsics.checkNotNull((Object)complication);
                    complication.getRenderer().setIdAndData(new IdAndComplicationData((int)id, complicationData), false);
                }
            }
            Calendar $i$f$map22 = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"UTC"));
            boolean bl = false;
            boolean bl4 = false;
            Calendar bl2 = $i$f$map22;
            object = WatchFaceImpl.this.getRenderer$wear_watchface_release();
            boolean bl5 = false;
            $this$apply.setTimeInMillis(calendarTimeMillis);
            idAndComplicationData = Unit.INSTANCE;
            Calendar calendar = $i$f$map22;
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance(Tim\u2026eMillis\n                }");
            Bitmap screenShot = ((Renderer)object).takeScreenshot$wear_watchface_release(calendar, renderParameters);
            if (idToComplicationData != null) {
                for (IdAndComplicationData idAndData : oldComplicationData) {
                    Complication complication = this.getComplicationsManager().get(idAndData.getComplicationId());
                    Intrinsics.checkNotNull((Object)complication);
                    complication.getRenderer().setIdAndData(idAndData, false);
                }
            }
            return screenShot;
        }

        @Override
        public void onDestroy() {
            if (WatchFaceImpl.this.watchState.isHeadless()) {
                WatchFaceImpl.this.onDestroy$wear_watchface_release();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/wear/watchface/WatchFaceImpl$Companion;", "", "()V", "CANCEL_COMPLICATION_HIGHLIGHTED_DELAY_MS", "", "EXTRA_MOCK_TIME_SPEED_MULTIPLIER", "", "EXTRA_MOCK_TIME_WRAPPING_MAX_TIME", "EXTRA_MOCK_TIME_WRAPPING_MIN_TIME", "INITIAL_LOW_BATTERY_THRESHOLD", "", "MAX_LOW_POWER_INTERACTIVE_UPDATE_RATE_MS", "MOCK_TIME_DEFAULT_SPEED_MULTIPLIER", "MOCK_TIME_INTENT", "MOCK_TIME_WRAPPING_MIN_TIME_DEFAULT", "NO_DEFAULT_PROVIDER", "", "wear-watchface_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

